/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.util.HecTime;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.util.Arrays;

public class DurationPeriod {
    public static final int UNDEFINED = -1;
    public static final int ANNUAL = 0;
    public static final int QUARTERLY = 1;
    public static final int MONTHLY = 2;
    public static final int OTHER = 3;
    public static final String[] DURATION_PERIOD_STRINGS = new String[]{"Annual", "Quarterly", "Monthly", "Other"};
    protected String _periodName = "";
    protected String _periodInterval = "";
    protected HecTime _startOfPeriod;
    protected HecTime _endOfPeriod;
    protected boolean _startDateBeforeEndDate = true;
    protected int _durationPeriodType = -1;
    protected int _numberValues;
    public double[] _values;
    public double[] _durationPercent;
    protected String _xunits = "Percent";
    protected String _yunits;
    protected String _xtype = "Prob";
    protected String _ytype = "LOG";
    protected String _xparameterString = "Exceedance";
    protected String _yparameterString;
    protected boolean _durationComputed;
    protected boolean _timeValid = false;

    public DurationPeriod(int type, String startOfPeriod, String endOfPeriod) {
        if (((String)startOfPeriod).length() == 5) {
            startOfPeriod = (String)startOfPeriod + "3000";
        }
        if (((String)endOfPeriod).length() == 5) {
            endOfPeriod = (String)endOfPeriod + "3000";
        }
        this._durationPeriodType = type;
        this._startOfPeriod = new HecTime((String)startOfPeriod, "0000", 1);
        this._endOfPeriod = new HecTime((String)endOfPeriod, "2400", 1);
        this._endOfPeriod.showTimeAsBeginningOfDay(false);
        if (this._startOfPeriod.isDefined() && this._endOfPeriod.isDefined()) {
            this._timeValid = true;
            if (this._startOfPeriod.greaterThan(this._endOfPeriod)) {
                this._startDateBeforeEndDate = false;
            }
        }
    }

    public DurationPeriod(String name, String startOfPeriod, String endOfPeriod) {
        if (((String)startOfPeriod).length() == 5) {
            startOfPeriod = (String)startOfPeriod + "3000";
        }
        if (((String)endOfPeriod).length() == 5) {
            endOfPeriod = (String)endOfPeriod + "3000";
        }
        this._periodName = name;
        this._startOfPeriod = new HecTime((String)startOfPeriod, "0000", 1);
        this._startOfPeriod.showTimeAsBeginningOfDay(true);
        this._endOfPeriod = new HecTime((String)endOfPeriod, "2400", 1);
        this._endOfPeriod.showTimeAsBeginningOfDay(false);
        if (this._startOfPeriod.isDefined() && this._endOfPeriod.isDefined()) {
            this._timeValid = true;
            if (this._startOfPeriod.greaterThan(this._endOfPeriod)) {
                this._startDateBeforeEndDate = false;
            }
        }
    }

    public boolean filterTimeSeries(TimeSeriesContainer tsc) {
        if (tsc == null || tsc.values.length < 1) {
            return false;
        }
        double[] valuesTmp = new double[tsc.numberValues];
        HecTime start3000 = new HecTime(1);
        start3000.set("01JAN3000", "0000");
        HecTime hecTime = new HecTime(1);
        HecTime hecTimeBeginningOfYear = new HecTime(1);
        long startBase = this._startOfPeriod.getMinutes() - start3000.getMinutes();
        long endBase = this._endOfPeriod.getMinutes() - start3000.getMinutes();
        int previousYear = -1;
        int icnt = 0;
        for (int i = 0; i < tsc.values.length; ++i) {
            hecTime.set(tsc.times[i], tsc.timeGranularitySeconds, tsc.julianBaseDate);
            int year = hecTime.year();
            if (year != previousYear) {
                hecTimeBeginningOfYear.setYearMonthDay(year, 1, 1, 0);
                previousYear = year;
            }
            long tsTime = hecTime.getMinutes() - hecTimeBeginningOfYear.getMinutes();
            long startTime = startBase;
            long endTime = endBase;
            if (year % 400 == 0 || year % 4 == 0 && year % 100 != 0) {
                if (startBase >= 84960L) {
                    startTime += 1440L;
                }
                if (endBase >= 84960L) {
                    endTime += 1440L;
                }
            }
            if (this._startDateBeforeEndDate) {
                if (tsTime <= startTime || tsTime > endTime) continue;
                valuesTmp[icnt] = tsc.values[i];
                ++icnt;
                continue;
            }
            if (tsTime > endTime && tsTime <= startTime) continue;
            valuesTmp[icnt] = tsc.values[i];
            ++icnt;
        }
        if (icnt < 0) {
            return false;
        }
        this.clearArrays();
        this._numberValues = icnt;
        this._values = Arrays.copyOf(valuesTmp, icnt);
        this._durationPercent = new double[icnt];
        Arrays.fill(this._durationPercent, 0.0);
        this._yunits = tsc.units;
        this._yparameterString = tsc.parameter;
        return true;
    }

    public void sortDescending() {
        Arrays.sort(this._values);
        for (int i = 0; i < this._values.length / 2; ++i) {
            int n = this._values.length - 1 - i;
            double tmp = this._values[i];
            this._values[i] = this._values[n];
            this._values[n] = tmp;
        }
        this._durationComputed = false;
        Arrays.fill(this._durationPercent, 0.0);
    }

    public boolean computeDuration() {
        double numberOfEvents = this._numberValues;
        int i = 0;
        while ((double)i < numberOfEvents) {
            double rank = i + 1;
            this._durationPercent[i] = 100.0 * (rank / (numberOfEvents + 1.0));
            ++i;
        }
        this._durationComputed = true;
        return true;
    }

    public static double[] computeBinLimits(double[] values, int numberBins, boolean useLog) {
        double min = values[0];
        double max = values[values.length - 1];
        int[] bins = new int[numberBins];
        Arrays.fill(bins, 0);
        double[] maxBinValue = new double[numberBins];
        if (useLog) {
            double minLog = Math.log10(min);
            double maxLog = Math.log10(max);
            double binSpan = (maxLog - minLog) / (double)numberBins;
            double nextBinLog = minLog;
            for (int i = 0; i < numberBins; ++i) {
                maxBinValue[i] = Math.pow(10.0, nextBinLog += binSpan);
            }
            maxBinValue[numberBins - 1] = max;
        } else {
            double binSpan = (max - min) / (double)numberBins;
            double nextBinValue = min;
            for (int i = 0; i < numberBins; ++i) {
                maxBinValue[i] = nextBinValue += binSpan;
            }
            maxBinValue[numberBins - 1] = max;
        }
        return maxBinValue;
    }

    public PairedDataContainer computeBins(double[] maxBinValue, double[] plottingPoints, int horizontalAxis) {
        Arrays.sort(this._values);
        int numberBins = maxBinValue.length;
        double max = this._values[this._numberValues - 1];
        int[] bins = new int[numberBins];
        Arrays.fill(bins, 0);
        double[] cum = new double[numberBins];
        int currentBin = 0;
        for (int i = 0; i < this._values.length; ++i) {
            block9: {
                if (this._values[i] <= maxBinValue[currentBin]) {
                    int n = currentBin;
                    bins[n] = bins[n] + 1;
                    continue;
                }
                do {
                    cum[currentBin] = i;
                    if (++currentBin >= bins.length) break block9;
                } while (!(this._values[i] <= maxBinValue[currentBin]));
                int n = currentBin;
                bins[n] = bins[n] + 1;
            }
            if (currentBin >= bins.length) break;
        }
        if (currentBin < numberBins - 1) {
            cum[currentBin] = this._values.length;
        }
        double[] values = new double[numberBins];
        double[] precentExceeded = new double[numberBins];
        for (int i = 0; i < numberBins; ++i) {
            if (maxBinValue[i] <= max) {
                precentExceeded[numberBins - i - 1] = 100.0 - 100.0 * (cum[i] / (double)this._values.length);
                if (precentExceeded[numberBins - i - 1] == 0.0) {
                    precentExceeded[numberBins - i - 1] = 1.0E-5;
                }
            } else {
                precentExceeded[numberBins - i - 1] = -3.4028234663852886E38;
            }
            values[numberBins - i - 1] = maxBinValue[i];
        }
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.numberCurves = 1;
        pdc.numberOrdinates = numberBins;
        pdc.xOrdinates = precentExceeded;
        pdc.yOrdinates = new double[1][];
        pdc.yOrdinates[0] = values;
        pdc.date = this._periodInterval;
        pdc.other = this._periodName;
        pdc.xunits = this._xunits;
        pdc.xparameter = this._xparameterString;
        pdc.xtype = this._xtype;
        pdc.yunits = this._yunits;
        pdc.yparameter = this._yparameterString;
        pdc.ytype = this._ytype;
        if (plottingPoints != null) {
            double[] interpolatedFlows = DurationPeriod.interpolate(precentExceeded, values, plottingPoints, horizontalAxis);
            pdc.numberOrdinates = plottingPoints.length;
            pdc.xOrdinates = (double[])plottingPoints.clone();
            pdc.yOrdinates[0] = interpolatedFlows;
        }
        return pdc;
    }

    public PairedDataContainer computeAll() {
        this.sortDescending();
        this.computeDuration();
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.xOrdinates = this._durationPercent;
        pdc.numberCurves = 1;
        pdc.labelsUsed = false;
        pdc.date = this._periodInterval;
        pdc.other = this._periodName;
        pdc.yOrdinates = new double[1][];
        pdc.yOrdinates[0] = this._values;
        pdc.numberOrdinates = this._values.length;
        pdc.xunits = this._xunits;
        pdc.xparameter = this._xparameterString;
        pdc.xtype = this._xtype;
        pdc.yunits = this._yunits;
        pdc.yparameter = this._yparameterString;
        pdc.ytype = this._ytype;
        return pdc;
    }

    public PairedDataContainer compute(double[] xintervals, int horizontalAxis) {
        this.sortDescending();
        this.computeDuration();
        double[] interpolatedFlows = DurationPeriod.interpolate(this._durationPercent, this._values, xintervals, horizontalAxis);
        double[] xnew = (double[])xintervals.clone();
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.xOrdinates = xnew;
        pdc.numberCurves = 1;
        pdc.labelsUsed = false;
        pdc.date = this._periodInterval;
        pdc.other = this._periodName;
        pdc.yOrdinates = new double[1][];
        pdc.yOrdinates[0] = interpolatedFlows;
        pdc.numberOrdinates = interpolatedFlows.length;
        pdc.xunits = this._xunits;
        pdc.xparameter = this._xparameterString;
        pdc.xtype = this._xtype;
        pdc.yunits = this._yunits;
        pdc.yparameter = this._yparameterString;
        pdc.ytype = this._ytype;
        return pdc;
    }

    static double getStandardNormalDeviate(double probability) {
        int i;
        probability = 1.0 - probability;
        double c0 = 2.515517;
        double c1 = 0.802853;
        double c2 = 0.010328;
        double d1 = 1.432788;
        double d2 = 0.189269;
        double d3 = 0.001308;
        double q = probability;
        if (q == 0.5) {
            return 0.0;
        }
        if (q <= 0.0) {
            q = 1.0E-15;
        }
        if (q >= 1.0) {
            q = 0.999999999999999;
        }
        if (q < 0.5) {
            i = -1;
        } else {
            i = 1;
            q = 1.0 - q;
        }
        double t = Math.sqrt(Math.log(1.0 / Math.pow(q, 2.0)));
        double x = t - (c0 + c1 * t + c2 * Math.pow(t, 2.0)) / (1.0 + d1 * t + d2 * Math.pow(t, 2.0) + d3 * Math.pow(t, 3.0));
        x = (double)i * x;
        return x;
    }

    protected static double[] interpolate(double[] xValues, double[] yValues, double[] newXValues, int horizontalAxis) {
        double[] interpolatedValues = new double[newXValues.length];
        Arrays.fill(interpolatedValues, -3.4028234663852886E38);
        int idx = 0;
        int nvals = xValues.length;
        for (int i = 0; i < newXValues.length; ++i) {
            double yinterp;
            double fact;
            double x = newXValues[i];
            if (x < xValues[idx]) continue;
            while (idx + 1 <= nvals - 1 && x > xValues[idx + 1]) {
                ++idx;
            }
            if (idx + 1 > nvals - 1) break;
            double d0 = xValues[idx];
            double d1 = xValues[idx + 1];
            double y0 = yValues[idx];
            double y1 = yValues[idx + 1];
            double logy0 = Math.log(y0);
            double logy1 = Math.log(y1);
            if (horizontalAxis == 1) {
                double dev0 = DurationPeriod.getStandardNormalDeviate(d0 / 100.0);
                double dev1 = DurationPeriod.getStandardNormalDeviate(d1 / 100.0);
                double devx = DurationPeriod.getStandardNormalDeviate(x / 100.0);
                fact = (devx - dev0) / (dev1 - dev0);
                yinterp = logy0 + fact * (logy1 - logy0);
                interpolatedValues[i] = Math.exp(yinterp);
                continue;
            }
            fact = (x - d0) / (d1 - d0);
            interpolatedValues[i] = yinterp = y0 + fact * (y1 - y0);
        }
        return interpolatedValues;
    }

    public void setName(String name) {
        this._periodName = name;
    }

    public String getName() {
        return this._periodName;
    }

    public void setInterval(String interval) {
        this._periodInterval = interval;
    }

    public String getInterval() {
        return this._periodInterval;
    }

    public void clearArrays() {
        this._numberValues = 0;
        this._values = null;
        this._durationPercent = null;
        this._durationComputed = false;
    }

    protected class DurationPoint {
        protected double value;
        protected double durationPercent;

        protected DurationPoint() {
        }
    }
}

