/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecDouble;
import hec.hecmath.DurationPeriod;
import hec.hecmath.HecMathException;
import hec.hecmath.LinearRegressionStatistics;
import hec.hecmath.PairedDataMath;
import hec.hecmath.TextMath;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.TimeSeriesMathVertDatum;
import hec.hecmath.computation.ScalarOperable;
import hec.hecmath.functions.TimeSeriesFunctions;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.annotation.Scriptable;
import hec.model.TSRecord;
import hec.script.Constants;
import rma.util.RMAConst;

@Scriptable
public abstract class HecMath
implements Constants {
    protected DataContainer _dc;
    protected DSSPathname _dssPath = new DSSPathname();
    protected int _curveNumber = 0;
    protected static final int ADD = 1;
    protected static final int SUBTRACT = 2;
    protected static final int MULTIPLY = 3;
    protected static final int DIVIDE = 4;
    protected static final int EXPONENTIATION = 5;
    protected static final int SQRT = 11;
    protected static final int LOG10 = 12;
    protected static final int LOG = 13;
    protected static final int ABS = 14;
    protected static final int TRUNCATE = 15;
    protected static final int ROUND = 16;
    protected static final int SIN = 17;
    protected static final int COS = 18;
    protected static final int TAN = 19;
    protected static final int INVERSE = 20;

    public HecMath abs() throws HecMathException {
        throw new HecMathException("abs() is not implemented.");
    }

    public HecMath accumulation() throws HecMathException {
        throw new HecMathException("accumulation() is not implemented.");
    }

    public HecMath add(double constant) throws HecMathException {
        throw new HecMathException("add() is not implemented.");
    }

    public HecMath add(HecMath math) throws HecMathException {
        throw new HecMathException("add() is not implemented.");
    }

    public HecMath applyMultipleLinearRegression(String startTimeString, String endTimeString, HecMath[] tsMathArray, double minimumLimit, double maximumLimit) throws HecMathException {
        throw new HecMathException("applyMultipleLinearRegression() is not implemented.");
    }

    public HecMath centeredMovingAverage(int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws HecMathException {
        throw new HecMathException("centeredMovingAverage() is not implemented.");
    }

    public HecMath conicInterpolation(HecMath tsMath, String inputType, String outputType, double storageScaleFactor) throws HecMathException {
        throw new HecMathException("conicInterpolation() is not implemented.");
    }

    public LinearRegressionStatistics correlationCoefficients(HecMath tsMath) throws HecMathException {
        throw new HecMathException("correlationCoefficients() is not implemented.");
    }

    public HecMath cos() throws HecMathException {
        throw new HecMathException("cos() is not implemented.");
    }

    public HecMath[] cyclicAnalysis() throws HecMathException {
        throw new HecMathException("cyclicAnalysis() is not implemented.");
    }

    public HecMath decayingBasinWetnessParameter(HecMath math, double decayRate) throws HecMathException {
        throw new HecMathException("decayingBasinWetnessParameter() is not implemented.");
    }

    public HecMath divide(double constant) throws HecMathException {
        throw new HecMathException("divide() is not implemented.");
    }

    public HecMath divide(HecMath math) throws HecMathException {
        throw new HecMathException("divide() is not implemented.");
    }

    public HecMath[] durationAnalysis(String durationPeriodType) throws HecMathException {
        throw new HecMathException("durationAnalysis() is not implemented.");
    }

    public HecMath[] durationAnalysis(String durationPeriodType, String plotScaleType, String plottingPointsType, int numberOfIntervals) throws HecMathException {
        throw new HecMathException("durationAnalysis() is not implemented.");
    }

    public HecMath[] durationAnalysis(DurationPeriod[] durationPeriods) throws HecMathException {
        throw new HecMathException("durationAnalysis() is not implemented.");
    }

    public HecMath[] durationAnalysis(DurationPeriod[] durationPeriods, String plotScaleType, String plottingPointsType, int numberOfIntervals) throws HecMathException {
        throw new HecMathException("durationAnalysis() is not implemented.");
    }

    public HecMath estimateForMissingPrecipValues(int maxMissingAllowed) throws HecMathException {
        throw new HecMathException("estimateForMissingPrecipValues() is not implemented.");
    }

    public HecMath estimateForMissingValues(int maxMissingAllowed) throws HecMathException {
        throw new HecMathException("estimateForMissingValues() is not implemented.");
    }

    public HecMath replaceSpecificValues(HecDouble from, HecDouble to) throws HecMathException {
        throw new HecMathException("replaceSpecificValues() is not implemented.");
    }

    public HecMath replaceValuesInRange(HecDouble min, HecDouble max, HecDouble to) throws HecMathException {
        throw new HecMathException("replaceSpecificValues() is not implemented.");
    }

    public HecMath exponentiation(double constant) throws HecMathException {
        throw new HecMathException("exponentiation() is not implemented.");
    }

    public HecMath extractTimeSeriesDataForTimeSpecification(String timeLevelString, String rangeString, boolean isInclusive, int intervalWindow, boolean setAsIrregular) throws HecMathException {
        throw new HecMathException("extractTimeSeriesDataForTimeSpecification() is not implemented.");
    }

    public HecMath flowAccumulatorGageProcessor(HecMath math) throws HecMathException {
        throw new HecMathException("flowAccumulatorGageProcessor() is not implemented.");
    }

    public HecMath forwardMovingAverage(int numberToAverageOver) throws HecMathException {
        throw new HecMathException("forwardMovingAverage() is not implemented.");
    }

    @Deprecated
    public HecMath generateDataPairs(HecMath math, boolean sort) throws HecMathException {
        throw new HecMathException("generateDataPairs() is not implemented.");
    }

    public PairedDataMath generatePairedData(HecMath tsMath, boolean sort) throws HecMathException {
        throw new HecMathException("generatePairedData() is not implemented.");
    }

    public HecMath generateDataPairs(HecMath math, double buffer) throws HecMathException {
        throw new HecMathException("generateDataPairs() is not implemented.");
    }

    public String getStandardUnits() {
        return "";
    }

    public String getUnits() {
        return "";
    }

    public HecMath interpolateDataAtRegularInterval(String timeIntervalString, String timeOffsetString) throws HecMathException {
        throw new HecMathException("interpolateDataAtRegularInterval() is not implemented.");
    }

    public HecMath inverse() throws HecMathException {
        throw new HecMathException("inverse() is not implemented.");
    }

    public boolean isValid(int index) {
        return false;
    }

    public int lastValidDate() throws HecMathException {
        throw new HecMathException("lastValidDate() is not implemented.");
    }

    public double lastValidValue() throws HecMathException {
        throw new HecMathException("lastValidValue() is not implemented.");
    }

    public HecMath log() throws HecMathException {
        throw new HecMathException("log() is not implemented.");
    }

    public HecMath transformWithFunction(ScalarOperable transformer) throws HecMathException {
        throw new HecMathException("transformWithFunction() is not implemented.");
    }

    public HecMath log10() throws HecMathException {
        throw new HecMathException("log10() is not implemented.");
    }

    public double max() throws HecMathException {
        throw new HecMathException("max() is not implemented.");
    }

    public int maxDate() throws HecMathException {
        throw new HecMathException("maxDate() is not implemented.");
    }

    public double mean() throws HecMathException {
        throw new HecMathException("mean() is not implemented.");
    }

    public HecMath mergePairedDataSets(HecMath math) throws HecMathException {
        throw new HecMathException("mergePairedDataSets() is not implemented.");
    }

    public HecMath mergeTimeSeries(HecMath math) throws HecMathException {
        throw new HecMathException("mergeTimeSeries() is not implemented.");
    }

    public double min() throws HecMathException {
        throw new HecMathException("min() is not implemented.");
    }

    public int minDate() throws HecMathException {
        throw new HecMathException("minDate() is not implemented.");
    }

    public HecMath modifiedPulsRouting(HecMath math, int numberSubreaches, double muskingumX) throws HecMathException {
        throw new HecMathException("modifiedPulsRouting() is not implemented.");
    }

    public HecMath multipleLinearRegression(HecMath[] tsMathArray, double minimumLimit, double maximumLimit) throws HecMathException {
        return this.multipleRegression(tsMathArray, minimumLimit, maximumLimit);
    }

    public HecMath multipleRegression(HecMath[] tsMathArray, double minimumLimit, double maximumLimit) throws HecMathException {
        throw new HecMathException("multipleRegression() is not implemented.");
    }

    public HecMath multiply(double constant) throws HecMathException {
        throw new HecMathException("multiply() is not implemented.");
    }

    public HecMath multiply(HecMath math) throws HecMathException {
        throw new HecMathException("multiply() is not implemented.");
    }

    public HecMath muskingumRouting(int numberSubreaches, double muskingumK, double muskingumX) throws HecMathException {
        throw new HecMathException("muskingumRouting() is not implemented.");
    }

    public int numberMissingValues() throws HecMathException {
        throw new HecMathException("numberMissingValues() is not implemented.");
    }

    public int numberValidValues() throws HecMathException {
        throw new HecMathException("numberValidValues() is not implemented.");
    }

    public HecMath olympicSmoothing(int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws HecMathException {
        throw new HecMathException("olympicSmoothing() is not implemented.");
    }

    public HecMath periodConstants(HecMath math) throws HecMathException {
        throw new HecMathException("periodConstants() is not implemented.");
    }

    public HecMath polynomialTransformation(HecMath tsMath) throws HecMathException {
        throw new HecMathException("polynomialTransformation() is not implemented.");
    }

    public HecMath polynomialTransformationWithIntegral(HecMath tsMath) throws HecMathException {
        throw new HecMathException("polynomialTransformationWithIntegral() is not implemented.");
    }

    public HecMath ratingTableInterpolation(HecMath tsMath) throws HecMathException {
        throw new HecMathException("ratingTableInterpolation() is not implemented.");
    }

    public HecMath reverseRatingTableInterpolation(HecMath tsMath) throws HecMathException {
        throw new HecMathException("reverseRatingTableInterpolation() is not implemented.");
    }

    public HecMath round() throws HecMathException {
        throw new HecMathException("round() is not implemented.");
    }

    public HecMath roundOff(int digitsPrecision, int powerOfTensPlace) throws HecMathException {
        throw new HecMathException("roundOff() is not implemented.");
    }

    public HecMath screenWithForwardMovingAverage(int numberToAverageOver, double changeLimit, boolean setInvalidToMissingValue, String qualityFlagForInvalidValue) throws HecMathException {
        throw new HecMathException("screenWithForwardMovingAverage() is not implemented.");
    }

    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidToMissingValue, String qualityFlagForInvalidValue) throws HecMathException {
        throw new HecMathException("screenWithMaxMin() is not implemented.");
    }

    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidToreplacementValue, double replacementValue, String qualityFlagForInvalidValue) throws HecMathException {
        throw new HecMathException("screenWithMaxMin() is not implemented.");
    }

    public void setCurve(int curveNumber) throws HecMathException {
        throw new HecMathException("setCurve() is not implemented.");
    }

    public void setCurve(String curveName) throws HecMathException {
        throw new HecMathException("setCurve() is not implemented.");
    }

    public HecMath shiftAdjustment(HecMath math) throws HecMathException {
        throw new HecMathException("shiftAdjustment() is not implemented.");
    }

    public HecMath shiftInTime(String timeShiftString) throws HecMathException {
        throw new HecMathException("shiftInTime() is not implemented.");
    }

    public HecMath sin() throws HecMathException {
        throw new HecMathException("sin() is not implemented.");
    }

    public double skewCoefficient() throws HecMathException {
        throw new HecMathException("skewCoefficient() is not implemented.");
    }

    public double kurtosisCoefficient() throws HecMathException {
        throw new HecMathException("kurtosisCoefficient() is not implemented.");
    }

    public double mode() throws HecMathException {
        throw new HecMathException("mode() is not implemented.");
    }

    public double med() throws HecMathException {
        throw new HecMathException("med() is not implemented.");
    }

    public double p1() throws HecMathException {
        throw new HecMathException("p1() is not implemented.");
    }

    public double p2() throws HecMathException {
        throw new HecMathException("p2() is not implemented.");
    }

    public double p5() throws HecMathException {
        throw new HecMathException("p5() is not implemented.");
    }

    public double p10() throws HecMathException {
        throw new HecMathException("p10() is not implemented.");
    }

    public double p20() throws HecMathException {
        throw new HecMathException("p20() is not implemented.");
    }

    public double p25() throws HecMathException {
        throw new HecMathException("p25() is not implemented.");
    }

    public double p75() throws HecMathException {
        throw new HecMathException("p75() is not implemented.");
    }

    public double p80() throws HecMathException {
        throw new HecMathException("p80() is not implemented.");
    }

    public double p90() throws HecMathException {
        throw new HecMathException("p90() is not implemented.");
    }

    public double p95() throws HecMathException {
        throw new HecMathException("p95() is not implemented.");
    }

    public double p98() throws HecMathException {
        throw new HecMathException("p98() is not implemented.");
    }

    public double p99() throws HecMathException {
        throw new HecMathException("p99() is not implemented.");
    }

    public HecMath snapToRegularInterval(String timeIntervalString, String timeOffsetString, String timeBackwardString, String timeForwardString) throws HecMathException {
        throw new HecMathException("snapToRegularInterval() is not implemented.");
    }

    public HecMath sqrt() throws HecMathException {
        throw new HecMathException("sqrt() is not implemented.");
    }

    public double standardDeviation() throws HecMathException {
        throw new HecMathException("standardDeviation() is not implemented.");
    }

    public HecMath standardNormalDeviate() throws HecMathException {
        throw new HecMathException("standardNormalDeviate() is not implemented.");
    }

    public HecMath straddleStaggerRouting(int numberToAverage, int numberToLag, int numberSubreaches) throws HecMathException {
        throw new HecMathException("straddleStaggerRouting() is not implemented.");
    }

    public HecMath subtract(double constant) throws HecMathException {
        throw new HecMathException("subtract() is not implemented.");
    }

    public HecMath subtract(HecMath math) throws HecMathException {
        throw new HecMathException("subtract() is not implemented.");
    }

    public HecMath successiveDifferences() throws HecMathException {
        throw new HecMathException("successiveDifferences() is not implemented.");
    }

    public double sum() throws HecMathException {
        throw new HecMathException("sum() is not implemented.");
    }

    public HecMath tan() throws HecMathException {
        throw new HecMathException("tan() is not implemented.");
    }

    public HecMath timeDerivative() throws HecMathException {
        throw new HecMathException("timeDerivative() is not implemented.");
    }

    public HecMath transformTimeSeries(HecMath math, String functionTypeString) throws HecMathException {
        throw new HecMathException("transformTimeSeries() is not implemented.");
    }

    public HecMath transformTimeSeries(HecMath math, String functionTypeString, boolean toIrregular) throws HecMathException {
        throw new HecMathException("transformTimeSeries() is not implemented.");
    }

    public HecMath transformTimeSeries(String timeIntervalString, String timeOffsetString, String functionTypeString, boolean toIrregular) throws HecMathException {
        throw new HecMathException("transformTimeSeries() is not implemented.");
    }

    public HecMath truncate() throws HecMathException {
        throw new HecMathException("truncate() is not implemented.");
    }

    public HecMath twoVariableRatingTableInterpolation(HecMath tsMathX, HecMath tsMathZ) throws HecMathException {
        throw new HecMathException("twoVariableRatingTableInterpolation() is not implemented.");
    }

    public HecMath convertToIrregular(String timeIntervalString) throws HecMathException {
        throw new HecMathException("timeIntervalString is not implemented.");
    }

    public HecMath transformTimeSeries(String timeIntervalString, String timeOffsetString, String functionTypeString) throws HecMathException {
        return this.transformTimeSeries(timeIntervalString, timeOffsetString, functionTypeString);
    }

    public abstract void setData(DataContainer var1) throws HecMathException;

    public abstract void getData(DataContainer var1) throws HecMathException;

    public abstract DataContainer getData() throws HecMathException;

    public int getSelectedCurve() {
        return this._curveNumber;
    }

    public abstract HecMath convertToEnglishUnits() throws HecMathException;

    public abstract HecMath convertToMetricUnits() throws HecMathException;

    public abstract boolean isMetric() throws HecMathException;

    public abstract boolean isEnglish() throws HecMathException;

    public abstract boolean canDetermineUnitSystem();

    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, String timeIntervalString, String timeOffsetString, double initialValue) throws HecMathException {
        return TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeIntervalString, timeOffsetString, initialValue);
    }

    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, String timeIntervalString, double initialValue) throws HecMathException {
        return TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeIntervalString, initialValue);
    }

    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, int timeIntervalMinutes, int timeOffsetMinutes, double initialValue) throws HecMathException {
        return TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeIntervalMinutes, timeOffsetMinutes, initialValue);
    }

    public abstract HecMath copy() throws HecMathException;

    public abstract void setUnits(String var1);

    protected String getFunctionName(int functionType) {
        String fname = "Undefined";
        if (functionType == 1) {
            fname = "add";
        } else if (functionType == 2) {
            fname = "subtract";
        } else if (functionType == 3) {
            fname = "multiply";
        } else if (functionType == 4) {
            fname = "divide";
        } else if (functionType == 5) {
            fname = "exponentiation";
        } else if (functionType == 11) {
            fname = "squareRoot";
        } else if (functionType == 12) {
            fname = "log10";
        } else if (functionType == 13) {
            fname = "log";
        } else if (functionType == 14) {
            fname = "abs";
        } else if (functionType == 15) {
            fname = "truncate";
        } else if (functionType == 16) {
            fname = "round";
        } else if (functionType == 17) {
            fname = "sin";
        } else if (functionType == 18) {
            fname = "cos";
        } else if (functionType == 19) {
            fname = "tan";
        } else if (functionType == 20) {
            fname = "inverse";
        }
        return fname;
    }

    @Scriptable
    public static HecMath createInstance(DataContainer dc) throws HecMathException {
        if (dc == null) {
            throw new HecMathException("HecMath.createInstance: Data Container is null");
        }
        HecMath math = null;
        if (dc instanceof TimeSeriesContainerVertDatum) {
            math = new TimeSeriesMathVertDatum();
            math.setData(dc);
        } else if (dc instanceof TimeSeriesContainer) {
            math = new TimeSeriesMath();
            math.setData(dc);
        } else if (dc instanceof PairedDataContainer) {
            math = new PairedDataMath();
            math.setData(dc);
        } else if (dc instanceof TextContainer) {
            math = new TextMath();
            math.setData(dc);
        } else {
            String msg = "HecMath.createInstance: DataContainer type not recognized";
            throw new HecMathException(msg);
        }
        return math;
    }

    public static HecMath createInstance(TSRecord tsRecord) throws HecMathException {
        if (tsRecord == null) {
            throw new HecMathException("HecMath.createInstance: TSRecord is null");
        }
        TimeSeriesContainer tsc = tsRecord.getTimeSeriesContainer();
        TimeSeriesMath math = new TimeSeriesMath();
        ((HecMath)math).setData(tsc);
        return math;
    }

    public static boolean isValid(byte[] bytes) {
        return true;
    }

    @Scriptable
    public static boolean checkContainer(DataContainer dc) throws HecMathException {
        if (dc == null) {
            System.out.println("Data Container is null");
            throw new HecMathException("Data Container is null");
        }
        return true;
    }

    @Scriptable
    public static boolean isMissing(double value) {
        return value == -3.4028234663852886E38;
    }

    @Scriptable
    public void setPathname(String pathname) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(pathname);
        this._dc.watershed = this._dssPath.aPart();
        this._dc.location = this._dssPath.bPart();
        this._dc.version = this._dssPath.fPart();
        this._dc.fullName = pathname;
    }

    @Scriptable
    public void setWatershed(String watershed) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setAPart(watershed);
        this._dc.fullName = this._dssPath.getPathname();
        this._dc.watershed = watershed;
    }

    @Scriptable
    public void setLocation(String location) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setBPart(location);
        this._dc.fullName = this._dssPath.getPathname();
        this._dc.location = location;
    }

    @Scriptable
    public void setTimeInterval(String timeInterval) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setEPart(timeInterval);
        this._dc.fullName = this._dssPath.getPathname();
    }

    @Scriptable
    public void setDPart(String dPart) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setDPart(dPart);
        this._dc.fullName = this._dssPath.getPathname();
    }

    @Scriptable
    public void setEPart(String ePart) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setEPart(ePart);
        this._dc.fullName = this._dssPath.getPathname();
    }

    @Scriptable
    public void setVersion(String version) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setFPart(version);
        this._dc.fullName = this._dssPath.getPathname();
        this._dc.version = version;
    }

    @Scriptable
    public void setParameterPart(String paramString) throws HecMathException {
        HecMath.checkContainer(this._dc);
        this._dssPath.setPathname(this._dc.fullName);
        this._dssPath.setCPart(paramString);
        this._dc.fullName = this._dssPath.getPathname();
    }

    protected static int bisearch(int[] xarray, int x, int n) {
        return TimeSeriesFunctions.bisearch(xarray, x, n);
    }

    protected static int bisearch(double[] xarray, double x, int n) {
        return TimeSeriesFunctions.bisearch(xarray, x, n);
    }

    protected static int hunt(double[] xarray, double x, int istart) {
        int khi;
        int n = xarray.length;
        int klo = istart + 1;
        boolean ascnd = false;
        if (xarray[n - 1] > xarray[0]) {
            ascnd = true;
        }
        if (klo <= 0 || klo > n) {
            klo = 0;
            khi = n + 1;
        } else {
            int inc = 1;
            if (x >= xarray[klo - 1] == ascnd) {
                if (klo == n) {
                    return klo - 1;
                }
                khi = klo + 1;
                while (x >= xarray[khi - 1] == ascnd) {
                    klo = khi;
                    if ((khi = klo + (inc += inc)) <= n) continue;
                    khi = n + 1;
                    break;
                }
            } else {
                if (klo == 1) {
                    return -1;
                }
                khi = klo--;
                while (x < xarray[klo - 1] == ascnd) {
                    khi = klo;
                    if ((klo = khi - (inc += inc)) >= 1) continue;
                    klo = 0;
                    break;
                }
            }
        }
        if (ascnd) {
            while (khi - klo > 1) {
                int k = (khi + klo) / 2;
                if (xarray[k - 1] > x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        } else {
            while (khi - klo > 1) {
                int k = (khi + klo) / 2;
                if (xarray[k - 1] < x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        }
        return klo - 1;
    }

    public static double roundOffValue(double dvalue, int desiredPrecision, int powerOfTensPlace) {
        if (dvalue == 0.0 || dvalue == -3.4028234663852886E38) {
            return dvalue;
        }
        double dd = dvalue;
        if (dd < 0.0) {
            dd = -dd;
        }
        int e = 0;
        double factor = 1.0;
        while (dd > 10.0) {
            ++e;
            factor /= 10.0;
            dd /= 10.0;
        }
        while (dd < 1.0) {
            --e;
            factor *= 10.0;
            dd *= 10.0;
        }
        int precision = e + 1 - powerOfTensPlace;
        if (precision > desiredPrecision) {
            precision = desiredPrecision;
        }
        double newVal = 0.0;
        if (precision >= 0) {
            double factPrecision = Math.pow(10.0, precision - 1);
            newVal = Math.rint(factPrecision * dd) / factPrecision;
            newVal *= 1.0 / factor;
            if (dvalue < 0.0) {
                newVal = -newVal;
            }
        }
        return newVal;
    }

    @Scriptable
    public String getPath() {
        if (this._dc == null) {
            return null;
        }
        return this._dc.fullName;
    }

    LinearRegressionStatistics getLinearRegressionStatistics(double[] array1, double[] array2) throws HecMathException {
        try {
            double sumX = 0.0;
            double sumY = 0.0;
            double sumXX = 0.0;
            double sumYY = 0.0;
            double sumXY = 0.0;
            int numberGood = 0;
            for (int i = 0; i < array1.length; ++i) {
                if (!RMAConst.isValidValue(array1[i]) || !RMAConst.isValidValue(array2[i])) continue;
                sumX += array1[i];
                sumY += array2[i];
                sumXX += array1[i] * array1[i];
                sumYY += array2[i] * array2[i];
                sumXY += array1[i] * array2[i];
                ++numberGood;
            }
            double nval = numberGood;
            if (nval < 1.0) {
                throw new HecMathException("HecMath.correlationCoefficients: No valid value pairs found for computation ");
            }
            double b = (sumXY -= sumX * sumY / nval) / (sumXX -= sumX * sumX / nval);
            double a = (sumY - b * sumX) / nval;
            double r = sumXY / Math.sqrt(sumXX * (sumYY -= sumY * sumY / nval));
            double rsq = sumXY * sumXY / (sumXX * sumYY);
            double ser = Math.sqrt((1.0 - rsq) * sumYY / (nval - 1.0));
            double rbsq = rsq;
            double sera = ser;
            if (numberGood >= 2) {
                rbsq = 1.0 - (1.0 - rsq) * (nval - 1.0) / (nval - 2.0);
                sera = Math.sqrt((1.0 - rbsq) * sumYY / (nval - 1.0));
            }
            LinearRegressionStatistics stats = new LinearRegressionStatistics();
            stats.regressionConstant = a;
            stats.regressionCoefficient = b;
            stats.correlationCoefficient = r;
            stats.determinationCoefficient = rsq;
            stats.standardErrorOfRegression = ser;
            stats.adjustedDeterminationCoefficient = rbsq;
            stats.adjustedStandardErrorOfRegression = sera;
            stats.numberValidValues = numberGood;
            return stats;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new HecMathException("HecMath.correlationCoefficients : " + e.toString());
        }
    }
}

