/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.hecmath.computation.ComputationException;
import hec.io.TimeSeriesContainer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import rma.util.RMAConst;

public class MassBalancedEvent {
    private double[] _originalValues;
    private long[] _originalTimes;
    private double[] _balancedValues;
    private long _dataDuration = 3600000L;
    private double[] _avgTargetValues;
    private long[] _avgTargetDurations;
    private DataType _dataType;
    private boolean _isBalanceEntireEvent = false;
    private boolean _isCoincidentEvents = false;
    private NavigableMap<Long, long[]> _timeWindowMap = new TreeMap<Long, long[]>();
    private Map<Long, AverageData> _averageDataMap = new HashMap<Long, AverageData>();
    private long _primaryDuration;
    private int _iterationsUsed = 0;

    public MassBalancedEvent() {
    }

    public MassBalancedEvent(TimeSeriesContainer tsc, long dataDuration, double[] avgTargetValues, long[] avgTargetDurations, DataType dataType) {
        this.setData(tsc, dataDuration, avgTargetValues, avgTargetDurations, dataType);
    }

    public void setData(TimeSeriesContainer tsc, long dataDuration, double[] avgTargetValues, long[] avgTargetDurations, DataType dataType) {
        this._originalValues = tsc.values;
        this._originalTimes = new long[tsc.times.length];
        for (int i = 0; i < this._originalTimes.length; ++i) {
            this._originalTimes[i] = (long)tsc.times[i] * 60000L;
        }
        this._dataDuration = dataDuration;
        this._avgTargetValues = avgTargetValues;
        this._avgTargetDurations = avgTargetDurations;
        this._dataType = dataType;
        this.dataChecks();
        this._primaryDuration = this._avgTargetDurations[0];
        this.populateAverageDataMap();
    }

    public Map<Long, Double> getDurationMagnitudeMap() {
        HashMap<Long, Double> retval = new HashMap<Long, Double>();
        for (Long dur : this._averageDataMap.keySet()) {
            Double magnitude = this._averageDataMap.get(dur).getOriginalAverage();
            if (DataType.PerCum.equals((Object)this._dataType)) {
                magnitude = magnitude * ((double)dur.longValue() / (double)this._dataDuration);
            }
            retval.put(dur, magnitude);
        }
        return retval;
    }

    public void setData(double[] values, int[] times, long dataDuration, double[] avgTargetValues, long[] avgTargetDurations, DataType dataType) {
        this._originalValues = values;
        this._originalTimes = new long[times.length];
        for (int i = 0; i < this._originalTimes.length; ++i) {
            this._originalTimes[i] = (long)times[i] * 60000L;
        }
        this._dataDuration = dataDuration;
        this._avgTargetValues = avgTargetValues;
        this._avgTargetDurations = avgTargetDurations;
        this._dataType = dataType;
        this.dataChecks();
        this._primaryDuration = this._avgTargetDurations[0];
        this.populateAverageDataMap();
    }

    public MassBalancedEvent(double[] values, long[] times, long dataDuration, double[] avgTargetValues, long[] avgTargetDurations, DataType dataType) {
        this._originalValues = values;
        this._originalTimes = times;
        this._dataDuration = dataDuration;
        this._avgTargetValues = avgTargetValues;
        this._avgTargetDurations = avgTargetDurations;
        this._dataType = dataType;
        this.dataChecks();
        this._primaryDuration = this._avgTargetDurations[0];
        this.populateAverageDataMap();
    }

    public void setTimeWindowMap(NavigableMap<Long, long[]> twMap) {
        int i = 0;
        for (long dur : this._avgTargetDurations) {
            if (!twMap.containsKey(dur)) continue;
            ++i;
        }
        if (i != this._avgTargetDurations.length) {
            throw new IllegalArgumentException("Time window map inconsistent with target durations.");
        }
        this._timeWindowMap.clear();
        this._timeWindowMap.putAll(twMap);
    }

    public NavigableMap<Long, long[]> getTimeWindowMap() {
        TreeMap<Long, long[]> retval = new TreeMap<Long, long[]>();
        for (Long dur : this._averageDataMap.keySet()) {
            retval.put(dur, new long[]{this._averageDataMap.get(dur).getStartTime(), this._averageDataMap.get(dur).getEndTime()});
        }
        return retval;
    }

    public void setPrimaryDuration(long duration) {
        if (!this._averageDataMap.containsKey(duration)) {
            throw new IllegalArgumentException("Primary duration: " + duration + " does not exist. Check inputs");
        }
        this._primaryDuration = duration;
    }

    private void populateAverageDataMap() {
        for (int i = 0; i < this._avgTargetDurations.length; ++i) {
            AverageData data = new AverageData();
            data.setDuration(this._avgTargetDurations[i]);
            data.setDesiredAverage(this._avgTargetValues[i]);
            this._averageDataMap.put(this._avgTargetDurations[i], data);
        }
    }

    private void dataChecks() {
        if (this._originalValues == null || this._avgTargetDurations == null || this._avgTargetDurations.length < 1 || this._avgTargetValues == null || this._avgTargetValues.length < 1) {
            throw new NullPointerException("Values improperly initialized in MassBalanceEvent");
        }
        if (this._avgTargetDurations.length != this._avgTargetValues.length) {
            throw new IllegalArgumentException("Durations and target values must have the same size.");
        }
        if (!this.isMonotonicallyIncreasing(this._avgTargetDurations)) {
            throw new IllegalArgumentException("Durations must be monotonically increasing");
        }
        if ((long)this._originalValues.length * this._dataDuration < this._avgTargetDurations[this._avgTargetDurations.length - 1]) {
            throw new IllegalArgumentException("Largest duration is longer than the data time window. Cannot scale data.");
        }
        if (!this.areTargetDurationsDivisibleByDataDuration()) {
            throw new IllegalArgumentException("Largest duration is longer than the data time window. Cannot scale data.");
        }
        if (!this.checkValues()) {
            throw new IllegalArgumentException("Invalid data in the data values or target values.");
        }
    }

    private boolean checkValues() {
        int i;
        for (i = 0; i < this._originalValues.length; ++i) {
            if (RMAConst.isValidValue(this._originalValues[i])) continue;
            return false;
        }
        for (i = 0; i < this._avgTargetValues.length; ++i) {
            if (RMAConst.isValidValue(this._avgTargetValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areTargetDurationsDivisibleByDataDuration() {
        if (!RMAConst.isValidValue(this._dataDuration) || this._dataDuration <= 0L) {
            return false;
        }
        for (int i = 0; i < this._avgTargetDurations.length; ++i) {
            if (this._avgTargetDurations[i] == 0L || RMAConst.isValidValue(this._avgTargetDurations[i]) && this._avgTargetDurations[i] > 0L && this._avgTargetDurations[i] % this._dataDuration == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean isMonotonicallyIncreasing(double[] vals) {
        if (!RMAConst.isValidValue(vals[0])) {
            return false;
        }
        for (int i = 1; i < vals.length; ++i) {
            if (RMAConst.isValidValue(vals[i]) && !(vals[i - 1] >= vals[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isMonotonicallyIncreasing(long[] vals) {
        if (!RMAConst.isValidValue(vals[0])) {
            return false;
        }
        for (int i = 1; i < vals.length; ++i) {
            if (RMAConst.isValidValue(vals[i]) && vals[i - 1] < vals[i]) continue;
            return false;
        }
        return true;
    }

    private int durationIndex() {
        if (this._avgTargetDurations.length == 1) {
            return 0;
        }
        for (int i = 0; i < this._avgTargetDurations.length; ++i) {
            if (this._avgTargetDurations[i] != this._primaryDuration) continue;
            return i;
        }
        throw new IllegalArgumentException("Primary duration does not exist in target duration list.");
    }

    public void computePeakDurationTimeWindowInformation() throws ComputationException {
        if (this._timeWindowMap == null || this._timeWindowMap.isEmpty()) {
            int j;
            for (int i = j = this.durationIndex(); i < this._avgTargetDurations.length; ++i) {
                AverageData data = this._averageDataMap.get(this._avgTargetDurations[i]);
                AverageData longerData = null;
                if (i < this._avgTargetDurations.length - 1 && this._isCoincidentEvents) {
                    longerData = this._averageDataMap.get(this._avgTargetDurations[i + 1]);
                }
                this.findPeakAverageData(data, this._originalValues, this._originalTimes, true, longerData);
            }
            double[] valuesSubArray = Arrays.copyOfRange(this._originalValues, this._averageDataMap.get(this._avgTargetDurations[j]).getStartIndex(), this._averageDataMap.get(this._avgTargetDurations[j]).getEndIndex());
            long[] timesSubArray = null;
            if (this._originalTimes != null) {
                timesSubArray = Arrays.copyOfRange(this._originalTimes, this._averageDataMap.get(this._avgTargetDurations[j]).getStartIndex(), this._averageDataMap.get(this._avgTargetDurations[j]).getEndIndex());
            }
            for (int i = 0; i < j; ++i) {
                AverageData data = this._averageDataMap.get(this._avgTargetDurations[i]);
                AverageData longerData = null;
                if (i < this._avgTargetDurations.length - 1 && this._isCoincidentEvents) {
                    longerData = this._averageDataMap.get(this._avgTargetDurations[i + 1]);
                }
                this.findPeakAverageData(data, valuesSubArray, timesSubArray, true, longerData);
                data.setStartIndex(this.indexOf(this._originalTimes, data.getStartTime()));
                data.setEndIndex(this.indexOf(this._originalTimes, data.getEndTime()));
            }
            this.fillTimeWindowMap();
        } else {
            for (int i = 0; i < this._avgTargetDurations.length; ++i) {
                AverageData data = this._averageDataMap.get(this._avgTargetDurations[i]);
                long[] tw = (long[])this._timeWindowMap.get(this._avgTargetDurations[i]);
                int index1 = this.indexOf(this._originalTimes, tw[0]);
                int index2 = this.indexOf(this._originalTimes, tw[1]);
                if (index1 < 0 || index2 < 0) {
                    throw new ComputationException("Failed to identify proper time window for scaling.");
                }
                this.findPeakAverageData(data, Arrays.copyOfRange(this._originalValues, index1, index2 + 1), Arrays.copyOfRange(this._originalTimes, index1, index2 + 1), true, null);
                data.setStartIndex(index1);
                data.setEndIndex(index2);
            }
        }
    }

    private void fillTimeWindowMap() {
        for (Long key : this._averageDataMap.keySet()) {
            long[] tw = new long[]{this._averageDataMap.get(key).getStartTime(), this._averageDataMap.get(key).getEndTime()};
            this._timeWindowMap.put(key, tw);
        }
    }

    private int indexOf(long[] times, long time) {
        for (int i = 0; i < times.length; ++i) {
            if (times[i] != time) continue;
            return i;
        }
        return -1;
    }

    public void balanceEvent() throws ComputationException {
        if (DataType.PerCum.equals((Object)this._dataType)) {
            for (Map.Entry<Long, AverageData> vals : this._averageDataMap.entrySet()) {
                vals.getValue().setDesiredAverage(vals.getValue().getDesiredAverage() / ((double)vals.getKey().longValue() / (double)this._dataDuration));
            }
        }
        int trial = 0;
        this.applyInitialAdjustment();
        boolean modified = false;
        boolean done = false;
        do {
            done = true;
            if (modified = this.modifyEventShape(++trial)) {
                done = false;
            }
            if (!(modified = this.adjustEvent())) continue;
            done = false;
        } while (!done && trial < 100);
        this.setIterationsUsed(trial);
        for (long duration : this._avgTargetDurations) {
            AverageData data = this._averageDataMap.get(duration);
            int startIndex = data.getStartIndex();
            int endIndex = data.getEndIndex();
            double averageFlow = this.findAverageData(startIndex, endIndex, this._originalValues);
            data.setOriginalAverage(averageFlow);
        }
        if (DataType.PerCum.equals((Object)this._dataType)) {
            Object object = this._averageDataMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry vals = (Map.Entry)object.next();
                ((AverageData)vals.getValue()).setDesiredAverage(((AverageData)vals.getValue()).getDesiredAverage() * ((double)((Long)vals.getKey()).longValue() * (double)this._dataDuration));
            }
        }
    }

    private void setIterationsUsed(int iterations) {
        this._iterationsUsed = iterations;
    }

    private boolean adjustEvent() throws ComputationException {
        double adjustedFlow;
        boolean modified = false;
        double tolerance = 1.0E-5;
        int leadStartIndex = 0;
        int tailEndIndex = this._balancedValues.length - 1;
        double leadFlowLimit = 1.0E10;
        double tailFlowLimit = 1.0E10;
        double previousDuration = 0.0;
        double previousDurationAverageFlow = 0.0;
        double ratio = 1.0;
        for (int j = 0; j < this._avgTargetDurations.length; ++j) {
            long duration = this._avgTargetDurations[j];
            AverageData data = this._averageDataMap.get(this._avgTargetDurations[j]);
            int startIndex = data.getLeadStartIndex();
            int endIndex = data.getTailEndIndex();
            double averageFlow = this.findAverageData(startIndex, endIndex, this._balancedValues);
            double previousVolume = previousDuration * previousDurationAverageFlow;
            double desiredVolume = data.getDesiredAverage() * (double)duration - previousVolume;
            double volume = averageFlow * (double)duration - previousVolume;
            ratio = desiredVolume > 0.0 && volume > 0.0 ? desiredVolume / volume : data.getDesiredAverage() / averageFlow;
            if (Math.abs(ratio - 1.0) > tolerance) {
                int i;
                int start = data.getLeadStartIndex();
                int end = data.getLeadEndIndex();
                for (i = start; i <= end; ++i) {
                    adjustedFlow = RMAConst.isUndefinedValue(this._balancedValues[i]) ? this._balancedValues[i] : ratio * this._balancedValues[i];
                    this._balancedValues[i] = Math.min(adjustedFlow, leadFlowLimit);
                }
                if (data.getTailStartIndex() > data.getLeadEndIndex()) {
                    start = data.getTailStartIndex();
                    end = data.getTailEndIndex();
                    for (i = start; i <= end; ++i) {
                        adjustedFlow = RMAConst.isUndefinedValue(this._balancedValues[i]) ? this._balancedValues[i] : ratio * this._balancedValues[i];
                        this._balancedValues[i] = Math.min(adjustedFlow, tailFlowLimit);
                    }
                }
                averageFlow = this.findAverageData(startIndex, endIndex, this._balancedValues);
                modified = true;
            }
            data.setAdjustedAverage(averageFlow);
            leadFlowLimit = this._balancedValues[startIndex];
            tailFlowLimit = this._balancedValues[endIndex];
            previousDurationAverageFlow = averageFlow;
            leadStartIndex = data.getLeadStartIndex();
            tailEndIndex = data.getTailEndIndex();
        }
        if (this._isBalanceEntireEvent && Math.abs(ratio - 1.0) > tolerance) {
            int i;
            for (i = 0; i < leadStartIndex; ++i) {
                adjustedFlow = RMAConst.isUndefinedValue(this._balancedValues[i]) ? this._balancedValues[i] : ratio * this._balancedValues[i];
                this._balancedValues[i] = Math.min(adjustedFlow, leadFlowLimit);
            }
            for (i = tailEndIndex + 1; i < this._balancedValues.length; ++i) {
                adjustedFlow = RMAConst.isUndefinedValue(this._balancedValues[i]) ? this._balancedValues[i] : ratio * this._balancedValues[i];
                this._balancedValues[i] = Math.min(adjustedFlow, tailFlowLimit);
            }
        }
        return modified;
    }

    private boolean modifyEventShape(int trial) {
        boolean modified = false;
        for (long duration : this._avgTargetDurations) {
            int i;
            double factor;
            int index;
            AverageData data = this._averageDataMap.get(duration);
            int startIndex = data.getLeadStartIndex();
            int endIndex = data.getTailEndIndex();
            if (data.getAdjustedAverage() <= data.getDesiredAverage()) continue;
            double startFlow = this._balancedValues[startIndex];
            if (startIndex > 0 && this._balancedValues[startIndex - 1] > startFlow) {
                int i2;
                double factor2;
                int index2;
                for (index2 = startIndex - 1; index2 >= 0 && this._balancedValues[index2] > startFlow; --index2) {
                }
                while (index2 >= 0 && RMAConst.isUndefinedValue(this._balancedValues[index2])) {
                    ++index2;
                }
                if (index2 >= 0) {
                    if (this._balancedValues[index2] < startFlow) {
                        factor2 = (this._balancedValues[index2] - startFlow) / (double)(index2 - startIndex);
                        for (i2 = index2; i2 < startIndex; ++i2) {
                            this._balancedValues[i2] = factor2 * (double)(i2 - startIndex) + startFlow;
                        }
                    } else {
                        factor2 = (startFlow - 1.0) / this._balancedValues[startIndex - 1];
                        for (i2 = 0; i2 < startIndex; ++i2) {
                            if (!RMAConst.isValidValue(this._balancedValues[i2])) continue;
                            int n = i2;
                            this._balancedValues[n] = this._balancedValues[n] * factor2;
                        }
                    }
                } else {
                    factor2 = (startFlow - 1.0) / this._balancedValues[startIndex - 1];
                    for (i2 = 0; i2 < startIndex; ++i2) {
                        if (!RMAConst.isValidValue(this._balancedValues[i2])) continue;
                        int n = i2;
                        this._balancedValues[n] = this._balancedValues[n] * factor2;
                    }
                }
                modified = true;
            }
            double endFlow = this._balancedValues[endIndex];
            if (endIndex >= this._balancedValues.length - 1 || !(this._balancedValues[endIndex + 1] > endFlow)) continue;
            for (index = endIndex + 1; index < this._balancedValues.length && this._balancedValues[index] > endFlow; ++index) {
            }
            while (index < this._balancedValues.length && RMAConst.isUndefinedValue(this._balancedValues[index])) {
                --index;
            }
            if (index < this._balancedValues.length) {
                if (this._balancedValues[index] < endFlow) {
                    factor = (this._balancedValues[index] - endFlow) / (double)(index - endIndex);
                    for (i = endIndex + 1; i < index; ++i) {
                        this._balancedValues[i] = factor * (double)(i - endIndex) + endFlow;
                    }
                } else {
                    factor = (endFlow - 1.0) / this._balancedValues[endIndex + 1];
                    for (i = endIndex + 1; i < index; ++i) {
                        if (!RMAConst.isValidValue(this._balancedValues[i])) continue;
                        int n = i;
                        this._balancedValues[n] = this._balancedValues[n] * factor;
                    }
                }
            } else {
                factor = (endFlow - 1.0) / this._balancedValues[endIndex + 1];
                for (i = endIndex + 1; i < this._balancedValues.length; ++i) {
                    if (!RMAConst.isValidValue(this._balancedValues[i])) continue;
                    int n = i;
                    this._balancedValues[n] = this._balancedValues[n] * factor;
                }
            }
            modified = true;
        }
        return modified;
    }

    private double findAverageData(int startIndex, int endIndex, double[] flow) {
        double averageFlow;
        double sum = 0.0;
        if (DataType.PerAvg.equals((Object)this._dataType) || DataType.PerCum.equals((Object)this._dataType)) {
            for (int i = startIndex; i <= endIndex; ++i) {
                sum += flow[i];
            }
            averageFlow = sum / (double)(endIndex - startIndex + 1);
        } else if (startIndex == endIndex) {
            averageFlow = flow[endIndex];
        } else {
            for (int i = startIndex; i < endIndex; ++i) {
                sum += 0.5 * (flow[i] + flow[i + 1]);
            }
            averageFlow = sum / (double)(endIndex - startIndex);
        }
        return averageFlow;
    }

    public void findPeakAverageData(AverageData data, double[] values, long[] times, boolean isBasisFlow, AverageData encompassingData) {
        long duration = data.getDuration();
        long timeInterval = this._dataDuration;
        int intervalsPerDuration = (int)(duration / timeInterval);
        int[] startIndex = new int[]{0};
        if (data.getEncompassedStartIndex() > 0) {
            startIndex[0] = data.getEncompassedEndIndex() - intervalsPerDuration;
            if (startIndex[0] < 0) {
                startIndex[0] = 0;
            }
        }
        while (startIndex[0] < values.length && RMAConst.isUndefinedValue(values[startIndex[0]])) {
            startIndex[0] = startIndex[0] + 1;
        }
        int[] endIndex = new int[1];
        double maxAverageData = MassBalancedEvent.computeMaximumAverageValue(data.getEncompassedStartIndex(), values, intervalsPerDuration, startIndex, endIndex, this._dataType);
        if (isBasisFlow) {
            data.setOriginalAverage(maxAverageData);
        }
        data.setStartIndex(startIndex[0]);
        data.setEndIndex(endIndex[0]);
        if (times != null && times.length > endIndex[0]) {
            data.setStartTime(times[startIndex[0]]);
            data.setEndTime(times[endIndex[0]]);
        }
        if (encompassingData != null) {
            encompassingData.setEncompassedStartIndex(startIndex[0]);
            encompassingData.setEncompassedEndIndex(endIndex[0]);
        }
    }

    public static double computeMaximumAverageValue(int encompassedStartIndex, double[] values, int intervalsPerDuration, int[] startIndex, int[] endIndex, DataType dt) {
        double maxAverageData;
        if (DataType.PerAvg.equals((Object)dt) || DataType.PerCum.equals((Object)dt)) {
            int count = Math.min(intervalsPerDuration, values.length);
            double sum = 0.0;
            for (int i = startIndex[0]; i < startIndex[0] + count && i < values.length; ++i) {
                sum += values[i];
            }
            endIndex[0] = startIndex[0] + count - 1;
            maxAverageData = sum;
            int lastSearchIndex = values.length;
            if (encompassedStartIndex >= 0 && (lastSearchIndex = encompassedStartIndex + intervalsPerDuration) > values.length) {
                lastSearchIndex = values.length;
            }
            for (int i = endIndex[0] + 1; i < lastSearchIndex; ++i) {
                sum += values[i];
                if (!((sum -= values[i - count]) > maxAverageData)) continue;
                maxAverageData = sum;
                endIndex[0] = i;
            }
            maxAverageData /= (double)count;
            startIndex[0] = endIndex[0] - count + 1;
        } else if (intervalsPerDuration == 0) {
            maxAverageData = 0.0;
            endIndex[0] = 0;
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] > maxAverageData)) continue;
                maxAverageData = values[i];
                endIndex[0] = i;
            }
            startIndex[0] = endIndex[0];
        } else {
            int count = Math.min(intervalsPerDuration + 1, values.length);
            double sum = 0.0;
            for (int i = startIndex[0] + 1; i < startIndex[0] + count && i < values.length; ++i) {
                sum += 0.5 * (values[i - 1] + values[i]);
            }
            endIndex[0] = startIndex[0] + count - 1;
            maxAverageData = sum;
            int lastSearchIndex = values.length;
            if (encompassedStartIndex >= 0 && (lastSearchIndex = encompassedStartIndex + intervalsPerDuration) > values.length) {
                lastSearchIndex = values.length;
            }
            for (int i = endIndex[0] + 1; i < lastSearchIndex; ++i) {
                sum += 0.5 * (values[i - 1] + values[i]);
                if (!((sum -= 0.5 * (values[i - count] + values[i - count + 1])) > maxAverageData)) continue;
                maxAverageData = sum;
                endIndex[0] = i;
            }
            maxAverageData /= (double)(count - 1);
            startIndex[0] = endIndex[0] - count + 1;
        }
        return maxAverageData;
    }

    private void applyInitialAdjustment() {
        int i;
        this._balancedValues = new double[this._originalValues.length];
        System.arraycopy(this._originalValues, 0, this._balancedValues, 0, this._balancedValues.length);
        int leadStartIndex = 0;
        int tailEndIndex = this._originalValues.length - 1;
        AverageData data = this._averageDataMap.get(this._avgTargetDurations[0]);
        int startIndex = data.getLeadStartIndex();
        int endIndex = data.getTailEndIndex();
        data.setLeadEndIndex(endIndex);
        data.setTailStartIndex(startIndex);
        double ratio = data.getDesiredAverage() / data.getOriginalAverage();
        for (int j = startIndex; j <= endIndex; ++j) {
            if (!RMAConst.isValidValue(this._balancedValues[j])) continue;
            int n = j;
            this._balancedValues[n] = this._balancedValues[n] * ratio;
        }
        if (this._avgTargetDurations.length == 1) {
            leadStartIndex = startIndex;
            tailEndIndex = endIndex;
        }
        double prevRatio = ratio;
        for (i = 1; i < this._avgTargetDurations.length; ++i) {
            int j;
            data = this._averageDataMap.get(this._avgTargetDurations[i]);
            data.setLeadEndIndex(startIndex - 1);
            data.setTailStartIndex(endIndex + 1);
            ratio = data.getDesiredAverage() / data.getOriginalAverage();
            ratio = Math.min(ratio, prevRatio);
            startIndex = data.getLeadStartIndex();
            endIndex = data.getLeadEndIndex();
            for (j = startIndex; j <= endIndex; ++j) {
                if (!RMAConst.isValidValue(this._balancedValues[j])) continue;
                int n = j;
                this._balancedValues[n] = this._balancedValues[n] * ratio;
            }
            startIndex = data.getTailStartIndex();
            endIndex = data.getTailEndIndex();
            for (j = startIndex; j <= endIndex; ++j) {
                if (!RMAConst.isValidValue(this._balancedValues[j])) continue;
                int n = j;
                this._balancedValues[n] = this._balancedValues[n] * ratio;
            }
            startIndex = data.getLeadStartIndex();
            endIndex = data.getTailEndIndex();
            prevRatio = ratio;
            leadStartIndex = data.getLeadStartIndex();
            tailEndIndex = data.getTailEndIndex();
        }
        if (this._isBalanceEntireEvent) {
            for (i = 0; i < leadStartIndex; ++i) {
                if (!RMAConst.isValidValue(this._balancedValues[i])) continue;
                int n = i;
                this._balancedValues[n] = this._balancedValues[n] * ratio;
            }
            for (i = tailEndIndex + 1; i < this._balancedValues.length; ++i) {
                if (!RMAConst.isValidValue(this._balancedValues[i])) continue;
                int n = i;
                this._balancedValues[n] = this._balancedValues[n] * ratio;
            }
        }
    }

    public void setForceCoincidentEvents(boolean b) {
        this._isCoincidentEvents = b;
    }

    public double[] getBalancedValues() {
        return this._balancedValues;
    }

    public void setBalanceEntireEvent(boolean b) {
        this._isBalanceEntireEvent = b;
    }

    public void setDataType(DataType dt) {
        this._dataType = dt;
    }

    public boolean isInst() {
        return DataType.Inst.equals((Object)this._dataType);
    }

    public static enum DataType {
        Inst,
        PerAvg,
        PerCum;

    }

    public static class AverageData
    implements Comparable<AverageData> {
        long _durationMillis;
        double _desiredAverage;
        double _originalAverage;
        double _adjustedAverage;
        int _leadStartIndex;
        int _leadEndIndex;
        long _startTime;
        long _endTime;
        int _tailStartIndex;
        int _tailEndIndex;
        int _encompassedStartIndex = -1;
        int _encompassedEndIndex = -1;

        long getDuration() {
            return this._durationMillis;
        }

        public void setEndTime(long l) {
            this._endTime = l;
        }

        public void setStartTime(long l) {
            this._startTime = l;
        }

        public long getStartTime() {
            return this._startTime;
        }

        public long getEndTime() {
            return this._endTime;
        }

        public void setEncompassedEndIndex(int endIndex) {
            this._encompassedEndIndex = endIndex;
        }

        public void setEncompassedStartIndex(int startIndex) {
            this._encompassedStartIndex = startIndex;
        }

        public int getEncompassedEndIndex() {
            return this._encompassedEndIndex;
        }

        public int getEncompassedStartIndex() {
            return this._encompassedStartIndex;
        }

        void setDuration(long duration) {
            this._durationMillis = duration;
        }

        double getDesiredAverage() {
            return this._desiredAverage;
        }

        void setDesiredAverage(double flow) {
            this._desiredAverage = flow;
        }

        double getOriginalAverage() {
            return this._originalAverage;
        }

        void setOriginalAverage(double flow) {
            this._originalAverage = flow;
        }

        double getAdjustedAverage() {
            return this._adjustedAverage;
        }

        void setAdjustedAverage(double flow) {
            this._adjustedAverage = flow;
        }

        int getStartIndex() {
            return this._leadStartIndex;
        }

        void setStartIndex(int index) {
            this._leadStartIndex = index;
        }

        int getEndIndex() {
            return this._tailEndIndex;
        }

        void setEndIndex(int index) {
            this._tailEndIndex = index;
        }

        int getLeadStartIndex() {
            return this._leadStartIndex;
        }

        int getLeadEndIndex() {
            return this._leadEndIndex;
        }

        void setLeadEndIndex(int index) {
            this._leadEndIndex = index;
        }

        int getTailStartIndex() {
            return this._tailStartIndex;
        }

        void setTailStartIndex(int index) {
            this._tailStartIndex = index;
        }

        int getTailEndIndex() {
            return this._tailEndIndex;
        }

        @Override
        public int compareTo(AverageData arg0) {
            if (this.getDuration() < arg0.getDuration()) {
                return -1;
            }
            if (this.getDuration() > arg0.getDuration()) {
                return 1;
            }
            return 0;
        }
    }
}

