/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

public final class NumericalIntegration {
    private NumericalIntegration() {
    }

    public static double trapezoidal(double[] x, double[] y) {
        int size = x.length;
        if (size != y.length) {
            throw new IllegalArgumentException("x and y must have same number of ordinates");
        }
        double retval = 0.0;
        for (int i = 1; i < x.length - 1; ++i) {
            double delta = x[i] - x[i - 1];
            retval += delta * (y[i - 1] + y[i]) / 2.0;
        }
        return retval;
    }
}

