/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.IRating;
import hec.data.IVerticalDatumOperations;
import hec.data.Parameter;
import hec.data.RatingException;
import hec.data.Units;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDataConversion;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.LinearRegressionStatistics;
import hec.hecmath.PairedDataMathVertDatum;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.computation.ScalarOperable;
import hec.io.Conversion;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.annotation.Scriptable;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;

@Scriptable
public class PairedDataMath
extends HecMath
implements IRating,
IVerticalDatumOperations<PairedDataMath, HecMathException> {
    protected int _curveNumber = 0;

    public PairedDataMath() {
    }

    public PairedDataMath(PairedDataContainer pdc) throws HecMathException {
        this.setData(pdc);
    }

    @Override
    public void setData(DataContainer container) throws HecMathException {
        if (container == null) {
            throw new HecMathException("PairedDataMath.setData: Parameter is null");
        }
        if (!(container instanceof PairedDataContainer)) {
            throw new HecMathException("PairedDataMath.setData: Parameter is not Paired Data");
        }
        PairedDataContainer pdc = (PairedDataContainer)container;
        this._dc = (DataContainer)pdc.clone();
    }

    private PairedDataContainer getContainer() {
        return (PairedDataContainer)this._dc;
    }

    private void setContainer(PairedDataContainer pdc) throws HecMathException {
        if (pdc == null) {
            throw new HecMathException("PairedDataMath.setContainer: Parameter is null");
        }
        this._dc = pdc;
    }

    @Override
    public void getData(DataContainer container) throws HecMathException {
        PairedDataContainer myPdc = this.getContainer();
        if (myPdc == null) {
            return;
        }
        PairedDataContainer pdc = (PairedDataContainer)container;
        if (pdc == null) {
            pdc = new PairedDataContainer();
        }
        myPdc.clone(pdc);
    }

    @Override
    public DataContainer getData() throws HecMathException {
        PairedDataContainer myPdc = this.getContainer();
        if (myPdc == null) {
            return null;
        }
        PairedDataContainer pdc = new PairedDataContainer();
        myPdc.clone(pdc);
        return pdc;
    }

    @Override
    public void setCurve(String curveName) throws HecMathException {
        if (curveName == null || curveName.length() < 1) {
            throw new HecMathException("HecMath.setCurve : curve name is empty or blank");
        }
        PairedDataContainer pdc = this.getContainer();
        if (pdc.labels == null) {
            throw new HecMathException("HecMath.setCurve : labels not defined in the PairedData");
        }
        curveName = curveName.trim();
        for (int i = 0; i < pdc.labels.length; ++i) {
            if (!pdc.labels[i].trim().equalsIgnoreCase(curveName)) continue;
            this._curveNumber = i;
            return;
        }
        if (curveName.equals(pdc.xparameter)) {
            this._curveNumber = -2;
            return;
        }
        if (curveName.equals(pdc.yparameter)) {
            this._curveNumber = 0;
            return;
        }
        throw new HecMathException("HecMath.setCurve : could not match the curve name to available PairedData labels\ncurve name = " + curveName);
    }

    @Override
    public void setCurve(int curveNumber) throws HecMathException {
        this._curveNumber = curveNumber;
    }

    @Override
    public int getSelectedCurve() {
        return this._curveNumber;
    }

    @Override
    public HecMath add(HecMath math) throws HecMathException {
        return this.operate(math, 1);
    }

    @Override
    public HecMath subtract(HecMath math) throws HecMathException {
        return this.operate(math, 2);
    }

    @Override
    public HecMath divide(HecMath math) throws HecMathException {
        return this.operate(math, 4);
    }

    @Override
    public HecMath multiply(HecMath math) throws HecMathException {
        return this.operate(math, 3);
    }

    private PairedDataMath operate(HecMath math, int functionType) throws HecMathException {
        String s = this.getFunctionName(functionType) + " of two paired data sets not supported for PairedDataMath";
        throw new HecMathException(s);
    }

    @Override
    public HecMath add(double constant) throws HecMathException {
        return this.operate(constant, 1);
    }

    @Override
    public HecMath subtract(double constant) throws HecMathException {
        return this.operate(constant, 2);
    }

    @Override
    public HecMath multiply(double constant) throws HecMathException {
        return this.operate(constant, 3);
    }

    @Override
    public HecMath divide(double constant) throws HecMathException {
        if (constant == 0.0) {
            throw new HecMathException("HecMath.divide : zero divisor");
        }
        return this.operate(constant, 4);
    }

    @Override
    public HecMath replaceSpecificValues(HecDouble from, HecDouble to) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        double tod = to.value();
        HecDoubleArray fromArray = new HecDoubleArray(pdcCollapsed.xOrdinates);
        fromArray.setPrecision(pdcCollapsed.xprecision);
        for (int i = 0; i < pdcCollapsed.xOrdinates.length; ++i) {
            if (!from.equals(fromArray.element(i))) continue;
            pdcCollapsed.xOrdinates[i] = tod;
        }
        for (int j = 0; j < pdcCollapsed.numberCurves; ++j) {
            fromArray = new HecDoubleArray(pdcCollapsed.yOrdinates[j]);
            fromArray.setPrecision(pdcCollapsed.yprecision);
            for (int i = 0; i < pdcCollapsed.yOrdinates[j].length; ++i) {
                if (!from.equals(fromArray.element(i))) continue;
                pdcCollapsed.yOrdinates[j][i] = tod;
            }
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setData(pdcCollapsed);
        return pdMath.expandVerticalDatum();
    }

    @Override
    public HecMath replaceValuesInRange(HecDouble min, HecDouble max, HecDouble to) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        double tod = to.value();
        HecDoubleArray fromArray = new HecDoubleArray(pdcCollapsed.xOrdinates);
        fromArray.setPrecision(pdcCollapsed.xprecision);
        for (int i = 0; i < pdcCollapsed.xOrdinates.length; ++i) {
            if (!min.lessThanEqual(fromArray.element(i)) || !max.greaterThanEqual(fromArray.element(i))) continue;
            pdcCollapsed.xOrdinates[i] = tod;
        }
        for (int j = 0; j < pdcCollapsed.numberCurves; ++j) {
            fromArray = new HecDoubleArray(pdcCollapsed.yOrdinates[j]);
            fromArray.setPrecision(pdcCollapsed.yprecision);
            for (int i = 0; i < pdcCollapsed.yOrdinates[j].length; ++i) {
                if (!min.lessThanEqual(fromArray.element(i)) || !max.greaterThanEqual(fromArray.element(i))) continue;
                pdcCollapsed.yOrdinates[j][i] = tod;
            }
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setContainer(pdcCollapsed);
        return pdMath.expandVerticalDatum();
    }

    @Override
    public HecMath exponentiation(double constant) throws HecMathException {
        return this.operate(constant, 5);
    }

    @Override
    public HecMath transformWithFunction(ScalarOperable transformer) throws HecMathException {
        if (this._curveNumber < 0 && this._curveNumber >= ((PairedDataContainer)this.getData()).numberCurves) {
            throw new HecMathException("Could not transform paired data.");
        }
        PairedDataContainer result = ((PairedDataContainer)this.getData()).collapseVerticalDatum();
        for (int i = 0; i < result.yOrdinates[this._curveNumber].length; ++i) {
            result.yOrdinates[this._curveNumber][i] = transformer.evaluate(result.yOrdinates[this._curveNumber][i]);
        }
        PairedDataMath retval = new PairedDataMath();
        retval.setContainer(result);
        return retval.expandVerticalDatum();
    }

    private PairedDataMath operate(double constant, int functionType) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        if (this._curveNumber == -1 || this._curveNumber == -3) {
            for (int icurve = 0; icurve < pdcCollapsed.numberCurves; ++icurve) {
                this.operate(pdcCollapsed, constant, functionType, icurve);
            }
        }
        if (this._curveNumber == -2 || this._curveNumber == -3) {
            this.operate(pdcCollapsed, constant, functionType, this._curveNumber);
        }
        if (this._curveNumber >= 0 && this._curveNumber < pdcCollapsed.numberCurves) {
            this.operate(pdcCollapsed, constant, functionType, this._curveNumber);
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setContainer(pdcCollapsed);
        pdMath.setCurve(this._curveNumber);
        return pdMath.expandVerticalDatum();
    }

    private void operate(PairedDataContainer pdc, double constant, int functionType, int curveNumber) throws HecMathException {
        PairedDataMath.checkPairedDataCurve(pdc, curveNumber);
        double[] array = curveNumber >= 0 ? pdc.yOrdinates[curveNumber] : pdc.xOrdinates;
        block7: for (int i = 0; i < array.length; ++i) {
            if (array[i] == -3.4028234663852886E38) continue;
            switch (functionType) {
                case 1: {
                    int n = i;
                    array[n] = array[n] + constant;
                    continue block7;
                }
                case 2: {
                    int n = i;
                    array[n] = array[n] - constant;
                    continue block7;
                }
                case 3: {
                    int n = i;
                    array[n] = array[n] * constant;
                    continue block7;
                }
                case 4: {
                    int n = i;
                    array[n] = array[n] / constant;
                    continue block7;
                }
                case 5: {
                    array[i] = Math.pow(array[i], constant);
                }
            }
        }
    }

    @Override
    public HecMath sqrt() throws HecMathException {
        return this.mathFunction(11);
    }

    @Override
    public HecMath log() throws HecMathException {
        return this.mathFunction(13);
    }

    @Override
    public HecMath log10() throws HecMathException {
        return this.mathFunction(12);
    }

    @Override
    public HecMath abs() throws HecMathException {
        return this.mathFunction(14);
    }

    @Override
    public HecMath truncate() throws HecMathException {
        return this.mathFunction(15);
    }

    @Override
    public HecMath round() throws HecMathException {
        return this.mathFunction(16);
    }

    @Override
    public HecMath sin() throws HecMathException {
        return this.mathFunction(17);
    }

    @Override
    public HecMath cos() throws HecMathException {
        return this.mathFunction(18);
    }

    @Override
    public HecMath tan() throws HecMathException {
        return this.mathFunction(19);
    }

    @Override
    public HecMath inverse() throws HecMathException {
        return this.mathFunction(20);
    }

    private PairedDataMath mathFunction(int functionType) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        if (this._curveNumber == -1 || this._curveNumber == -3) {
            for (int icurve = 0; icurve < pdcCollapsed.numberCurves; ++icurve) {
                this.mathFunction(pdcCollapsed, functionType, icurve);
            }
        }
        if (this._curveNumber == -2 || this._curveNumber == -3) {
            this.mathFunction(pdcCollapsed, functionType, this._curveNumber);
        }
        if (this._curveNumber >= 0 && this._curveNumber < pdcCollapsed.numberCurves) {
            this.mathFunction(pdcCollapsed, functionType, this._curveNumber);
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setContainer(pdcCollapsed);
        pdMath.setCurve(this._curveNumber);
        return pdMath.expandVerticalDatum();
    }

    private void mathFunction(PairedDataContainer pdc, int functionType, int curveNumber) throws HecMathException {
        PairedDataMath.checkPairedDataCurve(pdc, curveNumber);
        double[] array = curveNumber >= 0 ? pdc.yOrdinates[curveNumber] : pdc.xOrdinates;
        block12: for (int i = 0; i < array.length; ++i) {
            if (array[i] == -3.4028234663852886E38) continue;
            switch (functionType) {
                case 11: {
                    if (array[i] >= 0.0) {
                        array[i] = Math.sqrt(array[i]);
                        continue block12;
                    }
                    array[i] = -3.4028234663852886E38;
                    continue block12;
                }
                case 12: {
                    if (array[i] > 0.0) {
                        array[i] = Math.log(array[i]) / Math.log(10.0);
                        continue block12;
                    }
                    array[i] = -3.4028234663852886E38;
                    continue block12;
                }
                case 13: {
                    if (array[i] > 0.0) {
                        array[i] = Math.log(array[i]);
                        continue block12;
                    }
                    array[i] = -3.4028234663852886E38;
                    continue block12;
                }
                case 14: {
                    array[i] = Math.abs(array[i]);
                    continue block12;
                }
                case 15: {
                    array[i] = (long)array[i];
                    continue block12;
                }
                case 16: {
                    array[i] = Math.rint(array[i]);
                    continue block12;
                }
                case 17: {
                    array[i] = Math.sin(array[i]);
                    continue block12;
                }
                case 18: {
                    array[i] = Math.cos(array[i]);
                    continue block12;
                }
                case 19: {
                    array[i] = Math.tan(array[i]);
                    continue block12;
                }
                case 20: {
                    array[i] = array[i] != 0.0 ? 1.0 / array[i] : -3.4028234663852886E38;
                }
            }
        }
    }

    @Override
    public HecMath roundOff(int digitsPrecision, int powerOfTensPlace) throws HecMathException {
        double val;
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        if (this._curveNumber < -3 || this._curveNumber >= pdcCollapsed.numberCurves) {
            throw new HecMathException("HecMath.roundOff : Paired Data curve number out of range\nNumber available curves = " + pdcCollapsed.numberCurves + "  curve number = " + this._curveNumber);
        }
        int firstCurve = 0;
        int lastCurve = pdcCollapsed.numberCurves - 1;
        if (this._curveNumber != -1 && this._curveNumber != -3) {
            firstCurve = this._curveNumber;
            lastCurve = this._curveNumber;
        }
        if (digitsPrecision < 1) {
            digitsPrecision = 1;
        } else if (digitsPrecision > 8) {
            digitsPrecision = 8;
        }
        if (this._curveNumber == -2 || this._curveNumber == -3) {
            for (int i = 0; i < pdcCollapsed.xOrdinates.length; ++i) {
                if (pdcCollapsed.xOrdinates[i] == -3.4028234663852886E38) continue;
                pdcCollapsed.xOrdinates[i] = val = HecMath.roundOffValue(pdcCollapsed.xOrdinates[i], digitsPrecision, powerOfTensPlace);
            }
        }
        if (this._curveNumber != -2 && firstCurve > -1 && lastCurve < pdcCollapsed.yOrdinates.length) {
            for (int icurve = firstCurve; icurve <= lastCurve; ++icurve) {
                for (int i = 0; i < pdcCollapsed.yOrdinates[icurve].length; ++i) {
                    if (pdcCollapsed.yOrdinates[icurve][i] == -3.4028234663852886E38) continue;
                    pdcCollapsed.yOrdinates[icurve][i] = val = HecMath.roundOffValue(pdcCollapsed.yOrdinates[icurve][i], digitsPrecision, powerOfTensPlace);
                }
            }
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setContainer(pdcCollapsed);
        pdMath.setCurve(this._curveNumber);
        return pdMath.expandVerticalDatum();
    }

    @Override
    public HecMath convertToMetricUnits() throws HecMathException {
        return this.convertUnits(2);
    }

    @Override
    public HecMath convertToEnglishUnits() throws HecMathException {
        return this.convertUnits(1);
    }

    @Override
    public boolean isMetric() throws HecMathException {
        int unitSystem = this.getUnitSystem();
        if (unitSystem == 0) {
            throw new HecMathException("HecMath.isMetric : could not identify unit system");
        }
        return unitSystem == 2;
    }

    @Override
    public boolean isEnglish() throws HecMathException {
        int unitSystem = this.getUnitSystem();
        if (unitSystem == 0) {
            throw new HecMathException("HecMath.isEnglish : could not identify unit system");
        }
        return unitSystem == 1;
    }

    @Override
    public boolean canDetermineUnitSystem() {
        try {
            if (this.getUnitSystem() == 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private int getUnitSystem() throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = this.getContainer();
        String dataUnits = myPdc.yunits;
        int unitsSystem = HecDataConversion.getUnitSystem(dataUnits);
        if (unitsSystem == 0) {
            String[] aliases = Units.getAliasesForUnits(dataUnits);
            if (aliases != null && aliases.length > 0) {
                dataUnits = Units.getUnitsForAlias(dataUnits);
            }
            unitsSystem = Units.getUnitSystemForUnits(dataUnits);
        }
        int fromUnitSystem = unitsSystem;
        return fromUnitSystem;
    }

    @Override
    public String getUnits() {
        PairedDataContainer myPdc = this.getContainer();
        if (myPdc == null || myPdc.yunits == null || myPdc.yunits.length() < 1) {
            return "";
        }
        String dataUnits = myPdc.yunits;
        return dataUnits;
    }

    @Override
    public String getStandardUnits() {
        PairedDataContainer myPdc = this.getContainer();
        if (myPdc == null || myPdc.yunits == null || myPdc.yunits.length() < 1) {
            return "";
        }
        String dataUnits = myPdc.yunits;
        if (Units.getAliasesForUnits(dataUnits) != null) {
            dataUnits = Units.getUnitsForAlias(dataUnits);
        }
        return dataUnits;
    }

    @Override
    public void setUnits(String unitsString) {
        try {
            PairedDataContainer myPdc = this.getContainer();
            if (myPdc == null) {
                return;
            }
            myPdc.yunits = unitsString;
            this.setContainer(myPdc);
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "setUnits", e);
        }
    }

    private PairedDataMath convertUnits(int toUnitSystem) throws HecMathException {
        int fromUnitSystem = this.getUnitSystem();
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
        if (toUnitSystem != fromUnitSystem) {
            try {
                double[] testx = (double[])myPdc.xOrdinates.clone();
                stringContainer strcontainer = new stringContainer();
                strcontainer.string = myPdc.xunits;
                int xstatus = HecDataConversion.convertUnits(testx, testx.length, fromUnitSystem, toUnitSystem, strcontainer);
                int status = HecDataConversion.convertUnits(myPdc, toUnitSystem);
                if (status != 0 || xstatus != 0) {
                    Parameter yparam;
                    int yparamId;
                    myPdc = (PairedDataContainer)this.getContainer().clone();
                    Parameter xparam = new Parameter(myPdc.xparameter);
                    int xparamId = xparam.getParameterId();
                    if (xparamId != -1) {
                        Units.convertUnits(myPdc.xOrdinates, xparamId, fromUnitSystem, toUnitSystem);
                        myPdc.xunits = Parameter.getUnitsStringForSystem(xparamId, toUnitSystem);
                    }
                    if ((yparamId = (yparam = new Parameter(myPdc.yparameter)).getParameterId()) != -1) {
                        for (int icurve = 0; icurve < myPdc.numberCurves; ++icurve) {
                            Units.convertUnits(myPdc.yOrdinates[icurve], yparamId, fromUnitSystem, toUnitSystem);
                        }
                        myPdc.yunits = Parameter.getUnitsStringForSystem(yparamId, toUnitSystem);
                    }
                }
            }
            catch (DataSetException | IllegalArgumentException e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "HecMath.convertUnits", e);
                throw new HecMathException("HecMath.convertUnits : could not convert units.", e);
            }
            catch (RuntimeException e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "HecMath.convertUnits", e);
                throw new HecMathException("HecMath.convertUnits", e);
            }
        }
        PairedDataMath pdMath = new PairedDataMath();
        pdMath.setContainer(myPdc);
        pdMath.setCurve(this._curveNumber);
        return pdMath.expandVerticalDatum();
    }

    @Override
    public HecMath mergePairedDataSets(HecMath pdMathIn) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        PairedDataMath.checkPairedData((PairedDataContainer)pdMathIn._dc);
        PairedDataMath pdMath = (PairedDataMath)pdMathIn;
        PairedDataContainer otherPdc = new PairedDataContainer();
        pdMath.getData(otherPdc);
        try {
            int icurve;
            boolean noProblem = true;
            if (pdcCollapsed.xOrdinates.length != otherPdc.xOrdinates.length) {
                noProblem = false;
            } else {
                for (int i = 0; i < pdcCollapsed.xOrdinates.length; ++i) {
                    if (pdcCollapsed.xOrdinates[i] == otherPdc.xOrdinates[i]) continue;
                    noProblem = false;
                    break;
                }
            }
            if (!noProblem) {
                String s = "HecMath.mergePairedDataSets : x-values for the paired data sets must match point for point";
                throw new HecMathException(s);
            }
            int selectedCurve = pdMath.getSelectedCurve();
            int newNumberCurves = pdcCollapsed.numberCurves;
            newNumberCurves = selectedCurve == -1 ? (newNumberCurves += otherPdc.numberCurves) : ++newNumberCurves;
            double[][] newYordinates = new double[newNumberCurves][];
            String[] newLabels = null;
            if (pdcCollapsed.labelsUsed) {
                newLabels = new String[newNumberCurves];
            }
            for (icurve = 0; icurve < pdcCollapsed.numberCurves; ++icurve) {
                newYordinates[icurve] = pdcCollapsed.yOrdinates[icurve];
                if (!pdcCollapsed.labelsUsed) continue;
                newLabels[icurve] = pdcCollapsed.labels[icurve];
            }
            if (selectedCurve == -1) {
                for (icurve = 0; icurve < otherPdc.numberCurves; ++icurve) {
                    newYordinates[icurve + pdcCollapsed.numberCurves] = otherPdc.yOrdinates[icurve];
                    if (!pdcCollapsed.labelsUsed) continue;
                    newLabels[icurve + pdcCollapsed.numberCurves] = otherPdc.labelsUsed ? otherPdc.labels[icurve] : "";
                }
            } else if (selectedCurve >= 0 && selectedCurve < otherPdc.numberCurves) {
                newYordinates[newNumberCurves - 1] = otherPdc.yOrdinates[selectedCurve];
                if (pdcCollapsed.labelsUsed) {
                    newLabels[pdcCollapsed.numberCurves] = otherPdc.labelsUsed ? otherPdc.labels[0] : "";
                }
            } else {
                throw new HecMathException("HecMath.mergePairedDataSets : Paired Data curve number out of range\nNumber available curves = " + otherPdc.numberCurves + "  curve number = " + selectedCurve);
            }
            pdcCollapsed.yOrdinates = newYordinates;
            pdcCollapsed.numberCurves = pdcCollapsed.yOrdinates.length;
            if (pdcCollapsed.labelsUsed) {
                pdcCollapsed.labels = newLabels;
            }
            PairedDataMath newPdMath = new PairedDataMath();
            newPdMath.setContainer(pdcCollapsed);
            return newPdMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "HecMath.mergePairedData", e);
            throw new HecMathException("HecMath.mergePairedDataSets", e);
        }
    }

    @Override
    public TimeSeriesMath conicInterpolation(HecMath tsMath, String inputType, String outputType, double storageScaleFactor) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        String vdi = null;
        HashMap<String, String> si = pdcCollapsed.getSupplementalInfo();
        vdi = si.get("verticalDatumInfo");
        if (!(tsMath instanceof TimeSeriesMath)) {
            String s = "HecMath.conicInterpolation : Parameter is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer tscCollapsed = ((TimeSeriesContainer)tsMath.getData()).collapseVerticalDatum();
        TimeSeriesMath.checkTimeSeries(tscCollapsed);
        if (vdi == null) {
            si = tscCollapsed.getSupplementalInfo();
            vdi = si.get("verticalDatumInfo");
        }
        try {
            double conicDepth;
            double h;
            String outputTyp;
            boolean inputIsStorage = false;
            boolean outputIsArea = false;
            if (inputType == null || inputType.length() < 1 || outputType == null || outputType.length() < 1) {
                throw new HecMathException("HecMath.conicInterpolation: Input type or output type undefined");
            }
            String inputTyp = inputType.trim().toUpperCase().substring(0, 1);
            if (inputTyp.equals(outputTyp = outputType.trim().toUpperCase().substring(0, 1))) {
                throw new HecMathException("HecMath.conicInterpolation: Input type is the same as the output type\ninput type = " + inputType + "\noutput type = " + outputType);
            }
            if (!inputTyp.equals("E") && !inputTyp.equals("S")) {
                throw new HecMathException("HecMath.conicInterpolation: Input type not defined as STORAGE or ELEVATION. \ninput type = " + inputType);
            }
            if (!(outputTyp.equals("E") || outputTyp.equals("S") || outputTyp.equals("A"))) {
                throw new HecMathException("HecMath.conicInterpolation: Output type not defined as STORAGE, ELEVATION or AREA.\noutput type = " + outputType);
            }
            if (inputTyp.equals("S")) {
                inputIsStorage = true;
            }
            if (outputTyp.equals("A")) {
                outputIsArea = true;
            }
            if (storageScaleFactor == Double.NEGATIVE_INFINITY || storageScaleFactor == -3.4028234663852886E38 || storageScaleFactor == 0.0) {
                storageScaleFactor = 1.0;
            }
            for (int i = 2; i < pdcCollapsed.xOrdinates.length; ++i) {
                if (!(pdcCollapsed.xOrdinates[i - 1] >= pdcCollapsed.xOrdinates[i])) continue;
                throw new HecMathException("HecMath.conicInterpolation: x-values are not in ascending order");
            }
            double[] elevation = new double[pdcCollapsed.xOrdinates.length - 1];
            double[] area = new double[pdcCollapsed.xOrdinates.length - 1];
            System.arraycopy(pdcCollapsed.xOrdinates, 1, elevation, 0, pdcCollapsed.xOrdinates.length - 1);
            System.arraycopy(pdcCollapsed.yOrdinates[0], 1, area, 0, pdcCollapsed.xOrdinates.length - 1);
            double firstConicDepth = pdcCollapsed.xOrdinates[0];
            if (firstConicDepth == 0.0 && area[1] != 0.0) {
                firstConicDepth = (elevation[1] - elevation[0]) / (Math.sqrt(area[1] / area[0]) - 1.0);
            }
            double storageBelowFirstConicDepth = pdcCollapsed.yOrdinates[0][0];
            double[] storage = new double[elevation.length];
            storage[0] = storageBelowFirstConicDepth;
            for (int i = 1; i < elevation.length; ++i) {
                h = elevation[i] - elevation[i - 1];
                conicDepth = i == 1 ? firstConicDepth : h / (Math.sqrt(area[i] / area[i - 1]) - 1.0);
                storage[i] = (h + conicDepth) * area[i] / 3.0 - conicDepth * area[i - 1] / 3.0 + storage[i - 1];
            }
            double[] newValues = new double[tscCollapsed.times.length];
            for (int i = 0; i < tscCollapsed.times.length; ++i) {
                double areaInterp;
                double[] array;
                newValues[i] = -3.4028234663852886E38;
                TimeSeriesMath cfr_ignored_0 = (TimeSeriesMath)tsMath;
                if (!TimeSeriesMath.isValid(tscCollapsed, i)) continue;
                double tsValue = tscCollapsed.values[i];
                if (inputIsStorage) {
                    array = storage;
                    tsValue *= storageScaleFactor;
                } else {
                    array = elevation;
                }
                if (tsValue < array[0] || tsValue > array[array.length - 1]) continue;
                int idx = PairedDataMath.bisearch(array, tsValue, array.length);
                if (tsValue == array[array.length - 1]) {
                    idx = array.length - 2;
                }
                h = elevation[idx + 1] - elevation[idx];
                conicDepth = idx == 0 ? firstConicDepth : h / (Math.sqrt(area[idx + 1] / area[idx]) - 1.0);
                if (inputIsStorage) {
                    areaInterp = 3.0 * Math.sqrt(area[idx + 1]) * (tsValue - storage[idx] + conicDepth * area[idx] / 3.0) / (h + conicDepth);
                    areaInterp = Math.pow(areaInterp, 0.6666666667);
                    double elevInterp = Math.sqrt(areaInterp / area[idx + 1]) * (h + conicDepth) + elevation[idx] - conicDepth;
                    if (outputIsArea) {
                        newValues[i] = areaInterp;
                        continue;
                    }
                    newValues[i] = elevInterp;
                    continue;
                }
                areaInterp = area[idx + 1] * Math.pow((tsValue - elevation[idx] + conicDepth) / (h + conicDepth), 2.0);
                double storageInterp = (tsValue - elevation[idx] + conicDepth) * areaInterp / 3.0 - conicDepth * area[idx] / 3.0 + storage[idx];
                newValues[i] = outputIsArea ? areaInterp : storageInterp / storageScaleFactor;
            }
            tscCollapsed.values = newValues;
            String newParam = "";
            String newUnits = "";
            if (outputIsArea) {
                newParam = "AREA";
                newUnits = pdcCollapsed.yunits;
            } else if (inputIsStorage) {
                newParam = "ELEV";
                newUnits = pdcCollapsed.xunits;
            } else {
                newParam = "STOR";
                newUnits = "";
            }
            tscCollapsed.parameter = newParam;
            tscCollapsed.units = newUnits;
            if (vdi != null) {
                try {
                    VerticalDatumContainer vdc = new VerticalDatumContainer(TextUtil.uncompress(vdi, "base64"));
                    tscCollapsed.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "conicInterpolation", e);
                }
            }
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setData(tscCollapsed);
            newTsMath.setParameterPart(newParam);
            return newTsMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "conicInterpolation", e);
            throw new HecMathException("HecMath.conicInterpolation", e);
        }
    }

    public TimeSeriesMath ratingTableInterpolation(TimeSeriesMath tsMath) throws HecMathException {
        boolean doReverseInterpolation = false;
        return this.ratingTableInterpolation(tsMath, doReverseInterpolation);
    }

    public TimeSeriesMath reverseRatingTableInterpolation(TimeSeriesMath tsMath) throws HecMathException {
        boolean doReverseInterpolation = true;
        return this.ratingTableInterpolation(tsMath, doReverseInterpolation);
    }

    private TimeSeriesMath ratingTableInterpolation(TimeSeriesMath tsMath, boolean doReverseInterpolation) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
        if (tsMath == null || !(tsMath instanceof TimeSeriesMath)) {
            String s = "HecMath.ratingTableInterpolation : Parameter is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer tscCollapsed = ((TimeSeriesContainer)tsMath.getData()).collapseVerticalDatum();
        TimeSeriesMath.checkTimeSeries(tscCollapsed);
        VerticalDatumContainer vdc = null;
        try {
            vdc = myPdc.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "ratingTableInterpolation", e);
        }
        if (vdc == null) {
            try {
                vdc = tscCollapsed.extractVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "ratingTableInterpolation", e);
            }
        }
        boolean doExtrapolation = true;
        try {
            double[] yvalues;
            double[] xvalues;
            int numXvalues = myPdc.xOrdinates.length;
            double datum = myPdc.datum;
            double shift = myPdc.shift;
            double offset = myPdc.offset;
            if (datum == -3.4028234663852886E38) {
                datum = 0.0;
            }
            if (shift == -3.4028234663852886E38) {
                shift = 0.0;
            }
            if (offset == -3.4028234663852886E38) {
                offset = 0.0;
            }
            if (doReverseInterpolation) {
                if (!PairedDataMath.checkAscendingOrder(myPdc.yOrdinates[0])) {
                    String s = "HecMath.ratingTableInterpolation : for reverse rating table interpolation,\ny-values for rating table need to be in ascending order";
                    throw new HecMathException(s);
                }
                xvalues = myPdc.yOrdinates[0];
                yvalues = myPdc.xOrdinates;
            } else {
                if (!PairedDataMath.checkAscendingOrder(myPdc.xOrdinates)) {
                    String s = "HecMath.ratingTableInterpolation : for rating table interpolation,\nx-values for rating table need to be in ascending order";
                    throw new HecMathException(s);
                }
                xvalues = myPdc.xOrdinates;
                yvalues = myPdc.yOrdinates[0];
            }
            boolean isLogLog = false;
            if (myPdc.xtype.trim().equalsIgnoreCase("LOG") && myPdc.ytype.trim().equalsIgnoreCase("LOG")) {
                isLogLog = true;
            }
            double[] newValues = new double[tscCollapsed.times.length];
            intContainer lastIndex = new intContainer();
            lastIndex.value = 0;
            for (int i = 0; i < tscCollapsed.times.length; ++i) {
                newValues[i] = -3.4028234663852886E38;
                if (!TimeSeriesMath.isValid(tscCollapsed, i)) continue;
                double tsValue = tscCollapsed.values[i];
                if (!doReverseInterpolation) {
                    tsValue += shift - datum;
                }
                newValues[i] = isLogLog ? this.logLogInterpolate(xvalues, yvalues, tsValue, offset, lastIndex, doExtrapolation, doReverseInterpolation) : this.linearInterpolate(xvalues, yvalues, tsValue, lastIndex, doExtrapolation);
                if (!doReverseInterpolation) continue;
                int n = i;
                newValues[n] = newValues[n] - (shift - datum);
            }
            tscCollapsed.units = doReverseInterpolation ? myPdc.xunits : myPdc.yunits;
            if (doReverseInterpolation) {
                if (myPdc.xparameter.length() > 0) {
                    tscCollapsed.parameter = myPdc.xparameter;
                }
            } else if (myPdc.yparameter.length() > 0) {
                tscCollapsed.parameter = myPdc.yparameter;
            }
            tscCollapsed.values = newValues;
            if (vdc != null) {
                try {
                    tscCollapsed.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "ratingTableInterpolation", e);
                }
            }
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setData(tscCollapsed);
            if (tscCollapsed.parameter.length() > 0) {
                newTsMath.setParameterPart(tscCollapsed.parameter);
            }
            return newTsMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "ratingTableInterpolation", e);
            throw new HecMathException("HecMath.ratingTableInterpolation", e);
        }
    }

    public PairedDataMath translateXY() throws HecMathException {
        try {
            PairedDataContainer pdc = this.getContainer();
            PairedDataMath.checkPairedData(pdc);
            if (pdc.numberCurves != 1) {
                throw new HecMathException("HecMath.translateXY: Cannot translate a data set with more than one curve: " + pdc.numberCurves);
            }
            PairedDataContainer pdcCollapsed = pdc.collapseVerticalDatum();
            double[] tempd = pdcCollapsed.yOrdinates[0];
            pdcCollapsed.yOrdinates[0] = pdcCollapsed.xOrdinates;
            pdcCollapsed.xOrdinates = tempd;
            DSSPathname path = new DSSPathname(pdcCollapsed.fullName);
            Object c2 = path.cPart();
            int i = ((String)c2).indexOf("-");
            if (i > 0) {
                String c1 = ((String)c2).substring(0, i);
                String c22 = ((String)c2).substring(i + 1);
                c2 = c22.trim() + "-" + c1.trim();
                path.setCPart((String)c2);
            }
            pdcCollapsed.fullName = path.getPathname();
            pdcCollapsed.xparameter = pdc.yparameter;
            pdcCollapsed.yparameter = pdc.xparameter;
            pdcCollapsed.xunits = pdc.yunits;
            pdcCollapsed.yunits = pdc.xunits;
            pdcCollapsed.xtype = pdc.ytype;
            pdcCollapsed.ytype = pdc.xtype;
            PairedDataMath pdm = new PairedDataMath();
            pdm.setContainer(pdcCollapsed);
            return pdm.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "translateXY", e);
            throw new HecMathException("HecMath.interpolate", e);
        }
    }

    public PairedDataMath interpolate(double[] xarray, boolean linear, boolean doExtrapolation) throws HecMathException {
        try {
            PairedDataContainer pdc = this.getContainer();
            PairedDataMath.checkPairedData(pdc);
            PairedDataContainer pdcCollapsed = pdc.collapseVerticalDatum();
            pdcCollapsed.xOrdinates = new double[xarray.length];
            pdcCollapsed.yOrdinates = new double[pdc.numberCurves][xarray.length];
            intContainer lastIndex = new intContainer();
            for (int i = 0; i < pdc.numberCurves; ++i) {
                for (int j = 0; j < xarray.length; ++j) {
                    pdcCollapsed.yOrdinates[i][j] = linear ? this.linearInterpolate(pdc.xOrdinates, pdc.yOrdinates[i], xarray[j], lastIndex, doExtrapolation) : this.logLogInterpolate(pdc.xOrdinates, pdc.yOrdinates[i], xarray[j], 0.0, lastIndex, doExtrapolation, false);
                }
            }
            for (int j = 0; j < xarray.length; ++j) {
                pdcCollapsed.xOrdinates[j] = xarray[j];
            }
            pdcCollapsed.numberOrdinates = xarray.length;
            PairedDataMath pdm = new PairedDataMath();
            pdm.setContainer(pdcCollapsed);
            return pdm.expandVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "interpolate", e);
            throw new HecMathException("HecMath.interpolate", e);
        }
    }

    private double linearInterpolate(double[] xarray, double[] yarray, double x, intContainer lastIndex, boolean doExtrapolation) {
        int numValues = xarray.length;
        int idx = this.findInterval(xarray, x, lastIndex.value);
        if (x == xarray[numValues - 1]) {
            idx = numValues - 2;
        }
        if (doExtrapolation) {
            if (x < xarray[0]) {
                idx = 0;
            } else if (x >= xarray[numValues - 1]) {
                idx = numValues - 2;
            }
        }
        if (idx == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        double fact = (x - xarray[idx]) / (xarray[idx + 1] - xarray[idx]);
        return yarray[idx] + fact * (yarray[idx + 1] - yarray[idx]);
    }

    private double logLogInterpolate(double[] xarray, double[] yarray, double x, double offset, intContainer lastIndex, boolean doExtrapolation, boolean doReverseInterpolation) {
        double result;
        int numValues = xarray.length;
        int idx = this.findInterval(xarray, x, lastIndex.value);
        if (x == xarray[numValues - 1]) {
            idx = numValues - 2;
        }
        if (doExtrapolation) {
            if (x < xarray[0]) {
                idx = 0;
            } else if (x >= xarray[numValues - 1]) {
                idx = numValues - 2;
            }
        }
        if (idx == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        if (!doReverseInterpolation) {
            if (xarray[idx] - offset <= 0.0) {
                return -3.4028234663852886E38;
            }
            double fact = Math.log(yarray[idx + 1] / yarray[idx]) / Math.log((xarray[idx + 1] - offset) / (xarray[idx] - offset));
            double tmp = (x - offset) / (xarray[idx] - offset);
            result = Math.pow(tmp, fact) * yarray[idx];
        } else {
            if (yarray[idx] - offset <= 0.0) {
                return -3.4028234663852886E38;
            }
            double fact = Math.log((yarray[idx + 1] - offset) / (yarray[idx] - offset)) / Math.log(xarray[idx + 1] / xarray[idx]);
            result = offset + (yarray[idx] - offset) * Math.pow(x / xarray[idx], fact);
        }
        return result;
    }

    public TimeSeriesMath twoVariableRatingTableInterpolation(TimeSeriesMath tsMathX, TimeSeriesMath tsMathZ) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
        if (tsMathX == null || !(tsMathX instanceof TimeSeriesMath)) {
            String s = "HecMath.TwoVarisetParameterPartableRatingTableInterpolation : First Time Series Data is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer tscX = (TimeSeriesContainer)tsMathX.getData();
        TimeSeriesMath.checkTimeSeries(tscX);
        if (tsMathZ == null || !(tsMathZ instanceof TimeSeriesMath)) {
            String s = "HecMath.TwoVariableRatingTableInterpolation : Second Time Series Data is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer tscZ = (TimeSeriesContainer)tsMathZ.getData();
        TimeSeriesMath.checkTimeSeries(tscZ);
        tsMathX.checkTimeSeriesMatch(tscZ);
        VerticalDatumContainer vdc = null;
        try {
            vdc = myPdc.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
        }
        if (vdc == null) {
            try {
                vdc = tscX.extractVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
            }
        }
        if (vdc == null) {
            try {
                vdc = tscZ.extractVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
            }
        }
        String verticalDatum = null;
        String verticalDatumX = null;
        String verticalDatumZ = null;
        if (this instanceof VerticalDatum) {
            try {
                verticalDatum = ((PairedDataMathVertDatum)this).getCurrentVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
            }
        }
        if (tscX instanceof VerticalDatum) {
            try {
                verticalDatumX = ((TimeSeriesContainerVertDatum)tscX).getCurrentVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
            }
        }
        if (tscZ instanceof VerticalDatum) {
            try {
                verticalDatumZ = ((TimeSeriesContainerVertDatum)tscZ).getCurrentVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
            }
        }
        if (verticalDatum != null) {
            if (tscX.parameter.toUpperCase().startsWith("ELEV") && verticalDatumX != null) {
                try {
                    ((VerticalDatum)tscX).toVerticalDatum(verticalDatum);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
                }
            }
            if (tscZ.parameter.toUpperCase().startsWith("ELEV") && verticalDatumZ != null) {
                try {
                    ((TimeSeriesContainerVertDatum)tscZ).toVerticalDatum(verticalDatum);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
                }
            }
        }
        try {
            if (!myPdc.labelsUsed || myPdc.labels == null) {
                String s = "HecMath.TwoVariableRatingTableInterpolation : The curve labels are undefined for the Rating Table";
                throw new HecMathException(s);
            }
            double[] curveValues = new double[myPdc.numberCurves];
            for (int icurve = 0; icurve < myPdc.numberCurves; ++icurve) {
                String curveLabel = myPdc.labels[icurve].trim();
                if (curveLabel.length() < 1) {
                    String s = "HecMath.TwoVariableRatingTableInterpolation : The label for curve " + (icurve + 1) + " is empty";
                    throw new HecMathException(s);
                }
                try {
                    curveValues[icurve] = Double.valueOf(curveLabel);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String s = "HecMath.TwoVariableRatingTableInterpolation : Could not parse the curve label " + curveLabel + " as a number";
                    throw new HecMathException(s);
                }
            }
            if (!PairedDataMath.checkAscendingOrder(curveValues)) {
                String s = "HecMath.TwoVariableRatingTableInterpolation : The curve label values need to be in ascending order";
                throw new HecMathException(s);
            }
            double[] newValues = new double[tscX.times.length];
            int indexX = 0;
            int icurve = 0;
            for (int i = 0; i < tscX.times.length; ++i) {
                double y1;
                double y0;
                double tsValueX;
                newValues[i] = -3.4028234663852886E38;
                if (!TimeSeriesMath.isValid(tscX, i)) continue;
                if (!TimeSeriesMath.isValid(tscZ, i) || (indexX = this.findInterval(myPdc.xOrdinates, tsValueX = tscX.values[i], indexX)) == Integer.MIN_VALUE) continue;
                if (myPdc.numberCurves == 1) {
                    y0 = myPdc.yOrdinates[icurve][indexX];
                    y1 = myPdc.yOrdinates[icurve][indexX + 1];
                } else {
                    double tsValueZ = tscZ.values[i];
                    if (tsValueZ < curveValues[0] || tsValueZ > curveValues[curveValues.length - 1] || (icurve = this.findInterval(curveValues, tsValueZ, icurve)) == Integer.MIN_VALUE) continue;
                    if (icurve == curveValues.length - 1) {
                        --icurve;
                    }
                    double fact = curveValues[icurve + 1] == curveValues[icurve] ? 1.0 : (tsValueZ - curveValues[icurve]) / (curveValues[icurve + 1] - curveValues[icurve]);
                    y0 = myPdc.yOrdinates[icurve][indexX] + fact * (myPdc.yOrdinates[icurve + 1][indexX] - myPdc.yOrdinates[icurve][indexX]);
                    y1 = myPdc.yOrdinates[icurve][indexX + 1] + fact * (myPdc.yOrdinates[icurve + 1][indexX + 1] - myPdc.yOrdinates[icurve][indexX + 1]);
                }
                newValues[i] = y0 + (y1 - y0) * (tsValueX - myPdc.xOrdinates[indexX]) / (myPdc.xOrdinates[indexX + 1] - myPdc.xOrdinates[indexX]);
            }
            TimeSeriesContainer newTsc = (TimeSeriesContainer)tscX.clone();
            newTsc.values = newValues;
            newTsc.units = myPdc.yunits;
            if (vdc != null) {
                try {
                    newTsc.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "twoVariableRatingTableInterpolation", e);
                }
            }
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setData(newTsc);
            if (myPdc.yparameter.length() > 0) {
                newTsMath.setParameterPart(myPdc.yparameter);
            }
            return newTsMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "twoVariableRatingTableInterpolation", e);
            throw new HecMathException("HecMath.TwoVariableRatingTableInterpolation", e);
        }
    }

    public TimeSeriesMath polynomialTransformation(TimeSeriesMath tsMath) throws HecMathException {
        boolean withIntegral = false;
        return this.polynomialTransformation(tsMath, withIntegral);
    }

    public TimeSeriesMath polynomialTransformationWithIntegral(TimeSeriesMath tsMath) throws HecMathException {
        boolean withIntegral = true;
        return this.polynomialTransformation(tsMath, withIntegral);
    }

    private TimeSeriesMath polynomialTransformation(TimeSeriesMath tsMath, boolean withIntegral) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
        VerticalDatumContainer vdc = null;
        try {
            vdc = myPdc.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "polynomialTransformation", e);
        }
        if (tsMath == null || !(tsMath instanceof TimeSeriesMath)) {
            String s = "HecMath.polynomialTransformation : Parameter is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer myTsc = new TimeSeriesContainer();
        tsMath.getData(myTsc);
        TimeSeriesMath.checkTimeSeries(myTsc);
        try {
            double[] polyCoefs = myPdc.xOrdinates;
            double[] newValues = new double[myTsc.times.length];
            double datum = myPdc.datum;
            if (datum == -3.4028234663852886E38) {
                datum = 0.0;
            }
            for (int i = 0; i < myTsc.times.length; ++i) {
                double rk;
                int k;
                newValues[i] = -3.4028234663852886E38;
                if (!TimeSeriesMath.isValid(myTsc, i)) continue;
                double tsValue = myTsc.values[i] - datum;
                double sum = 0.0;
                if (withIntegral) {
                    for (k = 0; k < polyCoefs.length; ++k) {
                        rk = (double)k + 1.0;
                        sum += polyCoefs[k] * Math.pow(tsValue, rk + 1.0) / (rk + 1.0);
                    }
                } else {
                    for (k = 0; k < polyCoefs.length; ++k) {
                        rk = (double)k + 1.0;
                        sum += polyCoefs[k] * Math.pow(tsValue, rk);
                    }
                }
                newValues[i] = sum;
            }
            myTsc.values = newValues;
            myTsc.parameter = myPdc.xparameter;
            myTsc.units = myPdc.xunits;
            try {
                myTsc.insertVerticalDatum(vdc);
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "polynomialTransformation", e);
            }
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setData(myTsc);
            return newTsMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "polynomialTransformation", e);
            throw new HecMathException("HecMath.polynomialTransformation", e);
        }
    }

    public TimeSeriesMath applyMultipleLinearRegression(String startTimeString, String endTimeString, TimeSeriesMath[] tsMathArray, double minimumLimit, double maximumLimit) throws HecMathException {
        try {
            int numberPoints;
            int i;
            if (tsMathArray == null || tsMathArray.length < 1) {
                String s = "HecMath.applyMultipleLinearRegression : The set of time series data are empty";
                throw new HecMathException(s);
            }
            PairedDataMath.checkPairedData(this.getContainer());
            PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
            VerticalDatumContainer vdc = null;
            try {
                vdc = myPdc.extractVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "applyMultipleLinearRegression", e);
            }
            if (tsMathArray.length != myPdc.numberOrdinates - 1) {
                int expectedNumberOfTS = myPdc.numberOrdinates - 1;
                String s = "HecMath.applyMultipleLinearRegression : Expecting to have " + expectedNumberOfTS + " time series records.  \nHave instead " + tsMathArray.length;
                throw new HecMathException(s);
            }
            int numberOfTs = tsMathArray.length;
            TimeSeriesContainer[] tscArray = new TimeSeriesContainer[numberOfTs];
            for (i = 0; i < tsMathArray.length; ++i) {
                TimeSeriesMath tsMath = tsMathArray[i];
                if (tsMath == null || !(tsMath instanceof TimeSeriesMath)) {
                    String s = "HecMath.applyMultipleLinearRegression : A data set is empty or not a TimeSeries";
                    throw new HecMathException(s);
                }
                tscArray[i] = (TimeSeriesContainer)tsMathArray[i].getData();
                TimeSeriesMath.checkTimeSeries(tscArray[i]);
                if (vdc != null) continue;
                try {
                    vdc = tscArray[i].extractVerticalDatum();
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "applyMultipleLinearRegression", e);
                }
            }
            for (i = 0; i < tscArray.length; ++i) {
                if (tscArray[i].interval == 0) {
                    throw new HecMathException("HecMath.applyMultipleLinearRegression: The time series " + tscArray[i].fullName + " is not a regular interval time series.");
                }
                if (tscArray[i].interval == tscArray[0].interval) continue;
                throw new HecMathException("HecMath.applyMultipleLinearRegression: The time intervals are for the set of time series are not all the same.");
            }
            int timeStartMax = tscArray[0].times[0];
            int timeEndMin = tscArray[0].times[tscArray[0].times.length - 1];
            for (int i2 = 1; i2 < numberOfTs; ++i2) {
                int last;
                if (tscArray[i2].times[0] > timeStartMax) {
                    timeStartMax = tscArray[i2].times[0];
                }
                if (tscArray[i2].times[last = tscArray[i2].times.length - 1] >= timeEndMin) continue;
                timeEndMin = tscArray[i2].times[last];
            }
            if (startTimeString == null || startTimeString.length() < 1 || endTimeString == null || endTimeString.length() < 1) {
                HecTime htime = new HecTime(1);
                htime.set(timeStartMax);
                startTimeString = htime.dateAndTime(104);
                htime.set(timeEndMin);
                endTimeString = htime.dateAndTime(104);
            }
            int timeInterval = tscArray[0].interval;
            int timeOffset = 0;
            double initValue = -3.4028234663852886E38;
            TimeSeriesMath newTsMath = (TimeSeriesMath)TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeInterval, timeOffset, initValue);
            TimeSeriesContainer newTsc = (TimeSeriesContainer)newTsMath._dc;
            TimeSeriesMath.copyHeaderInfo(tscArray[0], newTsc);
            newTsc.version = "COMPUTED";
            if (newTsc.startTime > timeStartMax) {
                timeStartMax = newTsc.startTime;
            }
            if (newTsc.endTime > timeEndMin) {
                timeEndMin = newTsc.endTime;
            }
            if ((numberPoints = (timeEndMin - timeStartMax) / newTsc.interval + 1) < 1) {
                throw new HecMathException("HecMath.applyMultipleLinearRegression: There are problems with non-concurrent Time Windows for the time series");
            }
            int[] startIndex = new int[numberOfTs];
            for (int i3 = 0; i3 < numberOfTs; ++i3) {
                startIndex[i3] = TimeSeriesMath.findInterval(tscArray[i3].times, timeStartMax, 0);
                if (startIndex[i3] != Integer.MIN_VALUE) continue;
                throw new HecMathException("HecMath.applyMultipleLinearRegression: There are problems with non-concurrent Time Windows for the time series");
            }
            int startNewTsc = TimeSeriesMath.findInterval(newTsc.times, timeStartMax, 0);
            double[] coefs = myPdc.yOrdinates[0];
            for (int k = 0; k < numberPoints; ++k) {
                int idx;
                double sum = coefs[0];
                boolean isBad = false;
                for (int i4 = 0; i4 < numberOfTs; ++i4) {
                    idx = startIndex[i4] + k;
                    if (!TimeSeriesMath.isValid(tscArray[i4], idx)) {
                        isBad = true;
                        break;
                    }
                    sum += tscArray[i4].values[idx] * coefs[i4 + 1];
                }
                if (minimumLimit != -3.4028234663852886E38 && maximumLimit != -3.4028234663852886E38 && (!isBad && sum < minimumLimit || sum > maximumLimit)) {
                    isBad = true;
                }
                if ((idx = startNewTsc + k) >= newTsc.values.length) break;
                if (isBad) continue;
                newTsc.values[idx] = sum;
            }
            if (vdc != null) {
                newTsc.insertVerticalDatum(vdc);
            }
            return newTsMath.expandVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "applyMultipleLinearRegression", e);
            throw new HecMathException("HecMath.applyMultipleLinearRegression", e);
        }
    }

    public TimeSeriesMath modifiedPulsRouting(TimeSeriesMath tsMath, int numberSubreaches, double muskingumX) throws HecMathException {
        PairedDataMath.checkPairedData(this.getContainer());
        PairedDataContainer myPdc = (PairedDataContainer)this.getContainer().clone();
        if (tsMath == null || !(tsMath instanceof TimeSeriesMath)) {
            String s = "HecMath.modifiedPulsRouting : Parameter is null or not a TimeSeriesMath";
            throw new HecMathException(s);
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsMath.getData();
        TimeSeriesMath.checkTimeSeries(myTsc);
        VerticalDatumContainer vdc = null;
        try {
            vdc = myPdc.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "modifiedPulsRouting", e);
        }
        try {
            String s;
            if (myTsc.interval <= 0) {
                throw new HecMathException("HecMath.modifiedPulsRouting: This function requires a regular interval time series.\nThe time series " + myTsc.fullName + " is not a regular interval time series.");
            }
            double deltaT = (double)myTsc.interval / 60.0;
            if (muskingumX < 0.0 || muskingumX > 0.5) {
                String msg = "HecMath.modifiedPulsRouting: muskingumX value must be between 0.0 and 0.5\nmuskingumX = " + muskingumX;
                throw new HecMathException(msg);
            }
            if (numberSubreaches <= 0) {
                String msg = "HecMath.modifiedPulsRouting: Number of subreaches less than 1\nnumberSubreaches = " + numberSubreaches;
                throw new HecMathException(msg);
            }
            if (!PairedDataMath.checkAscendingOrder(myPdc.xOrdinates)) {
                String s2 = "HecMath.modifiedPulsRouting : for storage-flow table interpolation,\nx-values for table need to be in ascending order";
                throw new HecMathException(s2);
            }
            if (!PairedDataMath.checkAscendingOrder(myPdc.yOrdinates[0])) {
                String s3 = "HecMath.modifiedPulsRouting : for storage-flow table interpolation,\ny-values for table need to be in ascending order";
                throw new HecMathException(s3);
            }
            Parameter xparam = null;
            Parameter yparam = null;
            String flowUnits = "";
            String storUnits = "";
            try {
                String xParamString = myPdc.xparameter.trim().toUpperCase();
                if (xParamString.indexOf("STOR") > -1 || xParamString.indexOf("VOL") > -1) {
                    xParamString = "STOR";
                }
                xparam = new Parameter(xParamString);
            }
            catch (DataSetIllegalArgumentException de) {
                String s4 = "HecMath.modifiedPulsRouting : Could not parse x-parameter name: " + myPdc.xparameter;
                throw new HecMathException(s4);
            }
            try {
                String yParamString = myPdc.yparameter.trim().toUpperCase();
                if (yParamString.indexOf("STOR") > -1 || yParamString.indexOf("VOL") > -1) {
                    yParamString = "STOR";
                }
                yparam = new Parameter(yParamString);
            }
            catch (DataSetIllegalArgumentException de) {
                String s5 = "HecMath.modifiedPulsRouting : Could not parse y-parameter name: " + myPdc.yparameter;
                throw new HecMathException(s5);
            }
            if (xparam.getParameterId() != Parameter.PARAMID_FLOW && xparam.getParameterId() != Parameter.PARAMID_STOR) {
                s = "HecMath.modifiedPulsRouting : x-parameter needs to be either FLOW or STOR.  \nx-parameter name: " + myPdc.xparameter;
                throw new HecMathException(s);
            }
            if (yparam.getParameterId() != Parameter.PARAMID_FLOW && yparam.getParameterId() != Parameter.PARAMID_STOR) {
                s = "HecMath.modifiedPulsRouting : y-parameter needs to be either FLOW or STOR.  \ny-parameter name: " + myPdc.yparameter;
                throw new HecMathException(s);
            }
            if (xparam.getParameterId() == yparam.getParameterId()) {
                s = "HecMath.modifiedPulsRouting : x-parameter and y-parameter need to be either FLOW-STOR or STOR-FLOW.  \nx-parameter name: " + myPdc.xparameter + "\ny-parameter name: " + myPdc.yparameter;
                throw new HecMathException(s);
            }
            double[] storageTable = null;
            double[] flowTable = null;
            if (xparam.getParameterId() == Parameter.PARAMID_FLOW) {
                flowTable = myPdc.xOrdinates;
                storageTable = myPdc.yOrdinates[0];
                flowUnits = myPdc.xunits;
                storUnits = myPdc.yunits;
            } else {
                flowTable = myPdc.yOrdinates[0];
                storageTable = myPdc.xOrdinates;
                flowUnits = myPdc.yunits;
                storUnits = myPdc.xunits;
            }
            double storageToFlow = this.getStorageToFlowConversion(storUnits, flowUnits);
            double dstor_dt_to_q = storageToFlow / (deltaT * 3600.0);
            double[] inflow = myTsc.values;
            double[] outflow = new double[inflow.length];
            int istart = 0;
            for (istart = 0; istart < myTsc.values.length && !TimeSeriesMath.isValid(myTsc, istart); ++istart) {
            }
            int numOrd = myPdc.numberOrdinates;
            if (numberSubreaches < 1) {
                numberSubreaches = 1;
            }
            double[] storageIndication = new double[numOrd];
            double numreaches = numberSubreaches;
            for (int i = 0; i < numOrd; ++i) {
                double subreachStorage = storageTable[i] / numreaches;
                storageIndication[i] = subreachStorage * (1.0 - muskingumX) * dstor_dt_to_q + 0.5 * flowTable[i];
            }
            boolean doExtrapolation = false;
            intContainer lastIndex = new intContainer();
            double initialSubreachOutflow = myTsc.values[istart];
            double initialSubreachStorage = this.linearInterpolate(flowTable, storageIndication, initialSubreachOutflow, lastIndex, doExtrapolation);
            boolean isPeriodAverage = false;
            if (myTsc.type.toUpperCase().indexOf("INST-") < 0) {
                isPeriodAverage = true;
            }
            System.arraycopy(inflow, 0, outflow, 0, myTsc.times.length);
            for (int j = 0; j < numberSubreaches; ++j) {
                double q0 = outflow[istart];
                outflow[istart] = initialSubreachOutflow;
                double qout = initialSubreachOutflow;
                double stori = initialSubreachStorage;
                for (int i = istart + 1; i < myTsc.times.length; ++i) {
                    double q1 = outflow[i];
                    if (qout == -3.4028234663852886E38 || q0 == -3.4028234663852886E38 || q1 == -3.4028234663852886E38) {
                        stori = -3.4028234663852886E38;
                        outflow[i] = qout = -3.4028234663852886E38;
                    } else {
                        stori = isPeriodAverage ? stori - qout + q1 : stori - qout + 0.5 * (q0 + q1);
                        if (stori < 0.0) {
                            stori = 0.0;
                        }
                        outflow[i] = qout = this.linearInterpolate(storageIndication, flowTable, stori, lastIndex, doExtrapolation);
                        if (muskingumX > 0.0) {
                            outflow[i] = qout - muskingumX / (1.0 - muskingumX) * (q1 - qout);
                        }
                        if (outflow[i] < 0.0) {
                            outflow[i] = 0.0;
                        }
                    }
                    q0 = q1;
                }
                if (!isPeriodAverage) continue;
                double qtemp = outflow[istart];
                for (int i = istart + 1; i < myTsc.times.length; ++i) {
                    double temp = 0.5 * (qtemp + outflow[i]);
                    qtemp = outflow[i];
                    outflow[i] = temp;
                }
            }
            myTsc.values = outflow;
            if (vdc != null) {
                try {
                    myTsc.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "modifiedPulsRouting", e);
                }
            }
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setData(myTsc);
            return newTsMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "modifiedPulsRouting", e);
            throw new HecMathException("HecMath.modifiedPulsRouting", e);
        }
    }

    public PairedDataMath pairedDataOps(boolean reorder, int resampleSkip, boolean swapXY, int[] deleteCurves, int switchXYAxis) throws HecMathException {
        int j;
        PairedDataContainer pdcCollapsed = this.getContainer().collapseVerticalDatum();
        if (pdcCollapsed.xOrdinates == null || pdcCollapsed.xOrdinates.length < 1) {
            String s = "PairedDataMath.pairedDataOps : Invalid paired data X array for\n" + pdcCollapsed.fullName;
            throw new HecMathException(s);
        }
        if (reorder) {
            HashMap<Double, Integer> map = new HashMap<Double, Integer>(pdcCollapsed.xOrdinates.length);
            for (int j2 = 0; j2 < pdcCollapsed.xOrdinates.length; ++j2) {
                map.put(pdcCollapsed.xOrdinates[j2], j2);
            }
            TreeMap treeMap = new TreeMap(map);
            Set keys = treeMap.keySet();
            Collection vals = treeMap.values();
            Object[] Xarray = keys.toArray();
            Object[] positions = vals.toArray();
            int nlen = Xarray.length;
            double[] x = new double[nlen];
            double[][] y = new double[pdcCollapsed.numberCurves][nlen];
            for (int i = 0; i < nlen; ++i) {
                x[i] = (Double)Xarray[i];
                int ipos = (Integer)positions[i];
                for (int j3 = 0; j3 < pdcCollapsed.numberCurves; ++j3) {
                    y[j3][i] = pdcCollapsed.yOrdinates[j3][ipos];
                }
            }
            pdcCollapsed.xOrdinates = x;
            pdcCollapsed.yOrdinates = y;
            pdcCollapsed.numberOrdinates = nlen;
        }
        if (resampleSkip > 1) {
            int nlen = (pdcCollapsed.numberOrdinates - 1) / resampleSkip + 1;
            int klen = (nlen - 1) * resampleSkip + 1;
            if (klen != pdcCollapsed.numberOrdinates) {
                ++nlen;
            }
            double[] x = new double[nlen];
            double[][] y = new double[pdcCollapsed.numberCurves][nlen];
            int count = 0;
            for (int i = 0; i < nlen; ++i) {
                x[i] = pdcCollapsed.xOrdinates[count];
                for (j = 0; j < pdcCollapsed.numberCurves; ++j) {
                    y[j][i] = pdcCollapsed.yOrdinates[j][count];
                }
                if ((count += resampleSkip) < pdcCollapsed.xOrdinates.length) continue;
                count = pdcCollapsed.xOrdinates.length - 1;
                x[nlen - 1] = pdcCollapsed.xOrdinates[count];
                for (j = 0; j < pdcCollapsed.numberCurves; ++j) {
                    y[j][nlen - 1] = pdcCollapsed.yOrdinates[j][count];
                }
                break;
            }
            pdcCollapsed.xOrdinates = x;
            pdcCollapsed.yOrdinates = y;
            pdcCollapsed.numberOrdinates = nlen;
        }
        if (deleteCurves != null && deleteCurves.length > 0) {
            int nlen = pdcCollapsed.numberCurves - deleteCurves.length;
            if (nlen < 2) {
                throw new HecMathException("Cannot delete all curves for\n" + pdcCollapsed.fullName);
            }
            for (int j4 = 0; j4 < deleteCurves.length; ++j4) {
                if (deleteCurves[j4] < pdcCollapsed.numberCurves) continue;
                throw new HecMathException("Curve to delete is greater than number of curves for\n" + pdcCollapsed.fullName);
            }
            double[][] nY = new double[nlen][pdcCollapsed.xOrdinates.length];
            String[] nLabels = null;
            if (pdcCollapsed.labels != null && pdcCollapsed.labels.length == pdcCollapsed.numberCurves) {
                nLabels = new String[nlen];
            }
            int count = 0;
            for (int i = 0; i < pdcCollapsed.numberCurves; ++i) {
                boolean del = false;
                for (j = 0; j < deleteCurves.length; ++j) {
                    if (deleteCurves[j] != i) continue;
                    del = true;
                    break;
                }
                if (del) continue;
                nY[count] = Arrays.copyOf(pdcCollapsed.yOrdinates[i], pdcCollapsed.yOrdinates[i].length);
                if (nLabels != null) {
                    nLabels[count] = pdcCollapsed.labels[i];
                }
                ++count;
            }
            pdcCollapsed.yOrdinates = nY;
            if (nLabels != null) {
                pdcCollapsed.labels = nLabels;
            }
            pdcCollapsed.numberCurves = nlen;
        }
        if (swapXY) {
            if (pdcCollapsed.numberCurves != 1) {
                throw new HecMathException("Cannot swap multiple curves for\n" + pdcCollapsed.fullName);
            }
            double[] x = pdcCollapsed.xOrdinates;
            double[] y = pdcCollapsed.yOrdinates[0];
            pdcCollapsed.xOrdinates = y;
            pdcCollapsed.yOrdinates[0] = x;
            DSSPathname path = new DSSPathname(pdcCollapsed.fullName);
            Object c2 = path.cPart();
            int idx = ((String)c2).indexOf("-");
            c2 = ((String)c2).substring(idx + 1) + "-" + ((String)c2).substring(0, idx);
            path.setCPart((String)c2);
            pdcCollapsed.fullName = path.pathname();
            String temp = pdcCollapsed.xparameter;
            pdcCollapsed.xparameter = pdcCollapsed.yparameter;
            pdcCollapsed.yparameter = temp;
            temp = pdcCollapsed.xunits;
            pdcCollapsed.xunits = pdcCollapsed.yunits;
            pdcCollapsed.yunits = temp;
            temp = pdcCollapsed.xtype;
            pdcCollapsed.xtype = pdcCollapsed.ytype;
            pdcCollapsed.ytype = temp;
        }
        if (switchXYAxis > 0) {
            if (switchXYAxis == 1) {
                pdcCollapsed.switchXyAxis = false;
            } else if (switchXYAxis == 2) {
                pdcCollapsed.switchXyAxis = true;
            } else {
                throw new HecMathException("Invalid switchXYAxis parameter: " + switchXYAxis);
            }
        }
        PairedDataMath pdm = new PairedDataMath();
        pdm.setContainer(pdcCollapsed);
        return pdm.expandVerticalDatum();
    }

    private double getStorageToFlowConversion(String storageUnits, String flowUnits) throws HecMathException {
        try {
            flowUnits = flowUnits.toLowerCase();
            storageUnits = storageUnits.toLowerCase();
            double flowScale = Units.getScalarFactor(flowUnits, "cms");
            double storeScale = Units.getScalarFactor(storageUnits, "m3");
            if (flowScale > 0.0 && storeScale > 0.0) {
                return storeScale / flowScale;
            }
        }
        catch (DataSetException de) {
            String s = "HecMath.modifiedPulsRouting : Could not convert Flow or Storage units.\nFlow units = " + flowUnits + "\nStorage units = " + storageUnits;
            throw new HecMathException(s);
        }
        return 1.0;
    }

    public static boolean checkPairedData(PairedDataContainer pdc) throws HecMathException {
        PairedDataMath.checkContainer(pdc);
        try {
            if (pdc == null) {
                throw new HecMathException("Paired Data is null");
            }
            if (pdc.xOrdinates == null) {
                throw new HecMathException("Paired Data x-value array is null");
            }
            if (pdc.xOrdinates.length < 1) {
                throw new HecMathException("Paired Data x-value array has 0 elements");
            }
            if (pdc.yOrdinates == null) {
                throw new HecMathException("Paired Data Container y-value array is null");
            }
            return true;
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "checkPairedData", e);
            throw new HecMathException("HecMath.checkPairedData", e);
        }
    }

    public static boolean checkPairedDataCurve(PairedDataContainer pdc, int curveNumber) throws HecMathException {
        if (pdc == null || pdc.yOrdinates == null) {
            PairedDataMath.checkPairedData(pdc);
        }
        try {
            if (curveNumber < -3 || curveNumber >= pdc.yOrdinates.length) {
                throw new HecMathException("Paired Data Container: an operation requested y-curve no. " + curveNumber + ".  The number of y-value curves is " + pdc.yOrdinates.length);
            }
            if (curveNumber >= 0) {
                if (pdc.yOrdinates[curveNumber] == null) {
                    throw new HecMathException("Paired Data Container y-value array is null for curve no. " + curveNumber);
                }
            } else if (pdc.xOrdinates == null) {
                throw new HecMathException("Paired Data Container x-value array is null");
            }
            return true;
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "checkPairedDataCurve", e);
            throw new HecMathException("HecMath.checkPairedDataCurve", e);
        }
    }

    private static boolean checkAscendingOrder(double[] array) {
        if (array == null || array.length < 1) {
            return false;
        }
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i - 1] > array[i])) continue;
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.INFO, "At ordinate {0} value {1} is not less than {2}", new Number[]{i, array[i - 1], array[i]});
            return false;
        }
        return true;
    }

    private boolean isValid(DataContainer container, int index) {
        PairedDataContainer pdc = (PairedDataContainer)container;
        if (this._curveNumber < -3 || this._curveNumber >= pdc.numberCurves) {
            return false;
        }
        return PairedDataMath.isValid(container, this._curveNumber, index);
    }

    @Override
    public boolean isValid(int index) {
        PairedDataContainer pdc = this.getContainer();
        if (this._curveNumber < -3 || this._curveNumber >= pdc.numberCurves) {
            return false;
        }
        return PairedDataMath.isValid(pdc, this._curveNumber, index);
    }

    private static boolean isValid(DataContainer container, int icurve, int index) {
        PairedDataContainer pdc = (PairedDataContainer)container;
        return icurve < 0 ? pdc.xOrdinates[index] != -3.4028234663852886E38 : pdc.yOrdinates[icurve][index] != -3.4028234663852886E38;
    }

    @Override
    public HecMath copy() throws HecMathException {
        PairedDataMath pdMath = new PairedDataMath();
        PairedDataContainer pdc = new PairedDataContainer();
        PairedDataContainer myPdc = this.getContainer();
        myPdc.clone(pdc);
        pdMath.setData(pdc);
        pdMath.setCurve(this._curveNumber);
        return pdMath;
    }

    private int findInterval(double[] xvalues, double x, int lastIndex) {
        int idx;
        boolean ascending = true;
        if (x < xvalues[0] || x > xvalues[xvalues.length - 1]) {
            if (x <= xvalues[0] && x >= xvalues[xvalues.length - 1]) {
                ascending = false;
            } else {
                return Integer.MIN_VALUE;
            }
        }
        if ((idx = lastIndex) < 0 || idx >= xvalues.length - 1) {
            idx = 0;
        }
        if (ascending) {
            if (idx < xvalues.length - 1 && x >= xvalues[idx] && x < xvalues[idx + 1]) {
                return idx;
            }
            if (--idx >= 0 && x >= xvalues[idx] && x < xvalues[idx + 1]) {
                return idx;
            }
        } else {
            if (idx > 0 && x <= xvalues[idx] && x > xvalues[idx - 1]) {
                return idx;
            }
            if (++idx < xvalues.length - 1 && x <= xvalues[idx] && x > xvalues[idx - 1]) {
                return idx;
            }
        }
        if ((idx = PairedDataMath.bisearch(xvalues, x, xvalues.length)) == xvalues.length - 1) {
            --idx;
        }
        return idx;
    }

    @Override
    public String getName() {
        try {
            return this.getData().fullName;
        }
        catch (HecMathException e) {
            return null;
        }
    }

    @Override
    public void setName(String name) throws RatingException {
        block6: {
            try {
                PairedDataContainer pdc = (PairedDataContainer)this.getData();
                String[] parts = null;
                parts = TextUtil.split(name, "/", "L");
                if (parts.length == 8) {
                    pdc.fullName = name;
                    pdc.watershed = parts[1];
                    pdc.location = parts[2];
                    String params = parts[3];
                    String version = parts[6];
                    pdc.location = parts[2];
                    parts = TextUtil.split(params, "-", "L", 2);
                    if (parts.length != 2) {
                        throw new RatingException(String.format("Invalid parameter string: %s", params));
                    }
                    pdc.xparameter = parts[0];
                    pdc.yparameter = parts[1];
                    parts = TextUtil.split(version, "-", "L", 2);
                    pdc.version = parts[0];
                    pdc.subVersion = parts.length == 2 ? parts[1] : null;
                    this.setData(pdc);
                    break block6;
                }
                parts = TextUtil.split(name, ".", "L");
                if (parts.length == 4) {
                    pdc.fullName = name;
                    pdc.location = parts[0];
                    String params = parts[1];
                    String version = parts[3];
                    parts = TextUtil.split(params, ";", "L");
                    pdc.xparameter = TextUtil.split(parts[0], ",", "L")[0];
                    pdc.yparameter = parts[1];
                    parts = TextUtil.split(version, "-", "L", 2);
                    pdc.version = parts[0];
                    pdc.subVersion = parts.length == 2 ? parts[1] : null;
                    this.setData(pdc);
                    break block6;
                }
                throw new RatingException(String.format("Invalid name: %s", name));
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    @Override
    public String[] getRatingParameters() {
        String[] parameters = null;
        PairedDataContainer pdc = this.getContainer();
        parameters = new String[]{pdc.xparameter, pdc.yparameter};
        return parameters;
    }

    @Override
    public String[] getRatingUnits() {
        String[] units = null;
        PairedDataContainer pdc = this.getContainer();
        units = new String[]{pdc.xunits, pdc.yunits};
        return units;
    }

    @Override
    public String[] getDataUnits() {
        return this.getRatingUnits();
    }

    @Override
    public void setDataUnits(String[] units) throws RatingException {
        throw new RatingException(String.format("Method not supported by %s objects", this.getClass().getName()));
    }

    @Override
    public long getDefaultValueTime() {
        return Long.MIN_VALUE;
    }

    @Override
    public void setDefaultValueTime(long defaultValueTime) {
    }

    @Override
    public void resetDefaultValuetime() {
    }

    @Override
    public long getRatingTime() {
        return Long.MAX_VALUE;
    }

    @Override
    public void setRatingTime(long ratingTime) {
    }

    @Override
    public void resetRatingTime() {
    }

    @Override
    public double rate(double indVal) throws RatingException {
        double[] indVals = new double[]{indVal};
        return this.rateOne(System.currentTimeMillis(), indVals);
    }

    @Override
    public double rateOne(double ... indVals) throws RatingException {
        return this.rateOne2(indVals);
    }

    @Override
    public double rateOne2(double[] indVals) throws RatingException {
        return this.rateOne(System.currentTimeMillis(), indVals);
    }

    @Override
    public double[] rate(double[] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        double[][] _indVals = new double[indVals.length][1];
        Arrays.fill(valTimes, System.currentTimeMillis());
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i][0] = indVals[i];
        }
        return this.rate(valTimes, _indVals);
    }

    @Override
    public double[] rate(double[][] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, System.currentTimeMillis());
        return this.rate(valTimes, indVals);
    }

    @Override
    public double rate(long valTime, double indVal) throws RatingException {
        double[] indVals = new double[]{indVal};
        return this.rateOne(valTime, indVals);
    }

    @Override
    public double rateOne(long valTime, double ... indVals) throws RatingException {
        return this.rateOne2(valTime, indVals);
    }

    @Override
    public double rateOne2(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        double[][] _indVals = new double[1][];
        Arrays.fill(valTimes, valTime);
        _indVals[0] = indVals;
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    @Override
    public double[] rate(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        double[][] _indVals = new double[indVals.length][1];
        Arrays.fill(valTimes, valTime);
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i][0] = indVals[i];
        }
        return this.rate(valTimes, _indVals);
    }

    @Override
    public double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        double[][] _indVals = new double[indVals.length][1];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i][0] = indVals[i];
        }
        return this.rate(valTimes, _indVals);
    }

    @Override
    public double[] rate(long valTime, double[][] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    @Override
    public double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        try {
            return this.rate((TimeSeriesContainer[])this.makeTscs((long[])valTimes, (double[][])indVals)).values;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesContainer rate(TimeSeriesContainer tsc) throws RatingException {
        try {
            TimeSeriesContainer newTsc = tsc.collapseVerticalDatum();
            return (TimeSeriesContainer)this.ratingTableInterpolation(new TimeSeriesMath(newTsc)).getData();
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesContainer rate(TimeSeriesContainer[] tscs) throws RatingException {
        try {
            switch (tscs.length) {
                case 1: {
                    return this.rate(tscs[0]);
                }
                case 2: {
                    TimeSeriesContainer newTsc0 = tscs[0].collapseVerticalDatum();
                    TimeSeriesContainer newTsc1 = tscs[1].collapseVerticalDatum();
                    return (TimeSeriesContainer)this.twoVariableRatingTableInterpolation(new TimeSeriesMath(newTsc0), new TimeSeriesMath(newTsc1)).getData();
                }
            }
            throw new RatingException("Can rate only 1 or 2 independent parameters");
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesMath rate(TimeSeriesMath tsm) throws RatingException {
        try {
            return this.ratingTableInterpolation(tsm);
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesMath rate(TimeSeriesMath[] tsms) throws RatingException {
        try {
            switch (tsms.length) {
                case 1: {
                    return this.rate(tsms[0]);
                }
                case 2: {
                    return this.twoVariableRatingTableInterpolation(tsms[0], tsms[1]);
                }
            }
            throw new RatingException("Can rate only 1 or 2 independent parameters");
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public double reverseRate(double depVal) throws RatingException {
        long[] valTimes = new long[]{System.currentTimeMillis()};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    @Override
    public double[] reverseRate(double[] depVals) throws RatingException {
        long[] valTimes = new long[depVals.length];
        Arrays.fill(valTimes, System.currentTimeMillis());
        return this.reverseRate(valTimes, depVals);
    }

    @Override
    public double reverseRate(long valTime, double depVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[] depVals = new double[]{depVal};
        return this.reverseRate(valTimes, depVals)[0];
    }

    @Override
    public double[] reverseRate(long valTime, double[] depVals) throws RatingException {
        long[] valTimes = new long[depVals.length];
        Arrays.fill(valTimes, valTime);
        return this.reverseRate(valTimes, depVals);
    }

    @Override
    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        double[][] _depVals = new double[depVals.length][1];
        for (int i = 0; i < depVals.length; ++i) {
            _depVals[i][0] = depVals[i];
        }
        try {
            return this.reverseRate((TimeSeriesContainer)this.makeTscs((long[])valTimes, (double[][])_depVals)[0]).values;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesContainer reverseRate(TimeSeriesContainer tsc) throws RatingException {
        try {
            TimeSeriesContainer newTsc = tsc.collapseVerticalDatum();
            return (TimeSeriesContainer)this.reverseRatingTableInterpolation(new TimeSeriesMath(newTsc)).getData();
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public TimeSeriesMath reverseRate(TimeSeriesMath tsm) throws RatingException {
        try {
            return this.reverseRatingTableInterpolation(tsm);
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public int getIndParamCount() throws RatingException {
        try {
            PairedDataContainer pdc = (PairedDataContainer)this.getData();
            return pdc.numberCurves > 1 && pdc.labelsUsed ? 2 : 1;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public double[][] getRatingExtents() throws RatingException {
        try {
            PairedDataContainer pdc = (PairedDataContainer)this.getData();
            double[][] extents = new double[2][pdc.numberCurves > 1 ? 3 : 2];
            Arrays.fill(extents[0], Double.POSITIVE_INFINITY);
            Arrays.fill(extents[1], Double.NEGATIVE_INFINITY);
            if (pdc.numberCurves > 1) {
                int i;
                for (i = 0; i < pdc.numberCurves; ++i) {
                    try {
                        double val = Double.parseDouble(pdc.labels[i]);
                        if (val < extents[0][0]) {
                            extents[0][0] = val;
                        }
                        if (val > extents[1][0]) {
                            extents[1][0] = val;
                        }
                    }
                    catch (Throwable t) {
                        throw new RatingException("Cannot get rating extents on paired data object with non-numeric labels.");
                    }
                    for (int j = 0; j < pdc.numberOrdinates; ++j) {
                        if (pdc.yOrdinates[i][j] < extents[0][2]) {
                            extents[0][2] = pdc.yOrdinates[i][j];
                        }
                        if (!(pdc.yOrdinates[i][j] > extents[1][2])) continue;
                        extents[1][2] = pdc.yOrdinates[i][j];
                    }
                }
                for (i = 0; i < pdc.numberOrdinates; ++i) {
                    if (pdc.xOrdinates[i] < extents[0][1]) {
                        extents[0][1] = pdc.xOrdinates[i];
                    }
                    if (!(pdc.xOrdinates[i] > extents[1][1])) continue;
                    extents[1][1] = pdc.xOrdinates[i];
                }
            } else {
                for (int i = 0; i < pdc.numberOrdinates; ++i) {
                    if (pdc.xOrdinates[i] < extents[0][0]) {
                        extents[0][0] = pdc.xOrdinates[i];
                    }
                    if (pdc.xOrdinates[i] > extents[1][0]) {
                        extents[1][0] = pdc.xOrdinates[i];
                    }
                    if (pdc.yOrdinates[0][i] < extents[0][1]) {
                        extents[0][1] = pdc.yOrdinates[0][i];
                    }
                    if (!(pdc.yOrdinates[0][i] > extents[1][1])) continue;
                    extents[1][1] = pdc.yOrdinates[0][i];
                }
            }
            return extents;
        }
        catch (Throwable t) {
            if (t instanceof RatingException) {
                throw (RatingException)t;
            }
            throw new RatingException(t);
        }
    }

    @Override
    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        return this.getRatingExtents();
    }

    @Override
    public long[] getEffectiveDates() {
        return new long[]{Long.MIN_VALUE};
    }

    @Override
    public long[] getCreateDates() {
        return new long[]{Long.MIN_VALUE};
    }

    protected TimeSeriesContainer[] makeTscs(long[] valTimes, double[][] indVals) throws HecMathException {
        PairedDataContainer pdc = (PairedDataContainer)this.getData();
        VerticalDatumContainer vdc = null;
        try {
            vdc = pdc.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "makeTscs", e);
        }
        int indParamCount = indVals[0].length;
        int valueCount = valTimes.length;
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[indParamCount];
        for (int i = 0; i < indParamCount; ++i) {
            tscs[i] = new TimeSeriesContainer();
            tscs[i].location = pdc.location;
            tscs[i].parameter = pdc.xparameter;
            tscs[i].units = pdc.xunits;
            tscs[i].times = new int[valueCount];
            tscs[i].values = new double[valueCount];
            tscs[i].type = "INST-VAL";
            tscs[i].version = pdc.version;
            tscs[i].interval = 0;
            tscs[i].fullName = String.format("//%s/%s/IR-MONTH//%s/", tscs[i].location, tscs[i].parameter, tscs[i].version);
            for (int j = 0; j < valueCount; ++j) {
                tscs[i].times[j] = Conversion.toMinutes(valTimes[j]);
                tscs[i].values[j] = indVals[j][i];
            }
            tscs[i].numberValues = valueCount;
            tscs[i].startTime = tscs[i].times[0];
            tscs[i].endTime = tscs[i].times[valueCount - 1];
            try {
                tscs[i].insertVerticalDatum(vdc);
                continue;
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "makeTscs", e);
            }
        }
        return tscs;
    }

    @Override
    public LinearRegressionStatistics correlationCoefficients(HecMath tsMath) throws HecMathException {
        if (tsMath != null) {
            throw new HecMathException("Linear regression coefficients cannot be computed between paired data another dataset");
        }
        if (((PairedDataContainer)this._dc).numberCurves != 2) {
            throw new HecMathException("Paired data has " + ((PairedDataContainer)this._dc).numberCurves + " but linear regression statistics can only be computed between 2 curves.");
        }
        double[][] yOrdinates = ((PairedDataContainer)this._dc).yOrdinates;
        if (yOrdinates == null) {
            throw new HecMathException("Paired Data cannot have empty yOrdinates");
        }
        return this.getLinearRegressionStatistics(yOrdinates[0], yOrdinates[1]);
    }

    @Override
    public PairedDataMath generateDataPairs(HecMath pdMath, double buffer) throws HecMathException {
        PairedDataContainer pd2 = (PairedDataContainer)pdMath._dc;
        PairedDataContainer pd1 = this.getContainer();
        VerticalDatumContainer vdc = null;
        try {
            vdc = pd1.extractVerticalDatum();
        }
        catch (Exception e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
        }
        if (vdc == null) {
            try {
                vdc = pd2.extractVerticalDatum();
            }
            catch (Exception e) {
                Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
            }
        }
        TreeMap<Integer, Integer> overlapMap = new TreeMap<Integer, Integer>();
        int startIndex = 0;
        block8: for (int i = 0; i < pd1.xOrdinates.length; ++i) {
            if (!this.isValid(pd1, i)) continue;
            for (int j = startIndex; j < pd2.xOrdinates.length; ++j) {
                if (!this.isValid(pd2, j)) continue;
                if (Math.abs(pd1.xOrdinates[i] - pd2.xOrdinates[j]) <= buffer) {
                    if (overlapMap.containsKey(i)) {
                        throw new HecMathException("Two primary x values within the buffer of " + pd2.xOrdinates[j] + " and possibly more errors");
                    }
                    if (overlapMap.containsValue(j)) {
                        throw new HecMathException("Two secondary x values within the buffer of " + pd1.xOrdinates[i] + " and possibly more errors");
                    }
                    overlapMap.put(i, j);
                    startIndex = j;
                    continue;
                }
                if (pd2.xOrdinates.length <= i || pd1.xOrdinates[i] < pd2.xOrdinates[i]) continue block8;
            }
        }
        try {
            pdMath = new PairedDataMath();
            PairedDataContainer pdc = new PairedDataContainer();
            double[] dblIndices = new double[overlapMap.size()];
            int i = 0;
            Iterator iterator = overlapMap.keySet().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                dblIndices[i] = pd1.xOrdinates[index];
                ++i;
            }
            double[][] dblvals = new double[2][overlapMap.size()];
            i = 0;
            for (Map.Entry entry : overlapMap.entrySet()) {
                dblvals[0][i] = pd1.yOrdinates[0][(Integer)entry.getKey()];
                dblvals[1][i] = pd2.yOrdinates[0][(Integer)entry.getValue()];
                ++i;
            }
            pdc.xOrdinates = dblIndices;
            pdc.numberCurves = 2;
            pdc.yOrdinates = dblvals;
            pdc.numberOrdinates = dblIndices.length;
            pdc.xunits = pd1.xunits;
            pdc.xparameter = pd1.xparameter;
            pdc.xtype = "UNT";
            pdc.yunits = pd1.yunits;
            pdc.yparameter = pd1.yparameter;
            pdc.ytype = "UNT";
            pdc.labels = new String[]{pd1.fullName, pd2.fullName};
            pdc.labelsUsed = true;
            if (vdc != null) {
                try {
                    pdc.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(PairedDataMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
                }
            }
            pdMath.setData(pdc);
            pdMath.setWatershed(pd1.watershed);
            pdMath.setLocation(pd2.location);
            pdMath.setTimeInterval("");
            pdMath.setVersion("GENERATED DATA PAIRS");
            return ((PairedDataMath)pdMath).expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(PairedDataMath.class.getName()).log(Level.FINE, "generateDataPairs", e);
            throw new HecMathException("HecMath.generateDataPairs", e);
        }
    }

    @Override
    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidToMissingValue, String qualityFlagForInvalidValue) throws HecMathException {
        int i;
        PairedDataContainer resultCollapsed = this.getContainer().collapseVerticalDatum();
        ArrayList values = new ArrayList();
        ArrayList<Double> ordinates = new ArrayList<Double>();
        for (i = 0; i < resultCollapsed.xOrdinates.length; ++i) {
            boolean allWithinBounds = true;
            if (resultCollapsed.yOrdinates[this._curveNumber][i] < minValueLimit || resultCollapsed.yOrdinates[this._curveNumber][i] > maxValueLimit) {
                allWithinBounds = false;
            }
            if (!allWithinBounds) continue;
            ordinates.add(resultCollapsed.xOrdinates[i]);
            ArrayList<Double> currVals = new ArrayList<Double>();
            for (int j = 0; j < resultCollapsed.yOrdinates.length; ++j) {
                currVals.add(resultCollapsed.yOrdinates[j][i]);
            }
            values.add(currVals);
        }
        resultCollapsed.numberOrdinates = ordinates.size();
        resultCollapsed.xOrdinates = new double[ordinates.size()];
        resultCollapsed.yOrdinates = new double[resultCollapsed.numberCurves][ordinates.size()];
        for (i = 0; i < resultCollapsed.xOrdinates.length; ++i) {
            resultCollapsed.xOrdinates[i] = (Double)ordinates.get(i);
            for (int j = 0; j < resultCollapsed.yOrdinates.length; ++j) {
                resultCollapsed.yOrdinates[j][i] = (Double)((List)values.get(i)).get(j);
            }
        }
        PairedDataMath retval = new PairedDataMath();
        retval.setContainer(resultCollapsed);
        return retval.expandVerticalDatum();
    }

    @Override
    public PairedDataMath expandVerticalDatum() throws HecMathException {
        PairedDataContainer pdc;
        if (!(this instanceof VerticalDatum) && (pdc = this.getContainer().expandVerticalDatum()) instanceof VerticalDatum) {
            return new PairedDataMathVertDatum(pdc);
        }
        return (PairedDataMath)this.copy();
    }

    @Override
    public PairedDataMath collapseVerticalDatum() throws HecMathException {
        if (this instanceof VerticalDatum) {
            return new PairedDataMath(this.getContainer().collapseVerticalDatum());
        }
        return (PairedDataMath)this.copy();
    }
}

