/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.lang.UserId;
import hec.script.JPythonScript;
import hec.script.ScriptEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class ScriptLauncher {
    private JPythonScript _script = new JPythonScript();
    private boolean _startedFromMain;
    private String _fileName;
    private static boolean _debug = false;

    public ScriptLauncher(String fileName) {
        this(false, new String[]{fileName});
    }

    public ScriptLauncher(boolean startedFromMain, String[] args) {
        this._startedFromMain = startedFromMain;
        if (_debug) {
            ScriptLauncher.dumpArgs(args);
        }
        Vector scriptArgs = this.parseArgs(args);
        this._fileName = this.getFileName(args);
        if (this._fileName == null) {
            if (this._startedFromMain) {
                System.out.println("Error: Can't find script name");
                System.out.println("USAGE: ScriptLauncher [param=value][...] script");
                System.exit(2);
            }
            throw new IllegalArgumentException("Can't find file name in arg list");
        }
        String scriptText = this.readFile(this._fileName);
        this._script.setScript(scriptText);
        this._script.setArgs(scriptArgs);
    }

    public boolean execute() {
        int rv = ScriptEngine.engine().execute(this._script, UserId.getUserId(), this._fileName);
        if (this._startedFromMain) {
            if (rv == 0) {
                System.exit(0);
            }
            System.exit(rv);
        }
        return rv == 0;
    }

    protected String getFileName(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf("=") > -1 || !args[i].endsWith(".py")) continue;
            if (_debug) {
                System.out.println("found jpython script " + args[i]);
            }
            return args[i];
        }
        return null;
    }

    protected Vector parseArgs(String[] args) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf("=") <= -1) continue;
            if (_debug) {
                System.out.println("add argument " + args[i]);
            }
            v.add(args[i]);
        }
        return v;
    }

    protected String readFile(String fileName) {
        if (_debug) {
            System.out.println("reading file " + fileName);
        }
        File f = new File(fileName);
        StringBuffer buffer = new StringBuffer((int)f.length());
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Exception reading " + fileName + " Error:" + e);
            return null;
        }
        return buffer.toString();
    }

    private static void dumpArgs(String[] args) {
        if (args == null) {
            System.out.println("no arguments to dump");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println("arg " + i + "=[" + args[i] + "]");
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("USAGE: ScriptLauncher [param=value][...] script");
            System.exit(1);
        }
        if ("-d".equals(args[0])) {
            _debug = true;
        }
        ScriptLauncher sl = new ScriptLauncher(true, args);
        sl.execute();
    }
}

