/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.dss.DSSPathname;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleFrequencyAnalysis {
    private TimeSeriesContainer tsc;
    private PairedDataContainer pairedDataPeaks = new PairedDataContainer();
    private PairedDataContainer pairedDataComputed = new PairedDataContainer();
    private List<Double> droppedOutliers = new ArrayList<Double>();
    private static final double[] outlierDeviateTen = new double[]{1.148, 1.425, 1.602, 1.729, 1.828, 1.909, 1.977, 2.036, 2.088, 2.134, 2.175, 2.213, 2.247, 2.279, 2.309, 2.335, 2.361, 2.385, 2.408, 2.429, 2.448, 2.467, 2.486, 2.502, 2.519, 2.534, 2.549, 2.563, 2.577, 2.591, 2.604, 2.616, 2.628, 2.639, 2.65, 2.661, 2.671, 2.682, 2.692, 2.7, 2.71, 2.719, 2.727, 2.736, 2.744, 2.753, 2.76, 2.768, 2.775, 2.783, 2.79, 2.798, 2.804, 2.811, 2.818, 2.824, 2.831, 2.837, 2.842, 2.849, 2.854, 2.86, 2.866, 2.871, 2.877, 2.883, 2.888, 2.893, 2.897, 2.903, 2.908, 2.912, 2.917, 2.922, 2.927, 2.931, 2.935, 2.94, 2.945, 2.949, 2.953, 2.957, 2.961, 2.966, 2.97, 2.973, 2.977, 2.981, 2.984, 2.989, 2.993, 2.996, 3.0, 3.003, 3.006, 3.011, 3.014, 3.017, 3.021, 3.024, 3.027, 3.03, 3.033, 3.037, 3.04, 3.043, 3.046, 3.049, 3.052, 3.055, 3.058, 3.061, 3.064, 3.067, 3.07, 3.073, 3.075, 3.078, 3.081, 3.083, 3.086, 3.089, 3.092, 3.095, 3.097, 3.1, 3.102, 3.104, 3.107, 3.109, 3.112, 3.114, 3.116, 3.119, 3.122, 3.124, 3.126, 3.129, 3.131, 3.133, 3.135, 3.138, 3.14, 3.142, 3.144};

    public PairedDataContainer getPairedDataPeaks() {
        return this.pairedDataPeaks;
    }

    public PairedDataContainer getPairedDataComputed() {
        return this.pairedDataComputed;
    }

    public List<Double> getDroppedOutliers() {
        return this.droppedOutliers;
    }

    public SimpleFrequencyAnalysis(TimeSeriesContainer tsc) {
        this.tsc = tsc;
    }

    public void compute() throws HecMathException {
        double[] rankedPeaks = SimpleFrequencyAnalysis.getSortedPeaks(this.tsc);
        if ((rankedPeaks = this.removeOutliers(rankedPeaks, true)) == null) {
            throw new HecMathException("Error in obtaining maximum values.");
        }
        if (rankedPeaks.length < 10) {
            throw new HecMathException("Insufficient number of data for computing annual frequencies.");
        }
        double logSum = 0.0;
        int n = rankedPeaks.length;
        double[] peakLogs = new double[n];
        for (int i = 0; i < n; ++i) {
            if (rankedPeaks[i] == 0.0) {
                throw new HecMathException("can't handle zero value");
            }
            peakLogs[i] = Math.log10(rankedPeaks[i]);
            logSum += peakLogs[i];
        }
        double meanLog = logSum / (double)n;
        double[] logDiff2 = new double[n];
        double[] logDiff3 = new double[n];
        double[] returnPeriods = new double[n];
        double[] exceedenceProb = new double[n];
        double rp1 = (double)n + 1.0;
        double sumlogDiff2 = 0.0;
        double sumlogDiff3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = peakLogs[i] - meanLog;
            logDiff2[i] = d * d;
            sumlogDiff2 += logDiff2[i];
            logDiff3[i] = d * d * d;
            sumlogDiff3 += logDiff3[i];
            returnPeriods[i] = rp1 / (double)(i + 1);
            exceedenceProb[i] = 1.0 / returnPeriods[i];
        }
        double variance = sumlogDiff2 / ((double)n - 1.0);
        double stdDev = Math.sqrt(variance);
        double skew = (double)n * sumlogDiff3 / ((double)((n - 1) * (n - 2)) * Math.pow(stdDev, 3.0));
        double k = skew / 6.0;
        double[] freqReturnPeriods = new double[]{0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 80.0, 90.0, 95.0, 99.0};
        double[] freqFlows = new double[freqReturnPeriods.length];
        double[] freqExceedenceProb = new double[freqReturnPeriods.length];
        for (int i = 0; i < freqReturnPeriods.length; ++i) {
            double Q;
            double p;
            freqExceedenceProb[i] = p = freqReturnPeriods[i] / 100.0;
            double ln = Math.log(1.0 / (p * p));
            double w = Math.sqrt(ln);
            double numerator = 2.515517 + 0.802853 * w + 0.010328 * w * w;
            double denom = 1.0 + 1.432788 * w + 0.189269 * w * w + 0.0013 * w * w * w;
            double Kp = w - numerator / denom;
            double K = Kp + Kp * Kp * k + (Math.pow(Kp, 3.0) - 6.0 * Kp) * (k * k) / 3.0 - (Kp * Kp - 1.0) * Math.pow(k, 3.0) + Kp * Math.pow(k, 4.0) + Math.pow(k, 5.0) / 3.0;
            double logQ = meanLog + K * stdDev;
            freqFlows[i] = Q = Math.pow(10.0, logQ);
        }
        this.tsc.clone(this.pairedDataPeaks);
        this.pairedDataPeaks.numberCurves = 1;
        this.pairedDataPeaks.numberOrdinates = exceedenceProb.length;
        this.pairedDataPeaks.xOrdinates = exceedenceProb;
        this.pairedDataPeaks.yOrdinates = new double[1][1];
        this.pairedDataPeaks.yOrdinates[0] = rankedPeaks;
        DSSPathname path = new DSSPathname(this.pairedDataPeaks.fullName);
        this.pairedDataPeaks.yparameter = path.getCPart();
        this.pairedDataPeaks.xparameter = "Probability";
        path.setCPart("FREQ-" + path.getCPart());
        path.setDPart("");
        path.setEPart("");
        this.pairedDataPeaks.fullName = path.pathname();
        this.pairedDataPeaks.yunits = this.tsc.units;
        this.pairedDataPeaks.ytype = "LOG";
        this.pairedDataPeaks.xunits = "";
        this.pairedDataPeaks.xtype = "PROB";
        this.pairedDataPeaks.clone(this.pairedDataComputed);
        path.setFPart("Computed");
        this.pairedDataComputed.fullName = path.pathname();
        this.pairedDataComputed.location = "Computed";
        this.pairedDataComputed.version = "";
        this.pairedDataComputed.numberOrdinates = freqReturnPeriods.length;
        this.pairedDataComputed.xOrdinates = freqExceedenceProb;
        this.pairedDataComputed.yOrdinates = new double[1][1];
        this.pairedDataComputed.yOrdinates[0] = freqFlows;
    }

    protected static double[] getSortedPeaks(TimeSeriesContainer input) throws HecMathException {
        TimeSeriesMath m = new TimeSeriesMath(input);
        TimeSeriesMath outputMath = (TimeSeriesMath)((HecMath)m).transformTimeSeries("1YEAR", "0MIN", "MAX", true);
        TimeSeriesContainer tsc = outputMath.getContainer();
        double[] peaks = tsc.values;
        if (peaks == null || peaks.length == 0) {
            throw new HecMathException("Error in obtaining maximum values.");
        }
        int numberMissing = 0;
        for (int i = 0; i < peaks.length; ++i) {
            if (peaks[i] != -3.4028234663852886E38 && peaks[i] != 0.0) continue;
            ++numberMissing;
        }
        if (numberMissing > 0) {
            int newLen = peaks.length - numberMissing;
            if (newLen == 0) {
                return null;
            }
            double[] npeaks = new double[newLen];
            int j = 0;
            for (int i = 0; i < peaks.length; ++i) {
                if (peaks[i] == -3.4028234663852886E38 || peaks[i] == 0.0) continue;
                npeaks[j++] = peaks[i];
            }
            peaks = npeaks;
        }
        Arrays.sort(peaks);
        double[] rsort = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            rsort[i] = peaks[peaks.length - 1 - i];
        }
        return rsort;
    }

    private double[] removeOutliers(double[] input, boolean applyLogTransform) throws HecMathException {
        double[] log10Input = new double[input.length];
        if (applyLogTransform) {
            for (int i = 0; i < log10Input.length; ++i) {
                log10Input[i] = Math.log10(input[i]);
            }
        }
        ArrayList<Double> rval = new ArrayList<Double>();
        double testDeviate = 0.0;
        int sampleSize = log10Input.length;
        testDeviate = sampleSize < outlierDeviateTen.length ? outlierDeviateTen[sampleSize - 3] : 1.947 + 0.584 * Math.log10(sampleSize - 35);
        double mean = SimpleFrequencyAnalysis.Mean(log10Input);
        double std = SimpleFrequencyAnalysis.StandardDeviation(log10Input, mean);
        double lowValue = mean - testDeviate * std;
        for (int i = 0; i < log10Input.length; ++i) {
            if (log10Input[i] > lowValue) {
                rval.add(input[i]);
                continue;
            }
            System.out.println("dropping outlier " + input[i]);
            this.droppedOutliers.add(input[i]);
        }
        double[] a = new double[rval.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Double)rval.get(i);
        }
        return a;
    }

    private static double StandardDeviation(double[] input, double mean) {
        double rval = 0.0;
        for (int i = 0; i < input.length; ++i) {
            rval += Math.pow(input[i] - mean, 2.0);
        }
        return Math.sqrt(rval / (double)input.length);
    }

    private static double Mean(double[] input) throws HecMathException {
        if (input.length == 0) {
            throw new HecMathException("Mean: empty input array");
        }
        double rval = 0.0;
        for (int i = 0; i < input.length; ++i) {
            rval += input[i];
        }
        return rval / (double)input.length;
    }
}

