/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.data.DataSetException;
import hec.data.IVerticalDatumOperations;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.tx.QualityTx;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDataConversion;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.doubleContainer;
import hec.heclib.util.intContainer;
import hec.hecmath.CyclicAnalysisStatistics;
import hec.hecmath.DurationAnalysis;
import hec.hecmath.DurationPeriod;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.LinearRegressionStatistics;
import hec.hecmath.PairedDataMath;
import hec.hecmath.SimpleFrequencyAnalysis;
import hec.hecmath.TimeSeriesMathVertDatum;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Condition;
import hec.hecmath.computation.ScalarOperable;
import hec.hecmath.computation.ValueContainer;
import hec.hecmath.functions.TimeSeriesFunctions;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.annotation.Scriptable;
import hec.util.TextUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import rma.lang.RmaMath;

@Scriptable
public class TimeSeriesMath
extends HecMath
implements IVerticalDatumOperations<TimeSeriesMath, HecMathException> {
    public static final int TYPE_UNDEFINED = -1;
    public static final int INST = 1;
    public static final int INST_VAL = 2;
    public static final int INST_CUM = 3;
    public static final int PER_AVER = 4;
    public static final int PER_CUM = 5;
    public static final int INTERPOLATE = 11;
    public static final int MAX = 12;
    public static final int MIN = 13;
    public static final int AVERAGE = 14;
    public static final int INTEGRATE = 15;
    public static final int ACCUMULATE = 16;
    public static final int VOLUME = 17;
    public static final int COUNT_VALID = 18;
    public static final String LEVEL_YEAR_STRING = "YEAR";
    public static final String LEVEL_DAYMONTH_STRING = "DAYMON";
    public static final String LEVEL_MONTH_STRING = "MONTH";
    public static final String LEVEL_DAYWEEK_STRING = "DAYWEE";
    public static final String LEVEL_TIME_STRING = "TIME";
    private static final String[] _months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] _dayOfWeek = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private static int[] _mdays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected static List<ValueContainer> params(Object ... args) throws ComputationException {
        Vector<ValueContainer> vcs = new Vector<ValueContainer>();
        for (Object obj : args) {
            if (obj instanceof TimeSeriesMath) {
                vcs.add(new ValueContainer(((TimeSeriesMath)obj).getContainer()));
                continue;
            }
            if (obj instanceof HecMath[]) {
                HecMath[] hms;
                for (HecMath hm : hms = (HecMath[])obj) {
                    if (!(hm instanceof TimeSeriesMath)) continue;
                    TimeSeriesMath tsm = (TimeSeriesMath)hm;
                    vcs.add(new ValueContainer(tsm.getContainer()));
                }
                continue;
            }
            if (!(obj instanceof Double)) continue;
            vcs.add(new ValueContainer((Double)obj));
        }
        return vcs;
    }

    public TimeSeriesMath() {
    }

    public TimeSeriesMath(TimeSeriesContainer tsc) throws HecMathException {
        this.setData(tsc);
    }

    @Override
    @Scriptable
    public void setParameterPart(String paramString) throws HecMathException {
        super.setParameterPart(paramString);
        ((TimeSeriesContainer)this._dc).parameter = paramString;
    }

    @Override
    @Scriptable
    public void setData(DataContainer container) throws HecMathException {
        if (container == null) {
            throw new HecMathException("TimeSeriesMath.setData: Parameter is null");
        }
        if (!(container instanceof TimeSeriesContainer)) {
            throw new HecMathException("TimeSeriesMath.setData: Parameter is not TimeSeries Data");
        }
        TimeSeriesContainer tsc = ((TimeSeriesContainer)container).collapseVerticalDatum();
        TimeSeriesMath.checkTimeSeries(tsc);
        this._dc = (TimeSeriesContainer)tsc.clone();
    }

    @Override
    @Scriptable
    public DataContainer getData() throws HecMathException {
        TimeSeriesContainer tsc = this.getContainer();
        if (tsc == null) {
            return null;
        }
        return (DataContainer)tsc.clone();
    }

    @Override
    @Scriptable
    public void getData(DataContainer container) throws HecMathException {
        TimeSeriesContainer tsc = this.getContainer();
        if (tsc == null) {
            return;
        }
        if (container == null || !(container instanceof TimeSeriesContainer)) {
            throw new HecMathException("TimeSeriesMath.getData: Parameter is not TimeSeries Data");
        }
        tsc.clone((TimeSeriesContainer)container);
    }

    private void setContainer(TimeSeriesContainer tsc) throws HecMathException {
        if (tsc == null) {
            throw new HecMathException("TimeSeriesMath.setTimeSeriesContainer: Parameter is null");
        }
        this._dc = tsc;
    }

    @Scriptable
    public TimeSeriesContainer getContainer() {
        return (TimeSeriesContainer)this._dc;
    }

    @Override
    @Scriptable
    public HecMath add(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.add(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath add(double constant) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.add(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath subtract(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.subtract(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath subtract(double constant) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.subtract(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath multiply(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.multiply(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath multiply(double constant) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.multiply(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath divide(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.divide(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath divide(double constant) throws HecMathException {
        if (constant == 0.0) {
            throw new HecMathException("HecMath.divide : cannot divide by zero");
        }
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.divide(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath integerDivide(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.integer_divide(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    public HecMath integer_divide(HecMath tsMath) throws HecMathException {
        return this.integerDivide(tsMath);
    }

    @Scriptable
    public HecMath integerDivide(double constant) throws HecMathException {
        if (constant == 0.0) {
            throw new HecMathException("HecMath.divide : cannot divide by zero");
        }
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.integer_divide(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    public HecMath integer_divide(double constant) throws HecMathException {
        return this.integerDivide(constant);
    }

    @Scriptable
    public HecMath modulo(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.modulo(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath modulo(double constant) throws HecMathException {
        if (constant == 0.0) {
            throw new HecMathException("HecMath.divide : cannot divide by zero");
        }
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.modulo(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath exponentiation(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.exponentiation(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath exponentiation(double constant) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.exponentiation(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath abs() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.abs(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath negative() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.neg(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    public HecMath neg() throws HecMathException {
        return this.negative();
    }

    @Override
    @Scriptable
    public HecMath inverse() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.inverse(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath sign() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.sign(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath sqrt() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.sqrt(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath exp() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.exp(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath log() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.log(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath log10() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.log10(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    public HecMath transformWithFunction(ScalarOperable transformer) throws HecMathException {
        return new TimeSeriesMath(TimeSeriesFunctions.transformWithFunction(this.getContainer(), transformer)).expandVerticalDatum();
    }

    @Override
    @Scriptable
    public HecMath sin() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.sin(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath cos() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.cos(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath tan() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.tan(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath asin() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.asin(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath acos() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.acos(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath atan() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.atan(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath floor() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.floor(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath ceil() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.ceil(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath round() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.round(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath truncate() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.truncate(TimeSeriesMath.params(this), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath fmod(HecMath tsMath) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.fmod(TimeSeriesMath.params(this, tsMath), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath fmod(double constant) throws HecMathException {
        if (constant == 0.0) {
            throw new HecMathException("HecMath.divide : cannot divide by zero");
        }
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.fmod(TimeSeriesMath.params(this, constant), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath sum(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.sum(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath product(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.product(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath min(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.min(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath max(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.max(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath mean(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.mean(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath gmean(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.gmean(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath hmean(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.hmean(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath rms(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.rms(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath variance(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.var(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    public HecMath var(HecMath[] tsMathArray) throws HecMathException {
        return this.variance(tsMathArray);
    }

    @Scriptable
    public HecMath standardDeviation(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.stdev(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Deprecated
    public HecMath stddev(HecMath[] tsMathArray) throws HecMathException {
        return this.standardDeviation(tsMathArray);
    }

    @Scriptable
    public HecMath med(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.med(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p1(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p1(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p2(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p2(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p5(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p5(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p10(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p10(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p20(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p20(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p25(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p25(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p75(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p75(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p80(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p80(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p90(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p90(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p95(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p95(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p98(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p98(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath p99(HecMath[] tsMathArray) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.p99(TimeSeriesMath.params(this, tsMathArray), (Condition)null)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath roundOff(int digitsPrecision, int powerOfTensPlace) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.roundOff(this.getContainer(), digitsPrecision, powerOfTensPlace)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath accumulation() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.accumulation(this.getContainer())).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double min() throws HecMathException {
        try {
            return TimeSeriesFunctions.min(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public int minDate() throws HecMathException {
        try {
            return TimeSeriesFunctions.minDate(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double max() throws HecMathException {
        try {
            return TimeSeriesFunctions.max(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public int maxDate() throws HecMathException {
        try {
            return TimeSeriesFunctions.maxDate(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double mean() throws HecMathException {
        try {
            return TimeSeriesFunctions.mean(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double sum() throws HecMathException {
        try {
            return TimeSeriesFunctions.sum(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double standardDeviation() throws HecMathException {
        try {
            return TimeSeriesFunctions.standardDeviation(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double skewCoefficient() throws HecMathException {
        try {
            return TimeSeriesFunctions.skewCoefficient(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double kurtosisCoefficient() throws HecMathException {
        try {
            return TimeSeriesFunctions.kurtosisCoefficient(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double mode() throws HecMathException {
        try {
            return TimeSeriesFunctions.mode(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double med() throws HecMathException {
        try {
            return TimeSeriesFunctions.med(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p1() throws HecMathException {
        try {
            return TimeSeriesFunctions.p1(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p2() throws HecMathException {
        try {
            return TimeSeriesFunctions.p2(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p5() throws HecMathException {
        try {
            return TimeSeriesFunctions.p5(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p10() throws HecMathException {
        try {
            return TimeSeriesFunctions.p10(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p20() throws HecMathException {
        try {
            return TimeSeriesFunctions.p20(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p25() throws HecMathException {
        try {
            return TimeSeriesFunctions.p25(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p75() throws HecMathException {
        try {
            return TimeSeriesFunctions.p75(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p80() throws HecMathException {
        try {
            return TimeSeriesFunctions.p80(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p90() throws HecMathException {
        try {
            return TimeSeriesFunctions.p90(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p95() throws HecMathException {
        try {
            return TimeSeriesFunctions.p95(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p98() throws HecMathException {
        try {
            return TimeSeriesFunctions.p98(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double p99() throws HecMathException {
        try {
            return TimeSeriesFunctions.p99(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public int numberValidValues() throws HecMathException {
        try {
            return TimeSeriesFunctions.numberValidValues(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public int numberInvalidValues() throws HecMathException {
        try {
            return TimeSeriesFunctions.numberInvalidValues(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public int numberMissingValues() throws HecMathException {
        try {
            return TimeSeriesFunctions.numberMissingValues(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public int numberQuestionedValues() throws HecMathException {
        try {
            return TimeSeriesFunctions.numberQuestionedValues(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public int numberRejectedValues() throws HecMathException {
        try {
            return TimeSeriesFunctions.numberRejectedValues(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public int firstValidDate() throws HecMathException {
        try {
            return TimeSeriesFunctions.firstValidDate(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public double firstValidValue() throws HecMathException {
        try {
            return TimeSeriesFunctions.firstValidValue(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public int lastValidDate() throws HecMathException {
        try {
            return TimeSeriesFunctions.lastValidDate(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public double lastValidValue() throws HecMathException {
        try {
            return TimeSeriesFunctions.lastValidValue(this.getContainer());
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath convertToMetricUnits() throws HecMathException {
        return this.convertUnits(2);
    }

    @Override
    @Scriptable
    public HecMath convertToEnglishUnits() throws HecMathException {
        return this.convertUnits(1);
    }

    @Override
    @Scriptable
    public boolean isMetric() throws HecMathException {
        int unitSystem = this.getUnitSystem();
        if (unitSystem == 0) {
            throw new HecMathException("HecMath.isMetric : could not identify unit system");
        }
        return unitSystem == 2;
    }

    @Override
    @Scriptable
    public boolean isEnglish() throws HecMathException {
        int unitSystem = this.getUnitSystem();
        if (unitSystem == 0) {
            throw new HecMathException("HecMath.isEnglish : could not identify unit system");
        }
        return unitSystem == 1;
    }

    @Override
    @Scriptable
    public boolean canDetermineUnitSystem() {
        try {
            if (this.getUnitSystem() == 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private int getUnitSystem() throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = this.getContainer();
        String dataUnits = myTsc.units;
        int unitsSystem = HecDataConversion.getUnitSystem(dataUnits);
        if (unitsSystem == 0) {
            String[] aliases = Units.getAliasesForUnits(dataUnits);
            if (aliases != null && aliases.length > 0) {
                dataUnits = Units.getUnitsForAlias(dataUnits);
            }
            unitsSystem = Units.getUnitSystemForUnits(dataUnits);
        }
        int fromUnitSystem = unitsSystem;
        return fromUnitSystem;
    }

    private TimeSeriesMath convertUnits(int toUnitSystem) throws HecMathException {
        int fromUnitSystem = this.getUnitSystem();
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        if (toUnitSystem != fromUnitSystem) {
            try {
                int status = HecDataConversion.convertUnits(myTsc, toUnitSystem);
                if (status < 0) {
                    myTsc = this.getContainer().collapseVerticalDatum();
                    Parameter param = new Parameter(myTsc.parameter);
                    int paramId = param.getParameterId();
                    if (paramId != -1) {
                        Units.convertUnits(myTsc.values, paramId, fromUnitSystem, toUnitSystem);
                        myTsc.units = Parameter.getUnitsStringForSystem(paramId, toUnitSystem);
                    }
                }
            }
            catch (DataSetException | IllegalArgumentException e) {
                Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "convertUnits", e);
                throw new HecMathException("HecMath.convertUnits : could not convert units.", e);
            }
            catch (RuntimeException e) {
                Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "convertUnits", e);
                throw new HecMathException("HecMath.convertUnits", e);
            }
        }
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setContainer(myTsc);
        tsMath = tsMath.expandVerticalDatum();
        return tsMath;
    }

    @Override
    @Scriptable
    public String getUnits() {
        TimeSeriesContainer myTsc = this.getContainer();
        if (myTsc == null || myTsc.units == null || myTsc.units.length() < 1) {
            return "";
        }
        String dataUnits = myTsc.units;
        return dataUnits;
    }

    @Override
    @Scriptable
    public String getStandardUnits() {
        TimeSeriesContainer myTsc = this.getContainer();
        if (myTsc == null || myTsc.units == null || myTsc.units.length() < 1) {
            return "";
        }
        String dataUnits = myTsc.units;
        String[] aliases = Units.getAliasesForUnits(dataUnits);
        if (aliases != null && aliases.length > 0) {
            dataUnits = Units.getUnitsForAlias(dataUnits);
        }
        return dataUnits;
    }

    @Override
    @Scriptable
    public void setUnits(String unitsString) {
        try {
            TimeSeriesContainer myTsc = this.getContainer();
            if (myTsc == null) {
                return;
            }
            myTsc.units = unitsString;
            this.setContainer(myTsc);
        }
        catch (Exception e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "setUnits", e);
        }
    }

    @Scriptable
    public String getType() {
        TimeSeriesContainer myTsc = this.getContainer();
        if (myTsc == null || myTsc.type == null || myTsc.type.length() < 1) {
            return "";
        }
        String dataType = myTsc.type;
        return dataType;
    }

    @Scriptable
    public void setType(String typeString) {
        try {
            TimeSeriesContainer myTsc = this.getContainer();
            if (myTsc == null) {
                return;
            }
            myTsc.type = typeString;
            this.setContainer(myTsc);
        }
        catch (Exception e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "setType", e);
        }
    }

    @Override
    @Scriptable
    public HecMath successiveDifferences() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.successiveDifferences(this.getContainer())).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath timeDerivative() throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.timeDerivative(this.getContainer())).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath centeredMovingAverage(int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.centeredMovingAverage(this.getContainer(), numberToAverageOver, onlyValidValues, useReduced)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath olympicSmoothing(int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.olympicSmoothing(this.getContainer(), numberToAverageOver, onlyValidValues, useReduced)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath forwardMovingAverage(int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.forwardMovingAverage(this.getContainer(), numberToAverageOver, onlyValidValues, useReduced)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath forwardMovingAverage(int numberToAverageOver) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.forwardMovingAverage(this.getContainer(), numberToAverageOver)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithMaxMin(this.getContainer(), minValueLimit, maxValueLimit, changeLimit, true, "M")).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidToSpecified, double invalidValueReplacement, String qualityFlagForInvalidValue) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithMaxMin(this.getContainer(), minValueLimit, maxValueLimit, changeLimit, setInvalidToSpecified, invalidValueReplacement, qualityFlagForInvalidValue)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath screenWithMaxMin(double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidToUndefined, String qualityFlagForInvalidValue) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithMaxMin(this.getContainer(), minValueLimit, maxValueLimit, changeLimit, setInvalidToUndefined, qualityFlagForInvalidValue)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithMaxMin(double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithMaxMin(this.getContainer(), minRejectLimit, minQuestionLimit, maxQuestionLimit, maxRejectLimit)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithRateOfChange(double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithRateOfChange(this.getContainer(), minRejectLimit, minQuestionLimit, maxQuestionLimit, maxRejectLimit)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithDurationMagnitude(String durationStr, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithDurationMagnitude(this.getContainer(), durationStr, minRejectLimit, minQuestionLimit, maxQuestionLimit, maxRejectLimit)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithConstantValue(String durationStr, double rejectTolerance, double questionTolerance, double minThreshold, int maxMissing) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithConstantValue(this.getContainer(), durationStr, rejectTolerance, questionTolerance, minThreshold, maxMissing)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Scriptable
    public HecMath screenWithForwardMovingAverage(int numberToAverageOver, double changeLimit) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithForwardMovingAverage(this.getContainer(), numberToAverageOver, changeLimit, true, "M")).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath screenWithForwardMovingAverage(int numberToAverageOver, double changeLimit, boolean setInvalidToUndefined, String qualityFlagForInvalidValue) throws HecMathException {
        try {
            return new TimeSeriesMath(TimeSeriesFunctions.screenWithForwardMovingAverage(this.getContainer(), numberToAverageOver, changeLimit, setInvalidToUndefined, qualityFlagForInvalidValue)).expandVerticalDatum();
        }
        catch (ComputationException ce) {
            throw new HecMathException(ce);
        }
    }

    @Override
    @Scriptable
    public HecMath estimateForMissingValues(int maxMissingAllowed) throws HecMathException {
        TimeSeriesContainer myTsc = this.getContainer();
        TimeSeriesMath.checkTimeSeries(myTsc);
        try {
            myTsc = TimeSeriesFunctions.estimateForMissingValues(myTsc, maxMissingAllowed, false, false, false, true, true);
        }
        catch (ComputationException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "estimateForMissingValues", e);
            throw new HecMathException("HecMath.estimateForMissingValues", e);
        }
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setContainer(myTsc);
        tsMath = tsMath.expandVerticalDatum();
        return tsMath;
    }

    @Override
    @Scriptable
    public HecMath estimateForMissingPrecipValues(int maxMissingAllowed) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        if (this.getContainer().type.toUpperCase().indexOf("INST-CUM") < 0) {
            throw new HecMathException("HecMath.estimateForMissingPrecipValues : Data must be of type INST-CUM\nData type for this time series is " + this.getContainer().type);
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            myTsc = TimeSeriesFunctions.estimateForMissingValues(myTsc, maxMissingAllowed, true, false, false, true, true);
        }
        catch (ComputationException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "estimateForMissingPrecipValues", e);
            throw new HecMathException("HecMath.estimateForMissingPrecipValues", e);
        }
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setContainer(myTsc);
        tsMath = tsMath.expandVerticalDatum();
        return tsMath;
    }

    @Override
    @Scriptable
    public HecMath replaceSpecificValues(HecDouble from, HecDouble to) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        double tod = to.value();
        if (from.precision() == -1 || myTsc.precision == -1) {
            double fromd = from.value();
            for (int i = 0; i < myTsc.values.length; ++i) {
                if (myTsc.values[i] != fromd) continue;
                myTsc.values[i] = tod;
            }
        } else {
            HecDoubleArray fromArray = new HecDoubleArray(myTsc.values);
            fromArray.setPrecision(myTsc.precision);
            for (int i = 0; i < myTsc.values.length; ++i) {
                if (!from.equals(fromArray.element(i))) continue;
                myTsc.values[i] = tod;
            }
        }
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setContainer(myTsc);
        tsMath = tsMath.expandVerticalDatum();
        return tsMath;
    }

    @Override
    @Scriptable
    public HecMath replaceValuesInRange(HecDouble min, HecDouble max, HecDouble to) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        double tod = to.value();
        HecDoubleArray fromArray = new HecDoubleArray(myTsc.values);
        fromArray.setPrecision(myTsc.precision);
        for (int i = 0; i < myTsc.values.length; ++i) {
            if (!min.lessThanEqual(fromArray.element(i)) || !max.greaterThanEqual(fromArray.element(i))) continue;
            myTsc.values[i] = tod;
        }
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setContainer(myTsc);
        tsMath = tsMath.expandVerticalDatum();
        return tsMath;
    }

    @Override
    @Scriptable
    public HecMath mergeTimeSeries(HecMath tsMath) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "mergeTimeSeries");
        TimeSeriesContainer tsc = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tsc);
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            int i;
            int idx1;
            int npts = tsc.times.length + myTsc.times.length;
            int[] mergedTimes = new int[npts];
            double[] mergedValues = new double[npts];
            int icnt = 0;
            if (myTsc.times[0] < tsc.times[0]) {
                for (int idx0 = 0; idx0 < myTsc.times.length && myTsc.times[idx0] < tsc.times[0]; ++idx0) {
                    mergedTimes[icnt] = myTsc.times[idx0];
                    mergedValues[icnt] = myTsc.values[idx0];
                    ++icnt;
                }
            } else if (tsc.times[0] < myTsc.times[0]) {
                for (idx1 = 0; idx1 < tsc.times.length && tsc.times[idx1] < myTsc.times[0]; ++idx1) {
                    mergedTimes[icnt] = tsc.times[idx1];
                    mergedValues[icnt] = tsc.values[idx1];
                    ++icnt;
                }
            }
            for (i = idx0; i < myTsc.times.length; ++i) {
                while (idx1 < tsc.times.length && tsc.times[idx1] < myTsc.times[i]) {
                    mergedTimes[icnt] = tsc.times[idx1];
                    mergedValues[icnt] = tsc.values[idx1];
                    ++icnt;
                    ++idx1;
                }
                if (idx1 < tsc.times.length && tsc.times[idx1] == myTsc.times[i]) {
                    mergedTimes[icnt] = myTsc.times[i];
                    mergedValues[icnt] = TimeSeriesMath.isValid(myTsc, i) ? myTsc.values[i] : (TimeSeriesMath.isValid(tsc, idx1) ? tsc.values[idx1] : -3.4028234663852886E38);
                    ++icnt;
                    ++idx1;
                    continue;
                }
                mergedTimes[icnt] = myTsc.times[i];
                mergedValues[icnt] = myTsc.values[i];
                ++icnt;
            }
            for (i = idx1; i < tsc.times.length; ++i) {
                mergedTimes[icnt] = tsc.times[i];
                mergedValues[icnt] = tsc.values[i];
                ++icnt;
            }
            int[] newTimes = new int[icnt];
            double[] newValues = new double[icnt];
            System.arraycopy(mergedTimes, 0, newTimes, 0, icnt);
            System.arraycopy(mergedValues, 0, newValues, 0, icnt);
            myTsc.times = newTimes;
            myTsc.values = newValues;
            myTsc.numberValues = icnt;
            HecTime hecTime = new HecTime();
            hecTime.set(newTimes[0], myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            myTsc.setStartTime(hecTime);
            hecTime.set(newTimes[icnt - 1], myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            myTsc.setEndTime(hecTime);
            myTsc.quality = null;
            myTsc.interval = 0;
            if (myTsc.numberValues > 2) {
                myTsc.interval = myTsc.times[1] - myTsc.times[0];
            }
            for (int i2 = 2; i2 < myTsc.times.length; ++i2) {
                if (myTsc.times[i2 - 1] - myTsc.times[i2 - 2] == myTsc.times[i2] - myTsc.times[i2 - 1]) continue;
                myTsc.interval = 0;
                break;
            }
            String ePart = "IR-MONTH";
            if (myTsc.interval > 0) {
                ePart = HecTimeSeriesBase.getEPartFromInterval(myTsc.interval);
            }
            TimeSeriesMath tsMathNew = new TimeSeriesMath();
            tsMathNew.setContainer(myTsc);
            if (myTsc.version.indexOf("-MERGED") == -1) {
                tsMathNew.setVersion(myTsc.version + "-MERGED");
            }
            tsMathNew.setTimeInterval(ePart);
            tsMathNew = tsMathNew.expandVerticalDatum();
            return tsMathNew;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "mergeTimeSeries", e);
            throw new HecMathException("HecMath.mergeTimeSeries", e);
        }
    }

    @Override
    public PairedDataMath generateDataPairs(HecMath tsMath, double buffer) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "generateDataPairs");
        TimeSeriesContainer tscy = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tscy);
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer tscx = (TimeSeriesContainer)this.getContainer().clone();
        VerticalDatumContainer vdc = this.getValidVerticalDatumContainer(tscx, tscy);
        String vdi = this.getValidVerticalDatumInfo(tscx, tscy, vdc);
        TreeMap<Integer, Integer> overlapMap = new TreeMap<Integer, Integer>();
        int startIndex = 0;
        block4: for (int i = 0; i < tscx.times.length; ++i) {
            if (!TimeSeriesMath.isValid(tscx, i)) continue;
            for (int j = startIndex; j < tscy.times.length; ++j) {
                if (!TimeSeriesMath.isValid(tscy, j)) continue;
                if ((double)Math.abs(tscx.times[i] - tscy.times[j]) <= buffer) {
                    if (buffer > 0.0 && overlapMap.containsKey(i)) {
                        throw new HecMathException("Two primary times within the buffer of " + tscy.times[j] + " and possibly more errors");
                    }
                    if (buffer > 0.0 && overlapMap.containsValue(j)) {
                        throw new HecMathException("Two secondary times within the buffer of " + tscx.times[i] + " and possibly more errors");
                    }
                    overlapMap.put(i, j);
                    startIndex = j;
                    continue;
                }
                if (tscx.times[i] < tscy.times[j]) continue block4;
            }
        }
        try {
            PairedDataMath pdMath = new PairedDataMath();
            PairedDataContainer pdc = new PairedDataContainer();
            if (vdi != null) {
                pdc.supplementalInfo = "verticalDatumInfo:" + vdi + ";";
            }
            double[] dblIndices = this.getTimeIndices(overlapMap.keySet(), tscx.times);
            double[][] dblvals = this.getValues(overlapMap.entrySet(), tscx.values, tscy.values);
            pdc.xOrdinates = dblIndices;
            pdc.numberCurves = 2;
            pdc.yOrdinates = dblvals;
            pdc.numberOrdinates = dblIndices.length;
            pdc.xunits = tscx.units;
            pdc.xparameter = tscx.parameter;
            pdc.xtype = "UNT";
            pdc.yunits = tscy.units;
            pdc.yparameter = tscy.parameter;
            pdc.ytype = "UNT";
            pdc.labels = new String[]{tscx.fullName, tscy.fullName};
            pdc.labelsUsed = true;
            if (vdc != null) {
                try {
                    pdc.insertVerticalDatum(vdc);
                }
                catch (Exception e) {
                    Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
                }
            }
            pdMath.setData(pdc);
            pdMath.setWatershed(tscx.watershed);
            pdMath.setLocation(tscx.location);
            pdMath.setTimeInterval("");
            pdMath.setVersion("GENERATED DATA PAIRS");
            return pdMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateDataPairs", e);
            throw new HecMathException("HecMath.generateDataPairs", e);
        }
    }

    private VerticalDatumContainer getValidVerticalDatumContainer(TimeSeriesContainer primaryTsc, TimeSeriesContainer secondaryTsc) {
        VerticalDatumContainer vdc = null;
        if (primaryTsc instanceof TimeSeriesContainerVertDatum) {
            vdc = ((TimeSeriesContainerVertDatum)primaryTsc).getVerticalDatumContainer();
        } else if (secondaryTsc instanceof TimeSeriesContainerVertDatum) {
            vdc = ((TimeSeriesContainerVertDatum)secondaryTsc).getVerticalDatumContainer();
        }
        return vdc;
    }

    private double[][] getValues(Set<Map.Entry<Integer, Integer>> entrySet, double[] xArray, double[] yArray) {
        double[][] dblvals = new double[2][entrySet.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : entrySet) {
            dblvals[0][i] = xArray[entry.getKey()];
            dblvals[1][i] = yArray[entry.getValue()];
            ++i;
        }
        return dblvals;
    }

    private double[] getTimeIndices(Set<Integer> iSet, int[] array) {
        double[] dblIndices = new double[iSet.size()];
        int i = 0;
        for (int index : iSet) {
            dblIndices[i] = array[index];
            ++i;
        }
        return dblIndices;
    }

    @Override
    @Deprecated
    public PairedDataMath generateDataPairs(HecMath tsMath, boolean sort) throws HecMathException {
        return this.generatePairedData(tsMath, sort);
    }

    @Override
    @Scriptable
    public PairedDataMath generatePairedData(HecMath tsMath, boolean sort) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "generateDataPairs");
        TimeSeriesContainer tscy = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tscy);
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer tscx = (TimeSeriesContainer)this.getContainer().clone();
        this.checkTimeSeriesMatch(tscy);
        VerticalDatumContainer vdc = this.getValidVerticalDatumContainer(tscx, tscy);
        String vdi = this.getValidVerticalDatumInfo(tscx, tscy, vdc);
        try {
            int icnt = 0;
            for (int i = 0; i < tscx.times.length; ++i) {
                if (!TimeSeriesMath.isValid(tscx, i) || !TimeSeriesMath.isValid(tscy, i)) continue;
                ++icnt;
            }
            if (icnt < 2) {
                throw new HecMathException("HecMath.generateDataPairs : Not enough valid data.  At least 2 valid value-pairs required");
            }
            double[] xarray = new double[icnt];
            double[] yarray = new double[icnt];
            icnt = 0;
            for (int i = 0; i < tscx.times.length; ++i) {
                if (!TimeSeriesMath.isValid(tscx, i) || !TimeSeriesMath.isValid(tscy, i)) continue;
                xarray[icnt] = tscx.values[i];
                yarray[icnt] = tscy.values[i];
                ++icnt;
            }
            if (sort) {
                for (int i = 0; i < icnt - 1; ++i) {
                    for (int k = i + 1; k < icnt; ++k) {
                        if (!(xarray[i] > xarray[k])) continue;
                        double tmpx = xarray[i];
                        double tmpy = yarray[i];
                        xarray[i] = xarray[k];
                        yarray[i] = yarray[k];
                        xarray[k] = tmpx;
                        yarray[k] = tmpy;
                    }
                }
            }
            PairedDataMath pdMath = new PairedDataMath();
            PairedDataContainer pdc = new PairedDataContainer();
            if (vdi != null) {
                pdc.supplementalInfo = "verticalDatumInfo:" + vdi + ";";
            }
            pdc.xOrdinates = xarray;
            pdc.numberCurves = 1;
            pdc.yOrdinates = new double[1][];
            pdc.yOrdinates[0] = yarray;
            pdc.numberOrdinates = yarray.length;
            pdc.xunits = tscx.units;
            pdc.xparameter = tscx.parameter;
            pdc.xtype = "UNT";
            pdc.yunits = tscy.units;
            pdc.yparameter = tscy.parameter;
            pdc.ytype = "UNT";
            if (vdc != null) {
                try {
                    pdc.insertVerticalDatum(vdc);
                    Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, vdc.toString());
                    Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, pdc.supplementalInfo);
                }
                catch (Exception e) {
                    Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
                }
            }
            pdMath.setData(pdc);
            pdMath.setWatershed(tscx.watershed);
            pdMath.setLocation(tscx.location);
            pdMath.setTimeInterval("");
            pdMath.setVersion("GENERATED DATA PAIRS");
            return pdMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateDataPairs", e);
            throw new HecMathException("HecMath.generateDataPairs", e);
        }
    }

    private String getValidVerticalDatumInfo(TimeSeriesContainer primaryTsc, TimeSeriesContainer secondaryTsc, VerticalDatumContainer vdc) {
        String retval = null;
        if (vdc != null) {
            try {
                retval = TextUtil.compress(vdc.getVerticalDatumInfo(), "base64");
            }
            catch (IOException e) {
                Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "generateDataPairs", e);
            }
        } else {
            HashMap<String, String> si = primaryTsc.getSupplementalInfo();
            retval = si.get("verticalDatumInfo");
            if (retval == null) {
                si = secondaryTsc.getSupplementalInfo();
                retval = si.get("verticalDatumInfo");
            }
        }
        return retval;
    }

    @Scriptable
    public String isMuskingumRoutingStable(int numberSubreaches, double muskingumK, double muskingumX) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            double upperLimitK;
            if (myTsc.interval <= 0) {
                throw new HecMathException("HecMath.muskingumRouting: This function requires a regular interval time series.\nThe time series " + myTsc.fullName + " is not a regular interval time series.");
            }
            if (muskingumX < 0.0 || muskingumX > 0.5) {
                String msg = "HecMath.muskingumRouting: muskingumX value must be between 0.0 and 0.5\nmuskingumX = " + muskingumX;
                throw new HecMathException(msg);
            }
            if (numberSubreaches <= 0) {
                String msg = "HecMath.muskingumRouting: Number of subreaches less than 1\nnumberSubreaches = " + numberSubreaches;
                throw new HecMathException(msg);
            }
            double deltaT = (double)myTsc.interval / 60.0;
            double lowerLimitK = 1.0 / (2.0 * (1.0 - muskingumX));
            double subK = muskingumK / (double)numberSubreaches;
            String msg = null;
            if (subK / deltaT < lowerLimitK) {
                msg = "HecMath.muskingumRouting: Possible instabilities in the Muskingum Routing\nK subreach/delta T = " + subK / deltaT + " is less than \n1/(2*(1-x)) = " + lowerLimitK;
            }
            if (muskingumX > 0.0 && subK / deltaT > (upperLimitK = 1.0 / (2.0 * muskingumX))) {
                msg = "HecMath.muskingumRouting: Possible instabilities in the Muskingum Routing\nK subreach/delta T = " + subK / deltaT + " is greater than \n1/2x = " + upperLimitK;
            }
            return msg;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "muskingumRouting", e);
            throw new HecMathException("HecMath.muskingumRouting", e);
        }
    }

    @Override
    @Scriptable
    public HecMath muskingumRouting(int numberSubreaches, double muskingumK, double muskingumX) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            if (myTsc.interval <= 0) {
                throw new HecMathException("HecMath.muskingumRouting: This function requires a regular interval time series.\nThe time series " + myTsc.fullName + " is not a regular interval time series.");
            }
            double deltaT = (double)myTsc.interval / 60.0;
            if (muskingumX < 0.0 || muskingumX > 0.5) {
                String msg = "HecMath.muskingumRouting: muskingumX value must be between 0.0 and 0.5\nmuskingumX = " + muskingumX;
                throw new HecMathException(msg);
            }
            if (numberSubreaches <= 0) {
                String msg = "HecMath.muskingumRouting: Number of subreaches less than 1\nnumberSubreaches = " + numberSubreaches;
                throw new HecMathException(msg);
            }
            double subK = muskingumK / (double)numberSubreaches;
            double c0 = (-subK * muskingumX + 0.5 * deltaT) / (subK - subK * muskingumX + 0.5 * deltaT);
            double c1 = (subK * muskingumX + 0.5 * deltaT) / (subK - subK * muskingumX + 0.5 * deltaT);
            double c2 = (subK - subK * muskingumX - 0.5 * deltaT) / (subK - subK * muskingumX + 0.5 * deltaT);
            double[] inflow = myTsc.values;
            double[] outflow = new double[inflow.length];
            double initialSubreachOutflow = inflow[0];
            for (int j = 0; j < numberSubreaches; ++j) {
                outflow[0] = initialSubreachOutflow;
                for (int i = 1; i < myTsc.times.length; ++i) {
                    outflow[i] = inflow[i] == -3.4028234663852886E38 || inflow[i - 1] == -3.4028234663852886E38 || outflow[i - 1] == -3.4028234663852886E38 ? -3.4028234663852886E38 : c0 * inflow[i] + c1 * inflow[i - 1] + c2 * outflow[i - 1];
                }
                System.arraycopy(outflow, 0, inflow, 0, inflow.length);
            }
            myTsc.values = outflow;
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(myTsc);
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "muskingumRouting", e);
            throw new HecMathException("HecMath.muskingumRouting", e);
        }
    }

    @Override
    @Scriptable
    public HecMath straddleStaggerRouting(int numberToAverage, int numberToLag, int numberSubreaches) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            int i;
            if (myTsc.interval <= 0) {
                throw new HecMathException("HecMath.straddleStaggerRouting: This function requires a regular interval time series.\nThe time series " + myTsc.fullName + " is not a regular interval time series.");
            }
            if (numberSubreaches <= 0) {
                throw new HecMathException("HecMath.straddleStaggerRouting: Number of subreaches less than 1\nnumberSubreaches = " + numberSubreaches);
            }
            if (this.numberValidValues() < 2) {
                throw new HecMathException("HecMath.straddleStaggerRouting: Less than two valid values in time series\n" + myTsc.fullName);
            }
            double[] inflow = myTsc.values;
            double[] outflow = new double[inflow.length];
            int[] quality = myTsc.quality;
            boolean hasQuality = false;
            if (quality != null) {
                hasQuality = true;
            }
            for (i = myTsc.times.length - 1; i >= numberToLag; --i) {
                inflow[i] = inflow[i - numberToLag];
                if (!hasQuality) continue;
                quality[i] = quality[i - numberToLag];
            }
            for (i = 0; i < numberToLag; ++i) {
                inflow[i] = -3.4028234663852886E38;
            }
            for (int j = 0; j < numberSubreaches; ++j) {
                for (int i2 = 0; i2 < myTsc.times.length; ++i2) {
                    if (inflow[i2] == -3.4028234663852886E38) {
                        outflow[i2] = inflow[i2];
                        continue;
                    }
                    double sum = 0.0;
                    int icnt = 0;
                    for (int k = 0; k < numberToAverage; ++k) {
                        int idx = i2 + k - numberToAverage / 2;
                        if (idx < 0) {
                            idx = 0;
                        }
                        if (idx >= myTsc.times.length) {
                            idx = myTsc.times.length - 1;
                        }
                        if (inflow[idx] == -3.4028234663852886E38) continue;
                        sum += inflow[idx];
                        ++icnt;
                    }
                    outflow[i2] = icnt > 0 ? sum / (double)icnt : -3.4028234663852886E38;
                }
                System.arraycopy(outflow, 0, inflow, 0, myTsc.times.length);
            }
            myTsc.values = outflow;
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(myTsc);
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "straddleStaggerRouting", e);
            throw new HecMathException("HecMath.straddleStaggerRouting", e);
        }
    }

    @Override
    @Scriptable
    public HecMath decayingBasinWetnessParameter(HecMath tsMath, double decayRate) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "decayingBasinWetnessParameter");
        TimeSeriesContainer tscPrecip = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tscPrecip);
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        this.checkTimeSeriesMatch(tscPrecip);
        if (tscPrecip.interval <= 0) {
            throw new HecMathException("HecMath.decayingBasinWetnessParameter: The time series " + tscPrecip.fullName + " is not a regular interval time series.");
        }
        if (decayRate <= 0.0 || decayRate >= 1.0) {
            throw new HecMathException("HecMath.decayingBasinWetnessParameter: The Decay Rate should be greater than 0 and less than 1.\nDecay Rate = " + decayRate);
        }
        try {
            double[] newValues = new double[myTsc.times.length];
            newValues[0] = !TimeSeriesMath.isValid(myTsc, 0) ? 0.0 : myTsc.values[0];
            for (int i = 1; i < myTsc.times.length; ++i) {
                double precip = TimeSeriesMath.isValid(tscPrecip, i) ? tscPrecip.values[i] : 0.0;
                newValues[i] = decayRate * newValues[i - 1] + precip;
            }
            myTsc.values = newValues;
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(myTsc);
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "decayingBasinWetnessParameter", e);
            throw new HecMathException("HecMath.decayingBasinWetnessParameter", e);
        }
    }

    @Override
    @Scriptable
    public HecMath flowAccumulatorGageProcessor(HecMath tsMath) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "flowAccumulatorGageProcessor");
        TimeSeriesContainer tscCounts = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tscCounts);
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        this.checkTimeSeriesMatch(tscCounts);
        try {
            double[] flowAccumulator = myTsc.values;
            double[] counts = tscCounts.values;
            double[] newValues = new double[myTsc.times.length];
            newValues[0] = -3.4028234663852886E38;
            for (int i = 1; i < myTsc.times.length; ++i) {
                if (!(TimeSeriesMath.isValid(myTsc, i) && TimeSeriesMath.isValid(myTsc, i - 1) && TimeSeriesMath.isValid(tscCounts, i) && TimeSeriesMath.isValid(tscCounts, i - 1))) {
                    newValues[i] = -3.4028234663852886E38;
                    continue;
                }
                double diffFlowAccumulator = flowAccumulator[i] - flowAccumulator[i - 1];
                double diffCounts = counts[i] - counts[i - 1];
                if (diffFlowAccumulator <= 0.0 && diffCounts < 0.0) {
                    diffFlowAccumulator = flowAccumulator[i];
                    diffCounts = counts[i];
                    newValues[i] = diffFlowAccumulator / diffCounts;
                    continue;
                }
                newValues[i] = diffFlowAccumulator < 0.0 || diffCounts <= 0.0 ? -3.4028234663852886E38 : diffFlowAccumulator / diffCounts;
            }
            myTsc.values = newValues;
            myTsc.type = "PER-AVER";
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(myTsc);
            if (myTsc.allMissing()) {
                throw new HecMathException("Error: flowAccumulatorGageProcessor.  Please verify the counter series is incrementing, and other input data ");
            }
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "flowAccumulatorGageProcessor", e);
            throw new HecMathException("HecMath.flowAccumulatorGageProcessor", e);
        }
    }

    @Override
    public HecMath convertToIrregular(String blockSize) throws HecMathException {
        return this.convertToIrregular(blockSize, false);
    }

    public HecMath convertToIrregular(String blockSize, boolean removeMissing) throws HecMathException {
        try {
            TimeSeriesMath.checkTimeSeries(this.getContainer());
            TimeSeriesContainer currentTsc = this.getContainer().collapseVerticalDatum();
            if (removeMissing) {
                currentTsc.removeAllMissing();
            }
            DSSPathname path = new DSSPathname(currentTsc.fullName);
            path.setEPart(blockSize);
            currentTsc.fullName = path.toString();
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(currentTsc);
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "convertToIrregular", e);
            throw new HecMathException("HecMath.convertToIrregular", e);
        }
    }

    @Override
    @Scriptable
    public HecMath interpolateDataAtRegularInterval(String timeIntervalString, String timeOffsetString) throws HecMathException {
        try {
            TimeSeriesMath.checkTimeSeries(this.getContainer());
            TimeSeriesContainer currentTsc = (TimeSeriesContainer)this.getContainer().clone();
            int dataType = -1;
            if (currentTsc.type.toUpperCase().indexOf("INST-") >= 0) {
                dataType = 1;
            } else if (currentTsc.type.toUpperCase().equals("PER-AVER")) {
                dataType = 4;
            } else if (currentTsc.type.toUpperCase().equals("PER-CUM")) {
                dataType = 5;
            }
            if (dataType == -1) {
                String s = "HecMath.interpolateDataAtRegularInterval: data type undefined. \n" + currentTsc.fullName;
                throw new HecMathException(s);
            }
            String functionTypeString = "";
            if (dataType == 1) {
                functionTypeString = "INT";
            } else if (dataType == 4) {
                functionTypeString = "AVE";
            } else if (dataType == 5) {
                functionTypeString = "ACC";
            } else {
                String s = "HecMath.interpolateDataAtRegularInterval: data type undefined.\nData type = " + currentTsc.type;
                throw new HecMathException(s);
            }
            return this.transformTimeSeries(timeIntervalString, timeOffsetString, functionTypeString, false);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "interpolateDataAtRegularInterval", e);
            throw new HecMathException("HecMath.interpolateDataAtRegularInterval", e);
        }
    }

    @Override
    @Scriptable
    public HecMath transformTimeSeries(String timeIntervalString, String timeOffsetString, String functionTypeString) throws HecMathException {
        return this.transformTimeSeries(timeIntervalString, timeOffsetString, functionTypeString, false);
    }

    @Override
    public HecMath transformTimeSeries(String timeIntervalString, String timeOffsetString, String functionTypeString, boolean toIrregular) throws HecMathException {
        try {
            int timeIntervalMinutes = TimeSeriesMath.parseTimeInterval(timeIntervalString);
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.transformTimeSeries: timeIntervalString parameter could not be successfully parsed \ntimeIntervalString = " + timeIntervalString);
            }
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE || !TimeSeriesMath.isValidDssInterval(timeIntervalMinutes) && !toIrregular) {
                throw new HecMathException("HecMath.transformTimeSeries: Not a valid time interval \ntimeIntervalString = " + timeIntervalString);
            }
            int timeOffsetMinutes = 0;
            if (timeOffsetString != null && timeOffsetString.trim().length() > 0 && (timeOffsetMinutes = TimeSeriesMath.parseTimeInterval(timeOffsetString)) == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.transformTimeSeries: timeOffsetString parameter could not be successfully parsed \ntimeOffsetString = " + timeOffsetString);
            }
            if (timeOffsetMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.transformTimeSeries: timeOffsetString parameter could not be successfully parsed \ntimeOffsetString = " + timeOffsetString);
            }
            int functionType = this.getFunctionType(functionTypeString);
            return this.transformTimeSeries(timeIntervalMinutes, timeOffsetMinutes, functionType, toIrregular);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "transformTimeSeries", e);
            throw new HecMathException("HecMath.transformTimeSeries", e);
        }
    }

    @Scriptable
    private TimeSeriesMath transformTimeSeries(int timeIntervalMinutes, int timeOffsetMinutes, int functionType, boolean toIrregular) throws HecMathException {
        if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE || !TimeSeriesMath.isValidDssInterval(timeIntervalMinutes) && !toIrregular) {
            throw new HecMathException("HecMath.transformTimeSeries: Not a valid time interval \ntimeIntervalMinutes = " + timeIntervalMinutes);
        }
        TimeSeriesContainer regularTsc = (TimeSeriesContainer)this.generateRegularIntervalTimeSeries(timeIntervalMinutes, timeOffsetMinutes);
        return this.transformTimeSeries(regularTsc, functionType, toIrregular, 1.0);
    }

    @Override
    @Scriptable
    public HecMath transformTimeSeries(HecMath tsMath, String functionTypeString) throws HecMathException {
        return this.transformTimeSeries(tsMath, functionTypeString, false);
    }

    @Override
    public HecMath transformTimeSeries(HecMath tsMath, String functionTypeString, boolean toIrregular) throws HecMathException {
        return this.transformTimeSeries(tsMath, functionTypeString, toIrregular, 1.0);
    }

    public HecMath transformTimeSeries(HecMath tsMath, String functionTypeString, boolean toIrregular, double missingAllowed) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "transformTimeSeries");
        TimeSeriesMath.checkTimeSeries((TimeSeriesContainer)tsMath._dc);
        TimeSeriesContainer newTsc = (TimeSeriesContainer)((TimeSeriesContainer)tsMath._dc).clone();
        try {
            int functionType = this.getFunctionType(functionTypeString);
            DSSPathname dssPath = new DSSPathname();
            dssPath.setPathname(newTsc.fullName);
            String saveEPart = dssPath.getEPart();
            int saveInterval = newTsc.interval;
            TimeSeriesMath.checkTimeSeries(this.getContainer());
            TimeSeriesMath.copyHeaderInfo(this.getContainer(), newTsc);
            dssPath.setPathname(newTsc.fullName);
            dssPath.setEPart(saveEPart);
            dssPath.setDPart("");
            newTsc.fullName = dssPath.getPathname();
            newTsc.interval = saveInterval;
            Arrays.fill(newTsc.values, -3.4028234663852886E38);
            return this.transformTimeSeries(newTsc, functionType, toIrregular, missingAllowed);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "transformTimeSeries", e);
            throw new HecMathException("HecMath.transformTimeSeries", e);
        }
    }

    protected int getFunctionType(String functionTypeString) throws HecMathException {
        int functionType;
        if (functionTypeString.equals("INT")) {
            functionType = 11;
        } else if (functionTypeString.equals("MAX")) {
            functionType = 12;
        } else if (functionTypeString.equals("MIN")) {
            functionType = 13;
        } else if (functionTypeString.equals("AVE")) {
            functionType = 14;
        } else if (functionTypeString.equals("ACC")) {
            functionType = 16;
        } else if (functionTypeString.equals("ITG")) {
            functionType = 15;
        } else if (functionTypeString.equals("NUM")) {
            functionType = 18;
        } else if (functionTypeString.equals("VOL")) {
            functionType = 17;
        } else {
            throw new HecMathException("HecMath.transformTimeSeries: functionTypeString parameter could not be successfully parsed \nfunctionTypeString = " + functionTypeString);
        }
        return functionType;
    }

    private TimeSeriesMath transformTimeSeries(TimeSeriesContainer newTsc, int functionType, boolean toIrregular, double missingAllowed) throws HecMathException {
        try {
            TimeSeriesMath.checkTimeSeries(this.getContainer());
            TimeSeriesContainer currentTsc = (TimeSeriesContainer)this.getContainer().clone();
            TimeSeriesFunctions.transformTimeSeries(currentTsc, newTsc, functionType, toIrregular, missingAllowed);
            TimeSeriesMath tsMath = new TimeSeriesMath();
            tsMath.setContainer(newTsc);
            tsMath = tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (HecMathException | ComputationException | RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "transformTimeSeries", e);
            String message = "There was an error during the computation. \n There may be missing data, not enough input,\n or other condition such as combination of interval and amount of data.";
            throw new HecMathException("HecMath.transformTimeSeries " + message, e);
        }
    }

    @Override
    @Scriptable
    public HecMath snapToRegularInterval(String timeIntervalString, String timeOffsetString, String timeBackwardString, String timeForwardString) throws HecMathException {
        try {
            int timeIntervalMinutes = TimeSeriesMath.parseTimeInterval(timeIntervalString);
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.snapToRegularInterval: timeIntervalString parameter could not be successfully parsed \ntimeIntervalString = " + timeIntervalString);
            }
            if (!TimeSeriesMath.isValidDssInterval(timeIntervalMinutes)) {
                throw new HecMathException("HecMath.snapToRegularInterval: Not a valid time interval \ntimeIntervalStrings = " + timeIntervalString);
            }
            int timeOffsetMinutes = 0;
            if (timeOffsetString != null && timeOffsetString.trim().length() > 0 && (timeOffsetMinutes = TimeSeriesMath.parseTimeInterval(timeOffsetString)) == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.snapToRegularInterval: timeOffsetString parameter could not be successfully parsed \ntimeOffsetString = " + timeOffsetString);
            }
            int timeBackwardMinutes = TimeSeriesMath.parseTimeInterval(timeBackwardString);
            if (timeBackwardMinutes < 0 || timeBackwardMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.snapToRegularInterval: timeBackwardString parameter could not be successfully parsed \ntimeBackwardString = " + timeBackwardString);
            }
            int timeForwardMinutes = TimeSeriesMath.parseTimeInterval(timeForwardString);
            if (timeForwardMinutes < 0 || timeForwardMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.snapToRegularInterval: timeBackwardString parameter could not be successfully parsed \ntimeForwardMinutes = " + timeForwardMinutes);
            }
            return this.snapToRegularInterval(timeIntervalMinutes, timeOffsetMinutes, timeBackwardMinutes, timeForwardMinutes);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "snapToRegularInterval", e);
            throw new HecMathException("HecMath.snapToRegularInterval", e);
        }
    }

    private TimeSeriesMath snapToRegularInterval(int timeIntervalMinutes, int timeOffsetMinutes, int timeBackwardMinutes, int timeForwardMinutes) throws HecMathException {
        try {
            TimeSeriesContainer tsc = TimeSeriesFunctions.snapToRegularInterval(this.getContainer(), timeIntervalMinutes, timeOffsetMinutes, timeBackwardMinutes, timeForwardMinutes);
            if (tsc.allMissing()) {
                throw new HecMathException("Error with Irregular to Regular Snap.  You may need a larger Back and/or Forward Tolerance");
            }
            TimeSeriesMath tsMath = new TimeSeriesMath(tsc);
            tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (Throwable t) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "snapToRegularInterval", t);
            if (t instanceof HecMathException) {
                throw (HecMathException)t;
            }
            throw new HecMathException("HecMath.snapToRegularInterval", t);
        }
    }

    @Override
    @Scriptable
    public HecMath shiftInTime(String timeShiftString) throws HecMathException {
        try {
            intContainer numberIntervals = new intContainer();
            intContainer timeInterval = new intContainer();
            int timeShiftMinutes = TimeSeriesMath.parseTimeInterval(timeShiftString, timeInterval, numberIntervals);
            if (timeShiftMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.shiftInTime: timeShiftString parameter could not be successfully parsed \ntimeShiftString = " + timeShiftString);
            }
            return this.shiftInTime(timeShiftMinutes, timeInterval.value, numberIntervals.value);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "shiftInTime", e);
            throw new HecMathException("HecMath.shiftInTime", e);
        }
    }

    @Scriptable
    public HecMath shiftInTime(int timeShiftMinutes) throws HecMathException {
        return this.shiftInTime(timeShiftMinutes, 0, 0);
    }

    public HecMath shiftInTime(int timeShiftMinutes, int timeInterval, int numberIntervals) throws HecMathException {
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            if (timeInterval < 43200 || timeInterval == 0 || numberIntervals == 0) {
                int i = 0;
                while (i < myTsc.times.length) {
                    int n = i++;
                    myTsc.times[n] = myTsc.times[n] + timeShiftMinutes;
                }
            } else {
                HecTime time = new HecTime();
                for (int i = 0; i < myTsc.times.length; ++i) {
                    time.set(myTsc.times[i]);
                    time.increment(numberIntervals, timeInterval);
                    myTsc.times[i] = time.value();
                }
            }
            myTsc.startTime = myTsc.times[0];
            myTsc.endTime = myTsc.times[myTsc.times.length - 1];
            HecTime hecTime = new HecTime();
            hecTime.set(myTsc.startTime, myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            myTsc.setStartTime(hecTime);
            hecTime.set(myTsc.endTime, myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            myTsc.setEndTime(hecTime);
            TimeSeriesMath tsMath = new TimeSeriesMath();
            tsMath.setContainer(myTsc);
            tsMath = tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "shiftInTime", e);
            throw new HecMathException("HecMath.shiftInTime", e);
        }
    }

    @Scriptable
    public HecMath shiftInTime(HecTime timeToShift) throws HecMathException {
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            HecTime newTime = new HecTime(timeToShift.timeIncrement());
            for (int i = 0; i < myTsc.times.length; ++i) {
                newTime.set(myTsc.times[i]);
                newTime.add(timeToShift);
                myTsc.times[i] = newTime.value();
            }
            TimeSeriesMath tsMath = new TimeSeriesMath();
            tsMath.setContainer(myTsc);
            tsMath = tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "shiftInTime", e);
            throw new HecMathException("HecMath.shiftInTime", e);
        }
    }

    @Override
    @Scriptable
    public HecMath shiftAdjustment(HecMath tsMath) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "shiftAdjustment");
        TimeSeriesContainer tsc = (TimeSeriesContainer)tsMath._dc;
        TimeSeriesMath.checkTimeSeries(tsc);
        TimeSeriesContainer newTsc = (TimeSeriesContainer)tsc.clone();
        TimeSeriesContainer currentTsc = this.getContainer();
        TimeSeriesMath.checkTimeSeries(currentTsc);
        try {
            int dataType = 1;
            intContainer lastIndex = new intContainer();
            lastIndex.value = 0;
            for (int i = 0; i < newTsc.times.length; ++i) {
                newTsc.values[i] = newTsc.times[i] < currentTsc.times[0] ? 0.0 : (newTsc.times[i] > currentTsc.times[currentTsc.times.length - 1] ? currentTsc.values[currentTsc.times.length - 1] : this.interpolate(currentTsc, newTsc.times[i], dataType, lastIndex));
            }
            newTsc.units = currentTsc.units;
            newTsc.type = currentTsc.type;
            TimeSeriesMath newTsMath = new TimeSeriesMath();
            newTsMath.setContainer(newTsc);
            newTsMath = newTsMath.expandVerticalDatum();
            return newTsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "shiftAdjustment", e);
            throw new HecMathException("HecMath.shiftAdjustment", e);
        }
    }

    @Override
    @Scriptable
    public HecMath periodConstants(HecMath math) throws HecMathException {
        this.checkTimeSeriesMath(math, "periodConstants");
        TimeSeriesContainer tsc = (TimeSeriesContainer)math._dc;
        TimeSeriesMath.checkTimeSeries(tsc);
        TimeSeriesContainer newTsc = (TimeSeriesContainer)tsc.clone();
        TimeSeriesContainer currentTsc = this.getContainer();
        TimeSeriesMath.checkTimeSeries(currentTsc);
        try {
            int idx = 0;
            for (int i = 0; i < newTsc.times.length; ++i) {
                if (newTsc.times[i] < currentTsc.times[0]) {
                    newTsc.values[i] = -3.4028234663852886E38;
                    continue;
                }
                while (idx < currentTsc.times.length - 1 && newTsc.times[i] >= currentTsc.times[idx + 1]) {
                    ++idx;
                }
                newTsc.values[i] = currentTsc.values[idx];
            }
            newTsc.type = "INST-VAL";
            newTsc.units = currentTsc.units;
            TimeSeriesMath tsMath = new TimeSeriesMath();
            tsMath.setContainer(newTsc);
            tsMath = tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "periodConstants", e);
            throw new HecMathException("HecMath.periodConstants", e);
        }
    }

    @Override
    @Scriptable
    public LinearRegressionStatistics correlationCoefficients(HecMath tsMath) throws HecMathException {
        this.checkTimeSeriesMath(tsMath, "correlationCoefficients");
        TimeSeriesContainer tsc = (TimeSeriesContainer)tsMath._dc;
        this.checkTimeSeriesMatch(tsc);
        TimeSeriesContainer myTsc = this.getContainer();
        int numberGood = 0;
        for (int i = 0; i < myTsc.values.length; ++i) {
            if (!TimeSeriesMath.isValid(myTsc, i) || !TimeSeriesMath.isValid(tsc, i)) continue;
            ++numberGood;
        }
        double nval = numberGood;
        if (nval < 1.0) {
            throw new HecMathException("HecMath.correlationCoefficients: No valid value pairs found for computation ");
        }
        double[] array1 = new double[numberGood];
        double[] array2 = new double[numberGood];
        int j = -1;
        for (int i = 0; i < myTsc.values.length; ++i) {
            if (!TimeSeriesMath.isValid(myTsc, i) || !TimeSeriesMath.isValid(tsc, i)) continue;
            array1[++j] = myTsc.values[i];
            array2[j] = tsc.values[i];
        }
        return this.getLinearRegressionStatistics(array1, array2);
    }

    @Override
    @Scriptable
    public HecMath[] cyclicAnalysis() throws HecMathException {
        return this.cyclicAnalysis("3000");
    }

    public HecMath[] cyclicAnalysis(String startYear) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        try {
            int i;
            int i2;
            if (myTsc.interval <= 0) {
                throw new HecMathException("HecMath.cyclicAnalysis: This function requires a regular interval time series.\nThe time series " + myTsc.fullName + " is not a regular interval time series.");
            }
            int intervalType = -1;
            if (myTsc.interval == 60) {
                intervalType = 1;
            } else if (myTsc.interval == 1440) {
                intervalType = 2;
            } else if (myTsc.interval == 43200) {
                intervalType = 3;
            } else if (myTsc.interval < 1440) {
                intervalType = 4;
            }
            if (intervalType == -1) {
                throw new HecMathException("HecMath.cyclicAnalysis: This function requires a regular interval time series.\nwith 1 hour, 1 day or 1 month time interval.\nThe time series " + myTsc.fullName + " does not match this condition.");
            }
            int numberOfBins = 0;
            int numDailyBins = 0;
            if (intervalType == 1) {
                numberOfBins = 8760;
                numDailyBins = 24;
            } else if (intervalType == 2) {
                numberOfBins = 365;
                numDailyBins = 1;
            } else if (intervalType == 3) {
                numberOfBins = 12;
                numDailyBins = 0;
            } else if (intervalType == 4) {
                numberOfBins = 525600 / myTsc.interval;
                numDailyBins = 1440 / myTsc.interval;
            }
            CyclicAnalysisStatistics[] bins = new CyclicAnalysisStatistics[numberOfBins];
            HecTime hecTime = new HecTime(11);
            int numberValues = myTsc.times.length;
            int nwork = numberValues / numberOfBins + 2;
            for (int i3 = 0; i3 < numberOfBins; ++i3) {
                bins[i3] = new CyclicAnalysisStatistics(intervalType, nwork, myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            }
            int year = -1;
            int bin_index = -1;
            int bin_day = -1;
            int bin_subday = -1;
            for (i2 = 0; i2 < myTsc.values.length; ++i2) {
                hecTime.set(myTsc.times[i2], myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
                if (intervalType == 1) {
                    bin_day = this.dayOfYearSkipLeap(hecTime);
                    if (bin_day < 0) continue;
                    bin_index = (bin_day - 1) * 24 + hecTime.hour() - 1;
                } else if (intervalType == 2) {
                    bin_index = hecTime.dayOfYear() - 1;
                    if (hecTime.month() == 2 && hecTime.day() == 29) continue;
                    year = hecTime.year();
                    if (hecTime.month() > 2 && year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
                        --bin_index;
                    }
                    if (bin_index >= 365) {
                        continue;
                    }
                } else if (intervalType == 3) {
                    bin_index = hecTime.month() - 1;
                }
                if (intervalType == 4) {
                    bin_day = this.dayOfYearSkipLeap(hecTime);
                    if (bin_day < 0) continue;
                    bin_index = (bin_day - 1) * numDailyBins;
                    bin_index += hecTime.minutesSinceMidnight() / myTsc.interval - 1;
                }
                if (TimeSeriesMath.isValid(myTsc, i2)) {
                    bins[bin_index].add(myTsc.times[i2], myTsc.values[i2]);
                    continue;
                }
                bins[bin_index].add(myTsc.times[i2], -3.4028234663852886E38);
            }
            for (i2 = 0; i2 < numberOfBins; ++i2) {
                bins[i2].computeStatistics();
                bins[i2].freeWorkingArrays();
            }
            HecTime start3000 = new HecTime(1);
            if (intervalType == 1) {
                start3000.set("01JAN" + startYear, " 0100");
            } else if (intervalType == 2) {
                start3000.set("01JAN" + startYear, " 2400");
            } else if (intervalType == 3) {
                start3000.set("31JAN" + startYear, " 2400");
            } else if (intervalType == 4) {
                start3000.set("01JAN" + startYear, " 0000");
                start3000.addMinutes(myTsc.interval);
            }
            hecTime = start3000;
            int[] newTimes = new int[numberOfBins];
            for (int i4 = 0; i4 < numberOfBins; ++i4) {
                newTimes[i4] = hecTime.value();
                hecTime.increment(1, myTsc.interval);
            }
            TimeSeriesContainer baseTsc = this.getContainer().collapseVerticalDatum();
            baseTsc.times = newTimes;
            baseTsc.values = new double[numberOfBins];
            baseTsc.quality = null;
            baseTsc.numberValues = numberOfBins;
            baseTsc.startTime = newTimes[0];
            baseTsc.endTime = newTimes[numberOfBins - 1];
            baseTsc.julianBaseDate = 0;
            baseTsc.timeGranularitySeconds = 60;
            int nmath = 14;
            TimeSeriesContainer[] tscArray = new TimeSeriesContainer[nmath];
            for (i = 0; i < nmath; ++i) {
                tscArray[i] = (TimeSeriesContainer)baseTsc.clone();
            }
            for (i = 0; i < numberOfBins; ++i) {
                tscArray[0].values[i] = bins[i].numberValidValues;
                tscArray[1].values[i] = bins[i].dateAtMax;
                tscArray[2].values[i] = bins[i].dateAtMin;
                tscArray[3].values[i] = bins[i].mean;
                tscArray[4].values[i] = bins[i].max;
                tscArray[5].values[i] = bins[i].min;
                tscArray[6].values[i] = bins[i].p05;
                tscArray[7].values[i] = bins[i].p10;
                tscArray[8].values[i] = bins[i].p25;
                tscArray[9].values[i] = bins[i].p50;
                tscArray[10].values[i] = bins[i].p75;
                tscArray[11].values[i] = bins[i].p90;
                tscArray[12].values[i] = bins[i].p95;
                tscArray[13].values[i] = bins[i].sdev;
            }
            String origParam = myTsc.parameter;
            tscArray[0].parameter = "COUNT-" + origParam;
            tscArray[1].parameter = "DATE-" + origParam + "-MAX";
            tscArray[2].parameter = "DATE-" + origParam + "-MIN";
            tscArray[3].parameter = origParam + "-AVER";
            tscArray[4].parameter = origParam + "-MAX";
            tscArray[5].parameter = origParam + "-MIN";
            tscArray[6].parameter = origParam + "-P05";
            tscArray[7].parameter = origParam + "-P10";
            tscArray[8].parameter = origParam + "-P25";
            tscArray[9].parameter = origParam + "-P50";
            tscArray[10].parameter = origParam + "-P75";
            tscArray[11].parameter = origParam + "-P90";
            tscArray[12].parameter = origParam + "-P95";
            tscArray[13].parameter = origParam + "-SD";
            tscArray[0].type = "PER-CUM";
            tscArray[1].type = "PER-CUM";
            tscArray[2].type = "PER-CUM";
            tscArray[0].units = "COUNT";
            if (intervalType == 1) {
                tscArray[1].units = "YEAR.MD";
                tscArray[2].units = "YEAR.MD";
                tscArray[1].precision = 4;
                tscArray[2].precision = 4;
            } else {
                tscArray[1].units = LEVEL_YEAR_STRING;
                tscArray[2].units = LEVEL_YEAR_STRING;
                tscArray[1].precision = 0;
                tscArray[2].precision = 0;
            }
            hecTime.set(myTsc.times[0], myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            String startDateString = hecTime.date(104);
            hecTime.set(myTsc.times[myTsc.times.length - 1], myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
            String endDateString = hecTime.date(104);
            String partF = myTsc.version + "[" + startDateString + "-" + endDateString + "]";
            HecMath[] tsMathArray = new TimeSeriesMath[nmath];
            for (int i5 = 0; i5 < nmath; ++i5) {
                tsMathArray[i5] = new TimeSeriesMath();
                ((TimeSeriesMath)tsMathArray[i5]).setContainer(tscArray[i5]);
                ((TimeSeriesMath)tsMathArray[i5]).setParameterPart(tscArray[i5].parameter);
                tsMathArray[i5].setVersion(partF);
                tsMathArray[i5] = ((TimeSeriesMath)tsMathArray[i5]).expandVerticalDatum();
            }
            return tsMathArray;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "cyclicAnalysis", e);
            throw new HecMathException("HecMath.cyclicAnalysis", e);
        }
    }

    private int dayOfYearSkipLeap(HecTime hecTime) {
        int year = hecTime.year();
        int dayOfYear = hecTime.dayOfYear();
        if (!HecTime.isLeap(year)) {
            return dayOfYear;
        }
        if (hecTime.month() == 2 && hecTime.day() == 29) {
            return -1;
        }
        if (hecTime.month() > 2) {
            --dayOfYear;
        }
        if (dayOfYear >= 365) {
            dayOfYear = 365;
        }
        return dayOfYear;
    }

    @Scriptable
    public PairedDataMath[] durationAnalysisStandard(String periodType, DurationPeriod[] durationPeriods, int iplottingPointsMethod, double[] userDefinedPoints, int horizontalScale, int verticalScale) throws HecMathException {
        return this.computeDurationAnalysis(true, periodType, durationPeriods, 0, 0, null, iplottingPointsMethod, userDefinedPoints, horizontalScale, verticalScale);
    }

    public PairedDataMath[] durationAnalysisBin(String periodType, DurationPeriod[] durationPeriods, int binDistribution, int numberBins, double[] binLimits, int iplottingPointsMethod, double[] userDefinedPoints, int horizontalScale, int verticalScale) throws HecMathException {
        return this.computeDurationAnalysis(false, periodType, durationPeriods, binDistribution, numberBins, binLimits, iplottingPointsMethod, userDefinedPoints, horizontalScale, verticalScale);
    }

    protected PairedDataMath[] computeDurationAnalysis(boolean standardMethod, String durationPeriodType, DurationPeriod[] durationPeriods, int binDistribution, int numberBins, double[] binLimits, int iplottingPointsMethod, double[] userDefinedPoints, int horizontalScale, int verticalScale) throws HecMathException {
        DurationAnalysis durationAnalysis = new DurationAnalysis();
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = this.getContainer();
        myTsc.removeAllMissing();
        durationAnalysis.setDurationPeriodType(durationPeriodType, myTsc.startTime, myTsc.endTime, myTsc.interval, myTsc.timeGranularitySeconds, myTsc.julianBaseDate);
        if (durationAnalysis.getDurationPeriodType() == -1) {
            String msg = "TimeSeriesMath.durationAnalysis() \nInvalid value for parameter durationPeriodType.\nMust be one of 'ANNUAL', 'QUARTERLY', 'MONTHLY' or 'OTHER'.\ndurationPeriodType = " + durationPeriodType;
            throw new HecMathException(msg);
        }
        if (durationAnalysis.getDurationPeriodType() != 3) {
            durationPeriods = durationAnalysis.getDurationPeriods();
        } else {
            if (durationPeriods == null) {
                String msg = "TimeSeriesMath.durationAnalysis() \ndurationPeriodType is 'OTHER', but no duration periods defined.";
                throw new HecMathException(msg);
            }
            durationAnalysis.setOtherDefinedDurationPeriods(durationPeriods);
        }
        if (myTsc.interval > 525600 && durationAnalysis.getDurationPeriodType() != 0) {
            String msg = "TimeSeriesMath.durationAnalysis() \nYearly interval data must use a duration period of 'ANNUAL'.\ndurationPeriodType = " + durationPeriodType;
            throw new HecMathException(msg);
        }
        String vdi = null;
        if (myTsc instanceof VerticalDatum) {
            try {
                vdi = TextUtil.compress(((TimeSeriesContainerVertDatum)myTsc).getVerticalDatumContainer().toString(), "base64");
            }
            catch (IOException e) {
                Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "computeDurationAnalysis", e);
            }
        } else {
            HashMap<String, String> si = myTsc.getSupplementalInfo();
            vdi = si.get("verticalDatumInfo");
        }
        PairedDataMath[] pdMath = null;
        try {
            durationAnalysis.filterTimeSeries(myTsc);
            PairedDataContainer[] durationResults = durationAnalysis.computeDurationAnalysis(standardMethod, binDistribution, numberBins, binLimits, iplottingPointsMethod, userDefinedPoints, horizontalScale, verticalScale);
            pdMath = new PairedDataMath[durationResults.length];
            for (int i = 0; i < pdMath.length; ++i) {
                if (vdi != null) {
                    durationResults[i].supplementalInfo = "verticalDatumInfo:" + vdi + ";";
                }
                pdMath[i] = new PairedDataMath();
                pdMath[i].setData(durationResults[i]);
                pdMath[i] = pdMath[i].expandVerticalDatum();
                pdMath[i].setWatershed(myTsc.watershed);
                pdMath[i].setLocation(myTsc.location);
                pdMath[i].setVersion(myTsc.version);
                String paramPart = durationResults[i].xparameter + "-" + durationResults[i].yparameter;
                pdMath[i].setParameterPart(paramPart);
                pdMath[i].setDPart(durationResults[i].date);
                pdMath[i].setEPart(durationResults[i].other);
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "durationAnalysis", e);
            throw new HecMathException("HecMath.durationAnalysis", e);
        }
        return pdMath;
    }

    @Override
    @Scriptable
    public PairedDataMath multipleRegression(HecMath[] tsMathArray, double minimumLimit, double maximumLimit) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer tscY = this.getContainer();
        if (tscY.interval <= 0) {
            throw new HecMathException("HecMath.multipleRegression: Error - The time series " + tscY.fullName + " is not a regular interval time series.");
        }
        try {
            int j;
            int i;
            int idx0;
            for (int i2 = 0; i2 < tsMathArray.length; ++i2) {
                TimeSeriesMath tsMath = (TimeSeriesMath)tsMathArray[i2];
                this.checkTimeSeriesMath(tsMath, "multipleRegression");
                TimeSeriesContainer tscX = tsMath.getContainer();
                TimeSeriesMath.checkTimeSeries(tscX);
                if (tscX.interval == 0) {
                    throw new HecMathException("HecMath.multipleRegression: The time series " + tscX.fullName + " is not a regular interval time series.");
                }
                if (tscX.interval == tscY.interval) continue;
                throw new HecMathException("HecMath.multipleRegression: The time interval for " + tscX.fullName + " needs to be " + tscY.interval + " minutes.  It is instead " + tscX.interval + " minutes.");
            }
            int numberOfTs = tsMathArray.length + 1;
            TimeSeriesContainer[] tscArray = new TimeSeriesContainer[numberOfTs];
            tscArray[0] = tscY;
            for (int i3 = 0; i3 < tsMathArray.length; ++i3) {
                tscArray[i3 + 1] = ((TimeSeriesMath)tsMathArray[i3]).getContainer();
            }
            int timeStartMax = 0;
            int timeEndMin = Integer.MAX_VALUE;
            for (int i4 = 0; i4 < numberOfTs; ++i4) {
                int last;
                if (tscArray[i4].times[0] > timeStartMax) {
                    timeStartMax = tscArray[i4].times[0];
                }
                if (tscArray[i4].times[last = tscArray[i4].times.length - 1] >= timeEndMin) continue;
                timeEndMin = tscArray[i4].times[last];
            }
            int numberPoints = (timeEndMin - timeStartMax) / tscY.interval + 1;
            if (numberPoints < 1) {
                throw new HecMathException("HecMath.multipleRegression: There are problems with non-concurrent Time Windows for the time series");
            }
            int[] startIndex = new int[numberOfTs];
            for (int i5 = 0; i5 < numberOfTs; ++i5) {
                startIndex[i5] = TimeSeriesMath.findInterval(tscArray[i5].times, timeStartMax, 0);
                if (startIndex[i5] != Integer.MIN_VALUE) continue;
                throw new HecMathException("HecMath.multipleRegression: There are problems with non-concurrent Time Windows for the time series");
            }
            if (minimumLimit == Double.NEGATIVE_INFINITY) {
                minimumLimit = -3.4028234663852886E38;
            }
            if (maximumLimit == Double.NEGATIVE_INFINITY) {
                maximumLimit = -3.4028234663852886E38;
            }
            boolean[] isBad = new boolean[numberPoints];
            for (int k = 0; k < numberPoints; ++k) {
                int idx;
                isBad[k] = false;
                for (int i6 = 0; i6 < numberOfTs; ++i6) {
                    idx = startIndex[i6] + k;
                    if (TimeSeriesMath.isValid(tscArray[i6], idx)) continue;
                    isBad[k] = true;
                    break;
                }
                idx = startIndex[0] + k;
                if (minimumLimit != -3.4028234663852886E38 && tscY.values[idx] < minimumLimit) {
                    isBad[k] = true;
                }
                if (maximumLimit == -3.4028234663852886E38 || !(tscY.values[idx] > maximumLimit)) continue;
                isBad[k] = true;
            }
            double[][] xx = new double[numberOfTs][numberOfTs];
            double[] xy = new double[numberOfTs];
            for (int i7 = 0; i7 < numberOfTs; ++i7) {
                double xi;
                int idxI;
                xy[i7] = 0.0;
                for (int j2 = 0; j2 < numberOfTs; ++j2) {
                    xx[i7][j2] = 0.0;
                    for (int k = 0; k < numberPoints; ++k) {
                        if (isBad[k]) continue;
                        idxI = startIndex[i7] + k;
                        int idxJ = startIndex[j2] + k;
                        xi = i7 == 0 ? 1.0 : tscArray[i7].values[idxI];
                        double xj = j2 == 0 ? 1.0 : tscArray[j2].values[idxJ];
                        double[] dArray = xx[i7];
                        int n = j2;
                        dArray[n] = dArray[n] + xi * xj;
                    }
                }
                for (int k = 0; k < numberPoints; ++k) {
                    if (isBad[k]) continue;
                    idxI = startIndex[i7] + k;
                    xi = i7 == 0 ? 1.0 : tscArray[i7].values[idxI];
                    idx0 = startIndex[0] + k;
                    int n = i7;
                    xy[n] = xy[n] + xi * tscY.values[idx0];
                }
            }
            double[] a = new double[numberOfTs * numberOfTs];
            int icnt = 0;
            for (i = 0; i < numberOfTs; ++i) {
                for (j = 0; j < numberOfTs; ++j) {
                    a[icnt] = xx[i][j];
                    ++icnt;
                }
            }
            RmaMath.invertMatrix(a);
            icnt = 0;
            for (i = 0; i < numberOfTs; ++i) {
                for (j = 0; j < numberOfTs; ++j) {
                    xx[i][j] = a[icnt];
                    ++icnt;
                }
            }
            double[] beta = new double[numberOfTs];
            for (int i8 = 0; i8 < numberOfTs; ++i8) {
                beta[i8] = 0.0;
                for (int j3 = 0; j3 < numberOfTs; ++j3) {
                    int n = i8;
                    beta[n] = beta[n] + xx[i8][j3] * xy[j3];
                }
            }
            double sumY = 0.0;
            double sumYY = 0.0;
            for (int k = 0; k < numberPoints; ++k) {
                if (isBad[k]) continue;
                idx0 = startIndex[0] + k;
                sumY += tscY.values[idx0];
                sumYY += tscY.values[idx0] * tscY.values[idx0];
            }
            double sumBY = 0.0;
            for (int i9 = 0; i9 < numberOfTs; ++i9) {
                sumBY += beta[i9] * xy[i9];
            }
            double numberGood = 0.0;
            for (int k = 0; k < numberPoints; ++k) {
                if (isBad[k]) continue;
                numberGood += 1.0;
            }
            if (numberGood < 1.0) {
                throw new HecMathException("HecMath.multipleRegression: No common good points found ");
            }
            double errorSumOfSquares = sumBY - sumY * sumY / numberGood;
            double regressionSumOfSquares = sumYY - sumBY;
            double totalSumOfSquares = sumYY - sumY * sumY / numberGood;
            double coefOfMultipleDetermination = errorSumOfSquares / totalSumOfSquares;
            PairedDataMath pdMath = new PairedDataMath();
            PairedDataContainer pdc = new PairedDataContainer();
            String vdi = null;
            if (tscY instanceof VerticalDatum) {
                try {
                    vdi = TextUtil.compress(((TimeSeriesContainerVertDatum)tscY).getVerticalDatumContainer().getVerticalDatumInfo(), "base64");
                }
                catch (IOException e) {
                    Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.SEVERE, "multipleRegression", e);
                }
            } else {
                HashMap<String, String> si = tscY.getSupplementalInfo();
                vdi = si.get("verticalDatumInfo");
            }
            if (vdi != null) {
                pdc.supplementalInfo = "verticalDatumInfo:" + vdi + ";";
            }
            double[] xpoints = new double[numberOfTs];
            for (int i10 = 0; i10 < numberOfTs; ++i10) {
                xpoints[i10] = i10 + 1;
            }
            pdc.xOrdinates = xpoints;
            pdc.numberCurves = 1;
            pdc.yOrdinates = new double[1][];
            pdc.yOrdinates[0] = beta;
            pdc.numberOrdinates = beta.length;
            pdMath.setData(pdc);
            pdMath.setWatershed(tscY.watershed);
            pdMath.setLocation(tscY.location);
            pdMath.setTimeInterval("");
            pdMath.setVersion("REGRESSION COEFFICIENTS");
            return pdMath.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "multipleRegression", e);
            throw new HecMathException("HecMath.multipleRegression", e);
        }
    }

    @Override
    @Scriptable
    public HecMath extractTimeSeriesDataForTimeSpecification(String timeLevelString, String rangeString, boolean isInclusive, int intervalWindow, boolean setAsIrregular) throws HecMathException {
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer myTsc = (TimeSeriesContainer)this.getContainer().clone();
        if (myTsc.interval <= 0) {
            setAsIrregular = true;
        }
        try {
            String ePart;
            String endString;
            String startString;
            int LEVEL_UNDEFINED = -1;
            boolean LEVEL_YEAR = true;
            int LEVEL_MONTH = 2;
            int LEVEL_DAYMONTH = 3;
            int LEVEL_DAYWEEK = 4;
            int LEVEL_TIME = 5;
            int timeLevel = -1;
            timeLevelString = timeLevelString.trim().toUpperCase();
            if (timeLevelString.indexOf(LEVEL_YEAR_STRING) >= 0) {
                timeLevel = 1;
            } else if (timeLevelString.indexOf(LEVEL_DAYMONTH_STRING) >= 0) {
                timeLevel = 3;
            } else if (timeLevelString.indexOf(LEVEL_MONTH_STRING) >= 0) {
                timeLevel = 2;
            } else if (timeLevelString.indexOf(LEVEL_DAYWEEK_STRING) >= 0) {
                timeLevel = 4;
            } else if (timeLevelString.indexOf(LEVEL_TIME_STRING) >= 0) {
                timeLevel = 5;
            }
            if (timeLevel == -1) {
                String s = "HecMath.extractTimeSeriesDataForTimeSpecification : \nCould not parse the time level string = " + timeLevelString;
                throw new HecMathException(s);
            }
            if (rangeString == null || rangeString.length() < 1) {
                String s = "HecMath.extractTimeSeriesDataForTimeSpecification : \nThe range string is blank.";
                throw new HecMathException(s);
            }
            rangeString.trim().toUpperCase();
            boolean isRange = false;
            if (rangeString.indexOf("-") > 0) {
                isRange = true;
                startString = rangeString.substring(0, rangeString.indexOf("-"));
                endString = rangeString.substring(rangeString.indexOf("-") + 1);
            } else {
                startString = rangeString;
                endString = rangeString;
            }
            boolean startIsLastDay = false;
            boolean endIsLastDay = false;
            int start = Integer.MIN_VALUE;
            int end = Integer.MIN_VALUE;
            boolean problem = false;
            try {
                if (timeLevel == 1) {
                    start = Integer.parseInt(startString);
                    end = Integer.parseInt(endString);
                    if (start < 1900 || end < 1900) {
                        problem = true;
                    }
                } else if (timeLevel == 2) {
                    start = TimeSeriesMath.parseMonth(startString);
                    end = TimeSeriesMath.parseMonth(endString);
                    if (start < 1 || start > 12 || end < 1 || end > 12) {
                        problem = true;
                    }
                } else if (timeLevel == 3) {
                    if (startString.indexOf("LASTDAY") >= 0) {
                        startIsLastDay = true;
                    } else {
                        start = Integer.parseInt(startString);
                        if (start < 1 || start > 31) {
                            problem = true;
                        }
                    }
                    if (endString.indexOf("LASTDAY") >= 0) {
                        endIsLastDay = true;
                    } else {
                        end = Integer.parseInt(endString);
                        if (end < 1 || end > 31) {
                            problem = true;
                        }
                    }
                } else if (timeLevel == 4) {
                    start = TimeSeriesMath.parseDayOfWeek(startString);
                    end = TimeSeriesMath.parseDayOfWeek(endString);
                    if (start < 1 || start > 7 || end < 1 || end > 7) {
                        problem = true;
                    }
                } else if (timeLevel == 5) {
                    start = Integer.parseInt(startString);
                    end = Integer.parseInt(endString);
                    start = start / 100 * 60 + start % 100;
                    end = end / 100 * 60 + end % 100;
                    if (start < 1 || start > 1440 || end < 1 || end > 1440) {
                        problem = true;
                    }
                }
                if (start > end && timeLevel != 3) {
                    if (timeLevel == 2 || timeLevel == 4 || timeLevel == 5) {
                        int tmp = end;
                        end = start - 1;
                        start = tmp + 1;
                        isInclusive = !isInclusive;
                    } else if (timeLevel == 1) {
                        problem = true;
                    }
                }
            }
            catch (NumberFormatException fe) {
                String s = "HecMath.extractTimeSeriesDataForTimeSpecification : \nCould not parse the range string = " + rangeString;
                throw new HecMathException(s);
            }
            if (problem) {
                String s = "HecMath.extractTimeSeriesDataForTimeSpecification : \nCould not parse the range string = " + rangeString;
                throw new HecMathException(s);
            }
            int[] newTimes = new int[myTsc.times.length];
            double[] newValues = new double[myTsc.times.length];
            int[] newQuality = new int[myTsc.times.length];
            HecTime hecTime = new HecTime(1);
            intContainer year = new intContainer();
            intContainer month = new intContainer();
            intContainer day = new intContainer();
            int timeValue = 0;
            int icnt = 0;
            boolean isInclusiveSaved = isInclusive;
            for (int i = 0; i < myTsc.times.length; ++i) {
                hecTime.set(myTsc.times[i]);
                boolean valid = false;
                if (timeLevel == 1) {
                    timeValue = hecTime.year();
                } else if (timeLevel == 2) {
                    timeValue = hecTime.month();
                } else if (timeLevel == 3) {
                    timeValue = hecTime.day();
                } else if (timeLevel == 4) {
                    timeValue = hecTime.dayOfWeek();
                } else if (timeLevel == 5) {
                    timeValue = hecTime.minutesSinceMidnight();
                }
                if (startIsLastDay || endIsLastDay) {
                    int lastDay = TimeSeriesMath.getLastDayOfMonth(hecTime);
                    if (startIsLastDay) {
                        start = lastDay;
                    }
                    if (endIsLastDay) {
                        end = lastDay;
                    }
                }
                if (timeLevel == 3 && start > end) {
                    int tmp = end;
                    end = start - 1;
                    start = tmp + 1;
                    isInclusive = !isInclusiveSaved;
                }
                boolean bl = valid = timeValue >= start && timeValue <= end;
                if (!isInclusive) {
                    boolean bl2 = valid = !valid;
                }
                if (valid) {
                    newTimes[icnt] = myTsc.times[i];
                    newValues[icnt] = myTsc.values[i];
                    if (myTsc.quality != null) {
                        newQuality[icnt] = myTsc.quality[i];
                    }
                    ++icnt;
                    continue;
                }
                if (setAsIrregular) continue;
                newTimes[icnt] = myTsc.times[i];
                newValues[icnt] = -3.4028234663852886E38;
                if (myTsc.quality != null) {
                    newQuality[icnt] = myTsc.quality[i];
                }
                ++icnt;
            }
            myTsc.times = new int[icnt];
            myTsc.values = new double[icnt];
            System.arraycopy(newTimes, 0, myTsc.times, 0, icnt);
            System.arraycopy(newValues, 0, myTsc.values, 0, icnt);
            if (myTsc.quality != null) {
                myTsc.quality = new int[icnt];
                System.arraycopy(newQuality, 0, myTsc.quality, 0, icnt);
            }
            myTsc.numberValues = icnt;
            TimeSeriesMath tsMath = new TimeSeriesMath();
            tsMath.setContainer(myTsc);
            if (!setAsIrregular && HecTimeSeriesBase.isRegular(myTsc.times)) {
                ePart = HecTimeSeriesBase.getAppropriateRegularEPart(myTsc.times);
                myTsc.interval = HecTimeSeriesBase.getIntervalFromEPart(ePart);
            } else {
                ePart = HecTimeSeriesBase.getAppropriateIrregularBlock(myTsc.times);
                myTsc.interval = 0;
            }
            tsMath.setTimeInterval(ePart);
            if (myTsc.times.length > 0) {
                myTsc.startTime = myTsc.times[0];
                myTsc.endTime = myTsc.times[myTsc.numberValues - 1];
            }
            tsMath = tsMath.expandVerticalDatum();
            return tsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "extractTimeSeriesForTimeSpecification", e);
            throw new HecMathException("HecMath.extractTimeSeriesForTimeSpecification", e);
        }
    }

    @Scriptable
    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, String timeIntervalString, double initialValue) throws HecMathException {
        String timeOffsetString = "";
        try {
            int timeIntervalMinutes = TimeSeriesMath.parseTimeInterval(timeIntervalString);
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: timeIntervalString parameter could not be successfully parsed \ntimeIntervalString = " + timeIntervalString);
            }
            if (!TimeSeriesMath.isValidDssInterval(timeIntervalMinutes)) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: Not a valid time interval \ntimeIntervalStrings = " + timeIntervalString);
            }
            HecTime start = new HecTime(startTimeString);
            int timeOffsetMinutes = start.getIntervalOffset(timeIntervalMinutes);
            if (timeOffsetMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: Invalid Start time \nStart time = " + timeOffsetString);
            }
            return TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeIntervalMinutes, timeOffsetMinutes, initialValue);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateRegularIntervalTimeSeries", e);
            throw new HecMathException("HecMath.generateRegularIntervalTimeSeries", e);
        }
    }

    @Scriptable
    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, String timeIntervalString, String timeOffsetString, double initialValue) throws HecMathException {
        try {
            int timeOffsetMinutes;
            int timeIntervalMinutes = TimeSeriesMath.parseTimeInterval(timeIntervalString);
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: timeIntervalString parameter could not be successfully parsed \ntimeIntervalString = " + timeIntervalString);
            }
            if (!TimeSeriesMath.isValidDssInterval(timeIntervalMinutes)) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: Not a valid time interval \ntimeIntervalStrings = " + timeIntervalString);
            }
            if (timeOffsetString == null || timeOffsetString.length() == 0) {
                timeOffsetMinutes = 0;
            } else {
                timeOffsetMinutes = TimeSeriesMath.parseTimeInterval(timeOffsetString);
                if (timeOffsetMinutes < 0 || timeOffsetMinutes == Integer.MIN_VALUE) {
                    throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: timeOffsetString parameter could not be successfully parsed \timeOffsetString = " + timeOffsetString);
                }
            }
            return TimeSeriesMath.generateRegularIntervalTimeSeries(startTimeString, endTimeString, timeIntervalMinutes, timeOffsetMinutes, initialValue);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateRegularIntervalTimeSeries", e);
            throw new HecMathException("HecMath.generateRegularIntervalTimeSeries", e);
        }
    }

    @Scriptable
    public static HecMath generateRegularIntervalTimeSeries(String startTimeString, String endTimeString, int timeIntervalMinutes, int timeOffsetMinutes, double initialValue) throws HecMathException {
        try {
            HecTime startTime = new HecTime(startTimeString);
            HecTime endTime = new HecTime(endTimeString);
            if (startTime == null || endTime == null || startTime.value() >= endTime.value()) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: Could not form a proper time window \nStart Time: " + startTimeString + "\nEnd Time: " + endTimeString);
            }
            if (timeIntervalMinutes <= 0 || timeIntervalMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: timeIntervalMinutes parameter not valid \timeIntervalMinutes = " + timeIntervalMinutes);
            }
            if (timeOffsetMinutes == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: timeOffsetMinutes parameter not valid \timeOffsetMinutes = " + timeOffsetMinutes);
            }
            TimeSeriesContainer newTsc = (TimeSeriesContainer)TimeSeriesMath.generateRegularIntervalTimeSeries(null, startTime.value(), endTime.value(), timeIntervalMinutes, timeOffsetMinutes);
            Arrays.fill(newTsc.values, initialValue);
            TimeSeriesMath tsMath = new TimeSeriesMath();
            newTsc.version = "GENERATED TIME SERIES";
            tsMath._dc = newTsc;
            return tsMath;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateRegularIntervalTimeSeries", e);
            throw new HecMathException("HecMath.generateRegularIntervalTimeSeries", e);
        }
    }

    private DataContainer generateRegularIntervalTimeSeries(int timeInterval, int timeOffset) throws HecMathException {
        int endTime;
        TimeSeriesMath.checkTimeSeries(this.getContainer());
        TimeSeriesContainer tsc = this.getContainer();
        int startTime = tsc.startTime;
        if (startTime == 0) {
            startTime = tsc.times[0];
        }
        if ((endTime = tsc.endTime) == 0) {
            endTime = tsc.times[tsc.times.length - 1];
        }
        return TimeSeriesMath.generateRegularIntervalTimeSeries(tsc, startTime, endTime, timeInterval, timeOffset);
    }

    private static DataContainer generateRegularIntervalTimeSeries(TimeSeriesContainer templateTsc, int startTime, int endTime, int timeInterval, int timeOffset) throws HecMathException {
        try {
            int i;
            if (timeInterval < 1 || timeInterval == Integer.MIN_VALUE) {
                throw new HecMathException("HecMath.generateRegularIntervalTimeSeries: Invalid value for time interval \ntimeInterval = " + timeInterval);
            }
            TimeSeriesContainer newTsc = new TimeSeriesContainer();
            if (templateTsc != null) {
                TimeSeriesMath.copyHeaderInfo(templateTsc, newTsc);
                newTsc.supplementalInfo = templateTsc.collapseVerticalDatum().supplementalInfo;
            }
            HecTime oldStartTime = new HecTime(startTime, 1);
            HecTime oldEndTime = new HecTime(endTime, 1);
            HecTime newStartTime = TimeSeriesMath.roundTime(oldStartTime, timeInterval, timeOffset);
            HecTime newEndTime = TimeSeriesMath.roundTime(oldEndTime, timeInterval, timeOffset);
            HecTime htime = new HecTime(newStartTime);
            int numberValues = newStartTime.computeNumberIntervals(newEndTime, timeInterval) + 1;
            newTsc.times = new int[numberValues];
            int endTimeValue = oldEndTime.value();
            int icount = 0;
            for (i = 0; i < numberValues; ++i) {
                newTsc.times[i] = htime.value();
                htime.increment(1, timeInterval);
                ++icount;
            }
            if (icount < numberValues && icount > 0) {
                numberValues = icount;
                int[] tmpTimes = newTsc.times;
                newTsc.times = new int[numberValues];
                System.arraycopy(tmpTimes, 0, newTsc.times, 0, numberValues);
            }
            newTsc.values = new double[numberValues];
            newTsc.quality = null;
            for (i = 0; i < numberValues; ++i) {
                newTsc.values[i] = -3.4028234663852886E38;
            }
            newStartTime = new HecTime(newTsc.times[0], 1);
            newEndTime = new HecTime(newTsc.times[numberValues - 1], 1);
            newTsc.setStartTime(newStartTime);
            newTsc.setEndTime(newEndTime);
            newTsc.numberValues = numberValues;
            newTsc.interval = timeInterval;
            int[] status = new int[1];
            String ePart = Heclib.getEPartFromInterval(timeInterval, status);
            if (status[0] == 0) {
                DSSPathname dssPath = new DSSPathname();
                dssPath.setPathname(newTsc.fullName);
                dssPath.setEPart(ePart);
                newTsc.fullName = dssPath.getPathname();
            }
            return newTsc.expandVerticalDatum();
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "generateRegularIntervalTimeSeries", e);
            throw new HecMathException("HecMath.generateRegularIntervalTimeSeries", e);
        }
    }

    @Scriptable
    public boolean checkTimeSeriesMatch(TimeSeriesContainer tsc) throws HecMathException {
        TimeSeriesContainer myTsc = this.getContainer();
        TimeSeriesMath.checkTimeSeries(myTsc);
        TimeSeriesMath.checkTimeSeries(tsc);
        try {
            if (myTsc.times.length != tsc.times.length) {
                throw new HecMathException("The Time Series passed in the function parameter does not \nmatch the current Time Series in length");
            }
            for (int i = 0; i < myTsc.times.length; ++i) {
                if (myTsc.times[i] == tsc.times[i]) continue;
                throw new HecMathException("Time values for the Time Series passed in the function parameter do not \nmatch the current Time Series");
            }
        }
        catch (RuntimeException e) {
            throw new HecMathException(e);
        }
        return true;
    }

    @Scriptable
    public boolean checkTimeSeriesMath(HecMath math, String methodName) throws HecMathException {
        if (math == null) {
            String s = "HecMath." + methodName + " : The HecMath object in the parameter is null ";
            throw new HecMathException(s);
        }
        if (!(math instanceof TimeSeriesMath)) {
            String s = "HecMath." + methodName + " : Expecting a TimeSeriesMath object for the parameter.\nThe parameter is instead " + math.getClass().getName();
            throw new HecMathException(s);
        }
        return true;
    }

    @Scriptable
    public static boolean checkTimeSeries(TimeSeriesContainer tsc) throws HecMathException {
        TimeSeriesMath.checkContainer(tsc);
        try {
            Object tsName = "";
            if (tsc.fileName != null && tsc.fileName.length() > 0) {
                tsName = "\nFile name: " + tsc.fileName;
            }
            if (tsc.fullName != null && tsc.fullName.length() > 0) {
                tsName = (String)tsName + "\nPathname: " + tsc.fullName;
            }
            if (tsc.values == null) {
                throw new HecMathException("Time Series value array is missing or empty." + (String)tsName);
            }
            if (tsc.times == null) {
                throw new HecMathException("Time Series time array is missing or empty." + (String)tsName);
            }
            if (tsc.values.length < 0) {
                throw new HecMathException("Time Series value array has 0 elements." + (String)tsName);
            }
            if (tsc.times.length < 0) {
                throw new HecMathException("Time Series time array has 0 elements." + (String)tsName);
            }
            if (tsc.allMissing()) {
                throw new HecMathException("Time Series has no valid values." + (String)tsName);
            }
            for (int i = 1; i < tsc.times.length; ++i) {
                if (tsc.times[i - 1] <= tsc.times[i]) continue;
                throw new HecMathException("Time Series times are not monotonically increasing at location: " + i + (String)tsName);
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger(TimeSeriesMath.class.getName()).log(Level.FINE, "checkTimeSeries", e);
            throw new HecMathException("HecMath.checkTimeSeries", e);
        }
        return true;
    }

    protected static boolean isValid(DataContainer container, int index) {
        if (!(container instanceof TimeSeriesContainer)) {
            return false;
        }
        TimeSeriesContainer tsc = (TimeSeriesContainer)container;
        boolean useQualityFlags = false;
        if (index < 0 || index >= tsc.times.length) {
            return false;
        }
        if (tsc.quality != null) {
            // empty if block
        }
        if (!useQualityFlags) {
            return tsc.values[index] != -3.4028234663852886E38;
        }
        int qflag = tsc.quality[index];
        byte[] qbytes = QualityTx.getBytes(qflag);
        return HecMath.isValid(qbytes);
    }

    @Override
    @Scriptable
    public boolean isValid(int index) {
        return TimeSeriesMath.isValid(this.getContainer(), index);
    }

    @Override
    @Scriptable
    public HecMath copy() throws HecMathException {
        TimeSeriesContainer tsc = (TimeSeriesContainer)this.getData();
        TimeSeriesMath tsMath = new TimeSeriesMath();
        tsMath.setData(tsc);
        return tsMath;
    }

    private void setAllQualityToMissing(TimeSeriesContainer tsc) {
        if (tsc == null || tsc.quality == null) {
            return;
        }
        byte[] qualityBytes = new byte[4];
        qualityBytes = QualityTx.clearQuality(qualityBytes);
        qualityBytes = QualityTx.setMissing(qualityBytes);
        int missing = QualityTx.getInteger(qualityBytes);
        for (int i = 0; i < tsc.quality.length; ++i) {
            tsc.quality[i] = missing;
        }
    }

    protected static void copyHeaderInfo(TimeSeriesContainer fromTsc, TimeSeriesContainer toTsc) {
        toTsc.fullName = fromTsc.fullName;
        toTsc.watershed = fromTsc.watershed;
        toTsc.location = fromTsc.location;
        toTsc.version = fromTsc.version;
        toTsc.subVersion = fromTsc.subVersion;
        toTsc.fileName = fromTsc.fileName;
        toTsc.units = fromTsc.units;
        toTsc.type = fromTsc.type;
        toTsc.precision = fromTsc.precision;
        toTsc.subLocation = fromTsc.subLocation;
        toTsc.parameter = fromTsc.parameter;
        toTsc.subParameter = fromTsc.subParameter;
        toTsc.timeZoneID = fromTsc.timeZoneID != null ? new String(fromTsc.timeZoneID) : null;
        toTsc.timeZoneRawOffset = fromTsc.timeZoneRawOffset;
    }

    private double interpolate(TimeSeriesContainer tsc, int time, int dataType, intContainer lastIndex) {
        String dataTypeStr;
        try {
            dataTypeStr = (new String[]{"UNDEFINED", "INST", "INST-VAL", "INST-CUM", "PER-AVER", "PER-CUM"})[dataType];
        }
        catch (IndexOutOfBoundsException iobe) {
            dataTypeStr = "UNDEFINED";
        }
        return TimeSeriesFunctions.interpolate(tsc, time, dataTypeStr, lastIndex);
    }

    protected int findValidValue(TimeSeriesContainer tsc, int index, boolean lookAfter) {
        return TimeSeriesFunctions.findValidValue(tsc, index, lookAfter);
    }

    private double integrate(TimeSeriesContainer tsc, int time0, int time1, int dataType, int functionType, double missingAllowed, intContainer lastIndex, doubleContainer sumTime) {
        double deltaTime;
        int jlast;
        int ilast;
        if (time0 >= time1) {
            return -3.4028234663852886E38;
        }
        if (tsc.interval <= 0 && time0 < tsc.times[0]) {
            return -3.4028234663852886E38;
        }
        if (time1 < tsc.startTime || time0 > tsc.times[tsc.times.length - 1]) {
            return -3.4028234663852886E38;
        }
        int ifirst = Integer.MIN_VALUE;
        ifirst = time0 >= tsc.times[0] ? TimeSeriesMath.findInterval(tsc.times, time0, lastIndex.value) : -1;
        if (ifirst == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        if (time1 == tsc.times[tsc.times.length - 1]) {
            ilast = tsc.times.length - 2;
        } else {
            ilast = TimeSeriesMath.findInterval(tsc.times, time1, ifirst);
            if (ilast == Integer.MIN_VALUE) {
                HecTime nextTime = new HecTime();
                nextTime.set(time0);
                nextTime.increment(1, tsc.interval);
                if (ifirst == -1 && (dataType == 4 || dataType == 5) && nextTime.value() >= tsc.times[0]) {
                    ilast = -1;
                } else {
                    return -3.4028234663852886E38;
                }
            }
            if (ilast > -1 && ilast < tsc.times.length && tsc.times[ilast] == time1) {
                --ilast;
            }
        }
        double numberExpectedPoints = ilast - ifirst + 2;
        if (tsc.interval > 0) {
            numberExpectedPoints = HecTime.computeNumberIntervals(time0, time1, tsc.interval);
            if (dataType == 1 || dataType == 3) {
                numberExpectedPoints += 1.0;
            }
        }
        int numberBadAllowed = (int)(missingAllowed * numberExpectedPoints);
        int numberBad = 0;
        if (tsc.interval > 0) {
            HecTime htime = new HecTime(tsc.times[0], 1);
            htime.increment(-1, tsc.interval);
            int tscTime0 = htime.value();
            if (time0 < tscTime0) {
                numberBad = HecTime.computeNumberIntervals(time0, tscTime0, tsc.interval);
                if (dataType == 1 || dataType == 3) {
                    ++numberBad;
                }
            } else if (time1 > tsc.times[tsc.times.length - 1]) {
                numberBad = HecTime.computeNumberIntervals(tsc.times[tsc.times.length - 1], time1, tsc.interval) + 1;
            }
        }
        if (!(dataType != 1 && dataType != 3 || ifirst < 0 || TimeSeriesMath.isValid(tsc, ifirst))) {
            ++numberBad;
        }
        if ((jlast = ilast + 1) > tsc.values.length - 1) {
            jlast = tsc.values.length - 1;
        }
        for (int i = ifirst + 1; i <= jlast; ++i) {
            if (TimeSeriesMath.isValid(tsc, i)) continue;
            ++numberBad;
        }
        if (numberBad > numberBadAllowed) {
            return -3.4028234663852886E38;
        }
        double val0 = 0.0;
        double val1 = 0.0;
        double sumArea = 0.0;
        double accumulate = 0.0;
        sumTime.value = 0.0;
        int istepsForAveraging = 0;
        for (int i = ifirst + 1; i < ilast; ++i) {
            deltaTime = tsc.times[i + 1] - tsc.times[i];
            val1 = tsc.values[i + 1];
            if (dataType == 1 || dataType == 3) {
                val0 = tsc.values[i];
            } else if (dataType == 4) {
                val0 = tsc.values[i + 1];
            } else if (dataType == 5) {
                val0 = tsc.values[i + 1];
            }
            if (val0 == -3.4028234663852886E38 || val1 == -3.4028234663852886E38) continue;
            sumArea += deltaTime * 0.5 * (val0 + val1);
            sumTime.value += deltaTime;
            accumulate += val1;
            ++istepsForAveraging;
        }
        double avgDeltaTime = tsc.interval < 1 ? (istepsForAveraging > 0 ? sumTime.value / (double)istepsForAveraging : (double)(time1 - time0)) : (double)tsc.interval;
        lastIndex.value = ifirst;
        double valTime0 = -3.4028234663852886E38;
        if (ifirst >= 0 && time0 == tsc.times[ifirst]) {
            if (dataType == 4) {
                valTime0 = tsc.values[ifirst + 1];
            } else if (dataType == 5) {
                valTime0 = 0.0;
            }
        }
        if (time0 < tsc.times[0] && dataType == 4) {
            valTime0 = tsc.values[ifirst + 1];
        }
        if (valTime0 == -3.4028234663852886E38) {
            valTime0 = this.interpolate(tsc, time0, dataType, lastIndex);
        }
        lastIndex.value = ilast;
        double valTime1 = this.interpolate(tsc, time1, dataType, lastIndex);
        if (ilast < ifirst + 1) {
            if (valTime0 != -3.4028234663852886E38 && tsc.values[ifirst + 1] != -3.4028234663852886E38) {
                deltaTime = time1 - time0;
                sumArea += deltaTime * 0.5 * (valTime0 + valTime1);
                sumTime.value += deltaTime;
                accumulate = dataType == 5 ? (accumulate += valTime1 - valTime0) : (accumulate += valTime1);
            }
        } else {
            if (valTime0 != -3.4028234663852886E38 && tsc.values[ifirst + 1] != -3.4028234663852886E38) {
                deltaTime = tsc.times[ifirst + 1] - time0;
                sumArea += deltaTime * 0.5 * (valTime0 + tsc.values[ifirst + 1]);
                sumTime.value += deltaTime;
                accumulate = dataType == 5 ? (accumulate += tsc.values[ifirst + 1] - valTime0) : (accumulate += tsc.values[ifirst + 1]);
            }
            if (valTime1 != -3.4028234663852886E38) {
                deltaTime = time1 - tsc.times[ilast];
                double valilast = tsc.values[ilast];
                if (dataType == 4) {
                    valilast = tsc.values[ilast + 1];
                } else if (dataType == 5) {
                    valilast = 0.0;
                }
                if (valilast != -3.4028234663852886E38) {
                    sumArea += deltaTime * 0.5 * (valTime1 + valilast);
                    sumTime.value += deltaTime;
                    accumulate += valTime1;
                }
            }
        }
        if (functionType == 16 && dataType == 5) {
            sumTime.value = avgDeltaTime;
            if (istepsForAveraging == 0 && valTime1 == -3.4028234663852886E38) {
                return -3.4028234663852886E38;
            }
            return accumulate;
        }
        if (functionType == 16) {
            sumTime.value = avgDeltaTime;
        }
        return sumArea;
    }

    private double intervalStats(int functionType, TimeSeriesContainer tsc, int time0, int time1, int interval, int dataType, double missingAllowed, intContainer lastIndex, intContainer timeOfOccurrence) {
        double val1;
        int ilast;
        timeOfOccurrence.value = time1;
        if (time0 >= time1) {
            return -3.4028234663852886E38;
        }
        if (tsc.interval <= 0 && time1 < tsc.times[0]) {
            return -3.4028234663852886E38;
        }
        if (time1 < tsc.times[0] || time0 > tsc.times[tsc.times.length - 1]) {
            return -3.4028234663852886E38;
        }
        int ifirst = Integer.MIN_VALUE;
        if (time0 >= tsc.times[0]) {
            ifirst = TimeSeriesMath.findInterval(tsc.times, time0, lastIndex.value);
            ++ifirst;
        } else {
            ifirst = 0;
        }
        if (ifirst == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        if (time1 == tsc.times[tsc.times.length - 1]) {
            ilast = tsc.times.length - 2;
        } else {
            ilast = TimeSeriesMath.findInterval(tsc.times, time1, ifirst);
            if (ilast == Integer.MIN_VALUE) {
                if (time1 > tsc.times[tsc.times.length - 1]) {
                    ilast = tsc.times.length - 1;
                } else {
                    return -3.4028234663852886E38;
                }
            }
            if (ilast < tsc.times.length && tsc.times[ilast] == time1) {
                --ilast;
            }
        }
        double numberExpectedPoints = ilast - ifirst + 2;
        if (interval > 0) {
            numberExpectedPoints = HecTime.computeNumberIntervals(time0, time1, interval);
            if (dataType == 1) {
                numberExpectedPoints += 1.0;
            }
        }
        lastIndex.value = ilast;
        double minValue = 3.4028234663852886E38;
        double maxValue = -3.4028234663852886E38;
        int minTime = 0;
        int maxTime = 0;
        int lastTime = time0;
        int numberGood = 0;
        for (int i = ifirst; i <= ilast; ++i) {
            if (!TimeSeriesMath.isValid(tsc, i)) continue;
            if (tsc.values[i] < minValue) {
                minValue = tsc.values[i];
                minTime = tsc.times[i];
            }
            if (tsc.values[i] > maxValue) {
                maxValue = tsc.values[i];
                maxTime = tsc.times[i];
            }
            ++numberGood;
            lastTime = tsc.times[i];
        }
        int valTime = 0;
        if (ilast + 1 < tsc.times.length && time1 == tsc.times[ilast + 1]) {
            val1 = tsc.values[ilast + 1];
            valTime = tsc.times[ilast + 1];
            if (val1 != -3.4028234663852886E38) {
                ++numberGood;
                lastTime = tsc.times[ilast + 1];
            }
        } else {
            this.interpolate(tsc, time1, dataType, lastIndex);
            int start = time1 - interval;
            if (start > tsc.times[lastIndex.value]) {
                val1 = -3.4028234663852886E38;
                valTime = time1;
            } else {
                valTime = tsc.times[lastIndex.value];
                val1 = tsc.values[lastIndex.value];
            }
        }
        if (val1 != -3.4028234663852886E38) {
            if (val1 < minValue) {
                minValue = val1;
                minTime = valTime;
            }
            if (val1 > maxValue) {
                maxValue = val1;
                maxTime = valTime;
            }
        }
        double functionValue = -3.4028234663852886E38;
        if (functionType == 12) {
            if (maxValue != -3.4028234663852886E38) {
                functionValue = maxValue;
            }
            timeOfOccurrence.value = maxTime;
        } else if (functionType == 13) {
            if (minValue != 3.4028234663852886E38) {
                functionValue = minValue;
            }
            timeOfOccurrence.value = minTime;
        } else if (functionType == 18) {
            functionValue = numberGood;
            timeOfOccurrence.value = lastTime;
        }
        return functionValue;
    }

    protected static int findInterval(int[] times, int time, int lastIndex) {
        return TimeSeriesFunctions.findInterval(times, time, lastIndex);
    }

    private int firstValidIndex(TimeSeriesContainer tsc) throws HecMathException {
        try {
            for (int i = 0; i < tsc.values.length; ++i) {
                if (!TimeSeriesMath.isValid(tsc, i)) continue;
                return i;
            }
            return Integer.MIN_VALUE;
        }
        catch (RuntimeException e) {
            throw new HecMathException(e);
        }
    }

    private int lastValidIndex(TimeSeriesContainer tsc) throws HecMathException {
        try {
            for (int i = tsc.values.length - 1; i >= 0; --i) {
                if (!TimeSeriesMath.isValid(tsc, i)) continue;
                return i;
            }
            return Integer.MIN_VALUE;
        }
        catch (RuntimeException e) {
            throw new HecMathException(e);
        }
    }

    private static HecTime roundTime(HecTime htime, int myInterval, int myOffset) {
        HecTime newTime = new HecTime();
        if (TimeSeriesMath.isValidDssInterval(myInterval)) {
            int[] julian = new int[1];
            int[] minutes = new int[1];
            int[] offset = new int[1];
            julian[0] = htime.julian();
            minutes[0] = htime.minutesSinceMidnight();
            offset[0] = myOffset;
            Heclib.zofset(julian, minutes, myInterval, 2, offset);
            newTime.setJulian(julian[0], minutes[0]);
        } else if (myInterval < 1440) {
            int minutes = htime.minutesSinceMidnight();
            int nper = minutes / myInterval;
            int newMinutes = nper * myInterval;
            if (newMinutes != minutes) {
                newMinutes += myInterval;
            }
            newTime.setJulian(htime.julian(), newMinutes);
        } else {
            newTime.setJulian(htime.julian(), 0);
            newTime.increment(myInterval, 1);
        }
        return newTime;
    }

    private static int parseTimeInterval(String timeIntervalString) {
        intContainer numberIntervals = new intContainer();
        intContainer timeInterval = new intContainer();
        return TimeSeriesMath.parseTimeInterval(timeIntervalString, timeInterval, numberIntervals);
    }

    private static int parseTimeInterval(String timeIntervalString, intContainer timeInterval, intContainer numberIntervals) {
        char chr;
        if (timeIntervalString == null || timeIntervalString.length() < 2) {
            return Integer.MIN_VALUE;
        }
        int minutes = Integer.MIN_VALUE;
        int timeIncrement = HecTimeSeriesBase.getIntervalFromEPart(timeIntervalString = timeIntervalString.toUpperCase().trim());
        if (timeIncrement > 0) {
            timeInterval.value = timeIncrement;
            numberIntervals.value = 1;
            return timeIncrement;
        }
        int len = timeIntervalString.length();
        int start = 0;
        if (timeIntervalString.charAt(0) == '-') {
            start = 1;
        }
        for (int i = start; i < len; ++i) {
            chr = timeIntervalString.charAt(i);
            if (chr == ' ' || chr >= '0' && chr <= '9' || chr >= 'A' && chr <= 'Z') continue;
            return Integer.MIN_VALUE;
        }
        int alphaStart = 0;
        for (int i = 0; i < len; ++i) {
            chr = timeIntervalString.charAt(i);
            if (chr == ' ' || chr < 'A' || chr > 'Z') continue;
            alphaStart = i;
            break;
        }
        int number = Integer.parseInt(timeIntervalString.substring(0, alphaStart).trim());
        timeIncrement = 0;
        String timeIncrementString = timeIntervalString.substring(alphaStart).trim();
        if (timeIncrementString.length() < 1) {
            return 0;
        }
        if (timeIncrementString.substring(0, 1).equals("M")) {
            if (timeIncrementString.length() == 1) {
                timeIncrement = 1;
            } else if (timeIncrementString.substring(0, 2).equals("MI")) {
                timeIncrement = 1;
            } else if (timeIncrementString.substring(0, 2).equals("MO")) {
                timeIncrement = 43200;
            }
        } else if (timeIncrementString.substring(0, 1).equals("H")) {
            timeIncrement = 60;
        } else if (timeIncrementString.substring(0, 1).equals("D")) {
            timeIncrement = 1440;
        } else if (timeIncrementString.substring(0, 1).equals("W")) {
            timeIncrement = 10080;
        } else if (timeIncrementString.substring(0, 1).equals("Y")) {
            timeIncrement = 525600;
        }
        timeInterval.value = timeIncrement;
        numberIntervals.value = number;
        return timeIncrement *= number;
    }

    private static boolean isValidDssInterval(int timeInterval) {
        int[] status = new int[1];
        String ePart = Heclib.getEPartFromInterval(timeInterval, status);
        return status[0] == 0;
    }

    private static int parseMonth(String monthString) {
        for (int i = 0; i < _months.length; ++i) {
            if (monthString.indexOf(_months[i]) < 0) continue;
            return i + 1;
        }
        return -1;
    }

    private static int parseDayOfWeek(String dayOfWeekString) {
        for (int i = 0; i < _dayOfWeek.length; ++i) {
            if (dayOfWeekString.indexOf(_dayOfWeek[i]) < 0) continue;
            return i + 1;
        }
        return -1;
    }

    private static int getLastDayOfMonth(HecTime hecTime) {
        int imonth = hecTime.month();
        int year = hecTime.year();
        if (--imonth == 1 && year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
            return 29;
        }
        return _mdays[imonth];
    }

    @Deprecated
    public double[] getSortedPeaks() throws HecMathException {
        TimeSeriesMath outputMath = (TimeSeriesMath)this.transformTimeSeries("1YEAR", "0MIN", "MAX", true);
        TimeSeriesContainer tsc = outputMath.getContainer();
        return SimpleFrequencyAnalysis.getSortedPeaks(tsc);
    }

    @Deprecated
    public Vector computeSimpleFrequency() throws HecMathException {
        TimeSeriesContainer tsc = this.getContainer();
        SimpleFrequencyAnalysis fa = new SimpleFrequencyAnalysis(tsc);
        Vector<PairedDataContainer> v = new Vector<PairedDataContainer>(2);
        v.add(fa.getPairedDataPeaks());
        v.add(fa.getPairedDataComputed());
        return v;
    }

    @Override
    public TimeSeriesMath expandVerticalDatum() throws HecMathException {
        TimeSeriesContainer expandedTsc;
        if (!(this instanceof VerticalDatum) && (expandedTsc = ((TimeSeriesContainer)this.getData()).expandVerticalDatum()) instanceof VerticalDatum) {
            return new TimeSeriesMathVertDatum(expandedTsc);
        }
        return (TimeSeriesMath)this.copy();
    }

    @Override
    public TimeSeriesMath collapseVerticalDatum() throws HecMathException {
        if (this instanceof VerticalDatum) {
            return new TimeSeriesMath(((TimeSeriesContainer)this.getData()).collapseVerticalDatum());
        }
        return (TimeSeriesMath)this.copy();
    }

    public TimeSeriesMath resample(Interval interval) throws HecMathException {
        return new TimeSeriesMath(TimeSeriesFunctions.resample((TimeSeriesContainer)this._dc, interval));
    }
}

