/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class TimeSeriesMathVertDatum
extends TimeSeriesMath
implements VerticalDatum {
    public TimeSeriesMathVertDatum() {
    }

    public TimeSeriesMathVertDatum(TimeSeriesContainer tsc) throws HecMathException {
        this.setData(tsc);
    }

    @Override
    public void setData(DataContainer container) throws HecMathException {
        super.setData(container);
        if (container == null) {
            throw new HecMathException("TimeSeriesMathVertDatum.setData: Parameter is null");
        }
        if (!(container instanceof TimeSeriesContainerVertDatum)) {
            throw new HecMathException("TimeSeriesMath.setDatum: Parameter is not TimeSeries Data with Vertical Datum Info");
        }
        TimeSeriesContainerVertDatum tscvd = (TimeSeriesContainerVertDatum)container;
        TimeSeriesMathVertDatum.checkTimeSeries(tscvd);
        this._dc = (TimeSeriesContainerVertDatum)tscvd.clone();
    }

    @Override
    public DataContainer getData() throws HecMathException {
        DataContainer dc = null;
        if (this._dc != null) {
            dc = (DataContainer)((TimeSeriesContainerVertDatum)this._dc).clone();
        }
        return dc;
    }

    @Override
    public void getData(DataContainer container) throws HecMathException {
        if (this._dc != null) {
            ((TimeSeriesContainerVertDatum)this._dc).clone((TimeSeriesContainer)container);
        }
    }

    @Override
    public HecMath copy() throws HecMathException {
        TimeSeriesContainerVertDatum tsc = (TimeSeriesContainerVertDatum)this.getData();
        return new TimeSeriesMathVertDatum(tsc);
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        String retval = null;
        if (this._dc != null) {
            retval = ((TimeSeriesContainerVertDatum)this._dc).getNativeVerticalDatum();
        }
        return retval;
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        String retval = null;
        if (this._dc != null) {
            retval = ((TimeSeriesContainerVertDatum)this._dc).getCurrentVerticalDatum();
        }
        return retval;
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to determine if current vertical datum is estimated. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to convert to native vertical datum. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).toNativeVerticalDatum();
    }

    public boolean toNGVD29() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to convert to NGVD29. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).toNGVD29();
    }

    public boolean toNAVD88() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to convert to NAVD88. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).toNAVD88();
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to convert to " + datum + ". Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).toVerticalDatum(datum);
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to force vertical datum to " + datum + ". Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get current offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getCurrentOffset();
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get current offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get NGVD29 offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getNGVD29Offset();
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get NGVD29 offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get NAVD88 offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getNAVD88Offset();
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to get NAVD88 offset. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to determine if NGVD29 offset is estimated. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to determine if NAVD88 offset is estimated. Data container is null");
        }
        return ((TimeSeriesContainerVertDatum)this._dc).isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        String retval = null;
        if (this._dc != null) {
            retval = ((TimeSeriesContainerVertDatum)this._dc).getVerticalDatumInfo();
        }
        return retval;
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to set vertical datum info. Data container is null.");
        }
        ((TimeSeriesContainerVertDatum)this._dc).setVerticalDatumInfo(xmlStr);
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        VerticalDatumContainer retval = null;
        if (this._dc != null) {
            retval = ((TimeSeriesContainerVertDatum)this._dc).getVerticalDatumContainer();
        }
        return retval;
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) throws VerticalDatumException {
        if (this._dc == null) {
            throw new VerticalDatumException("Unable to set vertical datum container. Data container is null");
        }
        ((TimeSeriesContainerVertDatum)this._dc).setVerticalDatumContainer(vdc);
    }
}

