/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Condition;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.MathExpression;
import hec.hecmath.computation.QualityOperation;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Util;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class Computation
implements Constants,
Evaluable {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected static Pattern expand_when = Pattern.compile("(^|[\\W])(when)([\\W])", 2);
    protected static Pattern expand_otherwise = Pattern.compile("([\\W])(otherwise)([\\W])", 2);
    protected static Pattern split_when = Pattern.compile(" when ", 2);
    protected static Pattern split_otherwise = Pattern.compile(" otherwise ", 2);
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;
    protected boolean stale = true;
    protected String inputText = null;
    protected Variable result = null;
    protected VariableSet variables = new VariableSet();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();
    protected Set<UpdatableListener> updateListeners = null;
    protected List<ConditionalExpression> computation = new Vector<ConditionalExpression>();

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    protected Computation() {
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
    }

    public Computation(String expr) throws ComputationException {
        this();
        this.result = new Variable("$result", -3.4028234663852886E38);
        this.variables.addVariable(this.result);
        this.inputText = expr;
        this.setExpression(expr);
    }

    @Override
    public boolean getTolerateUndefined() {
        return this.tolerateUndefined;
    }

    @Override
    public boolean getExceptionOnUndefined() {
        return this.exceptionOnUndefined;
    }

    @Override
    public boolean getAllowDenormal() {
        return this.allowDenormal;
    }

    @Override
    public void setTolerateUndefined(boolean setting) {
        this.tolerateUndefined = setting;
        this.result.setTolerateUndefined(setting);
    }

    @Override
    public void setExceptionOnUndefined(boolean setting) {
        this.exceptionOnUndefined = setting;
        this.result.setExceptionOnUndefined(setting);
    }

    @Override
    public void setAllowDenormal(boolean setting) {
        this.allowDenormal = setting;
        this.result.setAllowDenormal(setting);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int len = this.computation.size();
        for (int i = 0; i < len; ++i) {
            ConditionalExpression ce = this.computation.get(i);
            if (ce.getCondition() == null) {
                if (i > 0) {
                    sb.append("\nOtherwise\n\t");
                }
            } else {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append("When ").append(ce.getCondition().toString()).append("\n\t");
            }
            if (ce.getExpression() != null) {
                sb.append(ce.getExpression().toString());
                if (ce.getQualityOp() != null) {
                    sb.append(" ; ");
                }
            }
            if (ce.getQualityOp() == null) continue;
            sb.append(ce.getQualityOp().toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double evaluate() throws ComputationException {
        Computation computation = this;
        synchronized (computation) {
            if (this.stale) {
                this.compute();
            }
            return this.result.evaluate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        Computation computation = this;
        synchronized (computation) {
            return Double.toString(this.evaluate());
        }
    }

    public synchronized int getQuality() throws ComputationException {
        return this.result.getQuality();
    }

    @Override
    public String toNotation(Constants.Notation notation) throws ComputationException {
        switch (notation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: 
            case INFIX: {
                return this.toString();
            }
        }
        throw new ComputationException("Invalid notation:" + notation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        Computation computation = this;
        synchronized (computation) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    protected synchronized void compute() throws ComputationException {
        for (ConditionalExpression ce : this.computation) {
            if (ce.condition != null && !ce.condition.test()) continue;
            if (ce.expression != null) {
                this.result.setValue(ce.expression.evaluate());
            }
            if (ce.qualityOp == null) break;
            ce.qualityOp.operate();
            break;
        }
    }

    protected ConditionalExpression makeConditionalExpression(String conditionText, String toDo) throws ComputationException {
        String mathExprText = null;
        String qualityOpText = null;
        String[] parts = toDo.split(";");
        switch (parts.length) {
            case 1: {
                parts[0] = parts[0].trim();
                if (QualityOperation.isQualityOperation(parts[0])) {
                    qualityOpText = parts[0];
                    break;
                }
                mathExprText = parts[0];
                break;
            }
            case 2: {
                mathExprText = parts[0].trim();
                qualityOpText = parts[1].trim();
                break;
            }
            default: {
                throw new ComputationException("Too many ';' in " + toDo);
            }
        }
        return new ConditionalExpression(conditionText, mathExprText, qualityOpText);
    }

    protected void setExpression(String expr) throws ComputationException {
        expr = Util.expandExpression(expr);
        expr = Util.reSub(expr, expand_when, "$1 $2 $3");
        String[] parts = split_when.split(expr = Util.reSub(expr, expand_otherwise, "$1 $2 $3"));
        if (parts.length == 1) {
            String conditionText = null;
            String toDo = expr;
            this.computation.add(this.makeConditionalExpression(conditionText, toDo));
        } else {
            if (parts[0].trim().length() > 0) {
                throw new ComputationException("Unexpected text before first \"When\": " + parts[0]);
            }
            for (int i = 1; i < parts.length; ++i) {
                int k;
                parts[i] = parts[i].trim();
                int j = Util.matchBracket(parts[i], 0) + 1;
                if (i == parts.length - 1) {
                    k = parts[i].toLowerCase().indexOf("otherwise");
                    if (k == -1) {
                        k = parts[i].length();
                    }
                } else {
                    k = parts[i].length();
                }
                String conditionText = parts[i].substring(0, j);
                String toDo = parts[i].substring(j, k);
                this.computation.add(this.makeConditionalExpression(conditionText, toDo));
                if (i != parts.length - 1 || k >= parts[i].length()) continue;
                conditionText = null;
                toDo = split_otherwise.split(parts[i])[1];
                this.computation.add(this.makeConditionalExpression(conditionText, toDo));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String expr = "when($0<$1/4)r!when($0<$1/2 or r?($0))$1/2;q!otherwise ok!";
        System.out.println(expr);
        Computation c1 = new Computation(expr);
        System.out.println("===========================\n" + c1.toString());
    }

    @Override
    public void registerListener(UpdatableListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = new HashSet<UpdatableListener>();
        }
        this.updateListeners.add(listener);
    }

    @Override
    public void unregisterListener(UpdatableListener listener) {
        if (this.updateListeners != null) {
            this.updateListeners.remove(listener);
        }
    }

    @Override
    public void notifyListeners() {
        if (this.updateListeners != null) {
            for (UpdatableListener l : this.updateListeners) {
                try {
                    l.dataUpdated(this);
                }
                catch (Throwable t) {
                    this.updateListeners.remove(l);
                }
            }
        }
    }

    class ConditionalExpression {
        Condition condition = null;
        MathExpression expression = null;
        QualityOperation qualityOp = null;

        ConditionalExpression(String conditionStr, String expressionStr, String qualityOpStr) throws ComputationException {
            if (expressionStr == null && qualityOpStr == null) {
                throw new ComputationException("A math expression or quality operation must be provided.");
            }
            if (conditionStr != null && conditionStr.length() > 0) {
                this.condition = new Condition(conditionStr, Computation.this.variables);
            }
            if (expressionStr != null && expressionStr.length() > 0) {
                this.expression = new MathExpression(expressionStr, Computation.this.variables);
            }
            if (qualityOpStr != null && qualityOpStr.length() > 0) {
                this.qualityOp = new QualityOperation(qualityOpStr, Computation.this.variables, Computation.this.result.getName());
            }
        }

        Condition getCondition() {
            return this.condition;
        }

        MathExpression getExpression() {
            return this.expression;
        }

        QualityOperation getQualityOp() {
            return this.qualityOp;
        }
    }
}

