/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.LogicTest;
import hec.hecmath.computation.MathExpression;
import hec.hecmath.computation.QualityTest;
import hec.hecmath.computation.Testable;
import hec.hecmath.computation.TextExpression;
import hec.hecmath.computation.TextTest;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Util;
import hec.hecmath.computation.ValueTest;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.util.TextUtil;
import java.util.HashSet;
import java.util.Set;

public class Condition
implements Constants,
Testable {
    protected String inputText = null;
    protected Testable condition = null;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();
    protected boolean stale = true;
    protected VariableSet variables = null;

    protected static String normalizeParentheses(String expr) {
        return expr.replaceAll("[\\[{]", "(").replaceAll("[}\\]]", ")");
    }

    public Condition(String expr) throws ComputationException {
        this(expr, null);
    }

    public Condition(String expr, VariableSet variables) throws ComputationException {
        this.variables = variables == null ? new VariableSet() : variables;
        this.setCondition(expr);
    }

    public VariableSet getVariables() {
        return this.variables;
    }

    @Override
    public boolean test() throws ComputationException {
        return this.condition.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        Condition condition = this;
        synchronized (condition) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    @Override
    public String toString() {
        return TextUtil.reduceParentheses(this.condition.toString());
    }

    protected void setCondition(String expr) throws ComputationException {
        if (expr == null) {
            throw new ComputationException("Expression must not be null.");
        }
        if ((expr = expr.trim()).length() == 0) {
            throw new ComputationException("Expression must not be null.");
        }
        this.inputText = expr;
        Util.validateBalancedBrackets(this.inputText);
        expr = Util.normalizeParentheses(expr);
        this.condition = this.buildCondition(expr);
    }

    protected Testable buildCondition(String expr) throws ComputationException {
        Testable condition;
        block28: {
            block26: {
                int index;
                String[] parts;
                block30: {
                    block29: {
                        block27: {
                            condition = null;
                            while (expr.charAt(0) == '(' && Util.matchBracket(expr, 0) == expr.length() - 1) {
                                expr = expr.substring(1, expr.length() - 1);
                            }
                            expr = Util.expandExpression(expr);
                            parts = expr.split("\\s+");
                            int level = 0;
                            int precedence = Integer.MAX_VALUE;
                            index = -1;
                            for (int i = 0; i < parts.length; ++i) {
                                if (parts[i].equals("(")) {
                                    ++level;
                                    continue;
                                }
                                if (parts[i].equals(")")) {
                                    --level;
                                    continue;
                                }
                                if (level != 0) continue;
                                if (LogicTest.isLogicTest(parts[i])) {
                                    if (LogicTest.precedence(parts[i]) > precedence) continue;
                                    precedence = LogicTest.precedence(parts[i]);
                                    index = i;
                                    continue;
                                }
                                if (ValueTest.isValueTest(parts[i])) {
                                    if (ValueTest.precedence(parts[i]) > precedence) continue;
                                    precedence = ValueTest.precedence(parts[i]);
                                    index = i;
                                    continue;
                                }
                                if (TextTest.isTextTest(parts[i])) {
                                    if (TextTest.precedence(parts[i]) > precedence) continue;
                                    precedence = TextTest.precedence(parts[i]);
                                    index = i;
                                    continue;
                                }
                                if (!QualityTest.isQualityTest(parts[i]) || QualityTest.precedence(parts[i]) > precedence) continue;
                                precedence = QualityTest.precedence(parts[i]);
                                index = i;
                            }
                            if (index < 0) break block26;
                            if (!LogicTest.isLogicTest(parts[index])) break block27;
                            switch (LogicTest.arity(parts[index])) {
                                case 1: {
                                    condition = new LogicTest(parts[index].toLowerCase(), this.buildCondition(Util.join(" ", parts, index + 1)));
                                    break block28;
                                }
                                case 2: {
                                    condition = new LogicTest(parts[index].toLowerCase(), this.buildCondition(Util.join(" ", parts, 0, index)), this.buildCondition(Util.join(" ", parts, index + 1)));
                                    break block28;
                                }
                                default: {
                                    throw new ComputationException("Unexpected LogicTest operator: " + parts[index]);
                                }
                            }
                        }
                        if (!ValueTest.isValueTest(parts[index])) break block29;
                        switch (ValueTest.arity(parts[index])) {
                            case 1: {
                                condition = new ValueTest(parts[index].toLowerCase(), this.variables, (Evaluable)new MathExpression(Util.join(" ", parts, index + 1), this.variables));
                                break block28;
                            }
                            case 2: {
                                condition = new ValueTest(parts[index].toLowerCase(), this.variables, new MathExpression(Util.join(" ", parts, 0, index), this.variables), new MathExpression(Util.join(" ", parts, index + 1), this.variables));
                                break block28;
                            }
                            default: {
                                throw new ComputationException("Unexpected ValueTest operator: " + parts[index]);
                            }
                        }
                    }
                    if (!TextTest.isTextTest(parts[index])) break block30;
                    switch (TextTest.arity(parts[index])) {
                        case 1: {
                            condition = new TextTest(parts[index].toLowerCase(), this.variables, (Evaluable)new TextExpression(Util.join(" ", parts, index + 1), this.variables));
                            break block28;
                        }
                        case 2: {
                            condition = new TextTest(parts[index].toLowerCase(), this.variables, new TextExpression(Util.join(" ", parts, 0, index), this.variables), new TextExpression(Util.join(" ", parts, index + 1), this.variables));
                            break block28;
                        }
                        default: {
                            throw new ComputationException("Unexpected TextTest operator: " + parts[index]);
                        }
                    }
                }
                if (QualityTest.isQualityTest(parts[index])) {
                    String[] newParts = null;
                    switch (QualityTest.arity(parts[index])) {
                        case 1: {
                            newParts = Util.join(" ", parts).trim().replace('(', ' ').replace(')', ' ').split("\\s+");
                            if (!newParts[0].equals(parts[index]) || newParts.length != 2 || !Variable.isVariableName(newParts[1])) {
                                throw new ComputationException("Invalid QualityTest operation: " + Util.join(" ", parts));
                            }
                            condition = new QualityTest(newParts[0], this.variables, newParts[1].toLowerCase());
                            break;
                        }
                        case 2: {
                            newParts = Util.join(" ", parts).trim().replace('(', ' ').replace(')', ' ').split("\\s+");
                            if (!(newParts[1].equals(parts[index]) && newParts.length == 3 && Variable.isVariableName(newParts[0]) && Variable.isVariableName(newParts[2]))) {
                                throw new ComputationException("Invalid QualityTest operation: " + Util.join(" ", parts));
                            }
                            condition = new QualityTest(newParts[1], this.variables, newParts[0].toLowerCase(), newParts[1].toLowerCase());
                            break;
                        }
                        default: {
                            throw new ComputationException("Unexpected QualityTest operator: " + parts[index]);
                        }
                    }
                }
                break block28;
            }
            throw new ComputationException("Mal-formed condition: " + expr);
        }
        this.registerAsListener(condition);
        return condition;
    }

    public static void main(String[] args) throws Exception {
        String expr1 = "($I1<0and r?($I2)or m?($I2))or2$I1+sqrt($I2)>=$I2/2";
        String expr2 = "2$I1+sqrt($I2)>=$I2/2or($I1<0and r?($I2)or m?($I2))";
        String expr3 = "$I3 /!=~/ cfs and $I1 - $I2 < 5.0";
        System.out.println("\n" + expr1);
        Condition c1 = new Condition(expr1);
        System.out.println(c1);
        System.out.println("\n" + expr2);
        Condition c2 = new Condition(expr2);
        System.out.println(c2);
        System.out.println("\n" + expr3);
        Condition c3 = new Condition(expr3);
        System.out.println(c3);
        for (String varname : c3.getVariables().getVariableNames()) {
            System.out.println(varname);
        }
        VariableSet vars = c3.getVariables();
        vars.setValue("$I3", "cfs");
        vars.setValue("$I1", 10.0);
        vars.setValue("$I2", 6.0);
        System.out.println(c3.test());
    }
}

