/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

public interface Constants {
    public static final int CONSTANT = 0;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    public static final int VARIADIC = -1;

    public static enum MathOperator {
        E(0, Precedence.FUNCTION, "e"),
        PI(0, Precedence.FUNCTION, "pi"),
        ADDITION(2, Precedence.ADDITIVE, "+"),
        SUBTRACTION(2, Precedence.ADDITIVE, "-"),
        MULTIPLICATION(2, Precedence.MULTIPLICATIVE, "*"),
        DIVISION(2, Precedence.MULTIPLICATIVE, "/"),
        INTEGER_DIVISION(2, Precedence.MULTIPLICATIVE, "//"),
        MODULO(2, Precedence.MULTIPLICATIVE, "%"),
        EXPONENTIATION(2, Precedence.EXPONENTIATION, "**", "^"),
        ABS(1, Precedence.FUNCTION, "abs"),
        NEG(1, Precedence.FUNCTION, "neg", "+/-"),
        INV(1, Precedence.FUNCTION, "inv"),
        SIGN(1, Precedence.FUNCTION, "sign"),
        SQRT(1, Precedence.FUNCTION, "sqrt"),
        EXP(1, Precedence.FUNCTION, "exp"),
        LOG(1, Precedence.FUNCTION, "log", "logn", "ln"),
        LOG10(1, Precedence.FUNCTION, "log10"),
        SIN(1, Precedence.FUNCTION, "sin"),
        COS(1, Precedence.FUNCTION, "cos"),
        TAN(1, Precedence.FUNCTION, "tan"),
        ASIN(1, Precedence.FUNCTION, "asin"),
        ACOS(1, Precedence.FUNCTION, "acos"),
        ATAN(1, Precedence.FUNCTION, "atan"),
        FLOOR(1, Precedence.FUNCTION, "floor"),
        CEIL(1, Precedence.FUNCTION, "ceil"),
        ROUND(1, Precedence.FUNCTION, "round"),
        TRUNC(1, Precedence.FUNCTION, "trunc"),
        FMOD(2, Precedence.FUNCTION, "fmod"),
        COUNT(-1, Precedence.FUNCTION, "count"),
        SUM(-1, Precedence.FUNCTION, "sum"),
        PROD(-1, Precedence.FUNCTION, "prod"),
        MIN(-1, Precedence.FUNCTION, "min"),
        MAX(-1, Precedence.FUNCTION, "max"),
        MEAN(-1, Precedence.FUNCTION, "mean", "avg"),
        GMEAN(-1, Precedence.FUNCTION, "gmean"),
        HMEAN(-1, Precedence.FUNCTION, "hmean"),
        RMS(-1, Precedence.FUNCTION, "rms", "qmean"),
        VAR(-1, Precedence.FUNCTION, "var"),
        STDEV(-1, Precedence.FUNCTION, "stdev"),
        SKEW(-1, Precedence.FUNCTION, "skew"),
        KURT(-1, Precedence.FUNCTION, "kurt"),
        MODE(-1, Precedence.FUNCTION, "mode"),
        MED(-1, Precedence.FUNCTION, "med", "p50"),
        P1(-1, Precedence.FUNCTION, "p1"),
        P2(-1, Precedence.FUNCTION, "p2"),
        P5(-1, Precedence.FUNCTION, "p5"),
        P10(-1, Precedence.FUNCTION, "p10"),
        P20(-1, Precedence.FUNCTION, "p20"),
        P25(-1, Precedence.FUNCTION, "p25"),
        P75(-1, Precedence.FUNCTION, "p75"),
        P80(-1, Precedence.FUNCTION, "p80"),
        P90(-1, Precedence.FUNCTION, "p90"),
        P95(-1, Precedence.FUNCTION, "p95"),
        P98(-1, Precedence.FUNCTION, "p98"),
        P99(-1, Precedence.FUNCTION, "p99");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private MathOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum ValueTestOperator {
        IS_NAN(1, Precedence.EQUALITY, "is-nan"),
        IS_INF(1, Precedence.EQUALITY, "is-inf"),
        IS_NEG_INF(1, Precedence.EQUALITY, "is-neg-inf"),
        IS_POS_INF(1, Precedence.EQUALITY, "is-pos-inf"),
        IS_UNDEF(1, Precedence.EQUALITY, "is-undef"),
        IS_NEAR_ZERO(1, Precedence.EQUALITY, "is-near-zero"),
        LT(2, Precedence.RELATIONAL, "lt", "<"),
        LE(2, Precedence.RELATIONAL, "le", "<="),
        GT(2, Precedence.RELATIONAL, "gt", ">"),
        GE(2, Precedence.RELATIONAL, "ge", ">="),
        EQ(2, Precedence.RELATIONAL, "eq", "=="),
        NE(2, Precedence.RELATIONAL, "ne", "!=", "<>");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private ValueTestOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum QualityOperator {
        Q_SET_CLEAR(1, Precedence.ASSIGNMENT, "q-set-clear", "clr!"),
        Q_SET_OK(1, Precedence.ASSIGNMENT, "q-set-ok", "ok!"),
        Q_SET_Q(1, Precedence.ASSIGNMENT, "q-set-q", "q!"),
        Q_SET_R(1, Precedence.ASSIGNMENT, "q-set-r", "r!"),
        Q_SET_M(1, Precedence.ASSIGNMENT, "q-set-m", "m!"),
        Q_SET_P(1, Precedence.ASSIGNMENT, "q-set-p", "p!");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private QualityOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum QualityTestOperator {
        Q_IS_CLEAR(1, Precedence.EQUALITY, "q-is-clear", "clr?"),
        Q_IS_OK(1, Precedence.EQUALITY, "q-is-ok", "ok?"),
        Q_IS_Q(1, Precedence.EQUALITY, "q-is-q", "q?"),
        Q_IS_R(1, Precedence.EQUALITY, "q-is-r", "r?"),
        Q_IS_M(1, Precedence.EQUALITY, "q-is-m", "m?"),
        Q_IS_P(1, Precedence.EQUALITY, "q-is-p", "p?"),
        Q_IS_S(1, Precedence.EQUALITY, "q-is-s", "s?"),
        Q_LT(2, Precedence.RELATIONAL, "q-lt", "q<"),
        Q_LE(2, Precedence.RELATIONAL, "q-le", "q<="),
        Q_GT(2, Precedence.RELATIONAL, "q-gt", "q>"),
        Q_GE(2, Precedence.RELATIONAL, "q-ge", "q>="),
        Q_EQ(2, Precedence.RELATIONAL, "q-eq", "q=="),
        Q_NE(2, Precedence.RELATIONAL, "q-ne", "q!=", "q<>");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private QualityTestOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum LogicTestOperator {
        NOT(1, Precedence.UNARY, "not", "!"),
        AND(2, Precedence.LOGICAL_AND, "and", "&&"),
        OR(2, Precedence.LOGICAL_OR, "or", "||"),
        XOR(2, Precedence.LOGICAL_XOR, "xor", "^^");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private LogicTestOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum TextTestOperator {
        EQ_CASE_LITERAL(2, Precedence.RELATIONAL, "/eq/", "/==/"),
        EQ_NOCASE_LITERAL(2, Precedence.RELATIONAL, "/eq_nocase/", "/==~/"),
        EQ_CASE_REGEX(2, Precedence.RELATIONAL, "/eq_regex/", "/==+/"),
        EQ_NOCASE_REGEX(2, Precedence.RELATIONAL, "/eq_nocase_regex/", "/==~+/", "/==+~/", "/eq_regex_nocase/"),
        EQ_CASE_GLOB(2, Precedence.RELATIONAL, "/eq_glob/", "/==*/"),
        EQ_NOCASE_GLOB(2, Precedence.RELATIONAL, "/eq_nocase_glob/", "/==~*/", "/==*~/", "/eq_glob_nocase/"),
        NE_CASE_LITERAL(2, Precedence.RELATIONAL, "/ne/", "/!=/", "/<>/"),
        NE_NOCASE_LITERAL(2, Precedence.RELATIONAL, "/ne_nocase/", "/!=~/", "/<>~/"),
        NE_CASE_REGEX(2, Precedence.RELATIONAL, "/ne_regex/", "/!=+/", "/<>+/"),
        NE_NOCASE_REGEX(2, Precedence.RELATIONAL, "/ne_nocase_regex/", "/!=~+/", "/<>~+/", "/!=+~/", "/ne_regex_nocase/"),
        NE_CASE_GLOB(2, Precedence.RELATIONAL, "/ne_glob/", "/!=*/", "/<>*/"),
        NE_NOCASE_GLOB(2, Precedence.RELATIONAL, "/ne_nocase_glob/", "/!=~*/", "/<>~*/", "/!=*~/", "/ne_glob_nocase/"),
        LT_CASE(2, Precedence.RELATIONAL, "/lt/", "/</"),
        LT_NOCASE(2, Precedence.RELATIONAL, "/lt_nocase/", "/<~/"),
        GT_CASE(2, Precedence.RELATIONAL, "/gt/", "/>/"),
        GT_NOCASE(2, Precedence.RELATIONAL, "/gt_nocase/", "/>~/"),
        LE_CASE(2, Precedence.RELATIONAL, "/le/", "/<=/"),
        LE_NOCASE(2, Precedence.RELATIONAL, "/le_nocase/", "/<=~/"),
        GE_CASE(2, Precedence.RELATIONAL, "/ge/", "/>=/"),
        GE_NOCASE(2, Precedence.RELATIONAL, "/ge_nocase/", "/>=~/"),
        SW_CASE_LITERAL(2, Precedence.RELATIONAL, "/starts_with/", "/=|/"),
        SW_NOCASE_LITERAL(2, Precedence.RELATIONAL, "/starts_with_nocase/", "/=|~/"),
        SW_CASE_REGEX(2, Precedence.RELATIONAL, "/starts_with_regex/", "/=|+/"),
        SW_NOCASE_REGEX(2, Precedence.RELATIONAL, "/starts_with_nocase_regex/", "/=|~+/", "/=|+~/", "/starts_with_regex_nocase/"),
        SW_CASE_GLOB(2, Precedence.RELATIONAL, "/starts_with_glob/", "/=|*/"),
        SW_NOCASE_GLOB(2, Precedence.RELATIONAL, "/starts_with_nocase_glob/", "/=|~*/", "/=|*~/", "/starts_with_glob_nocase/"),
        EW_CASE_LITERAL(2, Precedence.RELATIONAL, "/ends_with/", "/|=/"),
        EW_NOCASE_LITERAL(2, Precedence.RELATIONAL, "/ends_with_nocase/", "/|=~/"),
        EW_CASE_REGEX(2, Precedence.RELATIONAL, "/ends_with_regex/", "/|=+/"),
        EW_NOCASE_REGEX(2, Precedence.RELATIONAL, "/ends_with_nocase_regex/", "/|=~+/", "/|=+~/", "/ends_with_regex_nocase/"),
        EW_CASE_GLOB(2, Precedence.RELATIONAL, "/ends_with_glob/", "/|=*/"),
        EW_NOCASE_GLOB(2, Precedence.RELATIONAL, "/ends_with_nocase_glob/", "/|=~*/", "/|=*~/", "/ends_with_glob_nocase/"),
        CONTAINS_CASE_LITERAL(2, Precedence.RELATIONAL, "/contains/", "/|=|/"),
        CONTAINS_NOCASE_LITERAL(2, Precedence.RELATIONAL, "/contains_nocase/", "/|=|~/"),
        CONTAINS_CASE_REGEX(2, Precedence.RELATIONAL, "/contains_regex/", "/|=|+/"),
        CONTAINS_NOCASE_REGEX(2, Precedence.RELATIONAL, "/contains_nocase_regex/", "/|=|~+/", "/|=|+~/", "/contains_regex_nocase/"),
        CONTAINS_CASE_GLOB(2, Precedence.RELATIONAL, "/contains_glob/", "/|=|*/"),
        CONTAINS_NOCASE_GLOB(2, Precedence.RELATIONAL, "/contains_nocase_regex/", "/|=|~*/", "/|=|*~/", "/contains_regex_nocase/");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private TextTestOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum TextOperator {
        ADDITION(2, Precedence.ADDITIVE, "/+/"),
        UPPER(1, Precedence.FUNCTION, "upper", "uppercase"),
        LOWER(1, Precedence.FUNCTION, "lower", "lowercase"),
        TITLE(1, Precedence.FUNCTION, "title", "titlecase", "initcaps"),
        TRIM(1, Precedence.FUNCTION, "trim", "strip");

        private int arity;
        private int precedence;
        private String name;
        private String[] aliases = null;

        private TextOperator(int arity, Precedence precedence, String ... names) {
            this.arity = arity;
            this.precedence = precedence.precedence();
            this.name = names[0];
            if (names.length > 1) {
                this.aliases = new String[names.length - 1];
                System.arraycopy(names, 1, this.aliases, 0, this.aliases.length);
            }
        }

        public int arity() {
            return this.arity;
        }

        public int precedence() {
            return this.precedence;
        }

        public String opname() {
            return this.name;
        }

        public String[] aliases() {
            return this.aliases;
        }
    }

    public static enum Precedence {
        SEQUENCE(0),
        ASSIGNMENT(1),
        TERNARY(2),
        LOGICAL_OR(3),
        LOGICAL_XOR(4),
        LOGICAL_AND(5),
        BITWISE_OR(6),
        BITWISE_XOR(7),
        BITWISE_AND(8),
        EQUALITY(9),
        RELATIONAL(10),
        SHIFT(11),
        ADDITIVE(12),
        MULTIPLICATIVE(13),
        EXPONENTIATION(14),
        UNARY(15),
        POSTFIX(16),
        FUNCTION(17),
        MEMBERSHIP(18);

        private int precedence;

        private Precedence(int precedence) {
            this.precedence = precedence;
        }

        public int precedence() {
            return this.precedence;
        }
    }

    public static enum Notation {
        UNKNOWN,
        PREFIX,
        INFIX,
        POSTFIX,
        S_EXPR;

    }
}

