/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Testable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LogicTest
implements Constants,
Testable {
    protected static Map<Constants.LogicTestOperator, String> nameByOp = new EnumMap<Constants.LogicTestOperator, String>(Constants.LogicTestOperator.class);
    protected static Map<String, Constants.LogicTestOperator> opByName = new HashMap<String, Constants.LogicTestOperator>();
    protected boolean state;
    protected Constants.LogicTestOperator op;
    protected Testable[] test = new Testable[]{null, null};
    protected boolean stale;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources;
    protected Object updateSourcesLock = new Object();

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isLogicTest(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static int arity(String name) throws ComputationException {
        Constants.LogicTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.arity();
    }

    public static int precedence(String name) throws ComputationException {
        Constants.LogicTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.precedence();
    }

    public LogicTest(String name, Testable test0) throws ComputationException {
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 1) {
            throw new ComputationException("LogicTestOperator " + name + " cannot be used in a unary context.");
        }
        this.test[0] = test0;
        this.updateListeners = null;
        this.stale = true;
        if (this.test[0] instanceof Updatable) {
            this.registerAsListener(this.test[0]);
        }
    }

    public LogicTest(String name, Testable test0, Testable test1) throws ComputationException {
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 2) {
            throw new ComputationException("LogicTestOperator " + name + " cannot be used in a binary context.");
        }
        this.test[0] = test0;
        this.test[1] = test1;
        this.updateListeners = null;
        this.stale = true;
        if (this.test[0] instanceof Updatable) {
            this.registerAsListener(this.test[0]);
        }
        if (this.test[1] instanceof Updatable) {
            this.registerAsListener(this.test[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws ComputationException {
        boolean state;
        boolean stale;
        LogicTest logicTest = this;
        synchronized (logicTest) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            state = this.state;
        }
        if (stale) {
            this.notifyListeners();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        LogicTest logicTest = this;
        synchronized (logicTest) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        String s1 = this.test[0].toString();
        String s2 = null;
        if (this.test[0] instanceof LogicTest) {
            s1 = String.format("(%s)", s1);
        }
        switch (this.op.arity()) {
            case 1: {
                sb.append(nameByOp.get((Object)this.op)).append(s1);
                break;
            }
            case 2: {
                s2 = this.test[1].toString();
                if (this.test[1] instanceof LogicTest) {
                    s2 = String.format("(%s)", s2);
                }
                sb.append(s1).append(" ").append(nameByOp.get((Object)this.op)).append(" ").append(s2);
            }
        }
        return sb.toString();
    }

    protected synchronized void compute() throws ComputationException {
        try {
            switch (this.op) {
                case NOT: {
                    this.state = !this.test[0].test();
                    break;
                }
                case AND: {
                    this.state = this.test[0].test() && this.test[1].test();
                    break;
                }
                case OR: {
                    this.state = this.test[0].test() || this.test[1].test();
                    break;
                }
                case XOR: {
                    this.state = this.test[0].test() ^ this.test[1].test();
                    break;
                }
                default: {
                    throw new ComputationException("Unexpected LogicTest operator: " + this.op);
                }
            }
            this.stale = false;
        }
        catch (Exception e) {
            throw new ComputationException(e);
        }
    }

    static {
        String[] aliases = null;
        for (Constants.LogicTestOperator op : Constants.LogicTestOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

