/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.MathOperation;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Util;
import hec.hecmath.computation.Value;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class MathExpression
implements Constants,
Evaluable {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;
    protected String inputText = null;
    protected Constants.Notation inputNotation = Constants.Notation.UNKNOWN;
    protected Evaluable expression = null;
    protected VariableSet variables = null;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();
    protected boolean stale = true;
    protected double result = 0.0;

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    public MathExpression() {
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
    }

    public MathExpression(String expr) throws ComputationException {
        this(expr, null);
    }

    public MathExpression(String expr, VariableSet variables) throws ComputationException {
        this();
        this.variables = variables == null ? new VariableSet() : variables;
        this.setMathExpression(expr);
    }

    @Override
    public synchronized boolean getTolerateUndefined() {
        return this.tolerateUndefined;
    }

    @Override
    public synchronized boolean getExceptionOnUndefined() {
        return this.exceptionOnUndefined;
    }

    @Override
    public synchronized boolean getAllowDenormal() {
        return this.allowDenormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTolerateUndefined(boolean setting) {
        boolean stale;
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            if (this.expression != null) {
                this.expression.setTolerateUndefined(setting);
            }
            if (!this.stale) {
                this.stale = setting != this.tolerateUndefined;
            }
            stale = this.stale;
            this.tolerateUndefined = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setExceptionOnUndefined(boolean setting) {
        boolean stale;
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            if (this.expression != null) {
                this.expression.setExceptionOnUndefined(setting);
            }
            if (!this.stale) {
                this.stale = setting != this.exceptionOnUndefined;
            }
            stale = this.stale;
            this.exceptionOnUndefined = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAllowDenormal(boolean setting) {
        boolean stale;
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            if (this.expression != null) {
                this.expression.setAllowDenormal(setting);
            }
            if (!this.stale) {
                this.stale = setting != this.allowDenormal;
            }
            stale = this.stale;
            this.allowDenormal = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    public synchronized VariableSet getVariables() {
        return this.variables;
    }

    public synchronized Constants.Notation getNotation() {
        return this.inputNotation;
    }

    public synchronized String getNotationName() {
        return this.inputNotation.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double evaluate() throws ComputationException {
        double result;
        boolean stale;
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            stale = this.stale;
            if (this.stale) {
                this.result = this.expression.evaluate();
                this.stale = false;
            }
            result = this.result;
        }
        if (stale) {
            this.notifyListeners();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            return Double.toString(this.evaluate());
        }
    }

    @Override
    public synchronized String toString() {
        String result = null;
        try {
            result = this.toNotation(this.inputNotation);
        }
        catch (ComputationException e) {
            result = this.inputText;
        }
        return result;
    }

    @Override
    public synchronized String toNotation(Constants.Notation notation) throws ComputationException {
        switch (notation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: 
            case INFIX: {
                return this.expression.toNotation(notation);
            }
        }
        throw new ComputationException("Invalid notation:" + notation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        MathExpression mathExpression = this;
        synchronized (mathExpression) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    protected void setMathExpression(String expr) throws ComputationException {
        if (expr == null) {
            throw new ComputationException("MathExpression must not be null.");
        }
        this.inputText = expr.trim();
        String[] parts = null;
        if (Value.isValue(this.inputText) || Variable.isVariableName(this.inputText)) {
            parts = new String[]{this.inputText};
            this.inputNotation = Constants.Notation.INFIX;
        } else if (this.inputText.length() > 2 && Variable.isVariableName(this.inputText.substring(1))) {
            if (this.inputText.startsWith("+")) {
                parts = new String[]{this.inputText.substring(1)};
                this.inputNotation = Constants.Notation.INFIX;
            } else if (this.inputText.startsWith("-")) {
                parts = new String[]{"neg", this.inputText.substring(1)};
                this.inputNotation = Constants.Notation.PREFIX;
            }
        }
        if (parts != null) {
            this.buildExpression(Arrays.asList(parts));
            return;
        }
        Util.validateBalancedBrackets(this.inputText);
        int paren_pos = this.inputText.indexOf(40);
        parts = this.inputText.replaceAll("\\(", " ").replaceAll("\\)", " ").trim().split("\\s+");
        if (MathOperation.isMathOperation(parts[0])) {
            if (paren_pos == 0) {
                this.inputNotation = Constants.Notation.S_EXPR;
            } else if (paren_pos == -1) {
                this.inputNotation = Constants.Notation.PREFIX;
            }
        } else if (MathOperation.isMathOperation(parts[parts.length - 1]) && paren_pos == -1) {
            this.inputNotation = Constants.Notation.POSTFIX;
        }
        switch (this.inputNotation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: {
                this.buildExpression(this.parseMathExpression(this.inputText, this.inputNotation));
                break;
            }
            default: {
                this.buildExpression(this.parseMathExpression(this.inputText, Constants.Notation.UNKNOWN));
            }
        }
    }

    protected List<String> parseMathExpression(String expr, Constants.Notation notation) throws ComputationException {
        int i;
        int i2;
        int i3;
        String variablePattern;
        String valuePattern;
        String originalEqn = expr;
        HashMap<String, Object> op_pattern = new HashMap<String, Object>();
        HashSet<String> func_ops = new HashSet<String>();
        HashSet<String> sub_ops = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        String groupingTokenPattern = "([\\(\\,\\)])";
        Set<String> ops = MathOperation.getNames();
        for (String op : ops) {
            if (Character.isLetter(op.charAt(0))) {
                func_ops.add(op);
                sb.setLength(0);
                sb.append("([\\W])(").append(op).append(")([\\W])");
                op_pattern.put(op, sb.toString());
            } else {
                sb.setLength(0);
                sb.append("(\\Q").append(op).append("\\E)");
                op_pattern.put(op, sb.toString());
            }
            for (String op2 : ops) {
                if (op2.equals(op) || op.indexOf(op2) == -1 || sub_ops.contains(op2)) continue;
                sub_ops.add(op2);
            }
        }
        if (notation == Constants.Notation.INFIX || notation == Constants.Notation.S_EXPR) {
            String other = new String(notation == Constants.Notation.INFIX ? "(,)" : "()");
            for (int i4 = 0; i4 < other.length(); ++i4) {
                String s = other.substring(i4, i4 + 1);
                op_pattern.put(s, "\\" + s);
            }
        }
        expr = Util.normalizeParentheses(originalEqn);
        expr = Util.reSub(expr, groupingTokenPattern, " $1 ");
        if (notation == Constants.Notation.INFIX) {
            valuePattern = "(^|[^$])(\\d+(\\.\\d+)?(\\s*([eE]\\s*[-+]?\\s*\\d+(\\.\\d+)?))?)";
            variablePattern = "(\\$\\w+)";
        } else {
            valuePattern = "(^|[^$])([-+]?\\d+(\\.\\d+)?(\\s*([eE]\\s*[-+]?\\s*\\d+(\\.\\d+)?))?)";
            variablePattern = "([-+]?\\$\\w+)";
        }
        expr = Util.reSub(expr, variablePattern, "{$1}");
        String[] parts = expr.split("[{}]");
        for (i3 = 0; i3 < parts.length; ++i3) {
            parts[i3] = Pattern.matches(variablePattern, parts[i3]) ? " {" + parts[i3] + "} " : Util.reSub(parts[i3], valuePattern, "$1 {$2} ");
        }
        parts = TextUtil.join(" ", parts).split("\\s+");
        for (i3 = 1; i3 < parts.length; ++i3) {
            Iterator tester;
            if (parts[i3].indexOf(123) == -1 || !ops.contains(tester = sb.replace(0, sb.length(), parts[i3 - 1]).append(parts[i3]).toString().replaceAll("(\\{|\\})", ""))) continue;
            parts[i3 - 1] = tester;
            parts[i3] = "";
        }
        expr = Util.join(" ", parts);
        sb.replace(0, sb.length(), "([\\W])(");
        boolean first = true;
        for (String op : op_pattern.keySet()) {
            if (!func_ops.contains(op) || sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(op);
        }
        sb.append(")([\\W])");
        expr = Util.reSub(expr, sb.toString(), "$1 $2 $3");
        first = true;
        sb.replace(0, sb.length(), "(\\Q");
        for (String op : op_pattern.keySet()) {
            if (func_ops.contains(op) || sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("\\E|\\Q");
            }
            sb.append(op);
        }
        sb.append("\\E)");
        expr = Util.reSub(expr, sb.toString(), " $1 ").trim();
        parts = expr.split("\\s+");
        sb.replace(0, sb.length(), "([\\W])(");
        first = true;
        for (String op : op_pattern.keySet()) {
            if (!func_ops.contains(op) || !sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(op);
        }
        sb.append(")([\\W])");
        for (int i5 = 0; i5 < parts.length; ++i5) {
            if (MathOperation.isMathOperation(parts[i5])) continue;
            parts[i5] = Util.reSub(parts[i5], sb.toString(), "$1 $2 $3");
        }
        first = true;
        sb.replace(0, sb.length(), "(\\Q");
        for (String op : op_pattern.keySet()) {
            if (func_ops.contains(op) || !sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("\\E|\\Q");
            }
            sb.append(op);
        }
        sb.append("\\E)");
        for (i2 = 0; i2 < parts.length; ++i2) {
            if (MathOperation.isMathOperation(parts[i2])) continue;
            parts[i2] = Util.reSub(parts[i2], sb.toString(), " $1 ");
        }
        parts = Util.join(" ", parts).trim().split("\\s+");
        if (notation == Constants.Notation.UNKNOWN) {
            if (parts.length < 2) {
                throw new ComputationException("Invalid expression: " + this.inputText);
            }
            if (MathOperation.isMathOperation(parts[parts.length - 1])) {
                this.inputNotation = Constants.Notation.POSTFIX;
            } else if (MathOperation.isMathOperation(parts[0])) {
                this.inputNotation = parts[1].equals("(") ? Constants.Notation.INFIX : Constants.Notation.PREFIX;
            } else if (!parts[0].equals("(")) {
                this.inputNotation = Constants.Notation.INFIX;
            } else {
                for (i2 = 1; i2 < parts.length; ++i2) {
                    if (!MathOperation.isMathOperation(parts[i2]) || parts[i2 - 1].equals("(")) continue;
                    notation = this.inputNotation = Constants.Notation.INFIX;
                    break;
                }
                if (notation == Constants.Notation.UNKNOWN) {
                    this.inputNotation = Constants.Notation.S_EXPR;
                }
            }
            return this.parseMathExpression(originalEqn, this.inputNotation);
        }
        switch (notation) {
            case INFIX: {
                for (i2 = parts.length - 2; i2 >= 0; --i2) {
                    if (!parts[i2].equals("+") && !parts[i2].equals("-") || i2 != 0 && !op_pattern.containsKey(parts[i2 - 1]) || i2 != 0 && parts[i2 - 1].equals(")")) continue;
                    if (parts[i2].equals("-")) {
                        parts[i2 + 1] = "-" + parts[i2 + 1];
                    }
                    parts[i2] = "";
                }
                break;
            }
            case POSTFIX: {
                block22: for (i2 = 1; i2 < parts.length; ++i2) {
                    if (!parts[i2 - 1].endsWith("{")) continue;
                    if (parts[i2].equals("+")) {
                        parts[i2] = "";
                        continue;
                    }
                    if (!parts[i2].equals("-")) continue;
                    parts[i2] = "";
                    for (int j = i2 + 1; j < parts.length; ++j) {
                        if (!parts[j].endsWith("}")) continue;
                        int n = j;
                        parts[n] = parts[n] + " neg ";
                        continue block22;
                    }
                }
                break;
            }
            case S_EXPR: 
            case PREFIX: {
                for (i2 = 1; i2 < parts.length; ++i2) {
                    if (!parts[i2 - 1].endsWith("{")) continue;
                    if (parts[i2].equals("+")) {
                        parts[i2] = "";
                        continue;
                    }
                    if (!parts[i2].equals("-")) continue;
                    parts[i2] = "";
                    parts[i2 - 1] = parts[i2 - 1].substring(0, parts[i2 - 1].length() - 1) + " neg {";
                }
                break;
            }
        }
        parts = Util.join(" ", parts).trim().split("\\s+");
        if (notation == Constants.Notation.INFIX) {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(parts));
            for (int i6 = l.size() - 2; i6 >= 0; --i6) {
                int j = i6 + 1;
                if (!parts[i6].endsWith(")") && !parts[i6].endsWith("}") || !parts[j].startsWith("(") && !parts[j].startsWith("{") && !func_ops.contains(parts[j])) continue;
                l.add(j, "*");
            }
            parts = new String[l.size()];
            l.toArray(parts);
        }
        parts = Util.join(" ", parts).trim().split("\\{");
        for (i = 1; i < parts.length; ++i) {
            String[] subParts = parts[i].split("\\}");
            subParts[0] = subParts[0].replaceAll("\\s", "");
            parts[i] = Util.join("", subParts);
        }
        parts = Util.join("", parts).trim().split("\\s+");
        switch (notation) {
            case POSTFIX: {
                for (i = 1; i < parts.length; ++i) {
                    if (!parts[i].equals("neg") || !Value.isValue(parts[i - 1])) continue;
                    parts[i] = "";
                    parts[i - 1] = "-" + parts[i - 1];
                }
                break;
            }
            case S_EXPR: 
            case PREFIX: {
                for (i = 1; i < parts.length; ++i) {
                    if (!parts[i - 1].equals("neg") || !Value.isValue(parts[i])) continue;
                    parts[i - 1] = "";
                    parts[i] = "-" + parts[i];
                }
                break;
            }
        }
        expr = Util.join(" ", parts).trim();
        if (notation == Constants.Notation.INFIX) {
            this.infixToPostfix(expr);
        }
        return new ArrayList<String>(Arrays.asList(expr.trim().split("\\s+")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildExpression(List<String> tokens) throws ComputationException {
        if (tokens.size() == 1) {
            String token = tokens.get(0);
            if (MathOperation.isMathOperation(token)) {
                if (MathOperation.arity(token) != 0) throw new ComputationException(MathOperation.arityName(token) + " operator " + token + " cannot have 0 arguments.");
                MathOperation op = new MathOperation(token, new Evaluable[]{null});
                op.setExceptionOnUndefined(this.exceptionOnUndefined);
                op.setTolerateUndefined(this.tolerateUndefined);
                op.setAllowDenormal(this.allowDenormal);
                this.expression = op;
            } else if (Variable.isVariableName(token)) {
                this.expression = this.variables.getVariable(token, true);
            } else {
                if (!Value.isValue(token)) throw new ComputationException("Invalid single token: " + token);
                this.expression = new Value(token);
            }
        } else {
            List<String> prefix = null;
            List<String> postfix = null;
            switch (this.inputNotation) {
                case S_EXPR: {
                    prefix = this.sexpToPrefix(tokens);
                    break;
                }
                case PREFIX: {
                    prefix = tokens;
                    break;
                }
                case POSTFIX: {
                    postfix = tokens;
                    break;
                }
                case INFIX: {
                    postfix = this.infixToPostfix(tokens);
                    break;
                }
            }
            if (postfix != null) {
                Stack<String> stack = new Stack<String>();
                stack.addAll(postfix);
                this.expression = this.makeOperationFromPostfix(stack);
            } else if (prefix != null) {
                this.expression = this.makeOperationFromPrefix(new LinkedList<String>(prefix));
            }
        }
        this.registerAsListener(this.expression);
    }

    protected MathOperation makeOperationFromPostfix(Stack<String> stack) throws ComputationException {
        MathOperation op = null;
        String oper = stack.pop();
        Evaluable[] args = null;
        int arity = MathOperation.arity(oper);
        int specific_arity = arity == -1 ? Integer.parseInt(stack.pop()) : arity;
        if (arity != 0) {
            args = new Evaluable[specific_arity];
        }
        for (int i = 0; i < specific_arity; ++i) {
            int j = specific_arity - i - 1;
            if (MathOperation.isMathOperation(stack.peek())) {
                if (MathOperation.arity(stack.peek()) == 0) {
                    op = new MathOperation(stack.pop(), new Evaluable[]{null});
                    op.setExceptionOnUndefined(this.exceptionOnUndefined);
                    op.setTolerateUndefined(this.tolerateUndefined);
                    op.setAllowDenormal(this.allowDenormal);
                    args[j] = op;
                    continue;
                }
                args[j] = this.makeOperationFromPostfix(stack);
                continue;
            }
            if (Variable.isVariableName(stack.peek())) {
                args[j] = this.variables.getVariable(stack.pop(), true);
                continue;
            }
            if (Value.isValue(stack.peek())) {
                args[j] = new Value(stack.pop());
                continue;
            }
            throw new ComputationException("Cannot parse item: " + stack.peek());
        }
        op = new MathOperation(oper, args);
        op.setExceptionOnUndefined(this.exceptionOnUndefined);
        op.setTolerateUndefined(this.tolerateUndefined);
        op.setAllowDenormal(this.allowDenormal);
        return op;
    }

    protected MathOperation makeOperationFromPrefix(Queue<String> queue) throws ComputationException {
        int specific_arity;
        MathOperation op = null;
        String oper = queue.remove();
        Evaluable[] args = null;
        int arity = MathOperation.arity(oper);
        int n = specific_arity = arity == -1 ? Integer.parseInt(queue.remove()) : arity;
        if (arity != 0) {
            args = new Evaluable[specific_arity];
        }
        for (int i = 0; i < specific_arity; ++i) {
            if (MathOperation.isMathOperation(queue.peek())) {
                if (MathOperation.arity(queue.peek()) == 0) {
                    op = new MathOperation(queue.remove(), new Evaluable[]{null});
                    op.setExceptionOnUndefined(this.exceptionOnUndefined);
                    op.setTolerateUndefined(this.tolerateUndefined);
                    op.setAllowDenormal(this.allowDenormal);
                    args[i] = op;
                    continue;
                }
                args[i] = this.makeOperationFromPrefix(queue);
                continue;
            }
            if (Variable.isVariableName(queue.peek())) {
                args[i] = this.variables.getVariable(queue.remove(), true);
                continue;
            }
            if (Value.isValue(queue.peek())) {
                args[i] = new Value(queue.remove());
                continue;
            }
            throw new ComputationException("Cannot parse item: " + queue.peek());
        }
        op = new MathOperation(oper, args);
        op.setExceptionOnUndefined(this.exceptionOnUndefined);
        op.setTolerateUndefined(this.tolerateUndefined);
        op.setAllowDenormal(this.allowDenormal);
        return op;
    }

    protected String sexpToPrefix(String sexp) throws ComputationException {
        if (sexp == null) {
            return null;
        }
        List<String> prefix = this.sexpToPrefix(Arrays.asList(Util.reSub(sexp, "(\\(|\\))", " $1 ").split("\\s+")));
        String[] arr = new String[prefix.size()];
        prefix.toArray(arr);
        return Util.join(" ", arr).trim();
    }

    protected List<String> sexpToPrefix(List<String> sexp) throws ComputationException {
        LinkedList<String> prefix = new LinkedList<String>();
        ListIterator<String> i = sexp.listIterator();
        block0: while (i.hasNext()) {
            String token = i.next();
            if (token.equals("(") || token.equals(")")) continue;
            prefix.offer(token);
            if (!MathOperation.isMathOperation(token) || MathOperation.arity(token) != -1) continue;
            int count = 0;
            int level = 1;
            ListIterator<String> j = sexp.listIterator(i.nextIndex());
            while (j.hasNext()) {
                String token2 = j.next();
                if (token2.equals("(")) {
                    ++level;
                } else if (token2.equals(")")) {
                    --level;
                }
                if (level == 1) {
                    ++count;
                    continue;
                }
                if (level != 0) continue;
                prefix.offer(String.valueOf(count));
                continue block0;
            }
        }
        return new ArrayList<String>(prefix);
    }

    protected String infixToPostfix(String infix) throws ComputationException {
        if (infix == null) {
            return null;
        }
        List<String> postfix = this.infixToPostfix(Arrays.asList(infix.split("\\s+")));
        String[] arr = new String[postfix.size()];
        postfix.toArray(arr);
        return Util.join(" ", arr).trim();
    }

    protected List<String> infixToPostfix(List<String> infix) throws ComputationException {
        String token;
        List<String> _infix = infix.get(0).equals("(") && infix.get(infix.size() - 1).equals(")") ? infix.subList(1, infix.size() - 1) : infix;
        LinkedList<String> postfix = new LinkedList<String>();
        Stack<String> stack = new Stack<String>();
        ListIterator<String> i = _infix.listIterator();
        String string = token = i.hasNext() ? i.next() : null;
        while (token != null) {
            if (token.equals("(")) {
                int arg_count = 0;
                String previous = "";
                if (i.previousIndex() > 1) {
                    previous = _infix.get(i.previousIndex() - 1);
                }
                if (MathOperation.isMathOperation(previous) && MathOperation.arity(previous) == -1) {
                    String token2;
                    arg_count = 1;
                    int level = 1;
                    ListIterator<String> j = _infix.listIterator(i.nextIndex());
                    while ((token2 = j.next()) != null) {
                        if (token2.equals("(")) {
                            ++level;
                            continue;
                        }
                        if (token2.equals(")")) {
                            if (--level != 0) continue;
                            break;
                        }
                        if (!token2.equals(",") || level != 1) continue;
                        ++arg_count;
                    }
                }
                stack.push(token);
                if (arg_count > 0) {
                    stack.push(Integer.toString(arg_count));
                }
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (token.equals(")")) {
                while (!((String)stack.peek()).equals("(")) {
                    postfix.offer((String)stack.pop());
                }
                stack.pop();
                if (stack.size() > 0 && MathOperation.isMathOperation((String)stack.peek()) && MathOperation.arity((String)stack.peek()) == -1) {
                    postfix.offer((String)stack.pop());
                }
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (token.equals(",")) {
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (MathOperation.isMathOperation(token) && MathOperation.arity(token) != 0) {
                if (stack.size() == 0 || !MathOperation.isMathOperation((String)stack.peek()) || MathOperation.precedence(token) > MathOperation.precedence((String)stack.peek())) {
                    stack.push(token);
                    token = i.next();
                    continue;
                }
                postfix.offer((String)stack.pop());
                continue;
            }
            if (token.startsWith("+")) {
                postfix.offer(token.substring(1));
            } else if (token.startsWith("-")) {
                if (Value.isValue(token.substring(1))) {
                    postfix.offer(token);
                } else {
                    postfix.offer(token.substring(1));
                    postfix.offer("neg");
                }
            } else {
                postfix.offer(token);
            }
            token = i.hasNext() ? i.next() : null;
        }
        while (stack.size() > 0) {
            postfix.offer((String)stack.pop());
        }
        return new ArrayList<String>(postfix);
    }

    public static void main(String[] args) throws ComputationException {
        String infix_input = "2$0$2-[2.1/sqrt(3.2)]*-$1+(-3.7e-12({5logn[13.0/2log10(+2.3)]}**(-1.3/2.7)))";
        String postfix_input = "2.0$0*$2*2.1 3.2sqrt/-$1*- -3.7E-12 5.0 13.0 2.0/2.3log10*log* -1.3 2.7/** *+";
        String prefix_input = "+ - * *2.0$0$2*/2.1sqrt3.2-$1*-3.7E-12** *5.0log*/13.0 2.0log10 2.3/-1.3 2.7";
        String sexp_input = "(+(-(*(*2.0 $0)$2)(*(/2.1 (sqrt3.2))-$1))(*-3.7E-12(**(*5.0(log(*(/13.0 2.0)(log10 2.3))))(/-1.3 2.7))))";
        String infix_result = "2.0 * $0 * $2 - 2.1 / sqrt(3.2) * -$1 + -3.7E-12 * (5.0 * log(13.0 / 2.0 * log10(2.3))) ** (-1.3 / 2.7)";
        String postfix_result = "2.0 $0 * $2 * 2.1 3.2 sqrt / $1 neg * - -3.7E-12 5.0 13.0 2.0 / 2.3 log10 * log * -1.3 2.7 / ** * +";
        String prefix_result = "+ - * * 2.0 $0 $2 * / 2.1 sqrt 3.2 neg $1 * -3.7E-12 ** * 5.0 log * / 13.0 2.0 log10 2.3 / -1.3 2.7";
        String sexp_result = "(+ (- (* (* 2.0 $0) $2) (* (/ 2.1 (sqrt 3.2)) (neg $1))) (* -3.7E-12 (** (* 5.0 (log (* (/ 13.0 2.0) (log10 2.3)))) (/ -1.3 2.7))))";
        String variable = "$TheVariable";
        String value = "2-12.29";
        MathExpression expr = null;
        String result = null;
        expr = new MathExpression(infix_input);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        result = expr.toNotation(Constants.Notation.S_EXPR);
        if (!result.equals(sexp_result)) {
            throw new ComputationException("Invalid s-exp result: [" + result + "]");
        }
        System.out.println("S-EXP   = " + result);
        result = expr.toNotation(Constants.Notation.PREFIX);
        if (!result.equals(prefix_result)) {
            throw new ComputationException("Invalid prefix result: [" + result + "]");
        }
        System.out.println("PREFIX  = " + result);
        result = expr.toNotation(Constants.Notation.POSTFIX);
        if (!result.equals(postfix_result)) {
            throw new ComputationException("Invalid postfix result: [" + result + "]");
        }
        System.out.println("POSTFIX = " + result);
        result = expr.toNotation(Constants.Notation.INFIX);
        if (!result.equals(infix_result)) {
            throw new ComputationException("Invalid infix result: [" + result + "]");
        }
        System.out.println("INFIX   = " + result);
        System.out.println();
        expr = new MathExpression(postfix_input);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        result = expr.toNotation(Constants.Notation.S_EXPR);
        if (!result.equals(sexp_result)) {
            throw new ComputationException("Invalid s-exp result: [" + result + "]");
        }
        System.out.println("S-EXP   = " + result);
        result = expr.toNotation(Constants.Notation.PREFIX);
        if (!result.equals(prefix_result)) {
            throw new ComputationException("Invalid prefix result: [" + result + "]");
        }
        System.out.println("PREFIX  = " + result);
        result = expr.toNotation(Constants.Notation.POSTFIX);
        if (!result.equals(postfix_result)) {
            throw new ComputationException("Invalid postfix result: [" + result + "]");
        }
        System.out.println("POSTFIX = " + result);
        result = expr.toNotation(Constants.Notation.INFIX);
        if (!result.equals(infix_result)) {
            throw new ComputationException("Invalid infix result: [" + result + "]");
        }
        System.out.println("INFIX   = " + result);
        System.out.println();
        expr = new MathExpression(prefix_input);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        result = expr.toNotation(Constants.Notation.S_EXPR);
        if (!result.equals(sexp_result)) {
            throw new ComputationException("Invalid s-exp result: [" + result + "]");
        }
        System.out.println("S-EXP   = " + result);
        result = expr.toNotation(Constants.Notation.PREFIX);
        if (!result.equals(prefix_result)) {
            throw new ComputationException("Invalid prefix result: [" + result + "]");
        }
        System.out.println("PREFIX  = " + result);
        result = expr.toNotation(Constants.Notation.POSTFIX);
        if (!result.equals(postfix_result)) {
            throw new ComputationException("Invalid postfix result: [" + result + "]");
        }
        System.out.println("POSTFIX = " + result);
        result = expr.toNotation(Constants.Notation.INFIX);
        if (!result.equals(infix_result)) {
            throw new ComputationException("Invalid infix result: [" + result + "]");
        }
        System.out.println("INFIX   = " + result);
        System.out.println();
        expr = new MathExpression(sexp_input);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        result = expr.toNotation(Constants.Notation.S_EXPR);
        if (!result.equals(sexp_result)) {
            throw new ComputationException("Invalid s-exp result: [" + result + "]");
        }
        System.out.println("S-EXP   = " + result);
        result = expr.toNotation(Constants.Notation.PREFIX);
        if (!result.equals(prefix_result)) {
            throw new ComputationException("Invalid prefix result: [" + result + "]");
        }
        System.out.println("PREFIX  = " + result);
        result = expr.toNotation(Constants.Notation.POSTFIX);
        if (!result.equals(postfix_result)) {
            throw new ComputationException("Invalid postfix result: [" + result + "]");
        }
        System.out.println("POSTFIX = " + result);
        result = expr.toNotation(Constants.Notation.INFIX);
        if (!result.equals(infix_result)) {
            throw new ComputationException("Invalid infix result: [" + result + "]");
        }
        System.out.println("INFIX   = " + result);
        System.out.println();
        expr = new MathExpression(variable);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        System.out.println("S-EXP   = " + expr.toNotation(Constants.Notation.S_EXPR));
        System.out.println("PREFIX  = " + expr.toNotation(Constants.Notation.PREFIX));
        System.out.println("POSTFIX = " + expr.toNotation(Constants.Notation.POSTFIX));
        System.out.println("INFIX   = " + expr.toNotation(Constants.Notation.INFIX));
        System.out.println();
        expr = new MathExpression(value);
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        System.out.println("S-EXP   = " + expr.toNotation(Constants.Notation.S_EXPR));
        System.out.println("PREFIX  = " + expr.toNotation(Constants.Notation.PREFIX));
        System.out.println("POSTFIX = " + expr.toNotation(Constants.Notation.POSTFIX));
        System.out.println("INFIX   = " + expr.toNotation(Constants.Notation.INFIX));
        System.out.println();
        expr = new MathExpression("sqrt(-1)");
        System.out.println("INPUT   = " + expr.toString());
        System.out.println("Input is in " + expr.getNotationName() + " notation");
        System.out.println("S-EXP   = " + expr.toNotation(Constants.Notation.S_EXPR));
        System.out.println("PREFIX  = " + expr.toNotation(Constants.Notation.PREFIX));
        System.out.println("POSTFIX = " + expr.toNotation(Constants.Notation.POSTFIX));
        System.out.println("INFIX   = " + expr.toNotation(Constants.Notation.INFIX));
        System.out.println();
        System.exit(0);
    }
}

