/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MathOperation
implements Constants,
Evaluable {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected static Map<Constants.MathOperator, String> nameByOp = new EnumMap<Constants.MathOperator, String>(Constants.MathOperator.class);
    protected static Map<String, Constants.MathOperator> opByName = new HashMap<String, Constants.MathOperator>();
    protected double value = 0.0;
    protected Constants.MathOperator op = null;
    protected boolean stale = true;
    protected Evaluable[] args = null;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isMathOperation(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static int arity(String name) {
        return opByName.get(name.toLowerCase()).arity();
    }

    public static int precedence(String name) {
        return opByName.get(name.toLowerCase()).precedence();
    }

    public static String arityName(String name) {
        Constants.MathOperator op = opByName.get(name);
        switch (op.arity()) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "UNARY";
            }
            case 2: {
                return "BINARY";
            }
            case 3: {
                return "TERNARY";
            }
            case -1: {
                return "VARIADIC";
            }
        }
        return op.arity() + "-ARY";
    }

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    protected static double quantile(Evaluable[] l, int subsets, int position, boolean exceptionOnUndefined, boolean tolerateUndefined) throws ComputationException {
        int index;
        double fraction;
        double scaledFraction;
        double value = -3.4028234663852886E38;
        ArrayList<Double> values = new ArrayList<Double>();
        for (Evaluable e : l) {
            if (e.evaluate() == -3.4028234663852886E38) {
                if (exceptionOnUndefined) {
                    throw new ComputationException("Quantile computation encounterd an undefined argument.");
                }
                if (tolerateUndefined) continue;
                return value;
            }
            values.add(e.evaluate());
        }
        Collections.sort(values);
        int count = values.size();
        if (subsets < 2) {
            throw new ComputationException("Invalid subset count for quantile: " + subsets + ", must be two or more.");
        }
        if (position < 0 || position > subsets) {
            throw new ComputationException("Invalid position for " + subsets + "-quantile: " + position + ", must be 0 to " + subsets);
        }
        value = position == 0 ? (Double)values.get(0) : (position == subsets ? (Double)values.get(count - 1) : ((int)(scaledFraction = (double)count * (fraction = (double)position / (double)subsets)) == (index = (int)Math.ceil(scaledFraction)) && count % 2 == 0 ? (Double)values.get(index) - ((Double)values.get(index) - (Double)values.get(index - 1)) * fraction : (Double)values.get(index - 1)));
        return value;
    }

    protected static double mode(Evaluable[] l, boolean exceptionOnUndefined, boolean tolerateUndefined) throws ComputationException {
        double mode = -3.4028234663852886E38;
        int maxOccurrences = 0;
        HashMap<Double, Integer> valueMap = new HashMap<Double, Integer>();
        for (Evaluable e : l) {
            if (e.evaluate() == -3.4028234663852886E38) {
                if (exceptionOnUndefined) {
                    throw new ComputationException("Mode computation encounterd an undefined argument.");
                }
                if (tolerateUndefined) continue;
                return mode;
            }
            double key = e.evaluate();
            int occurrences = valueMap.containsKey(key) ? (Integer)valueMap.get(key) + 1 : 1;
            valueMap.put(key, occurrences);
            if (occurrences <= maxOccurrences) continue;
            mode = key;
            maxOccurrences = occurrences;
        }
        return mode;
    }

    public MathOperation(String name, List<? extends Evaluable> args) throws ComputationException {
        this(name, true, args);
    }

    public MathOperation(String name, Evaluable ... args) throws ComputationException {
        this(name, true, args);
    }

    public MathOperation(Constants.MathOperator op, List<? extends Evaluable> args) throws ComputationException {
        this(op, true, args);
    }

    public MathOperation(Constants.MathOperator op, Evaluable ... args) throws ComputationException {
        this(op, true, args);
    }

    public MathOperation(String name, boolean persistent, List<? extends Evaluable> args) throws ComputationException {
        this(name, persistent, args.toArray(new Evaluable[0]));
    }

    public MathOperation(String name, boolean persistent, Evaluable ... args) throws ComputationException {
        this(opByName.get(name.toLowerCase()), persistent, args);
    }

    public MathOperation(Constants.MathOperator op, boolean persistent, List<? extends Evaluable> args) throws ComputationException {
        this(op, persistent, args.toArray(new Evaluable[0]));
    }

    public MathOperation(Constants.MathOperator op, boolean persistent, Evaluable ... args) throws ComputationException {
        int argCount;
        if (op == null) {
            throw new ComputationException("Operator must not be null");
        }
        int n = argCount = args == null ? 0 : args.length;
        if (op.arity() != -1 && argCount != op.arity()) {
            throw new ComputationException("Expected " + op.arity() + " arguments for operator '" + op.opname() + "', received " + argCount + ".");
        }
        this.op = op;
        this.args = args;
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
        switch (op) {
            case E: {
                if (args != null && args.length > 0) {
                    throw new ComputationException("Arguments specified for math operator E (constant)");
                }
                this.value = Math.E;
                this.stale = false;
                break;
            }
            case PI: {
                if (args != null && args.length > 0) {
                    throw new ComputationException("Arguments specified for math operator PI (constant)");
                }
                this.value = Math.PI;
                this.stale = false;
                break;
            }
        }
        if (persistent) {
            for (Evaluable arg : args) {
                this.registerAsListener(arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    public synchronized String getName() {
        return this.op.opname();
    }

    public synchronized int getPrecedence() {
        return this.op.precedence();
    }

    public synchronized boolean isStale() {
        return this.stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double evaluate() throws ComputationException {
        double value;
        boolean stale;
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            value = this.value;
        }
        if (stale) {
            this.notifyListeners();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            return Double.toString(this.evaluate());
        }
    }

    @Override
    public synchronized boolean getTolerateUndefined() {
        return this.tolerateUndefined;
    }

    @Override
    public synchronized boolean getExceptionOnUndefined() {
        return this.exceptionOnUndefined;
    }

    @Override
    public synchronized boolean getAllowDenormal() {
        return this.allowDenormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTolerateUndefined(boolean setting) {
        boolean stale;
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            if (this.args != null) {
                for (Evaluable arg : this.args) {
                    arg.setTolerateUndefined(setting);
                }
            }
            if (!this.stale) {
                this.stale = setting != this.tolerateUndefined;
            }
            stale = this.stale;
            this.tolerateUndefined = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setExceptionOnUndefined(boolean setting) {
        boolean stale;
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            if (this.args != null) {
                for (Evaluable arg : this.args) {
                    arg.setExceptionOnUndefined(setting);
                }
            }
            if (!this.stale) {
                this.stale = setting != this.exceptionOnUndefined;
            }
            stale = this.stale;
            this.exceptionOnUndefined = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAllowDenormal(boolean setting) {
        boolean stale;
        MathOperation mathOperation = this;
        synchronized (mathOperation) {
            if (this.args != null) {
                for (Evaluable arg : this.args) {
                    arg.setAllowDenormal(setting);
                }
            }
            if (!this.stale) {
                this.stale = setting != this.allowDenormal;
            }
            stale = this.stale;
            this.allowDenormal = setting;
        }
        if (stale) {
            this.notifyListeners();
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.op.opname());
        if (this.args != null) {
            sb.append(" (");
            boolean first = true;
            for (Evaluable arg : this.args) {
                if (!first) {
                    sb.append(" ");
                } else {
                    first = false;
                }
                sb.append(arg.toString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public synchronized String toNotation(Constants.Notation notation) throws ComputationException {
        StringBuffer sb = new StringBuffer();
        boolean isVariadic = this.op.arity() == -1;
        boolean isBinary = this.op.arity() == 2;
        int specific_arity = isVariadic ? this.args.length : this.op.arity();
        switch (notation) {
            case S_EXPR: {
                if (this.args == null) {
                    sb.append(" ").append(this.op.opname());
                    break;
                }
                sb.append(" (").append(this.op.opname());
                for (Evaluable arg : this.args) {
                    sb.append(" ").append(arg.toNotation(notation));
                }
                sb.append(")");
                break;
            }
            case PREFIX: {
                sb.append(" ").append(this.op.opname());
                if (isVariadic) {
                    sb.append(" ").append(specific_arity);
                }
                for (Evaluable arg : this.args) {
                    sb.append(" ").append(arg.toNotation(notation));
                }
                break;
            }
            case POSTFIX: {
                for (Evaluable arg : this.args) {
                    sb.append(" ").append(arg.toNotation(notation));
                }
                if (isVariadic) {
                    sb.append(" ").append(specific_arity);
                }
                sb.append(" ").append(this.op.opname());
                break;
            }
            case INFIX: {
                if (isBinary && !Character.isLetter(this.op.opname().charAt(0))) {
                    if (this.args[0] instanceof MathOperation && ((MathOperation)this.args[0]).getPrecedence() < this.op.precedence()) {
                        sb.append(" (").append(this.args[0].toNotation(notation)).append(")");
                    } else {
                        sb.append(" ").append(this.args[0].toNotation(notation));
                    }
                    sb.append(" ").append(this.op.opname());
                    if (this.args[1] instanceof MathOperation && ((MathOperation)this.args[1]).getPrecedence() < this.op.precedence()) {
                        sb.append(" (").append(this.args[1].toNotation(notation)).append(")");
                        break;
                    }
                    sb.append(" ").append(this.args[1].toNotation(notation));
                    break;
                }
                if (this.op.opname().equals("neg")) {
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append("-").append(this.args[0].toNotation(notation));
                    if (Character.isWhitespace(sb2.charAt(1))) {
                        sb.delete(1, 2);
                    }
                    sb.append(sb2);
                    break;
                }
                sb.append(" ").append(this.op.opname()).append("(");
                boolean first = true;
                for (Evaluable arg : this.args) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(arg.toNotation(notation));
                }
                sb.append(")");
                break;
            }
            default: {
                throw new ComputationException("Invalid notation:" + notation);
            }
        }
        return sb.toString().trim().replaceAll("\\s+", " ");
    }

    protected synchronized void compute() throws ComputationException {
        switch (this.op) {
            case ADDITION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 + arg1;
                break;
            }
            case SUBTRACTION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 - arg1;
                break;
            }
            case MULTIPLICATION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 * arg1;
                break;
            }
            case DIVISION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 / arg1;
                break;
            }
            case INTEGER_DIVISION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 / arg1;
                if (Double.isInfinite(this.value) || Double.isNaN(this.value)) break;
                this.value = this.value < 0.0 ? Math.ceil(this.value) : Math.floor(this.value);
                break;
            }
            case MODULO: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 % arg1;
                break;
            }
            case EXPONENTIATION: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.pow(arg0, arg1);
                break;
            }
            case ABS: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.abs(arg0);
                break;
            }
            case NEG: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = -arg0;
                break;
            }
            case INV: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 == 0.0 ? -3.4028234663852886E38 : 1.0 / arg0;
                break;
            }
            case SIGN: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 < 0.0 ? -1.0 : (arg0 == 0.0 ? 0.0 : 1.0);
                break;
            }
            case SQRT: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.sqrt(arg0);
                break;
            }
            case EXP: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.exp(arg0);
                break;
            }
            case LOG: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.log(arg0);
                break;
            }
            case LOG10: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.log(arg0) / Math.log(10.0);
                break;
            }
            case SIN: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.sin(arg0);
                break;
            }
            case COS: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.cos(arg0);
                break;
            }
            case TAN: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.tan(arg0);
                break;
            }
            case ASIN: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.asin(arg0);
                break;
            }
            case ACOS: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.acos(arg0);
                break;
            }
            case ATAN: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.atan(arg0);
                break;
            }
            case FLOOR: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.floor(arg0);
                break;
            }
            case CEIL: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.ceil(arg0);
                break;
            }
            case ROUND: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.rint(arg0);
                break;
            }
            case TRUNC: {
                double arg0 = this.args[0].evaluate();
                if (arg0 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = arg0 > 0.0 ? Math.floor(arg0) : Math.ceil(arg0);
                break;
            }
            case FMOD: {
                double arg0 = this.args[0].evaluate();
                double arg1 = this.args[1].evaluate();
                if (arg0 == -3.4028234663852886E38 || arg1 == -3.4028234663852886E38) {
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    this.value = -3.4028234663852886E38;
                    break;
                }
                this.value = Math.IEEEremainder(arg0, arg1);
                break;
            }
            case COUNT: {
                this.value = this.args.length;
                break;
            }
            case SUM: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? sum : -3.4028234663852886E38;
                break;
            }
            case PROD: {
                double prod = 1.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        prod *= argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? prod : -3.4028234663852886E38;
                break;
            }
            case MIN: {
                double _min = Double.MAX_VALUE;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        if (!(argval < _min)) continue;
                        _min = argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? _min : -3.4028234663852886E38;
                break;
            }
            case MAX: {
                double _max = Double.NEGATIVE_INFINITY;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        if (!(argval > _max)) continue;
                        _max = argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? _max : -3.4028234663852886E38;
                break;
            }
            case MEAN: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? sum / (double)count : -3.4028234663852886E38;
                break;
            }
            case GMEAN: {
                double prod = 1.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        prod *= argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? Math.pow(prod, 1.0 / (double)count) : -3.4028234663852886E38;
                break;
            }
            case HMEAN: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += 1.0 / argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? (double)count / sum : -3.4028234663852886E38;
                break;
            }
            case RMS: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval * argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                this.value = count > 0 ? Math.sqrt(sum / (double)count) : -3.4028234663852886E38;
                break;
            }
            case VAR: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                if (count > 0) {
                    double mean = sum / (double)count;
                    sum = 0.0;
                    for (Evaluable arg : this.args) {
                        double argval = arg.evaluate();
                        if (argval == -3.4028234663852886E38) continue;
                        double diff = argval - mean;
                        sum += diff * diff;
                    }
                    this.value = sum / (double)count;
                    break;
                }
                this.value = -3.4028234663852886E38;
                break;
            }
            case STDEV: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                if (count > 1) {
                    double mean = sum / (double)count;
                    sum = 0.0;
                    for (Evaluable arg : this.args) {
                        double argval = arg.evaluate();
                        if (argval == -3.4028234663852886E38) continue;
                        double diff = argval - mean;
                        sum += diff * diff;
                    }
                    this.value = Math.sqrt(sum / (double)(count - 1));
                    break;
                }
                this.value = -3.4028234663852886E38;
                break;
            }
            case SKEW: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                if (count > 2) {
                    double dcount = count;
                    double mean = sum / dcount;
                    double sum2 = 0.0;
                    double sum3 = 0.0;
                    for (Evaluable arg : this.args) {
                        double argval = arg.evaluate();
                        if (argval == -3.4028234663852886E38) continue;
                        double diff = argval - mean;
                        sum2 += diff * diff;
                        sum3 += diff * diff * diff;
                    }
                    double stdev = Math.sqrt(sum2 / (dcount - 1.0));
                    double k3 = dcount * sum3 / ((dcount - 1.0) * (dcount - 2.0));
                    this.value = k3 / Math.pow(stdev, 3.0);
                    break;
                }
                this.value = -3.4028234663852886E38;
                break;
            }
            case KURT: {
                double sum = 0.0;
                int count = 0;
                for (Evaluable arg : this.args) {
                    double argval = arg.evaluate();
                    if (argval != -3.4028234663852886E38) {
                        ++count;
                        sum += argval;
                        continue;
                    }
                    if (this.exceptionOnUndefined) {
                        throw new ComputationException("MathOperator " + this.op.opname() + " encounterd an undefined argument.");
                    }
                    if (this.tolerateUndefined) continue;
                    count = 0;
                    break;
                }
                if (count > 3) {
                    double dcount = count;
                    double mean = sum / dcount;
                    double sum2 = 0.0;
                    double sum4 = 0.0;
                    for (Evaluable arg : this.args) {
                        double argval = arg.evaluate();
                        if (argval == -3.4028234663852886E38) continue;
                        double diff = argval - mean;
                        sum2 += diff * diff;
                        sum4 += diff * diff * diff * diff;
                    }
                    double k2 = sum2 / (dcount - 1.0);
                    double k4 = (dcount * (dcount + 1.0) * sum4 / (dcount - 1.0) - 3.0 * sum2 * sum2) / ((dcount - 2.0) * (dcount - 3.0));
                    this.value = k4 / (k2 * k2);
                    break;
                }
                this.value = -3.4028234663852886E38;
                break;
            }
            case MODE: {
                this.value = MathOperation.mode(this.args, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case MED: {
                this.value = MathOperation.quantile(this.args, 2, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P1: {
                this.value = MathOperation.quantile(this.args, 100, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P2: {
                this.value = MathOperation.quantile(this.args, 50, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P5: {
                this.value = MathOperation.quantile(this.args, 20, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P10: {
                this.value = MathOperation.quantile(this.args, 10, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P20: {
                this.value = MathOperation.quantile(this.args, 5, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P25: {
                this.value = MathOperation.quantile(this.args, 4, 1, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P75: {
                this.value = MathOperation.quantile(this.args, 4, 3, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P80: {
                this.value = MathOperation.quantile(this.args, 5, 4, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P90: {
                this.value = MathOperation.quantile(this.args, 10, 9, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P95: {
                this.value = MathOperation.quantile(this.args, 20, 19, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P98: {
                this.value = MathOperation.quantile(this.args, 50, 49, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
            case P99: {
                this.value = MathOperation.quantile(this.args, 100, 99, this.exceptionOnUndefined, this.tolerateUndefined);
                break;
            }
        }
        if (!this.allowDenormal && (Double.isInfinite(this.value) || Double.isNaN(this.value))) {
            this.value = -3.4028234663852886E38;
        }
        if (this.exceptionOnUndefined && this.value == -3.4028234663852886E38) {
            throw new ComputationException("MathOperator " + this.op.opname() + " generated an undefined result.");
        }
        this.stale = false;
    }

    static {
        String[] aliases = null;
        for (Constants.MathOperator op : Constants.MathOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

