/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.data.tx.QualityTx;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QualityOperation
implements Constants,
Updatable,
UpdatableListener {
    protected static Map<Constants.QualityOperator, String> nameByOp = new EnumMap<Constants.QualityOperator, String>(Constants.QualityOperator.class);
    protected static Map<String, Constants.QualityOperator> opByName = new HashMap<String, Constants.QualityOperator>();
    protected int quality;
    protected Constants.QualityOperator op;
    protected Variable var;
    protected boolean stale;
    protected Set<UpdatableListener> updateListeners;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources;
    protected Object updateSourcesLock = new Object();
    protected VariableSet variables = null;

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isQualityOperation(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public QualityOperation(String name, VariableSet variables, String var) throws ComputationException {
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        this.variables = variables == null ? new VariableSet() : variables;
        this.var = this.variables.getVariable(var, true);
        variables.setRequiresTsc(var);
        this.quality = 0;
        this.updateListeners = null;
        this.stale = true;
        this.var.registerListener(this);
    }

    public synchronized int operate() throws ComputationException {
        if (this.stale) {
            this.compute();
        }
        return this.quality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        QualityOperation qualityOperation = this;
        synchronized (qualityOperation) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(nameByOp.get((Object)this.op)).append("(").append(this.var.toString()).append(")");
        return sb.toString();
    }

    protected synchronized void compute() throws ComputationException {
        try {
            int oldQuality = this.var.hasQuality() ? this.var.getQuality() : 0;
            switch (this.op) {
                case Q_SET_CLEAR: {
                    this.quality = QualityTx.clearQuality_int(oldQuality);
                    break;
                }
                case Q_SET_OK: {
                    this.quality = QualityTx.setOkay_int(oldQuality);
                    break;
                }
                case Q_SET_Q: {
                    this.quality = QualityTx.setQuestion_int(oldQuality);
                    break;
                }
                case Q_SET_R: {
                    this.quality = QualityTx.setReject_int(oldQuality);
                    break;
                }
                case Q_SET_M: {
                    this.quality = QualityTx.setMissing_int(oldQuality);
                    break;
                }
                case Q_SET_P: {
                    this.quality = QualityTx.setProtected_int(oldQuality);
                    break;
                }
                default: {
                    throw new ComputationException("Unexpected QualityOperation operator: " + this.op);
                }
            }
            this.stale = false;
        }
        catch (Exception e) {
            throw new ComputationException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        VariableSet vars = new VariableSet();
        for (Constants.QualityOperator op : Constants.QualityOperator.values()) {
            System.out.println(op.toString());
        }
        for (String name : opByName.keySet()) {
            System.out.println(name);
        }
        Variable var = new Variable("test", 0.0, 0);
        vars.addVariable(var);
        QualityOperation qop = new QualityOperation("q-set-r", vars, "test");
        System.out.println(qop.toString() + ": " + qop.operate());
        for (int i = 0; i < 32; ++i) {
            var.setQuality(1 << i);
            System.out.print(i + " : " + var.getQuality() + " : ");
            System.out.println("" + qop.operate());
        }
        System.out.println("" + qop.operate());
    }

    static {
        String[] aliases = null;
        for (Constants.QualityOperator op : Constants.QualityOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

