/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.data.tx.QualityTx;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Testable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QualityTest
implements Constants,
Testable {
    protected static String defaultQualityOrder = "POQ-RM";
    protected static Map<Constants.QualityTestOperator, String> nameByOp = new EnumMap<Constants.QualityTestOperator, String>(Constants.QualityTestOperator.class);
    protected static Map<String, Constants.QualityTestOperator> opByName = new HashMap<String, Constants.QualityTestOperator>();
    protected boolean state;
    protected Constants.QualityTestOperator op;
    protected Variable[] var = new Variable[]{null, null};
    protected boolean stale;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources;
    protected Object updateSourcesLock = new Object();
    protected VariableSet variables = null;

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isQualityTest(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static int arity(String name) throws ComputationException {
        Constants.QualityTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.arity();
    }

    public static int precedence(String name) throws ComputationException {
        Constants.QualityTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.precedence();
    }

    public static String getQualityCompareOrder() {
        return defaultQualityOrder;
    }

    protected static void verifyQualityCompareOrder(String order) throws ComputationException {
        if (order == null) {
            throw new ComputationException("Quality sort order must not be null.");
        }
        String msg = "Quality sort order must contain exactly one each of P,O,Q,R,M,-";
        if (order.length() != 6) {
            throw new ComputationException(msg);
        }
        boolean p = false;
        boolean o = false;
        boolean q = false;
        boolean r = false;
        boolean u = false;
        boolean m = false;
        order = order.toUpperCase();
        block8: for (int i = 0; i < order.length(); ++i) {
            switch (order.charAt(i)) {
                case 'P': {
                    if (p) {
                        throw new ComputationException(msg);
                    }
                    p = true;
                    continue block8;
                }
                case 'O': {
                    if (o) {
                        throw new ComputationException(msg);
                    }
                    o = true;
                    continue block8;
                }
                case 'Q': {
                    if (q) {
                        throw new ComputationException(msg);
                    }
                    q = true;
                    continue block8;
                }
                case '-': {
                    if (u) {
                        throw new ComputationException(msg);
                    }
                    u = true;
                    continue block8;
                }
                case 'R': {
                    if (r) {
                        throw new ComputationException(msg);
                    }
                    r = true;
                    continue block8;
                }
                case 'M': {
                    if (m) {
                        throw new ComputationException(msg);
                    }
                    m = true;
                    continue block8;
                }
                default: {
                    throw new ComputationException(msg);
                }
            }
        }
    }

    public static void setDefaultQualityCompareOrder(String qualityOrder) throws ComputationException {
        QualityTest.verifyQualityCompareOrder(qualityOrder);
        defaultQualityOrder = qualityOrder.toUpperCase();
    }

    public static int compareQuality(Variable var0, Variable var1) throws ComputationException {
        return QualityTest.compareQuality(var0.getQuality(), var1.getQuality(), defaultQualityOrder);
    }

    public static int compareQuality(Variable var0, Variable var1, String qualityOrder) throws ComputationException {
        return QualityTest.compareQuality(var0.getQuality(), var1.getQuality(), qualityOrder);
    }

    public static int compareQuality(int q0, int q1) throws ComputationException {
        return QualityTest.compareQuality(q0, q0, defaultQualityOrder);
    }

    public static int compareQuality(int q0, int q1, String qualityOrder) throws ComputationException {
        QualityTest.verifyQualityCompareOrder(qualityOrder);
        block8: for (int i = 0; i < qualityOrder.length(); ++i) {
            switch (qualityOrder.charAt(i)) {
                case 'P': {
                    if (QualityTx.isProtected_int(q0)) {
                        return QualityTx.isProtected_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isProtected_int(q1)) continue block8;
                    return -1;
                }
                case 'A': {
                    if (QualityTx.isOkay_int(q0)) {
                        return QualityTx.isOkay_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isOkay_int(q1)) continue block8;
                    return -1;
                }
                case 'Q': {
                    if (QualityTx.isQuestion_int(q0)) {
                        return QualityTx.isQuestion_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isQuestion_int(q1)) continue block8;
                    return -1;
                }
                case '-': {
                    if (QualityTx.isQualityClear_int(q0)) {
                        return QualityTx.isQualityClear_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isQualityClear_int(q1)) continue block8;
                    return -1;
                }
                case 'R': {
                    if (QualityTx.isReject_int(q0)) {
                        return QualityTx.isReject_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isReject_int(q1)) continue block8;
                    return -1;
                }
                case 'M': {
                    if (QualityTx.isMissing_int(q0)) {
                        return QualityTx.isMissing_int(q1) ? 0 : 1;
                    }
                    if (!QualityTx.isMissing_int(q1)) continue block8;
                    return -1;
                }
            }
        }
        return 0;
    }

    public QualityTest(String name, VariableSet variables, String var0) throws ComputationException {
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 1) {
            throw new ComputationException("QualityTestOperator " + name + " cannot be used in a unary context.");
        }
        this.variables = variables == null ? new VariableSet() : variables;
        this.var[0] = this.variables.getVariable(var0, true);
        variables.setRequiresTsc(var0);
        this.updateListeners = null;
        this.stale = true;
        this.registerAsListener(this.var[0]);
    }

    public QualityTest(String name, VariableSet variables, String var0, String var1) throws ComputationException {
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 2) {
            throw new ComputationException("QualityTestOperator " + name + " cannot be used in a binary context.");
        }
        this.variables = variables == null ? new VariableSet() : variables;
        this.var[0] = this.variables.getVariable(var0, true);
        this.var[1] = this.variables.getVariable(var1, true);
        variables.setRequiresTsc(var0);
        variables.setRequiresTsc(var1);
        this.updateListeners = null;
        this.stale = true;
        this.registerAsListener(this.var[0]);
        this.registerAsListener(this.var[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws ComputationException {
        boolean state;
        boolean stale;
        QualityTest qualityTest = this;
        synchronized (qualityTest) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            state = this.state;
        }
        if (stale) {
            this.notifyListeners();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        QualityTest qualityTest = this;
        synchronized (qualityTest) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.op.arity()) {
            case 1: {
                sb.append(nameByOp.get((Object)this.op)).append("(").append(this.var[0].toString()).append(")");
                break;
            }
            case 2: {
                sb.append("(").append(this.var[0].toString()).append(")").append(" ").append(nameByOp.get((Object)this.op)).append(" ").append("(").append(this.var[1].toString()).append(")");
            }
        }
        return sb.toString();
    }

    protected synchronized void compute() throws ComputationException {
        try {
            switch (this.op) {
                case Q_IS_CLEAR: {
                    this.state = QualityTx.isQualityClear_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_OK: {
                    this.state = QualityTx.isOkay_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_Q: {
                    this.state = QualityTx.isQuestion_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_R: {
                    this.state = QualityTx.isReject_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_M: {
                    this.state = QualityTx.isMissing_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_P: {
                    this.state = QualityTx.isProtected_int(this.var[0].getQuality());
                    break;
                }
                case Q_IS_S: {
                    this.state = QualityTx.isScreened_int(this.var[0].getQuality());
                    break;
                }
                case Q_LT: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) < 0;
                    break;
                }
                case Q_LE: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) < 1;
                    break;
                }
                case Q_GT: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) > 0;
                    break;
                }
                case Q_GE: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) > -1;
                    break;
                }
                case Q_EQ: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) == 0;
                    break;
                }
                case Q_NE: {
                    this.state = QualityTest.compareQuality(this.var[0], this.var[1]) != 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected QualityTest operator: " + this.op);
                }
            }
            this.stale = false;
        }
        catch (Exception e) {
            throw new ComputationException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        VariableSet vars = new VariableSet();
        for (Constants.QualityTestOperator op : Constants.QualityTestOperator.values()) {
            System.out.println(op.toString());
        }
        for (String name : opByName.keySet()) {
            System.out.println(name);
        }
        Variable var0 = new Variable("test1", 0.0, 0);
        Variable var1 = new Variable("test2", 0.0, 3);
        vars.addVariable(var0);
        vars.addVariable(var1);
        QualityTest qtst = new QualityTest("S?", vars, var0.getName());
        System.out.println(qtst.toString() + ": " + qtst.test());
        for (int i = 0; i < 32; ++i) {
            var0.setQuality(1 << i);
            System.out.print(i + " : " + var0.getQuality() + " : ");
            System.out.println("" + qtst.test());
        }
        System.out.println("" + qtst.test());
        qtst.unregisterAsListener();
        var0.setQuality(0);
        for (String name : opByName.keySet()) {
            if (QualityTest.arity(name) != 2) continue;
            qtst = new QualityTest(name, vars, "test1", "test2");
            System.out.println(qtst.toString() + ": " + qtst.test());
            qtst.unregisterAsListener();
        }
    }

    static {
        String[] aliases = null;
        for (Constants.QualityTestOperator op : Constants.QualityTestOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

