/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Setable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.HashSet;
import java.util.Set;

public class Text
implements Comparable<Text>,
Evaluable,
Setable {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected String value = null;
    protected boolean isSet = false;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;

    public Text() {
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
    }

    public Text(String value) throws ComputationException {
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    @Override
    public void dataUpdated(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void registerAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener() {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(double value) throws ComputationException {
        Text text = this;
        synchronized (text) {
            this.value = String.valueOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int value) throws ComputationException {
        Text text = this;
        synchronized (text) {
            this.value = String.valueOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Double value) throws ComputationException {
        Text text = this;
        synchronized (text) {
            this.value = value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Integer value) throws ComputationException {
        Text text = this;
        synchronized (text) {
            this.value = value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String value) throws ComputationException {
        Text text = this;
        synchronized (text) {
            this.value = value;
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double evaluate() throws ComputationException {
        Text text = this;
        synchronized (text) {
            return Double.parseDouble(this.toString());
        }
    }

    @Override
    public String evaluateToString() throws ComputationException {
        return this.toString();
    }

    @Override
    public String toNotation(Constants.Notation notation) throws ComputationException {
        if (this.value.indexOf(32) != -1 || this.value.indexOf(9) != -1) {
            if (this.value.indexOf(34) != -1) {
                return "'" + this.value + "'";
            }
            return "\"" + this.value + "\"";
        }
        if (this.value.indexOf(34) != -1) {
            return "'" + this.value + "'";
        }
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTolerateUndefined() {
        Text text = this;
        synchronized (text) {
            return this.tolerateUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTolerateUndefined(boolean setting) {
        Text text = this;
        synchronized (text) {
            this.tolerateUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getExceptionOnUndefined() {
        Text text = this;
        synchronized (text) {
            return this.exceptionOnUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExceptionOnUndefined(boolean setting) {
        Text text = this;
        synchronized (text) {
            this.exceptionOnUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAllowDenormal() {
        Text text = this;
        synchronized (text) {
            return this.allowDenormal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllowDenormal(boolean setting) {
        Text text = this;
        synchronized (text) {
            this.allowDenormal = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(Text o) {
        Text text = this;
        synchronized (text) {
            return this.value.compareTo(o.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Text text = this;
        synchronized (text) {
            int hashCode = this.getClass().getName().hashCode();
            if (this.value != null) {
                hashCode += this.value.hashCode();
            }
            if (this.allowDenormal) {
                hashCode += 3;
            }
            if (this.exceptionOnUndefined) {
                hashCode += 5;
            }
            if (this.tolerateUndefined) {
                hashCode += 7;
            }
            return hashCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Text text = this;
        synchronized (text) {
            boolean equals = obj instanceof Text;
            if (equals) {
                equals = this.value.equals(((Text)obj).value);
            }
            if (equals) {
                boolean bl = equals = this.allowDenormal == ((Text)obj).allowDenormal;
            }
            if (equals) {
                boolean bl = equals = this.exceptionOnUndefined == ((Text)obj).exceptionOnUndefined;
            }
            if (equals) {
                equals = this.tolerateUndefined == ((Text)obj).tolerateUndefined;
            }
            return equals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        Text text = this;
        synchronized (text) {
            Text clone = null;
            try {
                clone = new Text(this.value);
                clone.allowDenormal = this.allowDenormal;
                clone.exceptionOnUndefined = this.exceptionOnUndefined;
                clone.tolerateUndefined = this.tolerateUndefined;
            }
            catch (ComputationException computationException) {
                // empty catch block
            }
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Text text = this;
        synchronized (text) {
            return this.value;
        }
    }
}

