/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Text;
import hec.hecmath.computation.TextOperation;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Util;
import hec.hecmath.computation.Value;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class TextExpression
implements Evaluable,
Constants {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;
    protected String inputText = null;
    protected Constants.Notation inputNotation = Constants.Notation.UNKNOWN;
    protected Evaluable expression = null;
    protected VariableSet variables = null;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();
    protected boolean stale = true;
    protected String result = null;

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    public TextExpression() {
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
    }

    public TextExpression(String expr) throws ComputationException {
        this(expr, null);
    }

    public TextExpression(String expr, VariableSet variables) throws ComputationException {
        this();
        this.variables = variables == null ? new VariableSet() : variables;
        this.setTextExpression(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    @Override
    public double evaluate() throws ComputationException {
        try {
            return Double.parseDouble(this.evaluateToString());
        }
        catch (NumberFormatException nfe) {
            throw new ComputationException(nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            if (this.expression == null) {
                throw new ComputationException("Cannot evaluate a null expression");
            }
            return this.expression.evaluateToString();
        }
    }

    protected String sexpToPrefix(String sexp) throws ComputationException {
        if (sexp == null) {
            return null;
        }
        List<String> prefix = this.sexpToPrefix(Arrays.asList(Util.reSub(sexp, "(\\(|\\))", " $1 ").split("\\s+")));
        String[] arr = new String[prefix.size()];
        prefix.toArray(arr);
        return Util.join(" ", arr).trim();
    }

    protected List<String> sexpToPrefix(List<String> sexp) throws ComputationException {
        LinkedList<String> prefix = new LinkedList<String>();
        ListIterator<String> i = sexp.listIterator();
        block0: while (i.hasNext()) {
            String token = i.next();
            if (token.equals("(") || token.equals(")")) continue;
            prefix.offer(token);
            if (!TextOperation.isTextOperation(token) || TextOperation.arity(token) != -1) continue;
            int count = 0;
            int level = 1;
            ListIterator<String> j = sexp.listIterator(i.nextIndex());
            while (j.hasNext()) {
                String token2 = j.next();
                if (token2.equals("(")) {
                    ++level;
                } else if (token2.equals(")")) {
                    --level;
                }
                if (level == 1) {
                    ++count;
                    continue;
                }
                if (level != 0) continue;
                prefix.offer(String.valueOf(count));
                continue block0;
            }
        }
        return new ArrayList<String>(prefix);
    }

    protected String infixToPostfix(String infix) throws ComputationException {
        if (infix == null) {
            return null;
        }
        List<String> postfix = this.infixToPostfix(Arrays.asList(infix.split("\\s+")));
        String[] arr = new String[postfix.size()];
        postfix.toArray(arr);
        return Util.trim(Util.join(" ", arr));
    }

    protected List<String> infixToPostfix(List<String> infix) throws ComputationException {
        String token;
        List<String> _infix = infix.get(0).equals("(") && infix.get(infix.size() - 1).equals(")") ? infix.subList(1, infix.size() - 1) : infix;
        LinkedList<String> postfix = new LinkedList<String>();
        Stack<String> stack = new Stack<String>();
        ListIterator<String> i = _infix.listIterator();
        String string = token = i.hasNext() ? i.next() : null;
        while (token != null) {
            if (token.equals("(")) {
                String previous;
                int arg_count = 0;
                String string2 = previous = i.hasPrevious() ? "" : _infix.get(i.previousIndex() - 1);
                if (TextOperation.isTextOperation(previous) && TextOperation.arity(previous) == -1) {
                    String token2;
                    arg_count = 1;
                    int level = 1;
                    ListIterator<String> j = _infix.listIterator(i.nextIndex());
                    while ((token2 = j.next()) != null) {
                        if (token2.equals("(")) {
                            ++level;
                            continue;
                        }
                        if (token2.equals(")")) {
                            if (--level != 0) continue;
                            break;
                        }
                        if (!token2.equals(",")) continue;
                        ++arg_count;
                    }
                }
                stack.push(token);
                if (arg_count > 0) {
                    stack.push(Integer.toString(arg_count));
                }
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (token.equals(")")) {
                while (!((String)stack.peek()).equals("(")) {
                    postfix.offer((String)stack.pop());
                }
                stack.pop();
                if (stack.size() > 0 && TextOperation.isTextOperation((String)stack.peek()) && TextOperation.arity((String)stack.peek()) == -1) {
                    postfix.offer((String)stack.pop());
                }
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (token.equals(",")) {
                token = i.hasNext() ? i.next() : null;
                continue;
            }
            if (TextOperation.isTextOperation(token) && TextOperation.arity(token) != 0) {
                if (stack.size() == 0 || !TextOperation.isTextOperation((String)stack.peek()) || TextOperation.precedence(token) > TextOperation.precedence((String)stack.peek())) {
                    stack.push(token);
                    token = i.next();
                    continue;
                }
                postfix.offer((String)stack.pop());
                continue;
            }
            if (token.startsWith("+")) {
                postfix.offer(token.substring(1));
            } else if (token.startsWith("-")) {
                if (Value.isValue(token.substring(1))) {
                    postfix.offer(token);
                } else {
                    postfix.offer(token.substring(1));
                    postfix.offer("neg");
                }
            } else {
                postfix.offer(token);
            }
            token = i.hasNext() ? i.next() : null;
        }
        while (stack.size() > 0) {
            postfix.offer((String)stack.pop());
        }
        return new ArrayList<String>(postfix);
    }

    protected void setTextExpression(String expr) throws ComputationException {
        if (expr == null) {
            throw new ComputationException("TextExpression must not be null.");
        }
        this.inputText = expr.trim();
        String[] parts = null;
        if (Variable.isVariableName(this.inputText)) {
            parts = new String[]{this.inputText};
            this.inputNotation = Constants.Notation.INFIX;
        } else if (this.inputText.length() > 2 && Variable.isVariableName(this.inputText.substring(1))) {
            if (this.inputText.startsWith("+")) {
                parts = new String[]{this.inputText.substring(1)};
                this.inputNotation = Constants.Notation.INFIX;
            } else if (this.inputText.startsWith("-")) {
                parts = new String[]{"neg", this.inputText.substring(1)};
                this.inputNotation = Constants.Notation.PREFIX;
            }
        }
        if (parts != null) {
            this.buildExpression(Arrays.asList(parts));
            return;
        }
        Util.validateBalancedBrackets(this.inputText);
        int paren_pos = this.inputText.indexOf(40);
        parts = this.inputText.replaceAll("\\(", " ").replaceAll("\\)", " ").trim().split("\\s+");
        if (TextOperation.isTextOperation(parts[0])) {
            if (paren_pos == 0) {
                this.inputNotation = Constants.Notation.S_EXPR;
            } else if (paren_pos == -1) {
                this.inputNotation = Constants.Notation.PREFIX;
            }
        } else if (TextOperation.isTextOperation(parts[parts.length - 1]) && paren_pos == -1) {
            this.inputNotation = Constants.Notation.POSTFIX;
        }
        switch (this.inputNotation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: {
                this.buildExpression(this.parseTextExpression(this.inputText, this.inputNotation));
                break;
            }
            default: {
                this.buildExpression(this.parseTextExpression(this.inputText, Constants.Notation.UNKNOWN));
            }
        }
    }

    protected List<String> parseTextExpression(String expr) throws ComputationException {
        return this.parseTextExpression(expr, Constants.Notation.UNKNOWN);
    }

    protected List<String> parseTextExpression(String expr, Constants.Notation notation) throws ComputationException {
        int i;
        String originalEqn = expr;
        HashMap<String, Object> op_pattern = new HashMap<String, Object>();
        HashSet<String> func_ops = new HashSet<String>();
        HashSet<String> sub_ops = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        String groupingTokenPattern = "([\\(\\,\\)])";
        Set<String> ops = TextOperation.getNames();
        for (String op : ops) {
            if (Character.isLetter(op.charAt(0))) {
                func_ops.add(op);
                sb.setLength(0);
                sb.append("([\\W])(").append(op).append(")([\\W])");
                op_pattern.put(op, sb.toString());
            } else {
                sb.setLength(0);
                sb.append("(\\Q").append(op).append("\\E)");
                op_pattern.put(op, sb.toString());
            }
            for (String op2 : ops) {
                if (op2.equals(op) || op.indexOf(op2) == -1 || sub_ops.contains(op2)) continue;
                sub_ops.add(op2);
            }
        }
        if (notation == Constants.Notation.INFIX || notation == Constants.Notation.S_EXPR) {
            String other = new String(notation == Constants.Notation.INFIX ? "(,)" : "()");
            for (int i2 = 0; i2 < other.length(); ++i2) {
                String s = other.substring(i2, i2 + 1);
                op_pattern.put(s, "\\" + s);
            }
        }
        expr = Util.normalizeParentheses(originalEqn);
        expr = Util.reSub(expr, groupingTokenPattern, " $1 ");
        String variablePattern = "(\\$\\w+)";
        String textStringPattern = "(\".+?\"|'.+?')";
        expr = Util.reSub(expr, variablePattern, "{$1}");
        expr = Util.reSub(expr, textStringPattern, "{$1}");
        String[] parts = expr.split("[{}]");
        for (int i3 = 0; i3 < parts.length; ++i3) {
            if (Pattern.matches(variablePattern, parts[i3])) {
                parts[i3] = " {" + parts[i3] + "} ";
                continue;
            }
            if (!Pattern.matches(textStringPattern, parts[i3])) continue;
            parts[i3] = " {" + parts[i3].substring(1, parts[i3].length() - 1).replace(' ', '\u0001') + "} ";
        }
        parts = TextUtil.join(" ", parts).split("\\s+");
        expr = Util.join(" ", parts);
        sb.replace(0, sb.length(), "([\\W])(");
        boolean first = true;
        for (Object op : op_pattern.keySet()) {
            if (!func_ops.contains(op) || sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((String)op);
        }
        sb.append(")([\\W])");
        expr = Util.reSub(expr, sb.toString(), "$1 $2 $3");
        first = true;
        sb.replace(0, sb.length(), "(\\Q");
        for (Object op : op_pattern.keySet()) {
            if (func_ops.contains(op) || sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("\\E|\\Q");
            }
            sb.append((String)op);
        }
        sb.append("\\E)");
        expr = Util.reSub(expr, sb.toString(), " $1 ").trim();
        parts = expr.split("\\s+");
        sb.replace(0, sb.length(), "([\\W])(");
        first = true;
        int count = 0;
        for (String op : op_pattern.keySet()) {
            if (!func_ops.contains(op) || !sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(op);
            ++count;
        }
        if (count > 0) {
            sb.append(")([\\W])");
            for (int i4 = 0; i4 < parts.length; ++i4) {
                if (TextOperation.isTextOperation(parts[i4])) continue;
                parts[i4] = Util.reSub(parts[i4], sb.toString(), "$1 $2 $3");
            }
        }
        first = true;
        count = 0;
        sb.replace(0, sb.length(), "(\\Q");
        for (String op : op_pattern.keySet()) {
            if (func_ops.contains(op) || !sub_ops.contains(op)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("\\E|\\Q");
            }
            sb.append(op);
            ++count;
        }
        if (count > 0) {
            sb.append("\\E)");
            for (int i5 = 0; i5 < parts.length; ++i5) {
                if (TextOperation.isTextOperation(parts[i5])) continue;
                parts[i5] = Util.reSub(parts[i5], sb.toString(), " $1 ");
            }
        }
        parts = Util.join(" ", parts).trim().split("\\s+");
        if (notation == Constants.Notation.UNKNOWN) {
            if (TextOperation.isTextOperation(parts[parts.length - 1])) {
                this.inputNotation = Constants.Notation.POSTFIX;
            } else if (TextOperation.isTextOperation(parts[0])) {
                this.inputNotation = parts[1].equals("(") ? Constants.Notation.INFIX : Constants.Notation.PREFIX;
            } else if (!parts[0].equals("(")) {
                this.inputNotation = Constants.Notation.INFIX;
            } else {
                for (int i6 = 1; i6 < parts.length; ++i6) {
                    if (!TextOperation.isTextOperation(parts[i6]) || parts[i6 - 1].equals("(")) continue;
                    notation = this.inputNotation = Constants.Notation.INFIX;
                    break;
                }
                if (notation == Constants.Notation.UNKNOWN) {
                    this.inputNotation = Constants.Notation.S_EXPR;
                }
            }
            return this.parseTextExpression(originalEqn, this.inputNotation);
        }
        switch (notation) {
            case INFIX: {
                for (int i7 = parts.length - 2; i7 >= 0; --i7) {
                    if (!parts[i7].equals("+") && !parts[i7].equals("-") || i7 != 0 && !op_pattern.containsKey(parts[i7 - 1]) || i7 != 0 && parts[i7 - 1].equals(")")) continue;
                    if (parts[i7].equals("-")) {
                        parts[i7 + 1] = "-" + parts[i7 + 1];
                    }
                    parts[i7] = "";
                }
                break;
            }
            case POSTFIX: {
                block21: for (int i8 = 1; i8 < parts.length; ++i8) {
                    if (!parts[i8 - 1].endsWith("{")) continue;
                    if (parts[i8].equals("+")) {
                        parts[i8] = "";
                        continue;
                    }
                    if (!parts[i8].equals("-")) continue;
                    parts[i8] = "";
                    for (int j = i8 + 1; j < parts.length; ++j) {
                        if (!parts[j].endsWith("}")) continue;
                        int n = j;
                        parts[n] = parts[n] + " neg ";
                        continue block21;
                    }
                }
                break;
            }
            case S_EXPR: 
            case PREFIX: {
                for (int i9 = 1; i9 < parts.length; ++i9) {
                    if (!parts[i9 - 1].endsWith("{")) continue;
                    if (parts[i9].equals("+")) {
                        parts[i9] = "";
                        continue;
                    }
                    if (!parts[i9].equals("-")) continue;
                    parts[i9] = "";
                    parts[i9 - 1] = parts[i9 - 1].substring(0, parts[i9 - 1].length() - 1) + " neg {";
                }
                break;
            }
        }
        parts = Util.join(" ", parts).trim().split("\\s+");
        if (notation == Constants.Notation.INFIX) {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(parts));
            for (int i10 = l.size() - 2; i10 >= 0; --i10) {
                int j = i10 + 1;
                if (!parts[i10].endsWith(")") && !parts[i10].endsWith("}") || !parts[j].startsWith("(") && !parts[j].startsWith("{") && !func_ops.contains(parts[j])) continue;
                l.add(j, "*");
            }
            parts = new String[l.size()];
            l.toArray(parts);
        }
        parts = Util.join(" ", parts).trim().split("\\{");
        for (i = 1; i < parts.length; ++i) {
            String[] subParts = parts[i].split("\\}");
            subParts[0] = subParts[0].replaceAll("\\s", "");
            parts[i] = Util.join("", subParts);
        }
        parts = Util.trim(Util.join("", parts)).split("\\s+");
        switch (notation) {
            case POSTFIX: {
                for (i = 1; i < parts.length; ++i) {
                    if (!parts[i].equals("neg") || !Value.isValue(parts[i - 1])) continue;
                    parts[i] = "";
                    parts[i - 1] = "-" + parts[i - 1];
                }
                break;
            }
            case S_EXPR: 
            case PREFIX: {
                for (i = 1; i < parts.length; ++i) {
                    if (!parts[i - 1].equals("neg") || !Value.isValue(parts[i])) continue;
                    parts[i - 1] = "";
                    parts[i] = "-" + parts[i];
                }
                break;
            }
        }
        expr = Util.trim(Util.join(" ", parts));
        if (notation == Constants.Notation.INFIX) {
            this.infixToPostfix(expr);
        }
        for (i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].replace('\u0001', ' ');
        }
        return new ArrayList<String>(Arrays.asList(parts));
    }

    protected TextOperation makeOperationFromPostfix(Stack<String> stack) throws ComputationException {
        TextOperation op = null;
        String oper = stack.pop();
        Evaluable[] args = null;
        int arity = TextOperation.arity(oper);
        int specific_arity = arity == -1 ? Integer.parseInt(stack.pop()) : arity;
        if (arity != 0) {
            args = new Evaluable[specific_arity];
        }
        for (int i = 0; i < specific_arity; ++i) {
            int j = specific_arity - i - 1;
            if (TextOperation.isTextOperation(stack.peek())) {
                if (TextOperation.arity(stack.peek()) == 0) {
                    op = new TextOperation(stack.pop(), new Evaluable[]{null});
                    op.setExceptionOnUndefined(this.exceptionOnUndefined);
                    op.setTolerateUndefined(this.tolerateUndefined);
                    op.setAllowDenormal(this.allowDenormal);
                    args[j] = op;
                    continue;
                }
                args[j] = this.makeOperationFromPostfix(stack);
                continue;
            }
            args[j] = Variable.isVariableName(stack.peek()) ? this.variables.getVariable(stack.pop(), true) : new Text(stack.pop());
        }
        op = new TextOperation(oper, args);
        op.setExceptionOnUndefined(this.exceptionOnUndefined);
        op.setTolerateUndefined(this.tolerateUndefined);
        op.setAllowDenormal(this.allowDenormal);
        return op;
    }

    protected TextOperation makeOperationFromPrefix(Queue<String> queue) throws ComputationException {
        int specific_arity;
        TextOperation op = null;
        String oper = queue.remove();
        Evaluable[] args = null;
        int arity = TextOperation.arity(oper);
        int n = specific_arity = arity == -1 ? Integer.parseInt(queue.remove()) : arity;
        if (arity != 0) {
            args = new Evaluable[specific_arity];
        }
        for (int i = 0; i < specific_arity; ++i) {
            if (TextOperation.isTextOperation(queue.peek())) {
                if (TextOperation.arity(queue.peek()) == 0) {
                    op = new TextOperation(queue.remove(), new Evaluable[]{null});
                    op.setExceptionOnUndefined(this.exceptionOnUndefined);
                    op.setTolerateUndefined(this.tolerateUndefined);
                    op.setAllowDenormal(this.allowDenormal);
                    args[i] = op;
                    continue;
                }
                args[i] = this.makeOperationFromPrefix(queue);
                continue;
            }
            if (Variable.isVariableName(queue.peek())) {
                args[i] = this.variables.getVariable(queue.remove(), true);
                continue;
            }
            if (Value.isValue(queue.peek())) {
                args[i] = new Value(queue.remove());
                continue;
            }
            throw new ComputationException("Cannot parse item: " + queue.peek());
        }
        op = new TextOperation(oper, args);
        op.setExceptionOnUndefined(this.exceptionOnUndefined);
        op.setTolerateUndefined(this.tolerateUndefined);
        op.setAllowDenormal(this.allowDenormal);
        return op;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildExpression(List<String> tokens) throws ComputationException {
        if (tokens.size() == 1) {
            String token = tokens.get(0);
            if (TextOperation.isTextOperation(token)) {
                if (TextOperation.arity(token) != 0) throw new ComputationException(TextOperation.arityName(token) + " operator " + token + " cannot have 0 arguments.");
                TextOperation op = new TextOperation(token, new Evaluable[]{null});
                op.setExceptionOnUndefined(this.exceptionOnUndefined);
                op.setTolerateUndefined(this.tolerateUndefined);
                op.setAllowDenormal(this.allowDenormal);
                this.expression = op;
            } else {
                this.expression = Variable.isVariableName(token) ? this.variables.getVariable(token, true) : new Text(token);
            }
        } else {
            List<String> prefix = null;
            List<String> postfix = null;
            switch (this.inputNotation) {
                case S_EXPR: {
                    prefix = this.sexpToPrefix(tokens);
                    break;
                }
                case PREFIX: {
                    prefix = tokens;
                    break;
                }
                case POSTFIX: {
                    postfix = tokens;
                    break;
                }
                case INFIX: {
                    postfix = this.infixToPostfix(tokens);
                    break;
                }
            }
            if (postfix != null) {
                Stack<String> stack = new Stack<String>();
                stack.addAll(postfix);
                this.expression = this.makeOperationFromPostfix(stack);
            } else if (prefix != null) {
                this.expression = this.makeOperationFromPrefix(new LinkedList<String>(prefix));
            }
        }
        this.registerAsListener(this.expression);
    }

    @Override
    public String toNotation(Constants.Notation notation) throws ComputationException {
        switch (notation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: 
            case INFIX: {
                return this.expression.toNotation(notation);
            }
        }
        throw new ComputationException("Invalid notation:" + notation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTolerateUndefined() {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            return this.tolerateUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTolerateUndefined(boolean setting) {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            this.tolerateUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getExceptionOnUndefined() {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            return this.exceptionOnUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExceptionOnUndefined(boolean setting) {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            this.exceptionOnUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAllowDenormal() {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            return this.allowDenormal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllowDenormal(boolean setting) {
        TextExpression textExpression = this;
        synchronized (textExpression) {
            this.allowDenormal = setting;
        }
    }

    @Override
    public synchronized String toString() {
        String result = null;
        try {
            result = this.toNotation(this.inputNotation);
        }
        catch (ComputationException e) {
            result = this.inputText;
        }
        return result;
    }
}

