/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Text;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TextOperation
implements Constants,
Evaluable {
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected static Map<Constants.TextOperator, String> nameByOp = new EnumMap<Constants.TextOperator, String>(Constants.TextOperator.class);
    protected static Map<String, Constants.TextOperator> opByName = new HashMap<String, Constants.TextOperator>();
    protected String value = null;
    protected Constants.TextOperator op = null;
    protected boolean stale = true;
    protected Evaluable[] args = null;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources = null;
    protected Object updateSourcesLock = new Object();

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isTextOperation(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static int arity(String name) {
        return opByName.get(name.toLowerCase()).arity();
    }

    public static int precedence(String name) {
        return opByName.get(name.toLowerCase()).precedence();
    }

    public static String arityName(String name) {
        Constants.TextOperator op = opByName.get(name);
        switch (op.arity()) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "UNARY";
            }
            case 2: {
                return "BINARY";
            }
            case 3: {
                return "TERNARY";
            }
            case -1: {
                return "VARIADIC";
            }
        }
        return op.arity() + "-ARY";
    }

    public TextOperation(String name, List<? extends Evaluable> args) throws ComputationException {
        this(name, true, args);
    }

    public TextOperation(String name, Evaluable ... args) throws ComputationException {
        this(name, true, args);
    }

    public TextOperation(Constants.TextOperator op, List<? extends Evaluable> args) throws ComputationException {
        this(op, true, args);
    }

    public TextOperation(Constants.TextOperator op, Evaluable ... args) throws ComputationException {
        this(op, true, args);
    }

    public TextOperation(String name, boolean persistent, List<? extends Evaluable> args) throws ComputationException {
        this(name, persistent, args.toArray(new Evaluable[0]));
    }

    public TextOperation(String name, boolean persistent, Evaluable ... args) throws ComputationException {
        this(opByName.get(name.toLowerCase()), persistent, args);
    }

    public TextOperation(Constants.TextOperator op, boolean persistent, List<? extends Evaluable> args) throws ComputationException {
        this(op, persistent, args.toArray(new Evaluable[0]));
    }

    public TextOperation(Constants.TextOperator op, boolean persistent, Evaluable ... args) throws ComputationException {
        int argCount;
        if (op == null) {
            throw new ComputationException("Operator must not be null");
        }
        int n = argCount = args == null ? 0 : args.length;
        if (op.arity() != -1 && argCount != op.arity()) {
            throw new ComputationException("Expected " + op.arity() + " arguments for operator '" + op.opname() + "', received " + argCount + ".");
        }
        this.op = op;
        this.args = args;
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
        if (persistent) {
            for (Evaluable arg : args) {
                this.registerAsListener(arg);
            }
        }
    }

    protected synchronized void compute() throws ComputationException {
        switch (this.op) {
            case ADDITION: {
                this.value = this.args[0].evaluateToString() + this.args[1].evaluateToString();
                break;
            }
            case UPPER: {
                this.value = this.args[0].evaluateToString().toUpperCase();
                break;
            }
            case LOWER: {
                this.value = this.args[0].evaluateToString().toLowerCase();
                break;
            }
            case TITLE: {
                char[] chars = this.args[0].evaluateToString().toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                for (int i = 1; i < chars.length; ++i) {
                    chars[i] = !Character.isWhitespace(chars[i]) && Character.isWhitespace(chars[i - 1]) ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
                }
                this.value = new String(chars);
                break;
            }
            case TRIM: {
                this.value = this.args[0].evaluateToString().trim();
            }
        }
        this.stale = false;
    }

    public synchronized String getName() {
        return this.op.opname();
    }

    public synchronized int getPrecedence() {
        return this.op.precedence();
    }

    public synchronized boolean isStale() {
        return this.stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        String value;
        boolean stale;
        TextOperation textOperation = this;
        synchronized (textOperation) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            value = this.value;
            this.stale = false;
        }
        if (stale) {
            this.notifyListeners();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    @Override
    public double evaluate() throws ComputationException {
        return Double.parseDouble(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toNotation(Constants.Notation notation) throws ComputationException {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            StringBuffer sb = new StringBuffer();
            boolean isVariadic = this.op.arity() == -1;
            boolean isBinary = this.op.arity() == 2;
            int specific_arity = isVariadic ? this.args.length : this.op.arity();
            switch (notation) {
                case S_EXPR: {
                    if (this.args == null) {
                        sb.append(" ").append(this.op.opname());
                        break;
                    }
                    sb.append(" (").append(this.op.opname());
                    for (Evaluable arg : this.args) {
                        sb.append(" ").append(arg.toNotation(notation));
                    }
                    sb.append(")");
                    break;
                }
                case PREFIX: {
                    sb.append(" ").append(this.op.opname());
                    if (isVariadic) {
                        sb.append(" ").append(specific_arity);
                    }
                    for (Evaluable arg : this.args) {
                        sb.append(" ").append(arg.toNotation(notation));
                    }
                    break;
                }
                case POSTFIX: {
                    for (Evaluable arg : this.args) {
                        sb.append(" ").append(arg.toNotation(notation));
                    }
                    if (isVariadic) {
                        sb.append(" ").append(specific_arity);
                    }
                    sb.append(" ").append(this.op.opname());
                    break;
                }
                case INFIX: {
                    if (isBinary && !Character.isLetter(this.op.opname().charAt(0))) {
                        if (this.args[0] instanceof TextOperation && ((TextOperation)this.args[0]).getPrecedence() < this.op.precedence()) {
                            sb.append(" (").append(this.args[0].toNotation(notation)).append(")");
                        } else {
                            sb.append(" ").append(this.args[0].toNotation(notation));
                        }
                        sb.append(" ").append(this.op.opname());
                        if (this.args[1] instanceof TextOperation && ((TextOperation)this.args[1]).getPrecedence() < this.op.precedence()) {
                            sb.append(" (").append(this.args[1].toNotation(notation)).append(")");
                            break;
                        }
                        sb.append(" ").append(this.args[1].toNotation(notation));
                        break;
                    }
                    if (this.op.opname().equals("neg")) {
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("-").append(this.args[0].toNotation(notation));
                        if (Character.isWhitespace(sb2.charAt(1))) {
                            sb.delete(1, 2);
                        }
                        sb.append(sb2);
                        break;
                    }
                    sb.append(" ").append(this.op.opname()).append("(");
                    boolean first = true;
                    for (Evaluable arg : this.args) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(arg.toNotation(notation));
                    }
                    sb.append(")");
                    break;
                }
                default: {
                    throw new ComputationException("Invalid notation:" + notation);
                }
            }
            return sb.toString().trim().replaceAll("\\s+", " ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTolerateUndefined() {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            return this.tolerateUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTolerateUndefined(boolean setting) {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            this.tolerateUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getExceptionOnUndefined() {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            return this.exceptionOnUndefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExceptionOnUndefined(boolean setting) {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            this.exceptionOnUndefined = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAllowDenormal() {
        TextOperation textOperation = this;
        synchronized (textOperation) {
            return this.allowDenormal;
        }
    }

    @Override
    public void setAllowDenormal(boolean setting) {
        this.allowDenormal = setting;
    }

    public static void main(String[] args) throws Exception {
        Text e1 = new Text(" this is part 1 ");
        Text e2 = new Text(" this is part 2 ");
        TextOperation op1 = new TextOperation(Constants.TextOperator.ADDITION, new TextOperation(Constants.TextOperator.UPPER, e1), new TextOperation(Constants.TextOperator.TITLE, e2));
        System.out.println(op1.evaluateToString());
        e1.setValue("some other text");
        System.out.println(op1.evaluateToString());
    }

    static {
        String[] aliases = null;
        for (Constants.TextOperator op : Constants.TextOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

