/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Testable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.util.TextUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextTest
implements Constants,
Testable {
    protected static Map<Constants.TextTestOperator, String> nameByOp = new EnumMap<Constants.TextTestOperator, String>(Constants.TextTestOperator.class);
    protected static Map<String, Constants.TextTestOperator> opByName = new HashMap<String, Constants.TextTestOperator>();
    protected boolean state;
    protected Constants.TextTestOperator op;
    protected Evaluable[] val = new Evaluable[]{null, null};
    protected boolean stale;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources;
    protected Object updateSourcesLock = new Object();
    protected VariableSet variables = null;

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isTextTest(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static int arity(String name) throws ComputationException {
        Constants.TextTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.arity();
    }

    public static int precedence(String name) throws ComputationException {
        Constants.TextTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.precedence();
    }

    public TextTest(String name, Evaluable val0) throws ComputationException {
        this(name, (VariableSet)null, val0);
    }

    public TextTest(String name, VariableSet variables, Evaluable val0) throws ComputationException {
        this.variables = variables == null ? new VariableSet() : variables;
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 1) {
            throw new ComputationException("TextTestOperator " + name + " cannot be used in a unary context.");
        }
        this.val[0] = val0;
        this.updateListeners = null;
        this.stale = true;
        if (this.variables != null && this.val[0] instanceof Variable) {
            this.variables.addVariable((Variable)this.val[0]);
        }
        this.registerAsListener(this.val[0]);
    }

    public TextTest(String name, Evaluable val0, Evaluable val1) throws ComputationException {
        this(name, null, val0, val1);
    }

    public TextTest(String name, VariableSet variables, Evaluable val0, Evaluable val1) throws ComputationException {
        this.variables = variables == null ? new VariableSet() : variables;
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 2) {
            throw new ComputationException("TextTestOperator " + name + " cannot be used in a binary context.");
        }
        this.val[0] = val0;
        this.val[1] = val1;
        this.updateListeners = null;
        this.stale = true;
        if (this.variables != null) {
            if (this.val[0] instanceof Variable) {
                this.variables.addVariable((Variable)this.val[0]);
            }
            if (this.val[1] instanceof Variable) {
                this.variables.addVariable((Variable)this.val[1]);
            }
        }
        this.registerAsListener(this.val[0]);
        this.registerAsListener(this.val[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        TextTest textTest = this;
        synchronized (textTest) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws ComputationException {
        boolean state;
        boolean stale;
        TextTest textTest = this;
        synchronized (textTest) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            state = this.state;
        }
        if (stale) {
            this.notifyListeners();
        }
        return state;
    }

    protected synchronized void compute() throws ComputationException {
        String s0 = this.val[0].evaluateToString();
        String s1 = this.val[1].evaluateToString();
        Pattern pat = null;
        Matcher m = null;
        boolean nocase = this.op.toString().indexOf("NOCASE") != -1;
        boolean glob = this.op.toString().indexOf("GLOB") != -1;
        try {
            switch (this.op) {
                case EQ_NOCASE_LITERAL: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case EQ_CASE_LITERAL: {
                    this.state = s0.equals(s1);
                    break;
                }
                case EQ_NOCASE_GLOB: 
                case EQ_CASE_GLOB: 
                case EQ_NOCASE_REGEX: 
                case EQ_CASE_REGEX: {
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s1) : s1, nocase ? 2 : 0);
                    m = pat.matcher(s0);
                    if (m.matches()) {
                        this.state = true;
                        break;
                    }
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s0) : s0, nocase ? 2 : 0);
                    m = pat.matcher(s1);
                    this.state = m.matches();
                    break;
                }
                case NE_NOCASE_LITERAL: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case NE_CASE_LITERAL: {
                    this.state = !s0.equals(s1);
                    break;
                }
                case NE_NOCASE_GLOB: 
                case NE_CASE_GLOB: 
                case NE_NOCASE_REGEX: 
                case NE_CASE_REGEX: {
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s1) : s1, nocase ? 2 : 0);
                    m = pat.matcher(s0);
                    if (m.matches()) {
                        this.state = false;
                        break;
                    }
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s0) : s0, nocase ? 2 : 0);
                    m = pat.matcher(s1);
                    this.state = !m.matches();
                    break;
                }
                case LT_NOCASE: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case LT_CASE: {
                    this.state = s0.compareTo(s1) < 0;
                    break;
                }
                case GT_NOCASE: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case GT_CASE: {
                    this.state = s0.compareTo(s1) > 0;
                    break;
                }
                case LE_NOCASE: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case LE_CASE: {
                    this.state = s0.compareTo(s1) <= 0;
                    break;
                }
                case GE_NOCASE: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case GE_CASE: {
                    this.state = s0.compareTo(s1) >= 0;
                    break;
                }
                case SW_NOCASE_LITERAL: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case SW_CASE_LITERAL: {
                    this.state = s0.startsWith(s1);
                    break;
                }
                case SW_NOCASE_GLOB: 
                case SW_CASE_GLOB: 
                case SW_NOCASE_REGEX: 
                case SW_CASE_REGEX: {
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s1) : s1, nocase ? 2 : 0);
                    m = pat.matcher(s0);
                    this.state = m.find() && m.start() == 0;
                    break;
                }
                case EW_NOCASE_LITERAL: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case EW_CASE_LITERAL: {
                    this.state = s0.endsWith(s1);
                    break;
                }
                case EW_NOCASE_GLOB: 
                case EW_CASE_GLOB: 
                case EW_NOCASE_REGEX: 
                case EW_CASE_REGEX: {
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s1) : s1, nocase ? 2 : 0);
                    m = pat.matcher(s0);
                    this.state = m.find() && m.end() == s0.length();
                    break;
                }
                case CONTAINS_NOCASE_LITERAL: {
                    s0 = s0.toUpperCase();
                    s1 = s1.toUpperCase();
                }
                case CONTAINS_CASE_LITERAL: {
                    this.state = s0.indexOf(s1) != -1;
                    break;
                }
                case CONTAINS_NOCASE_GLOB: 
                case CONTAINS_CASE_GLOB: 
                case CONTAINS_NOCASE_REGEX: 
                case CONTAINS_CASE_REGEX: {
                    pat = Pattern.compile(glob ? TextUtil.glob2Regex(s1) : s1, nocase ? 2 : 0);
                    m = pat.matcher(s0);
                    this.state = m.find();
                    break;
                }
                default: {
                    throw new ComputationException("Unexpected TextTest operator: " + this.op);
                }
            }
            this.stale = false;
        }
        catch (Exception e) {
            throw new ComputationException(e);
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.op.arity()) {
            case 1: {
                sb.append(nameByOp.get((Object)this.op)).append(this.val[0].toString());
                break;
            }
            case 2: {
                sb.append(this.val[0].toString()).append(" ").append(nameByOp.get((Object)this.op)).append(" ").append(this.val[1].toString());
            }
        }
        return sb.toString();
    }

    static {
        String[] aliases = null;
        for (Constants.TextTestOperator op : Constants.TextTestOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

