/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.LogicTest;
import hec.hecmath.computation.MathOperation;
import hec.hecmath.computation.QualityOperation;
import hec.hecmath.computation.QualityTest;
import hec.hecmath.computation.TextOperation;
import hec.hecmath.computation.TextTest;
import hec.hecmath.computation.ValueTest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    protected static Map<Character, Character> matchingBracket;
    protected static Set<String> allOperators;
    protected static Pattern[][] nonMathPatternLevels;
    protected static Pattern[][] mathPatternLevels;

    protected static boolean isIdChar(char c2) {
        return c2 == '_' || Character.isLetter(c2) || Character.isDigit(c2);
    }

    protected static String buildPatternString(Set<String> ops) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String op : ops) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            for (char c2 : op.toCharArray()) {
                if (!Util.isIdChar(c2)) {
                    sb.append("\\");
                }
                sb.append(c2);
            }
        }
        return sb.toString();
    }

    public static boolean isOperator(String str) {
        return allOperators.contains(str.toLowerCase());
    }

    public static String reSub(String src, String pattern, String repl) {
        return Util.reSub(src, Pattern.compile(pattern, 2), repl);
    }

    public static String reSub(String src, Pattern pattern, String repl) {
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(src);
        while (m.find()) {
            int i = sb.length();
            m.appendReplacement(sb, repl);
        }
        return sb.length() > 0 ? m.appendTail(sb).toString() : src;
    }

    public static String trim(String s) {
        int j;
        int i = 0;
        int len = j = s.length();
        while (s.charAt(i) == ' ' || s.charAt(i) == '\t') {
            ++i;
        }
        while (j > i && (s.charAt(j - 1) == ' ' || s.charAt(j - 1) == '\t')) {
            --j;
        }
        if (i > 0 || j < len) {
            s = j > i ? s.substring(i, j) : "";
        }
        return s;
    }

    public static String join(String separator, String[] parts) {
        return Util.join(separator, parts, 0, parts.length);
    }

    public static String join(String separator, String[] parts, int start) {
        return Util.join(separator, parts, start, parts.length);
    }

    public static String join(String separator, String[] parts, int start, int end) {
        StringBuffer sb = new StringBuffer(parts[start]);
        for (int i = start + 1; i < end; ++i) {
            sb.append(separator).append(parts[i]);
        }
        return sb.toString();
    }

    public static void validateBalancedBrackets(String expr) throws ComputationException {
        block4: for (int i = 0; i < expr.length(); ++i) {
            switch (expr.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    i = Util.matchBracket(expr, i);
                    continue block4;
                }
                case ')': 
                case ']': 
                case '}': {
                    throw new ComputationException("Unbalanced brackets in expression: " + expr);
                }
            }
        }
    }

    public static String normalizeParentheses(String expr) {
        return expr.replaceAll("[\\[{]", "(").replaceAll("[}\\]]", ")");
    }

    public static int nestedLevel(String expr, int pos) throws ComputationException {
        int level = 0;
        block4: for (int i = 0; i < pos; ++i) {
            switch (expr.charAt(pos)) {
                case '(': 
                case '[': 
                case '{': {
                    ++level;
                    continue block4;
                }
                case ')': 
                case ']': 
                case '}': {
                    --level;
                }
            }
        }
        return level;
    }

    public static int matchBracket(String expr, int pos) throws ComputationException {
        int level = 0;
        Stack<Character> stack = new Stack<Character>();
        switch (expr.charAt(pos)) {
            case '(': 
            case '[': 
            case '{': {
                block12: for (int i = pos; i < expr.length(); ++i) {
                    char c2 = expr.charAt(i);
                    switch (c2) {
                        case '(': 
                        case '[': 
                        case '{': {
                            stack.push(Character.valueOf(c2));
                            ++level;
                            continue block12;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            char s = ((Character)stack.pop()).charValue();
                            if (s != matchingBracket.get(Character.valueOf(c2)).charValue()) {
                                throw new ComputationException("Mismatched brackets: " + s + c2);
                            }
                            if (--level != 0) continue block12;
                            return i;
                        }
                    }
                }
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                block13: for (int i = pos; i >= 0; --i) {
                    char c3 = expr.charAt(i);
                    switch (expr.charAt(i)) {
                        case ')': 
                        case ']': 
                        case '}': {
                            stack.push(Character.valueOf(c3));
                            ++level;
                            continue block13;
                        }
                        case '(': 
                        case '[': 
                        case '{': {
                            char s = ((Character)stack.pop()).charValue();
                            if (s != matchingBracket.get(Character.valueOf(c3)).charValue()) {
                                throw new ComputationException("Mismatched brackets: " + s + c3);
                            }
                            if (--level != 0) continue block13;
                            return i;
                        }
                    }
                }
                break;
            }
            default: {
                throw new ComputationException("Position " + pos + " of \"" + expr + "\" is not a parenthesis, bracket, or brace character.");
            }
        }
        throw new ComputationException("Cannot match \"" + expr.charAt(pos) + "\" at position " + pos + " of " + expr);
    }

    public static String expandExpression(String expr) throws ComputationException {
        String[] parts = Util.reSub(expr, "([\\(\\[\\{\\,\\}\\]\\)])", " $1 ").trim().split("\\s+");
        expr = Util.join(" ", parts).trim();
        for (int i = 0; i < nonMathPatternLevels.length; ++i) {
            for (int j = 0; j < parts.length; ++j) {
                if (Util.isOperator(parts[j])) continue;
                if (nonMathPatternLevels[i][0] != null) {
                    parts[j] = Util.reSub(parts[j], nonMathPatternLevels[i][0], "$1 $2 $3");
                }
                if (nonMathPatternLevels[i][1] != null) {
                    parts[j] = Util.reSub(parts[j], nonMathPatternLevels[i][1], "$1 $2 ");
                }
                if (nonMathPatternLevels[i][2] != null) {
                    parts[j] = Util.reSub(parts[j], nonMathPatternLevels[i][2], " $1 ");
                }
                if (nonMathPatternLevels[i][3] == null) continue;
                parts[j] = Util.reSub(parts[j], nonMathPatternLevels[i][3], " $1 $2");
            }
            expr = Util.join(" ", parts).trim();
            parts = expr.split("\\s+");
        }
        return expr;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int i;
        matchingBracket = new HashMap<Character, Character>();
        allOperators = new HashSet<String>();
        nonMathPatternLevels = null;
        mathPatternLevels = null;
        matchingBracket.put(Character.valueOf('('), Character.valueOf(')'));
        matchingBracket.put(Character.valueOf('['), Character.valueOf(']'));
        matchingBracket.put(Character.valueOf('{'), Character.valueOf('}'));
        matchingBracket.put(Character.valueOf(')'), Character.valueOf('('));
        matchingBracket.put(Character.valueOf(']'), Character.valueOf('['));
        matchingBracket.put(Character.valueOf('}'), Character.valueOf('{'));
        Set<String> mathOperators = MathOperation.getNames();
        Set<String> valueTestOperators = ValueTest.getNames();
        Set<String> qualityOperators = QualityOperation.getNames();
        Set<String> qualityTestOperators = QualityTest.getNames();
        Set<String> logicTestOperators = LogicTest.getNames();
        Set<String> textOperators = TextOperation.getNames();
        Set<String> textTestOperators = TextTest.getNames();
        allOperators.addAll(mathOperators);
        allOperators.addAll(valueTestOperators);
        allOperators.addAll(qualityOperators);
        allOperators.addAll(qualityTestOperators);
        allOperators.addAll(logicTestOperators);
        allOperators.addAll(textOperators);
        allOperators.addAll(textTestOperators);
        for (String op1 : mathOperators) {
            for (String string : valueTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : qualityOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : qualityTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : logicTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        for (String op1 : valueTestOperators) {
            for (String string : qualityOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : qualityTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : logicTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        for (String op1 : qualityOperators) {
            for (String string : qualityTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : logicTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        for (String op1 : qualityTestOperators) {
            for (String string : logicTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        for (String op1 : logicTestOperators) {
            for (String string : textOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        for (String op1 : textOperators) {
            for (String string : textTestOperators) {
                if (!string.equals(op1)) continue;
                throw new RuntimeException("Operator " + op1 + " has multiple contexts!");
            }
        }
        Vector nonMathOpLevels = new Vector();
        nonMathOpLevels.add(new HashSet());
        ((Set)nonMathOpLevels.get(0)).addAll(allOperators);
        ((Set)nonMathOpLevels.get(0)).removeAll(mathOperators);
        HashSet<String> subOps = new HashSet<String>();
        int i2 = 0;
        while (true) {
            subOps.clear();
            for (Object op1 : (Set)nonMathOpLevels.get(i2)) {
                for (Object op2 : (Set)nonMathOpLevels.get(i2)) {
                    if (op1 == op2 || ((String)op1).indexOf((String)op2) == -1) continue;
                    subOps.add((String)op2);
                }
            }
            if (subOps.isEmpty()) break;
            ((Set)nonMathOpLevels.get(i2)).removeAll(subOps);
            nonMathOpLevels.add(new HashSet(subOps));
            ++i2;
        }
        Vector mathOpLevels = new Vector();
        mathOpLevels.add(new HashSet());
        ((Set)mathOpLevels.get(0)).addAll(mathOperators);
        boolean bl = false;
        while (true) {
            void var10_42;
            subOps.clear();
            for (String op1 : (Set)mathOpLevels.get((int)var10_42)) {
                for (String op2 : (Set)mathOpLevels.get((int)var10_42)) {
                    if (op1 == op2 || op1.indexOf(op2) == -1) continue;
                    subOps.add(op2);
                }
            }
            if (subOps.isEmpty()) break;
            ((Set)mathOpLevels.get((int)var10_42)).removeAll(subOps);
            mathOpLevels.add(new HashSet(subOps));
            ++var10_42;
        }
        nonMathPatternLevels = new Pattern[nonMathOpLevels.size()][4];
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> symbolOps = new HashSet<String>();
        HashSet<String> alphaSymbolOps = new HashSet<String>();
        HashSet<String> symbolAlphaOps = new HashSet<String>();
        StringBuffer sbAlpha = new StringBuffer();
        StringBuffer sbSymbol = new StringBuffer();
        StringBuffer sbAlphaSymbol = new StringBuffer();
        StringBuffer sbSymbolAlpha = new StringBuffer();
        for (i = 0; i < nonMathPatternLevels.length; ++i) {
            hashSet.clear();
            symbolOps.clear();
            alphaSymbolOps.clear();
            symbolAlphaOps.clear();
            sbAlpha.setLength(0);
            sbSymbol.setLength(0);
            sbAlphaSymbol.setLength(0);
            sbSymbolAlpha.setLength(0);
            for (String op : (Set)nonMathOpLevels.get(i)) {
                if (Util.isIdChar(op.charAt(0))) {
                    if (Util.isIdChar(op.charAt(op.length() - 1))) {
                        hashSet.add(op);
                        continue;
                    }
                    alphaSymbolOps.add(op);
                    continue;
                }
                if (Util.isIdChar(op.charAt(op.length() - 1))) {
                    symbolAlphaOps.add(op);
                    continue;
                }
                symbolOps.add(op);
            }
            if (hashSet.isEmpty()) {
                Util.nonMathPatternLevels[i][0] = null;
            } else {
                sbAlpha.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(hashSet)).append(")([^a-zA-Z_]|$)");
                Util.nonMathPatternLevels[i][0] = Pattern.compile(sbAlpha.toString(), 2);
            }
            if (alphaSymbolOps.isEmpty()) {
                Util.nonMathPatternLevels[i][1] = null;
            } else {
                sbAlphaSymbol.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(alphaSymbolOps)).append(")");
                Util.nonMathPatternLevels[i][1] = Pattern.compile(sbAlphaSymbol.toString(), 2);
            }
            if (symbolOps.isEmpty()) {
                Util.nonMathPatternLevels[i][2] = null;
            } else {
                sbSymbol.append("(").append(Util.buildPatternString(symbolOps)).append(")");
                Util.nonMathPatternLevels[i][2] = Pattern.compile(sbSymbol.toString(), 2);
            }
            if (symbolAlphaOps.isEmpty()) {
                Util.nonMathPatternLevels[i][3] = null;
                continue;
            }
            sbSymbolAlpha.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(symbolAlphaOps)).append(")([^a-zA-Z_]|$)");
            Util.nonMathPatternLevels[i][3] = Pattern.compile(sbSymbolAlpha.toString(), 2);
        }
        mathPatternLevels = new Pattern[mathOpLevels.size()][4];
        for (i = 0; i < mathPatternLevels.length; ++i) {
            hashSet.clear();
            symbolOps.clear();
            alphaSymbolOps.clear();
            symbolAlphaOps.clear();
            sbAlpha.setLength(0);
            sbSymbol.setLength(0);
            sbAlphaSymbol.setLength(0);
            sbSymbolAlpha.setLength(0);
            for (String op : (Set)mathOpLevels.get(i)) {
                if (Util.isIdChar(op.charAt(0))) {
                    if (Util.isIdChar(op.charAt(op.length() - 1))) {
                        hashSet.add(op);
                        continue;
                    }
                    alphaSymbolOps.add(op);
                    continue;
                }
                if (Util.isIdChar(op.charAt(op.length() - 1))) {
                    symbolAlphaOps.add(op);
                    continue;
                }
                symbolOps.add(op);
            }
            if (hashSet.isEmpty()) {
                Util.mathPatternLevels[i][0] = null;
            } else {
                sbAlpha.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(hashSet)).append(")([^a-zA-Z_]|$)");
                Util.mathPatternLevels[i][0] = Pattern.compile(sbAlpha.toString(), 2);
            }
            if (alphaSymbolOps.isEmpty()) {
                Util.mathPatternLevels[i][1] = null;
            } else {
                sbAlphaSymbol.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(alphaSymbolOps)).append(")");
                Util.mathPatternLevels[i][1] = Pattern.compile(sbAlphaSymbol.toString(), 2);
            }
            if (symbolOps.isEmpty()) {
                Util.mathPatternLevels[i][2] = null;
            } else {
                sbSymbol.append("(").append(Util.buildPatternString(symbolOps)).append(")");
                Util.mathPatternLevels[i][2] = Pattern.compile(sbSymbol.toString(), 2);
            }
            if (symbolAlphaOps.isEmpty()) {
                Util.mathPatternLevels[i][3] = null;
                continue;
            }
            sbSymbolAlpha.append("(^|[^a-zA-Z_])(").append(Util.buildPatternString(symbolAlphaOps)).append(")([^a-zA-Z_]|$)");
            Util.mathPatternLevels[i][3] = Pattern.compile(sbSymbolAlpha.toString(), 2);
        }
    }
}

