/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Setable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.HashSet;
import java.util.Set;

public class Value
implements Evaluable,
Setable,
Comparable<Value> {
    public static final String valuePattern = "[-+]?\\d+(\\.\\d+)?(\\s*([eE]\\s*[-+]?\\s*\\d+(\\.\\d+)?))?";
    public static final String valuePatternWithoutSign = "\\d+(\\.\\d+)?(\\s*([eE]\\s*[-+]?\\s*\\d+(\\.\\d+)?))?";
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected double value;
    protected boolean isSet = false;
    protected boolean tolerateUndefined = tolerateUndefinedByDefault;
    protected boolean exceptionOnUndefined = exceptionOnUndefinedByDefault;
    protected boolean allowDenormal = allowDenormalByDefault;

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    public static double normalize(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return -3.4028234663852886E38;
        }
        if (value == -0.0) {
            return 0.0;
        }
        return value;
    }

    public static boolean isValue(String text) {
        return text.matches(valuePattern);
    }

    public Value() {
    }

    public Value(double value) throws ComputationException {
        this();
        this.setValue(value);
    }

    public Value(int value) throws ComputationException {
        this();
        this.setValue(value);
    }

    public Value(Double value) throws ComputationException {
        this();
        this.setValue(value);
    }

    public Value(Integer value) throws ComputationException {
        this();
        this.setValue(value);
    }

    public Value(String value) throws ComputationException {
        this();
        this.setValue(value);
    }

    @Override
    public synchronized void setValue(double value) throws ComputationException {
        double d = this.value = this.allowDenormal ? value : Value.normalize(value);
        if (this.value == -3.4028234663852886E38 && this.exceptionOnUndefined) {
            throw new ComputationException("Value cannot be undefined.");
        }
        this.isSet = true;
        this.notifyListeners();
    }

    @Override
    public void setValue(int value) throws ComputationException {
        this.setValue((double)value);
    }

    @Override
    public void setValue(Double value) throws ComputationException {
        if (value == null) {
            throw new ComputationException("Value cannot be null.");
        }
        this.setValue((double)value);
    }

    @Override
    public void setValue(Integer value) throws ComputationException {
        if (value == null) {
            throw new ComputationException("Value cannot be null.");
        }
        this.setValue((double)value.intValue());
    }

    @Override
    public void setValue(String value) throws ComputationException {
        if (value == null) {
            throw new ComputationException("Value cannot be null.");
        }
        this.setValue(Double.parseDouble(value));
    }

    public synchronized void reset() {
        this.isSet = false;
    }

    @Override
    public double evaluate() throws ComputationException {
        if (!this.isSet) {
            throw new ComputationException("Value is not set");
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateToString() throws ComputationException {
        Value value = this;
        synchronized (value) {
            return Double.toString(this.evaluate());
        }
    }

    @Override
    public synchronized String toString() {
        try {
            return String.valueOf(this.evaluate());
        }
        catch (ComputationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public synchronized String toNotation(Constants.Notation notation) throws ComputationException {
        switch (notation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: 
            case INFIX: {
                return String.valueOf(this.evaluate());
            }
        }
        throw new ComputationException("Invalid notation:" + notation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    @Override
    public synchronized boolean getTolerateUndefined() {
        return this.tolerateUndefined;
    }

    @Override
    public synchronized boolean getExceptionOnUndefined() {
        return this.exceptionOnUndefined;
    }

    @Override
    public synchronized boolean getAllowDenormal() {
        return this.allowDenormal;
    }

    @Override
    public synchronized void setTolerateUndefined(boolean setting) {
        this.tolerateUndefined = setting;
    }

    @Override
    public synchronized void setExceptionOnUndefined(boolean setting) {
        this.exceptionOnUndefined = setting;
    }

    @Override
    public synchronized void setAllowDenormal(boolean setting) {
        this.allowDenormal = setting;
    }

    @Override
    public void registerAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener() {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void dataUpdated(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public int compareTo(Value o) {
        try {
            return (int)Math.signum(this.evaluate() - o.evaluate());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

