/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.io.TimeSeriesContainer;
import java.util.List;
import java.util.Vector;

public class ValueContainer {
    protected boolean containsDouble = false;
    protected boolean containsTimeSeriesContainer = false;
    protected double value = -3.4028234663852886E38;
    protected TimeSeriesContainer tsc = null;

    public static List<ValueContainer> list(Object ... args) throws ComputationException {
        Vector<ValueContainer> list = new Vector<ValueContainer>();
        for (Object obj : args) {
            if (obj instanceof TimeSeriesContainer) {
                list.add(new ValueContainer((TimeSeriesContainer)obj));
                continue;
            }
            if (obj instanceof Double) {
                list.add(new ValueContainer((Double)obj));
                continue;
            }
            if (obj instanceof Integer) {
                list.add(new ValueContainer(((Integer)obj).doubleValue()));
                continue;
            }
            if (obj instanceof String) {
                list.add(new ValueContainer(Double.parseDouble((String)obj)));
                continue;
            }
            if (obj instanceof double[]) {
                for (double d : (double[])obj) {
                    list.add(new ValueContainer(d));
                }
                continue;
            }
            throw new ComputationException("Cannot instantiate a ValueContainer from type " + obj.getClass().getName());
        }
        return list;
    }

    public static ValueContainer[] array(Object ... args) throws ComputationException {
        List<ValueContainer> list = ValueContainer.list(args);
        ValueContainer[] arr = new ValueContainer[list.size()];
        list.toArray(arr);
        return arr;
    }

    public ValueContainer() {
    }

    public ValueContainer(double value) {
        this.setValue(value);
    }

    public ValueContainer(TimeSeriesContainer tsc) {
        this.setTimeSeriesContainer(tsc);
    }

    public synchronized double getValue() throws ComputationException {
        if (!this.containsDouble) {
            throw new ComputationException("ValueContainer does not contain a double value.");
        }
        return this.value;
    }

    public synchronized TimeSeriesContainer getTimeSeriesContainer() throws ComputationException {
        if (!this.containsTimeSeriesContainer) {
            throw new ComputationException("ValueContainer does not contain a TimeSeriesContainer.");
        }
        return this.tsc;
    }

    public synchronized void setValue(double value) {
        this.value = value;
        this.tsc = null;
        this.containsTimeSeriesContainer = false;
        this.containsDouble = true;
    }

    public synchronized void setTimeSeriesContainer(TimeSeriesContainer tsc) {
        this.value = -3.4028234663852886E38;
        this.tsc = tsc;
        this.containsTimeSeriesContainer = true;
        this.containsDouble = false;
    }

    public synchronized boolean isDouble() {
        return this.containsDouble;
    }

    public synchronized boolean isTimeSeriesContainer() {
        return this.containsTimeSeriesContainer;
    }
}

