/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Testable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValueTest
implements Constants,
Testable {
    protected static double near_zero_value = 1.4E-45f;
    protected static Map<Constants.ValueTestOperator, String> nameByOp = new EnumMap<Constants.ValueTestOperator, String>(Constants.ValueTestOperator.class);
    protected static Map<String, Constants.ValueTestOperator> opByName = new HashMap<String, Constants.ValueTestOperator>();
    protected boolean state;
    protected Constants.ValueTestOperator op;
    protected Evaluable[] val = new Evaluable[]{null, null};
    protected boolean stale;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected Set<Updatable> updateSources;
    protected Object updateSourcesLock = new Object();
    protected VariableSet variables = null;

    public static Set<String> getNames() {
        return opByName.keySet();
    }

    public static boolean isValueTest(String name) {
        return opByName.keySet().contains(name.toLowerCase());
    }

    public static void setNearZeroValue(double value) {
        near_zero_value = value;
    }

    public static int arity(String name) throws ComputationException {
        Constants.ValueTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.arity();
    }

    public static int precedence(String name) throws ComputationException {
        Constants.ValueTestOperator op = opByName.get(name.toLowerCase());
        if (op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        return op.precedence();
    }

    public ValueTest(String name, Evaluable val0) throws ComputationException {
        this(name, (VariableSet)null, val0);
    }

    public ValueTest(String name, VariableSet variables, Evaluable val0) throws ComputationException {
        this.variables = variables == null ? new VariableSet() : variables;
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 1) {
            throw new ComputationException("ValueTestOperator " + name + " cannot be used in a unary context.");
        }
        this.val[0] = val0;
        this.updateListeners = null;
        this.stale = true;
        if (this.variables != null && this.val[0] instanceof Variable) {
            this.variables.addVariable((Variable)this.val[0]);
        }
        this.registerAsListener(this.val[0]);
    }

    public ValueTest(String name, Evaluable val0, Evaluable val1) throws ComputationException {
        this(name, null, val0, val1);
    }

    public ValueTest(String name, VariableSet variables, Evaluable val0, Evaluable val1) throws ComputationException {
        this.variables = variables == null ? new VariableSet() : variables;
        this.op = opByName.get(name.toLowerCase());
        if (this.op == null) {
            throw new ComputationException("Invalid operator name: " + name);
        }
        if (this.op.arity() != 2) {
            throw new ComputationException("ValueTestOperator " + name + " cannot be used in a binary context.");
        }
        this.val[0] = val0;
        this.val[1] = val1;
        this.updateListeners = null;
        this.stale = true;
        if (this.variables != null) {
            if (this.val[0] instanceof Variable) {
                this.variables.addVariable((Variable)this.val[0]);
            }
            if (this.val[1] instanceof Variable) {
                this.variables.addVariable((Variable)this.val[1]);
            }
        }
        this.registerAsListener(this.val[0]);
        this.registerAsListener(this.val[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws ComputationException {
        boolean state;
        boolean stale;
        ValueTest valueTest = this;
        synchronized (valueTest) {
            stale = this.stale;
            if (this.stale) {
                this.compute();
            }
            state = this.state;
        }
        if (stale) {
            this.notifyListeners();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources == null) {
                this.updateSources = new HashSet<Updatable>();
            }
            if (!this.updateSources.contains(u)) {
                u.registerListener(this);
                this.updateSources.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener(Updatable u) {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            if (this.updateSources.contains(u)) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAsListener() {
        Object object = this.updateSourcesLock;
        synchronized (object) {
            for (Updatable u : this.updateSources) {
                u.unregisterListener(this);
                this.updateSources.remove(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataUpdated(Updatable u) {
        ValueTest valueTest = this;
        synchronized (valueTest) {
            this.stale = true;
        }
        this.notifyListeners();
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.op.arity()) {
            case 1: {
                sb.append(nameByOp.get((Object)this.op)).append(this.val[0].toString());
                break;
            }
            case 2: {
                sb.append(this.val[0].toString()).append(" ").append(nameByOp.get((Object)this.op)).append(" ").append(this.val[1].toString());
            }
        }
        return sb.toString();
    }

    protected synchronized void compute() throws ComputationException {
        try {
            switch (this.op) {
                case IS_NAN: {
                    this.state = Double.isNaN(this.val[0].evaluate());
                    break;
                }
                case IS_INF: {
                    this.state = Double.isInfinite(this.val[0].evaluate());
                    break;
                }
                case IS_NEG_INF: {
                    this.state = this.val[0].evaluate() == Double.NEGATIVE_INFINITY;
                    break;
                }
                case IS_POS_INF: {
                    this.state = this.val[0].evaluate() == Double.POSITIVE_INFINITY;
                    break;
                }
                case IS_UNDEF: {
                    this.state = this.val[0].evaluate() == -3.4028234663852886E38;
                    break;
                }
                case IS_NEAR_ZERO: {
                    this.state = Math.abs(this.val[0].evaluate()) < near_zero_value;
                    break;
                }
                case LT: {
                    this.state = this.val[0].evaluate() < this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                case LE: {
                    this.state = this.val[0].evaluate() <= this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                case GT: {
                    this.state = this.val[0].evaluate() > this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                case GE: {
                    this.state = this.val[0].evaluate() >= this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                case EQ: {
                    this.state = this.val[0].evaluate() == this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                case NE: {
                    this.state = this.val[0].evaluate() != this.val[1].evaluate() && this.val[0].evaluate() != -3.4028234663852886E38 && this.val[1].evaluate() != -3.4028234663852886E38;
                    break;
                }
                default: {
                    throw new ComputationException("Unexpected ValueTest operator: " + this.op);
                }
            }
            this.stale = false;
        }
        catch (Exception e) {
            throw new ComputationException(e);
        }
    }

    static {
        String[] aliases = null;
        for (Constants.ValueTestOperator op : Constants.ValueTestOperator.values()) {
            nameByOp.put(op, op.opname());
            opByName.put(op.opname(), op);
            aliases = op.aliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                opByName.put(alias, op);
            }
        }
    }
}

