/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.Setable;
import hec.hecmath.computation.Updatable;
import hec.hecmath.computation.UpdatableListener;
import java.util.HashSet;
import java.util.Set;

public class Variable
implements Evaluable,
Setable {
    public static final String variableNamePattern = "\\$\\w+";
    public static final String textStringPattern = "\".+?\"|'.+?'";
    protected static Variable theInstance = null;
    protected static boolean tolerateUndefinedByDefault = false;
    protected static boolean exceptionOnUndefinedByDefault = false;
    protected static boolean allowDenormalByDefault = true;
    protected Set<UpdatableListener> updateListeners = null;
    protected Object updateListenersLock = new Object();
    protected String name = null;
    protected boolean containsValue = false;
    protected boolean containsQuality = false;
    protected boolean containsText = false;
    protected double value = -3.4028234663852886E38;
    protected int quality = Integer.MIN_VALUE;
    protected String text = null;
    protected boolean tolerateUndefined = false;
    protected boolean exceptionOnUndefined = false;
    protected boolean allowDenormal = false;

    public static boolean getTolerateUndefinedByDefault() {
        return tolerateUndefinedByDefault;
    }

    public static void setTolerateUndefinedByDefault(boolean setting) {
        tolerateUndefinedByDefault = setting;
    }

    public static boolean getExceptionOnUndefinedByDefault() {
        return exceptionOnUndefinedByDefault;
    }

    public static void setExceptionOnUndefinedByDefault(boolean setting) {
        exceptionOnUndefinedByDefault = setting;
    }

    public static boolean getAllowDenormalByDefault() {
        return allowDenormalByDefault;
    }

    public static void setAllowDenormalByDefault(boolean setting) {
        allowDenormalByDefault = setting;
    }

    public static double normalize(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return -3.4028234663852886E38;
        }
        if (value == -0.0) {
            return 0.0;
        }
        return value;
    }

    public static boolean isVariableName(String text) {
        return text.matches(variableNamePattern);
    }

    protected Variable() {
        this.tolerateUndefined = tolerateUndefinedByDefault;
        this.exceptionOnUndefined = exceptionOnUndefinedByDefault;
        this.allowDenormal = allowDenormalByDefault;
    }

    public Variable(String name) throws ComputationException {
        this.setName(name);
    }

    public Variable(String name, double value) throws ComputationException {
        this(name);
        this.setValue(value);
    }

    public Variable(String name, double value, int quality) throws ComputationException {
        this(name);
        this.setValueAndQuality(value, quality);
    }

    public Variable(String name, Object valueObj) throws ComputationException {
        this(name);
        double value;
        String text = null;
        if (valueObj == null) {
            throw new ComputationException("Value cannot be null.");
        }
        if (valueObj instanceof Double) {
            value = (Double)valueObj;
        } else if (valueObj instanceof Integer) {
            value = ((Integer)valueObj).doubleValue();
        } else if (valueObj instanceof String) {
            text = (String)valueObj;
        } else {
            throw new ComputationException("Cannot parse value from type: " + valueObj.getClass().getName());
        }
        if (text != null) {
            try {
                value = Double.parseDouble(text);
                this.setValue(value);
                text = null;
            }
            catch (NumberFormatException nfe) {
                this.setText(text);
            }
        }
    }

    public Variable(String name, Object value, Object quality) throws ComputationException {
        this(name);
        this.setValueAndQuality(value, quality);
    }

    public synchronized void reset() {
        this.value = -3.4028234663852886E38;
        this.quality = Integer.MIN_VALUE;
        this.text = null;
        this.containsValue = false;
        this.containsQuality = false;
        this.containsText = false;
        this.notifyListeners();
    }

    @Override
    public synchronized void setValue(double value) throws ComputationException {
        double d = this.value = this.allowDenormal ? value : Variable.normalize(value);
        if (this.value == -3.4028234663852886E38 && this.exceptionOnUndefined) {
            throw new ComputationException("Value cannot be undefined.");
        }
        this.containsValue = true;
        this.notifyListeners();
    }

    @Override
    public void setValue(int value) throws ComputationException {
        this.setValue((double)value);
    }

    @Override
    public void setValue(Double value) throws ComputationException {
        if (value == null) {
            throw new ComputationException("Value cannot be null.");
        }
        this.setValue((double)value);
    }

    @Override
    public void setValue(Integer value) throws ComputationException {
        if (value == null) {
            throw new ComputationException("Value cannot be null.");
        }
        this.setValue((double)value.intValue());
    }

    @Override
    public void setValue(String value) throws ComputationException {
        this.setText(value);
    }

    public synchronized void setQuality(int quality) throws ComputationException {
        if (this.containsText) {
            throw new ComputationException("Cannot set quality on text variable");
        }
        this.quality = quality;
        this.containsQuality = quality != Integer.MIN_VALUE;
        this.notifyListeners();
    }

    public void setQuality(Integer quality) throws ComputationException {
        if (quality == null) {
            this.containsQuality = false;
        } else {
            this.setQuality((int)quality);
        }
    }

    public void setQuality(String quality) throws ComputationException {
        if (quality == null) {
            this.containsQuality = false;
        }
        this.setQuality(Integer.parseInt(quality));
    }

    public synchronized void setValueAndQuality(double value, int quality) throws ComputationException {
        double d = this.value = this.allowDenormal ? value : Variable.normalize(value);
        if (this.value == -3.4028234663852886E38 && this.exceptionOnUndefined) {
            throw new ComputationException("Value cannot be undefined.");
        }
        this.value = value;
        this.quality = quality;
        this.text = null;
        this.containsValue = true;
        this.containsQuality = true;
        this.containsText = false;
        this.notifyListeners();
    }

    public void setValueAndQuality(Object valueObj, Object qualityObj) throws ComputationException {
        double value;
        if (valueObj == null) {
            throw new ComputationException("Value cannot be null.");
        }
        if (valueObj instanceof Double) {
            value = (Double)valueObj;
        } else if (valueObj instanceof Integer) {
            value = ((Integer)valueObj).doubleValue();
        } else if (valueObj instanceof String) {
            value = Double.parseDouble((String)valueObj);
        } else {
            throw new ComputationException("Cannot parse value from type: " + valueObj.getClass().getName());
        }
        if (qualityObj == null) {
            this.containsQuality = false;
            this.setValue(value);
        } else {
            int quality;
            if (qualityObj instanceof Integer) {
                quality = (Integer)qualityObj;
            } else if (qualityObj instanceof String) {
                quality = Integer.parseInt((String)qualityObj);
            } else {
                throw new ComputationException("Cannot parse quality from type: " + qualityObj.getClass().getName());
            }
            this.setValueAndQuality(value, quality);
        }
    }

    public void setText(String text) throws ComputationException {
        if (text == null && this.exceptionOnUndefined) {
            throw new ComputationException("Text cannot be undefined");
        }
        this.value = -3.4028234663852886E38;
        this.quality = Integer.MIN_VALUE;
        this.text = text;
        this.containsValue = false;
        this.containsQuality = false;
        this.containsText = text != null;
        this.notifyListeners();
    }

    @Override
    public synchronized double evaluate() throws ComputationException {
        if (this.containsValue) {
            return this.value;
        }
        if (this.containsText) {
            try {
                return Double.parseDouble(this.text);
            }
            catch (NumberFormatException nfe) {
                throw new ComputationException(nfe);
            }
        }
        throw new ComputationException("Variable " + this.name + " has not been set.");
    }

    @Override
    public String evaluateToString() throws ComputationException {
        Variable variable = this;
        synchronized (variable) {
            if (this.containsText) {
                return this.text;
            }
            if (this.containsValue) {
                return Double.toString(this.evaluate());
            }
            throw new ComputationException("Variable " + this.name + " has not been set.");
        }
    }

    public synchronized boolean hasQuality() {
        return this.containsQuality;
    }

    public synchronized int getQuality() throws ComputationException {
        if (!this.containsQuality) {
            throw new ComputationException("Variable " + this.name + " does not have quality.");
        }
        return this.quality;
    }

    protected synchronized void setName(String name) throws ComputationException {
        if (name == null) {
            throw new ComputationException("Variable name cannot be null.");
        }
        this.name = name;
    }

    public synchronized String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String toNotation(Constants.Notation notation) throws ComputationException {
        switch (notation) {
            case S_EXPR: 
            case PREFIX: 
            case POSTFIX: 
            case INFIX: {
                return this.getName();
            }
        }
        throw new ComputationException("Invalid notation:" + notation);
    }

    @Override
    public synchronized boolean getTolerateUndefined() {
        return this.tolerateUndefined;
    }

    @Override
    public synchronized boolean getExceptionOnUndefined() {
        return this.exceptionOnUndefined;
    }

    @Override
    public synchronized boolean getAllowDenormal() {
        return this.allowDenormal;
    }

    @Override
    public synchronized void setTolerateUndefined(boolean setting) {
        this.tolerateUndefined = setting;
    }

    @Override
    public synchronized void setExceptionOnUndefined(boolean setting) {
        this.exceptionOnUndefined = setting;
    }

    @Override
    public synchronized void setAllowDenormal(boolean setting) {
        this.allowDenormal = setting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners == null) {
                this.updateListeners = new HashSet<UpdatableListener>();
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(UpdatableListener listener) {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                this.updateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners() {
        Object object = this.updateListenersLock;
        synchronized (object) {
            if (this.updateListeners != null) {
                for (UpdatableListener l : this.updateListeners) {
                    try {
                        l.dataUpdated(this);
                    }
                    catch (Throwable t) {
                        this.updateListeners.remove(l);
                    }
                }
            }
        }
    }

    @Override
    public void registerAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void unregisterAsListener() {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    @Override
    public void dataUpdated(Updatable u) {
        throw new UnsupportedOperationException("UpdatableListener operations are not supported for class " + this.getClass().getName());
    }

    static {
        theInstance = new Variable();
    }
}

