/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.computation;

import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Variable;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerAligner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VariableSet {
    protected Set<Variable> variables = new HashSet<Variable>();
    protected Map<String, Variable> varByName = new HashMap<String, Variable>();
    protected Map<TimeSeriesContainer, Variable> varByTsc = new HashMap<TimeSeriesContainer, Variable>();
    protected Map<String, TimeSeriesContainer> tscByName = new HashMap<String, TimeSeriesContainer>();
    protected Map<String, Boolean> requiresTscByName = new HashMap<String, Boolean>();

    public synchronized void addVariable(Variable var) {
        if (this.variables.add(var)) {
            String name = var.getName();
            this.varByName.put(name, var);
            this.requiresTscByName.put(name, false);
        }
    }

    public synchronized void addVariable(Variable var, boolean requiresTsc) throws ComputationException {
        this.addVariable(var);
        if (requiresTsc) {
            this.setRequiresTsc(var.getName());
        }
    }

    public synchronized void addVariable(Variable var, TimeSeriesContainer tsc, boolean requiresTsc) throws ComputationException {
        this.addVariable(var);
        this.varByTsc.put(tsc, var);
        this.tscByName.put(var.getName(), tsc);
        if (requiresTsc) {
            this.setRequiresTsc(var.getName());
        }
    }

    public synchronized Variable addVariable(String name) throws ComputationException {
        Variable var = new Variable(name);
        if (!this.varByName.containsKey(name)) {
            this.addVariable(var);
        }
        return var;
    }

    public synchronized Variable addVariable(String name, boolean requiresTsc) throws ComputationException {
        Variable var = new Variable(name);
        if (!this.varByName.containsKey(name)) {
            this.addVariable(var, requiresTsc);
        }
        return var;
    }

    public synchronized Variable addVariable(String name, TimeSeriesContainer tsc, boolean requiresTsc) throws ComputationException {
        Variable var = new Variable(name);
        if (!this.varByName.containsKey(name)) {
            this.addVariable(var, tsc, requiresTsc);
        }
        return var;
    }

    public synchronized int getVariableCount() {
        return this.variables.size();
    }

    public synchronized Set<String> getVariableNames() {
        return this.varByName.keySet();
    }

    public synchronized Variable getVariable(String name) throws ComputationException {
        return this.getVariable(name, false);
    }

    public synchronized Variable getVariable(String name, boolean createIfNecessary) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null && createIfNecessary) {
            var = this.addVariable(name);
        }
        return var;
    }

    public synchronized void reset() throws ComputationException {
        Iterator<Variable> it = this.variables.iterator();
        while (it.hasNext()) {
            it.next().reset();
        }
    }

    public synchronized void setRequiresTsc(String name) throws ComputationException {
        if (!this.varByName.containsKey(name)) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        this.requiresTscByName.put(name, true);
    }

    public synchronized boolean requiresTsc(String name) throws ComputationException {
        if (this.varByName.containsKey(name)) {
            return this.requiresTscByName.get(name);
        }
        throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
    }

    public synchronized void setTimeSeriesContainer(String name, TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesContainer otherTsc;
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        if (this.varByTsc.containsKey(tsc) && (otherTsc = this.tscByName.get(name)) != tsc) {
            String otherName = null;
            for (String varName : this.varByName.keySet()) {
                otherTsc = this.tscByName.get(varName);
                if (otherTsc != tsc) continue;
                otherName = varName;
                break;
            }
            throw new ComputationException(String.format("TimeSeriesContainer %s already set with name %s", tsc, otherName));
        }
        this.varByTsc.put(tsc, var);
        this.tscByName.put(name, tsc);
    }

    public synchronized void setValue(String name, double value) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        if (this.requiresTscByName.get(name).booleanValue()) {
            throw new ComputationException("Variable \"" + name + "\" requires a TimeSeriesContainer.");
        }
        var.setValue(value);
    }

    public synchronized void setValue(String name, int value) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        if (this.requiresTscByName.get(name).booleanValue()) {
            throw new ComputationException("Variable \"" + name + "\" requires a TimeSeriesContainer.");
        }
        var.setValue(value);
    }

    public synchronized void setValue(String name, String value) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        if (this.requiresTscByName.get(name).booleanValue()) {
            throw new ComputationException("Variable \"" + name + "\" requires a TimeSeriesContainer.");
        }
        var.setValue(value);
    }

    public synchronized double getValue(String name) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        return var.evaluate();
    }

    public synchronized void setData(TimeSeriesContainer tsc, int index) throws ComputationException {
        Variable var = this.varByTsc.get(tsc);
        if (var == null) {
            throw new ComputationException("No variable is associated with the TimeSeriesContainer");
        }
        var.setValueAndQuality(tsc.values[index], tsc.quality == null ? 0 : tsc.quality[index]);
    }

    public synchronized void setData(TimeSeriesContainerAligner tsca, int index) throws ComputationException {
        this.setData(tsca.getTsc(index), tsca.getIndex(index));
    }

    public synchronized int getQuality(String name) throws ComputationException {
        Variable var = this.varByName.get(name);
        if (var == null) {
            throw new ComputationException("Variable \"" + name + "\" does not exist in variable set.");
        }
        return var.getQuality();
    }
}

