/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.functions;

import hec.hecmath.computation.Constants;

public class ScalarFunctions
implements Constants {
    public static double roundOffValue(double dvalue, int desiredPrecision, int powerOfTensPlace) {
        if (dvalue == 0.0 || dvalue == -3.4028234663852886E38) {
            return dvalue;
        }
        double dd = dvalue;
        if (dd < 0.0) {
            dd = -dd;
        }
        int e = 0;
        double factor = 1.0;
        while (dd > 10.0) {
            ++e;
            factor /= 10.0;
            dd /= 10.0;
        }
        while (dd < 1.0) {
            --e;
            factor *= 10.0;
            dd *= 10.0;
        }
        int precision = e + 1 - powerOfTensPlace;
        if (precision > desiredPrecision) {
            precision = desiredPrecision;
        }
        double newVal = 0.0;
        if (precision >= 0) {
            double factPrecision = Math.pow(10.0, precision - 1);
            newVal = Math.rint(factPrecision * dd) / factPrecision;
            newVal *= 1.0 / factor;
            if (dvalue < 0.0) {
                newVal = -newVal;
            }
        }
        return newVal;
    }
}

