/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath.functions;

import hec.data.IntervalOffset;
import hec.data.Units;
import hec.data.tx.QualityTx;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleContainer;
import hec.heclib.util.intContainer;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Condition;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.Evaluable;
import hec.hecmath.computation.MathOperation;
import hec.hecmath.computation.QualityTest;
import hec.hecmath.computation.ScalarOperable;
import hec.hecmath.computation.Value;
import hec.hecmath.computation.ValueContainer;
import hec.hecmath.computation.Variable;
import hec.hecmath.computation.VariableSet;
import hec.io.Conversion;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerAligner;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.annotation.Scriptable;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.util.RMAConst;

public class TimeSeriesFunctions
implements Constants {
    private static Object allowUnsafeLock = new Object();
    private static Boolean AlwaysAllowUnsafe = true;
    private static Boolean AlwaysWarnUnsafe = true;
    private static Boolean AlwaysCreateQuality = false;
    private static final String UNSAFE_INTERVAL = "Unsafe math operation: time series have different intervals.";
    private static final String UNSAFE_TYPE = "Unsafe math operation: time series have different data types.";
    private static final String UNSAFE_UNITS = "Unsafe math operation: time series have different units.";
    public static Set<String> validTimeSeriesTypes;
    public static Set<String> instTimeSeriesTypes;
    public static Set<String> periodTimeSeriesTypes;
    public static Set<String> totalTimeSeriesTypes;
    public static Set<String> averageTimeSeriesTypes;
    public static Set<String> dssTimeSeriesTypes;
    public static Set<String> cwmsTimeSeriesTypes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseTimeIntervalString(String timeIntervalStr) throws ComputationException {
        Pattern intervalStringPattern = Pattern.compile("(\\d+)(\\w+)", 2);
        int timeIntervalMinutes = Integer.MIN_VALUE;
        Matcher m = null;
        String timeStr = null;
        m = intervalStringPattern.matcher(timeIntervalStr);
        if (!m.matches()) throw new ComputationException("Invalid time interval string: " + timeIntervalStr);
        timeIntervalMinutes = Integer.parseInt(m.group(1));
        timeStr = m.group(2).toLowerCase();
        if ("minutes".startsWith(timeStr)) return timeIntervalMinutes;
        if ("hours".startsWith(timeStr)) {
            timeIntervalMinutes *= 60;
            return timeIntervalMinutes;
        } else if ("days".startsWith(timeStr)) {
            timeIntervalMinutes *= 1440;
            return timeIntervalMinutes;
        } else if ("weeks".startsWith(timeStr)) {
            timeIntervalMinutes *= 10080;
            return timeIntervalMinutes;
        } else if ("months".startsWith(timeStr)) {
            timeIntervalMinutes *= 43200;
            return timeIntervalMinutes;
        } else {
            if (!"years".startsWith(timeStr)) throw new ComputationException("Invalid time interval string: " + timeIntervalStr);
            timeIntervalMinutes *= 525600;
        }
        return timeIntervalMinutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAlwaysAllowUnsafe(boolean state) {
        boolean previousState;
        Object object = allowUnsafeLock;
        synchronized (object) {
            previousState = AlwaysAllowUnsafe;
            AlwaysAllowUnsafe = state;
        }
        return previousState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAlwaysWarnUnsafe(boolean state) {
        boolean previousState;
        Object object = allowUnsafeLock;
        synchronized (object) {
            previousState = AlwaysWarnUnsafe;
            AlwaysWarnUnsafe = state;
        }
        return previousState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAlwaysCreateQuality(boolean state) {
        boolean previousState;
        Object object = allowUnsafeLock;
        synchronized (object) {
            previousState = AlwaysCreateQuality;
            AlwaysCreateQuality = state;
        }
        return previousState;
    }

    public static void validateTimeSeriesContainer(TimeSeriesContainer tsc) throws ComputationException {
        if (tsc == null) {
            throw new ComputationException("TimeSeriesContainer is null.");
        }
        if (tsc.times == null) {
            throw new ComputationException("TimeSeriesContainer " + tsc.fullName + " had null times array.");
        }
        if (tsc.values == null) {
            throw new ComputationException("TimeSeriesContainer " + tsc.fullName + " had null values array.");
        }
        if (tsc.times.length != tsc.numberValues || tsc.values.length != tsc.numberValues || tsc.quality != null && tsc.quality.length != tsc.numberValues) {
            throw new ComputationException("TimeSeriesContainer is corrupt: " + tsc.fullName);
        }
    }

    public static void validateIndex(TimeSeriesContainer tsc, int index) throws ComputationException {
        if (index < 0 || index > tsc.numberValues) {
            throw new ComputationException("Index " + index + " is out of bounds: " + tsc.fullName);
        }
    }

    public static boolean isRegular(TimeSeriesContainer tsc) {
        return tsc.interval != 0;
    }

    public static boolean isIregular(TimeSeriesContainer tsc) {
        return tsc.interval == 0;
    }

    public static List<ValueContainer> collectValidValues(TimeSeriesContainer tsc) {
        Vector<ValueContainer> list = new Vector<ValueContainer>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            list.add(new ValueContainer(tsc.values[i]));
        }
        return list;
    }

    public static boolean isValid(TimeSeriesContainer tsc, int index) {
        if (index < 0 || index >= tsc.values.length) {
            return false;
        }
        return tsc.quality != null ? !QualityTx.isMissing_int(tsc.quality[index]) && !QualityTx.isReject_int(tsc.quality[index]) && RMAConst.isValidValue(tsc.values[index]) : RMAConst.isValidValue(tsc.values[index]);
    }

    protected static boolean isMissing(TimeSeriesContainer tsc, int index) {
        if (tsc.quality != null) {
            return QualityTx.isMissing_int(tsc.quality[index]) || tsc.values[index] == -3.4028234663852886E38;
        }
        return tsc.values[index] == -3.4028234663852886E38;
    }

    public static int bisearch(int[] xarray, int x, int n) {
        int lo = 0;
        int hi = n + 1;
        int mid = -1;
        if (xarray[n - 1] > xarray[0]) {
            while (hi - lo > 1) {
                mid = (hi + lo) / 2;
                if (xarray[mid - 1] > x) {
                    hi = mid;
                    continue;
                }
                lo = mid;
            }
        } else {
            while (hi - lo > 1) {
                mid = (hi + lo) / 2;
                if (xarray[mid - 1] < x) {
                    hi = mid;
                    continue;
                }
                lo = mid;
            }
        }
        return lo - 1;
    }

    public static int bisearch(double[] xarray, double x, int n) {
        int lo = 0;
        int hi = n + 1;
        int mid = -1;
        if (xarray[n - 1] > xarray[0]) {
            while (hi - lo > 1) {
                mid = (hi + lo) / 2;
                if (xarray[mid - 1] > x) {
                    hi = mid;
                    continue;
                }
                lo = mid;
            }
        } else {
            while (hi - lo > 1) {
                mid = (hi + lo) / 2;
                if (xarray[mid - 1] < x) {
                    hi = mid;
                    continue;
                }
                lo = mid;
            }
        }
        return lo - 1;
    }

    public static int findInterval(int[] times, int time, int lastIndex) {
        if (time < times[0] || time > times[times.length - 1]) {
            return Integer.MIN_VALUE;
        }
        int idx = lastIndex;
        if (idx < 0 || idx >= times.length - 1) {
            idx = 0;
        }
        if (idx < times.length - 1 && time >= times[idx] && time < times[idx + 1]) {
            return idx;
        }
        if (++idx < times.length - 1 && time >= times[idx] && time < times[idx + 1]) {
            return idx;
        }
        idx = Arrays.binarySearch(times, time);
        if (idx < 0) {
            idx = -idx - 2;
        }
        return idx;
    }

    public static int findValidValue(TimeSeriesContainer tsc, int index, boolean lookAfter) {
        int validIndex = Integer.MIN_VALUE;
        if (lookAfter) {
            for (int i = index + 1; i < tsc.values.length; ++i) {
                if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
                validIndex = i;
                break;
            }
        } else {
            for (int i = index - 1; i >= 0; --i) {
                if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
                validIndex = i;
                break;
            }
        }
        return validIndex;
    }

    public static double integrate(TimeSeriesContainer tsc, int time0, int time1, String dataType, int functionType, double missingAllowed, intContainer lastIndex, doubleContainer sumTime) {
        double deltaTime;
        int jlast;
        int ilast;
        if (time0 >= time1) {
            return -3.4028234663852886E38;
        }
        if (tsc.interval <= 0 && time0 < tsc.times[0]) {
            return -3.4028234663852886E38;
        }
        if (time1 < tsc.startTime || time0 > tsc.times[tsc.times.length - 1]) {
            return -3.4028234663852886E38;
        }
        int ifirst = Integer.MIN_VALUE;
        ifirst = time0 >= tsc.times[0] ? TimeSeriesFunctions.findInterval(tsc.times, time0, lastIndex.value) : -1;
        if (ifirst == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        if (time1 == tsc.times[tsc.times.length - 1]) {
            ilast = tsc.times.length - 2;
        } else {
            ilast = TimeSeriesFunctions.findInterval(tsc.times, time1, ifirst);
            if (ilast == Integer.MIN_VALUE) {
                HecTime nextTime = new HecTime();
                nextTime.set(time0);
                nextTime.increment(1, tsc.interval);
                if (ifirst == -1 && periodTimeSeriesTypes.contains(dataType.toLowerCase()) && nextTime.value() >= tsc.times[0]) {
                    ilast = -1;
                } else {
                    return -3.4028234663852886E38;
                }
            }
            if (ilast > -1 && ilast < tsc.times.length && tsc.times[ilast] == time1) {
                --ilast;
            }
        }
        double numberExpectedPoints = ilast - ifirst + 2;
        if (tsc.interval > 0) {
            numberExpectedPoints = HecTime.computeNumberIntervals(time0, time1, tsc.interval);
            if (instTimeSeriesTypes.contains(dataType.toLowerCase())) {
                numberExpectedPoints += 1.0;
            }
        }
        int numberBadAllowed = (int)(missingAllowed * numberExpectedPoints);
        int numberBad = 0;
        if (tsc.interval > 0) {
            HecTime htime = new HecTime(tsc.times[0], 1);
            htime.increment(-1, tsc.interval);
            int tscTime0 = htime.value();
            if (time0 < tscTime0) {
                numberBad = HecTime.computeNumberIntervals(time0, tscTime0, tsc.interval);
                if (instTimeSeriesTypes.contains(dataType.toLowerCase())) {
                    ++numberBad;
                }
            } else if (time1 > tsc.times[tsc.times.length - 1]) {
                numberBad = HecTime.computeNumberIntervals(tsc.times[tsc.times.length - 1], time1, tsc.interval) + 1;
            }
        }
        if (instTimeSeriesTypes.contains(dataType.toLowerCase()) && ifirst >= 0 && !TimeSeriesFunctions.isValid(tsc, ifirst)) {
            ++numberBad;
        }
        if ((jlast = ilast + 1) > tsc.values.length - 1) {
            jlast = tsc.values.length - 1;
        }
        for (int i = ifirst + 1; i <= jlast; ++i) {
            if (TimeSeriesFunctions.isValid(tsc, i)) continue;
            ++numberBad;
        }
        if (numberBad > numberBadAllowed) {
            return -3.4028234663852886E38;
        }
        double val0 = 0.0;
        double val1 = 0.0;
        double sumArea = 0.0;
        double accumulate = 0.0;
        sumTime.value = 0.0;
        int istepsForAveraging = 0;
        for (int i = ifirst + 1; i < ilast; ++i) {
            deltaTime = tsc.times[i + 1] - tsc.times[i];
            val1 = tsc.values[i + 1];
            if (instTimeSeriesTypes.contains(dataType.toLowerCase())) {
                val0 = tsc.values[i];
            } else if (averageTimeSeriesTypes.contains(dataType.toLowerCase())) {
                val0 = tsc.values[i + 1];
            } else if (totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
                val0 = 0.0;
            }
            if (val0 == -3.4028234663852886E38 || val1 == -3.4028234663852886E38) continue;
            sumArea += deltaTime * 0.5 * (val0 + val1);
            sumTime.value += deltaTime;
            accumulate += val1;
            ++istepsForAveraging;
        }
        double avgDeltaTime = tsc.interval < 1 ? (istepsForAveraging > 0 ? sumTime.value / (double)istepsForAveraging : (double)(time1 - time0)) : (double)tsc.interval;
        lastIndex.value = ifirst;
        double valTime0 = -3.4028234663852886E38;
        if (ifirst >= 0 && time0 == tsc.times[ifirst]) {
            if (averageTimeSeriesTypes.contains(dataType.toLowerCase())) {
                valTime0 = tsc.values[ifirst + 1];
            } else if (totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
                valTime0 = 0.0;
            }
        }
        if (time0 < tsc.times[0] && averageTimeSeriesTypes.contains(dataType.toLowerCase())) {
            valTime0 = tsc.values[ifirst + 1];
        }
        if (valTime0 == -3.4028234663852886E38) {
            valTime0 = TimeSeriesFunctions.interpolate(tsc, time0, dataType, lastIndex);
        }
        lastIndex.value = ilast;
        double valTime1 = TimeSeriesFunctions.interpolate(tsc, time1, dataType, lastIndex);
        if (ilast < ifirst + 1) {
            if (valTime0 != -3.4028234663852886E38 && tsc.values[ifirst + 1] != -3.4028234663852886E38) {
                deltaTime = time1 - time0;
                sumArea += deltaTime * 0.5 * (valTime0 + valTime1);
                sumTime.value += deltaTime;
                accumulate = totalTimeSeriesTypes.contains(dataType.toLowerCase()) ? (accumulate += valTime1 - valTime0) : (accumulate += valTime1);
            }
        } else {
            if (valTime0 != -3.4028234663852886E38 && tsc.values[ifirst + 1] != -3.4028234663852886E38) {
                deltaTime = tsc.times[ifirst + 1] - time0;
                sumArea += deltaTime * 0.5 * (valTime0 + tsc.values[ifirst + 1]);
                sumTime.value += deltaTime;
                accumulate = totalTimeSeriesTypes.contains(dataType.toLowerCase()) ? (accumulate += tsc.values[ifirst + 1] - valTime0) : (accumulate += tsc.values[ifirst + 1]);
            }
            if (valTime1 != -3.4028234663852886E38) {
                deltaTime = time1 - tsc.times[ilast];
                double valilast = tsc.values[ilast];
                if (averageTimeSeriesTypes.contains(dataType.toLowerCase()) && ilast < tsc.numberValues - 1) {
                    valilast = tsc.values[ilast + 1];
                } else if (totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
                    valilast = 0.0;
                }
                if (valilast != -3.4028234663852886E38) {
                    sumArea += deltaTime * 0.5 * (valTime1 + valilast);
                    sumTime.value += deltaTime;
                    accumulate += valTime1;
                }
            }
        }
        if (functionType == 16 && totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
            sumTime.value = avgDeltaTime;
            if (istepsForAveraging == 0 && valTime1 == -3.4028234663852886E38) {
                return -3.4028234663852886E38;
            }
            return accumulate;
        }
        if (functionType == 16) {
            sumTime.value = avgDeltaTime;
        }
        return sumArea;
    }

    public static double intervalStats(int functionType, TimeSeriesContainer tsc, int time0, int time1, int interval, String dataType, double missingAllowed, intContainer lastIndex, intContainer timeOfOccurrence) {
        int ilast;
        timeOfOccurrence.value = time1;
        if (time0 >= time1) {
            return -3.4028234663852886E38;
        }
        if (tsc.interval <= 0 && time1 < tsc.times[0]) {
            return -3.4028234663852886E38;
        }
        if (time1 < tsc.times[0] || time0 > tsc.times[tsc.times.length - 1]) {
            return -3.4028234663852886E38;
        }
        int ifirst = Integer.MIN_VALUE;
        ifirst = time0 >= tsc.times[0] ? TimeSeriesFunctions.findInterval(tsc.times, time0, lastIndex.value) : 0;
        if (ifirst == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        if (ifirst <= lastIndex.value) {
            ifirst = lastIndex.value + 1;
        }
        if (time1 == tsc.times[tsc.times.length - 1]) {
            ilast = tsc.times.length - 1;
        } else {
            ilast = TimeSeriesFunctions.findInterval(tsc.times, time1, ifirst);
            if (ilast == Integer.MIN_VALUE) {
                if (time1 > tsc.times[tsc.times.length - 1]) {
                    ilast = tsc.times.length - 1;
                } else {
                    return -3.4028234663852886E38;
                }
            }
        }
        lastIndex.value = ilast;
        double minValue = 3.4028234663852886E38;
        double maxValue = -3.4028234663852886E38;
        int minTime = 0;
        int maxTime = 0;
        int lastTime = time0;
        int numberGood = 0;
        if (time1 - time0 <= tsc.interval) {
            if (tsc.times[ilast] >= time1 && TimeSeriesFunctions.isValid(tsc, ilast)) {
                if (tsc.values[ilast] < minValue) {
                    minValue = tsc.values[ilast];
                    minTime = tsc.times[ilast];
                }
                if (tsc.values[ilast] > maxValue) {
                    maxValue = tsc.values[ilast];
                    maxTime = tsc.times[ilast];
                }
                ++numberGood;
                lastTime = tsc.times[ilast];
            }
        } else {
            for (int i = ifirst; i <= ilast; ++i) {
                if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
                if (tsc.values[i] < minValue) {
                    minValue = tsc.values[i];
                    minTime = tsc.times[i];
                }
                if (tsc.values[i] > maxValue) {
                    maxValue = tsc.values[i];
                    maxTime = tsc.times[i];
                }
                ++numberGood;
                lastTime = tsc.times[i];
            }
        }
        double functionValue = -3.4028234663852886E38;
        if (functionType == 12) {
            if (maxValue != -3.4028234663852886E38) {
                functionValue = maxValue;
            }
            timeOfOccurrence.value = maxTime;
        } else if (functionType == 13) {
            if (minValue != 3.4028234663852886E38) {
                functionValue = minValue;
            }
            timeOfOccurrence.value = minTime;
        } else if (functionType == 18) {
            functionValue = numberGood;
            timeOfOccurrence.value = lastTime;
        }
        return functionValue;
    }

    public static TimeSeriesContainer add(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ADDITION);
    }

    public static TimeSeriesContainer add(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ADDITION);
    }

    public static TimeSeriesContainer subtract(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SUBTRACTION);
    }

    public static TimeSeriesContainer subtract(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SUBTRACTION);
    }

    public static TimeSeriesContainer multiply(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MULTIPLICATION);
    }

    public static TimeSeriesContainer multiply(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MULTIPLICATION);
    }

    public static TimeSeriesContainer divide(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.DIVISION);
    }

    public static TimeSeriesContainer divide(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.DIVISION);
    }

    public static TimeSeriesContainer integer_divide(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.INTEGER_DIVISION);
    }

    public static TimeSeriesContainer integer_divide(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.INTEGER_DIVISION);
    }

    public static TimeSeriesContainer modulo(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MODULO);
    }

    public static TimeSeriesContainer modulo(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MODULO);
    }

    public static TimeSeriesContainer exponentiation(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.EXPONENTIATION);
    }

    public static TimeSeriesContainer exponentiation(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.EXPONENTIATION);
    }

    public static TimeSeriesContainer abs(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ABS);
    }

    public static TimeSeriesContainer abs(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ABS);
    }

    public static TimeSeriesContainer neg(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.NEG);
    }

    public static TimeSeriesContainer neg(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.NEG);
    }

    public static TimeSeriesContainer inverse(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.INV);
    }

    public static TimeSeriesContainer inverse(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.INV);
    }

    public static TimeSeriesContainer sign(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SIGN);
    }

    public static TimeSeriesContainer sign(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SIGN);
    }

    public static TimeSeriesContainer sqrt(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SQRT);
    }

    public static TimeSeriesContainer sqrt(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SQRT);
    }

    public static TimeSeriesContainer exp(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.EXP);
    }

    public static TimeSeriesContainer exp(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.EXP);
    }

    public static TimeSeriesContainer log(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.LOG);
    }

    public static TimeSeriesContainer log(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.LOG);
    }

    public static TimeSeriesContainer log10(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.LOG10);
    }

    public static TimeSeriesContainer log10(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.LOG10);
    }

    public static TimeSeriesContainer sin(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SIN);
    }

    public static TimeSeriesContainer sin(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SIN);
    }

    public static TimeSeriesContainer cos(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.COS);
    }

    public static TimeSeriesContainer cos(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.COS);
    }

    public static TimeSeriesContainer tan(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.TAN);
    }

    public static TimeSeriesContainer tan(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.TAN);
    }

    public static TimeSeriesContainer asin(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ASIN);
    }

    public static TimeSeriesContainer asin(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ASIN);
    }

    public static TimeSeriesContainer acos(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ACOS);
    }

    public static TimeSeriesContainer acos(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ACOS);
    }

    public static TimeSeriesContainer atan(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ATAN);
    }

    public static TimeSeriesContainer atan(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ATAN);
    }

    public static TimeSeriesContainer floor(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.FLOOR);
    }

    public static TimeSeriesContainer floor(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.FLOOR);
    }

    public static TimeSeriesContainer ceil(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.CEIL);
    }

    public static TimeSeriesContainer ceil(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.CEIL);
    }

    public static TimeSeriesContainer round(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ROUND);
    }

    public static TimeSeriesContainer round(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.ROUND);
    }

    public static TimeSeriesContainer truncate(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.TRUNC);
    }

    public static TimeSeriesContainer truncate(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.TRUNC);
    }

    public static TimeSeriesContainer fmod(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.FMOD);
    }

    public static TimeSeriesContainer fmod(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.FMOD);
    }

    public static TimeSeriesContainer sum(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SUM);
    }

    public static TimeSeriesContainer sum(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.SUM);
    }

    public static TimeSeriesContainer product(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.PROD);
    }

    public static TimeSeriesContainer product(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.PROD);
    }

    public static TimeSeriesContainer max(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MAX);
    }

    public static TimeSeriesContainer max(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MAX);
    }

    public static TimeSeriesContainer min(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MIN);
    }

    public static TimeSeriesContainer min(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MIN);
    }

    public static TimeSeriesContainer mean(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MEAN);
    }

    public static TimeSeriesContainer mean(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MEAN);
    }

    public static TimeSeriesContainer gmean(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.GMEAN);
    }

    public static TimeSeriesContainer gmean(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.GMEAN);
    }

    public static TimeSeriesContainer hmean(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.HMEAN);
    }

    public static TimeSeriesContainer hmean(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.HMEAN);
    }

    public static TimeSeriesContainer rms(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.RMS);
    }

    public static TimeSeriesContainer rms(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.RMS);
    }

    public static TimeSeriesContainer stdev(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.STDEV);
    }

    public static TimeSeriesContainer stdev(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.STDEV);
    }

    public static TimeSeriesContainer var(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.VAR);
    }

    public static TimeSeriesContainer var(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.VAR);
    }

    public static TimeSeriesContainer med(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MED);
    }

    public static TimeSeriesContainer med(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.MED);
    }

    public static TimeSeriesContainer p1(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P1);
    }

    public static TimeSeriesContainer p1(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P1);
    }

    public static TimeSeriesContainer p2(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P2);
    }

    public static TimeSeriesContainer p2(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P2);
    }

    public static TimeSeriesContainer p5(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P5);
    }

    public static TimeSeriesContainer p5(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P5);
    }

    public static TimeSeriesContainer p10(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P10);
    }

    public static TimeSeriesContainer p10(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P10);
    }

    public static TimeSeriesContainer p20(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P20);
    }

    public static TimeSeriesContainer p20(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P20);
    }

    public static TimeSeriesContainer p25(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P25);
    }

    public static TimeSeriesContainer p25(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P25);
    }

    public static TimeSeriesContainer p75(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P75);
    }

    public static TimeSeriesContainer p75(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P75);
    }

    public static TimeSeriesContainer p80(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P80);
    }

    public static TimeSeriesContainer p80(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P80);
    }

    public static TimeSeriesContainer p90(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P90);
    }

    public static TimeSeriesContainer p90(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P90);
    }

    public static TimeSeriesContainer p95(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P95);
    }

    public static TimeSeriesContainer p95(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P95);
    }

    public static TimeSeriesContainer p98(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P98);
    }

    public static TimeSeriesContainer p98(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P98);
    }

    public static TimeSeriesContainer p99(List<ValueContainer> vcl, Condition c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P99);
    }

    public static TimeSeriesContainer p99(List<ValueContainer> vcl, String c2) throws ComputationException {
        return TimeSeriesFunctions.operate(vcl, c2, Constants.MathOperator.P99);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeSeriesContainer operate(List<ValueContainer> vcl, String conditionStr, Constants.MathOperator op) throws ComputationException {
        boolean createQuality;
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
            createQuality = AlwaysCreateQuality;
        }
        return TimeSeriesFunctions.operate(vcl, conditionStr, op, allowUnsafe, warnUnsafe, createQuality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeSeriesContainer operate(List<ValueContainer> vcl, Condition condition, Constants.MathOperator op) throws ComputationException {
        boolean createQuality;
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
            createQuality = AlwaysCreateQuality;
        }
        return TimeSeriesFunctions.operate(vcl, condition, op, allowUnsafe, warnUnsafe, createQuality);
    }

    private static TimeSeriesContainer operate(List<ValueContainer> vcl, String conditionStr, Constants.MathOperator op, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        Condition condition = null;
        if (conditionStr != null && conditionStr.length() > 0) {
            condition = new Condition(conditionStr);
            VariableSet varSet = condition.getVariables();
            Set<String> varNames = varSet.getVariableNames();
            if (varNames.size() > vcl.size()) {
                throw new ComputationException("Condition requires too many variables: " + conditionStr);
            }
            for (String varName : varNames) {
                if (varName.length() < 2 || varName.charAt(0) != '$') {
                    throw new ComputationException("Invalid variable name \"" + varName + "\" in condtion: " + conditionStr);
                }
                try {
                    int i = Integer.parseInt(varName.substring(1));
                    if (i >= 0 && i < vcl.size()) continue;
                    throw new ComputationException("Variable name \"" + varName + "\" is greater than number of parameters");
                }
                catch (NumberFormatException nfe) {
                    throw new ComputationException("Invalid variable name \"" + varName + "\" in condtion: " + conditionStr);
                }
            }
        }
        return TimeSeriesFunctions.operate(vcl, condition, op, allowUnsafe, warnUnsafe, createQuality);
    }

    private static TimeSeriesContainer operate(List<ValueContainer> vcl, Condition condition, Constants.MathOperator op, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        int j;
        int i;
        boolean unsafe = false;
        TimeSeriesContainer baseTsc = null;
        TimeSeriesContainer tsc = null;
        TimeSeriesContainer result = null;
        TimeSeriesContainer[] tscs = null;
        Vector<TimeSeriesContainer> tscList = new Vector<TimeSeriesContainer>();
        String name = null;
        int[] v = null;
        if (vcl == null) {
            throw new ComputationException("Null array of ValueContainers supplied.");
        }
        VariableSet varSet = condition == null ? null : condition.getVariables();
        boolean first = true;
        for (ValueContainer vc : vcl) {
            if (vc == null) {
                throw new ComputationException("Null ValueContainer supplied.");
            }
            if (first) {
                if (!vc.isTimeSeriesContainer()) {
                    throw new ComputationException("First ValueContainer is not a TimeSeriesContainer");
                }
                baseTsc = vc.getTimeSeriesContainer();
                first = false;
            }
            if (vc.isTimeSeriesContainer()) {
                tsc = vc.getTimeSeriesContainer();
                if (tsc.times == null || tsc.values == null || tsc.times.length == 0 || tsc.values.length != tsc.times.length || tsc.quality != null && tsc.quality.length != tsc.times.length || tsc.numberValues != tsc.times.length) {
                    throw new ComputationException("Invalid TimeSeriesContainer: " + tsc.fullName);
                }
                if (baseTsc != null && tsc != baseTsc) {
                    unsafe = false;
                    if (TimeSeriesFunctions.isRegular(tsc) && TimeSeriesFunctions.isRegular(baseTsc) && tsc.interval != baseTsc.interval && (averageTimeSeriesTypes.contains(tsc.type.toLowerCase()) || totalTimeSeriesTypes.contains(tsc.type.toLowerCase()) || averageTimeSeriesTypes.contains(baseTsc.type.toLowerCase()) || totalTimeSeriesTypes.contains(baseTsc.type.toLowerCase()))) {
                        if (!allowUnsafe) {
                            throw new ComputationException(UNSAFE_INTERVAL);
                        }
                        if (warnUnsafe) {
                            Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, UNSAFE_INTERVAL, new ComputationException(UNSAFE_INTERVAL));
                        }
                        unsafe = true;
                    }
                    switch (op) {
                        case ADDITION: 
                        case SUBTRACTION: {
                            if (!tsc.type.equalsIgnoreCase(baseTsc.type)) {
                                if (!allowUnsafe) {
                                    throw new ComputationException(UNSAFE_TYPE);
                                }
                                if (warnUnsafe) {
                                    Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, UNSAFE_TYPE, new ComputationException(UNSAFE_TYPE));
                                }
                                unsafe = true;
                            }
                            if (tsc.units.equalsIgnoreCase(baseTsc.units)) break;
                            if (!allowUnsafe) {
                                throw new ComputationException(UNSAFE_UNITS);
                            }
                            if (warnUnsafe) {
                                Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, UNSAFE_UNITS, new ComputationException(UNSAFE_UNITS));
                            }
                            unsafe = true;
                            break;
                        }
                    }
                    if (unsafe && warnUnsafe) {
                        Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, "\t{0}", baseTsc.fullName);
                        Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, "\t{0}\n", tsc.fileName);
                    }
                }
                tscList.add(tsc);
                continue;
            }
            if (vc.isDouble()) {
                if (vc.getValue() != -3.4028234663852886E38) continue;
                throw new ComputationException("ValueContainer contains UNDEFINED value.");
            }
            throw new ComputationException("ValueContainer has not been initialized.");
        }
        tscs = new TimeSeriesContainer[tscList.size()];
        tscList.toArray(tscs);
        result = (TimeSeriesContainer)baseTsc.clone();
        if (result.quality == null && createQuality) {
            result.quality = new int[result.numberValues];
        }
        for (i = 0; i < result.numberValues; ++i) {
            result.values[i] = -3.4028234663852886E38;
            if (result.quality == null) continue;
            result.quality[i] = QualityTx.setMissing_int(0);
        }
        Value[] vals = null;
        Variable[] vars = null;
        v = new int[tscs.length];
        if (condition == null) {
            vals = new Value[vcl.size()];
            j = 0;
            for (i = 0; i < vcl.size(); ++i) {
                vals[i] = new Value();
                if (vcl.get(i).isDouble()) {
                    vals[i].setValue(vcl.get(i).getValue());
                    continue;
                }
                v[j++] = i;
            }
        } else {
            vars = new Variable[vcl.size()];
            j = 0;
            for (i = 0; i < vcl.size(); ++i) {
                name = "$" + i;
                vars[i] = varSet.getVariable(name, true);
                if (vcl.get(i).isDouble()) {
                    vars[i].setValue(vcl.get(i).getValue());
                    continue;
                }
                v[j] = i;
                varSet.setTimeSeriesContainer(name, tscs[j++]);
            }
        }
        MathOperation operation = new MathOperation(op, (Evaluable[])(vals == null ? vars : vals));
        TimeSeriesContainerAligner tsca = new TimeSeriesContainerAligner(tscs);
        for (i = 0; i < result.numberValues && tsca.hasCurrent(); ++i) {
            for (j = 0; j < tscs.length && tsca.getValue(j) != -3.4028234663852886E38 && !QualityTx.isMissing_int(tsca.getQuality(j)); ++j) {
                if (condition == null) {
                    vals[v[j]].setValue(tsca.getValue(j));
                    continue;
                }
                name = "$" + v[j];
                varSet.setData(tsca, j);
            }
            if (j == tscs.length) {
                if (condition == null || condition.test()) {
                    result.values[i] = operation.evaluate();
                    if (result.quality != null) {
                        result.quality[i] = QualityTx.clearMissing_int(result.quality[i]);
                        for (j = 0; j < tscs.length; ++j) {
                            if (QualityTest.compareQuality(result.quality[i], tsca.getQuality(j)) >= 0) continue;
                            result.quality[i] = tsca.getQuality(j);
                        }
                    }
                } else if (condition != null) {
                    result.values[i] = baseTsc.values[i];
                    if (result.quality != null) {
                        result.quality[i] = baseTsc.quality[i];
                    }
                }
            }
            tsca.alignNext();
        }
        return result;
    }

    @Scriptable
    public static TimeSeriesContainer roundOff(TimeSeriesContainer tsc, int digitsPrecision, int powerOfTensPlace) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int null_quality = 0;
        int missing = QualityTx.setMissing_int(null_quality);
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        boolean createQuality = AlwaysCreateQuality;
        if (tsc.quality == null && createQuality) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        if (digitsPrecision < 1) {
            digitsPrecision = 1;
        } else if (digitsPrecision > 8) {
            digitsPrecision = 8;
        }
        for (int i = 0; i < myTsc.numberValues; ++i) {
            if (TimeSeriesFunctions.isMissing(myTsc, i)) {
                if (myTsc.quality == null) continue;
                myTsc.quality[i] = missing;
                continue;
            }
            myTsc.values[i] = HecMath.roundOffValue(myTsc.values[i], digitsPrecision, powerOfTensPlace);
            if (myTsc.quality == null) continue;
            myTsc.quality[i] = null_quality;
        }
        return myTsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scriptable
    public static TimeSeriesContainer accumulation(TimeSeriesContainer tsc) throws ComputationException {
        boolean createQuality;
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
            createQuality = AlwaysCreateQuality;
        }
        return TimeSeriesFunctions.accumulation(tsc, allowUnsafe, warnUnsafe, createQuality);
    }

    @Scriptable
    public static TimeSeriesContainer accumulation(TimeSeriesContainer tsc, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        boolean unsafe;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        boolean bl = unsafe = !totalTimeSeriesTypes.contains(tsc.type.toLowerCase());
        if (unsafe) {
            if (!allowUnsafe) {
                throw new ComputationException("Unsafe math operation: cannot accumulate data type " + tsc.type + "on " + tsc.fullName);
            }
            if (warnUnsafe) {
                System.err.println("Unsafe math operation: accumulating data type " + tsc.type + ".\n\t" + tsc.fullName);
            }
        }
        int null_quality = 0;
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        double sum = 0.0;
        for (int i = 0; i < myTsc.numberValues; ++i) {
            if (myTsc.quality != null && !QualityTx.isNotProtected_int(myTsc.quality[i])) continue;
            myTsc.values[i] = TimeSeriesFunctions.isValid(myTsc, i) ? (sum += myTsc.values[i]) : sum;
            if (myTsc.quality == null) continue;
            myTsc.quality[i] = null_quality;
        }
        if (!unsafe) {
            myTsc.type = dssTimeSeriesTypes.contains(tsc.type.toLowerCase()) ? "INST-CUM" : "Inst";
        }
        return myTsc;
    }

    @Scriptable
    public static double min(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.min(tsc, Double.NEGATIVE_INFINITY);
    }

    @Scriptable
    public static double min(TimeSeriesContainer tsc, double floor) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double minValue = Double.POSITIVE_INFINITY;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i) || !(tsc.values[i] < minValue) || !(tsc.values[i] > floor)) continue;
            minValue = tsc.values[i];
        }
        return minValue == Double.POSITIVE_INFINITY ? -3.4028234663852886E38 : minValue;
    }

    @Scriptable
    public static int minDate(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.minDate(tsc, Double.NEGATIVE_INFINITY);
    }

    @Scriptable
    public static int minDate(TimeSeriesContainer tsc, double floor) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double minValue = Double.POSITIVE_INFINITY;
        int minDate = Integer.MIN_VALUE;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i) || !(tsc.values[i] < minValue) || !(tsc.values[i] > floor)) continue;
            minValue = tsc.values[i];
            minDate = tsc.times[i];
        }
        return minDate;
    }

    @Scriptable
    public static double max(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.max(tsc, Double.POSITIVE_INFINITY);
    }

    @Scriptable
    public static double max(TimeSeriesContainer tsc, double ceiling) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double maxValue = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i) || !(tsc.values[i] > maxValue) || !(tsc.values[i] < ceiling)) continue;
            maxValue = tsc.values[i];
        }
        return maxValue == Double.NEGATIVE_INFINITY ? -3.4028234663852886E38 : maxValue;
    }

    @Scriptable
    public static int maxDate(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.maxDate(tsc, Double.POSITIVE_INFINITY);
    }

    @Scriptable
    public static int maxDate(TimeSeriesContainer tsc, double ceiling) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double maxValue = Double.NEGATIVE_INFINITY;
        int maxDate = Integer.MIN_VALUE;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i) || !(tsc.values[i] > maxValue) || !(tsc.values[i] < ceiling)) continue;
            maxValue = tsc.values[i];
            maxDate = tsc.times[i];
        }
        return maxDate;
    }

    @Scriptable
    public static double mean(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double sum = 0.0;
        int validCount = 0;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            sum += tsc.values[i];
            ++validCount;
        }
        return validCount > 0 ? sum / (double)validCount : -3.4028234663852886E38;
    }

    private static double mathOperatorFunc(TimeSeriesContainer tsc, Constants.MathOperator mathOperator) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        ArrayList<Value> vals = new ArrayList<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        if (!vals.isEmpty()) {
            return new MathOperation(mathOperator, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double gmean(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.GMEAN);
    }

    @Scriptable
    public static double hmean(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.HMEAN);
    }

    @Scriptable
    public static double rms(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.RMS);
    }

    @Scriptable
    public static double var(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.VAR);
    }

    @Scriptable
    public static double sum(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        double sum = 0.0;
        int validCount = 0;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            sum += tsc.values[i];
            ++validCount;
        }
        return validCount > 0 ? sum : -3.4028234663852886E38;
    }

    @Scriptable
    public static double standardDeviation(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.STDEV);
    }

    @Scriptable
    public static double skewCoefficient(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.SKEW);
    }

    @Scriptable
    public static double kurtosisCoefficient(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.KURT);
    }

    @Scriptable
    public static double mode(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.MODE);
    }

    @Scriptable
    public static double med(TimeSeriesContainer tsc) throws ComputationException {
        return TimeSeriesFunctions.mathOperatorFunc(tsc, Constants.MathOperator.MED);
    }

    @Scriptable
    public static double p1(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        ArrayList<Value> vals = new ArrayList<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (!vals.isEmpty()) {
            return new MathOperation(Constants.MathOperator.P1, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p2(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P2, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p5(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P5, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p10(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P10, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p20(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P20, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p25(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P25, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p75(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P75, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p80(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P80, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p90(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P90, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p95(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P95, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p98(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P98, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static double p99(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        Vector<Value> vals = new Vector<Value>();
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            vals.add(new Value(tsc.values[i]));
        }
        Collections.sort(vals);
        if (vals.size() > 0) {
            return new MathOperation(Constants.MathOperator.P99, false, vals).evaluate();
        }
        return -3.4028234663852886E38;
    }

    @Scriptable
    public static int numberValidValues(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int count = 0;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isValid(tsc, i)) continue;
            ++count;
        }
        return count;
    }

    @Scriptable
    public static int numberInvalidValues(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int count = 0;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (TimeSeriesFunctions.isValid(tsc, i)) continue;
            ++count;
        }
        return count;
    }

    @Scriptable
    public static int numberMissingValues(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int count = 0;
        for (int i = 0; i < tsc.numberValues; ++i) {
            if (!TimeSeriesFunctions.isMissing(tsc, i)) continue;
            ++count;
        }
        return count;
    }

    @Scriptable
    public static int numberRejectedValues(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int count = 0;
        if (tsc.quality != null) {
            for (int i = 0; i < tsc.numberValues; ++i) {
                if (!QualityTx.isReject_int(tsc.quality[i])) continue;
                ++count;
            }
        }
        return count;
    }

    @Scriptable
    public static int numberQuestionedValues(TimeSeriesContainer tsc) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int count = 0;
        if (tsc.quality != null) {
            for (int i = 0; i < tsc.numberValues; ++i) {
                if (!QualityTx.isQuestion_int(tsc.quality[i])) continue;
                ++count;
            }
        }
        return count;
    }

    @Scriptable
    public static int firstValidDate(TimeSeriesContainer tsc) throws ComputationException {
        int i;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        for (i = 0; i < tsc.numberValues && !TimeSeriesFunctions.isValid(tsc, i); ++i) {
        }
        return i == tsc.values.length ? Integer.MIN_VALUE : tsc.times[i];
    }

    @Scriptable
    public static double firstValidValue(TimeSeriesContainer tsc) throws ComputationException {
        int i;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        for (i = 0; i < tsc.numberValues && !TimeSeriesFunctions.isValid(tsc, i); ++i) {
        }
        return i == tsc.values.length ? -3.4028234663852886E38 : tsc.values[i];
    }

    @Scriptable
    public static int lastValidDate(TimeSeriesContainer tsc) throws ComputationException {
        int i;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        for (i = tsc.numberValues - 1; i >= 0 && !TimeSeriesFunctions.isValid(tsc, i); --i) {
        }
        return i < 0 ? Integer.MIN_VALUE : tsc.times[i];
    }

    @Scriptable
    public static double lastValidValue(TimeSeriesContainer tsc) throws ComputationException {
        int i;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        for (i = tsc.numberValues - 1; i >= 0 && !TimeSeriesFunctions.isValid(tsc, i); --i) {
        }
        return i < 0 ? -3.4028234663852886E38 : tsc.values[i];
    }

    @Scriptable
    public static TimeSeriesContainer differences(TimeSeriesContainer tsc, boolean time_based, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        boolean safe = instTimeSeriesTypes.contains(tsc.type.toLowerCase());
        if (!safe) {
            String name;
            String string = name = time_based ? "time derivatives" : "successive differences";
            if (!allowUnsafe) {
                throw new ComputationException("Unsafe math operation: cannot compute " + name + " on data type " + tsc.type + "on " + tsc.fullName);
            }
            if (warnUnsafe) {
                System.err.println("Unsafe math operation: computing " + name + " on data type " + tsc.type + ".\n\t" + tsc.fullName);
            }
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        myTsc.numberValues = tsc.values.length - 1;
        myTsc.values = new double[myTsc.numberValues];
        myTsc.times = new int[myTsc.numberValues];
        if (myTsc.quality != null) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        int null_quality = 0;
        int questionable = QualityTx.setQuestion_int(null_quality);
        int missing = QualityTx.setMissing_int(null_quality);
        boolean previousWasQuestionable = false;
        boolean thisIsQuestionable = false;
        int i = 0;
        int j = 1;
        while (i < myTsc.numberValues) {
            myTsc.times[i] = tsc.times[j];
            if ((myTsc.quality == null || QualityTx.isNotProtected_int(myTsc.quality[i])) && TimeSeriesFunctions.isValid(tsc, i) && TimeSeriesFunctions.isValid(tsc, j)) {
                myTsc.values[i] = tsc.values[j] - tsc.values[i];
                if (myTsc.values[i] != -3.4028234663852886E38) {
                    if (time_based) {
                        int n = i;
                        myTsc.values[n] = myTsc.values[n] / (double)(tsc.times[j] - tsc.times[i]);
                    }
                    if (tsc.quality == null) {
                        if (myTsc.quality != null) {
                            myTsc.quality[i] = null_quality;
                        }
                    } else {
                        thisIsQuestionable = QualityTx.isQuestion_int(tsc.quality[j]);
                        myTsc.quality[i] = thisIsQuestionable || previousWasQuestionable ? questionable : null_quality;
                        previousWasQuestionable = thisIsQuestionable;
                    }
                }
            } else {
                myTsc.values[i] = -3.4028234663852886E38;
                if (myTsc.quality != null) {
                    myTsc.quality[i] = missing;
                }
            }
            ++i;
            ++j;
        }
        myTsc.setStartTime(new HecTime(myTsc.times[0], 11));
        String[] parts = null;
        if (time_based) {
            myTsc.type = dssTimeSeriesTypes.contains(tsc.type.toLowerCase()) ? "PER-AVER" : "Ave";
            parts = TextUtil.split(myTsc.fullName, ".");
            if (parts.length == 6 && TextUtil.split(parts[2], "-")[0].equalsIgnoreCase("Inst")) {
                parts[2] = parts[2].replaceFirst("(?i)Inst", "Ave");
                myTsc.fullName = TextUtil.join(".", parts);
            }
            myTsc.units = tsc.units + "/min";
        } else {
            if (tsc.type.equalsIgnoreCase("INST-CUM")) {
                myTsc.type = "PER-CUM";
            } else if (tsc.type.equalsIgnoreCase("Inst")) {
                myTsc.type = "Total";
            }
            parts = TextUtil.split(myTsc.fullName, ".");
            if (parts.length == 6 && TextUtil.split(parts[2], "-")[0].equalsIgnoreCase("Inst")) {
                parts[2] = parts[2].replaceFirst("(?i)Inst", "Total");
                myTsc.fullName = TextUtil.join(".", parts);
            }
        }
        return myTsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scriptable
    public static TimeSeriesContainer successiveDifferences(TimeSeriesContainer tsc) throws ComputationException {
        boolean createQuality;
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
            createQuality = AlwaysCreateQuality;
        }
        return TimeSeriesFunctions.successiveDifferences(tsc, allowUnsafe, warnUnsafe, createQuality);
    }

    @Scriptable
    public static TimeSeriesContainer successiveDifferences(TimeSeriesContainer tsc, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        return TimeSeriesFunctions.differences(tsc, false, allowUnsafe, warnUnsafe, createQuality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scriptable
    public static TimeSeriesContainer timeDerivative(TimeSeriesContainer tsc) throws ComputationException {
        boolean createQuality;
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
            createQuality = AlwaysCreateQuality;
        }
        return TimeSeriesFunctions.timeDerivative(tsc, allowUnsafe, warnUnsafe, createQuality);
    }

    @Scriptable
    public static TimeSeriesContainer timeDerivative(TimeSeriesContainer tsc, boolean allowUnsafe, boolean warnUnsafe, boolean createQuality) throws ComputationException {
        return TimeSeriesFunctions.differences(tsc, true, allowUnsafe, warnUnsafe, createQuality);
    }

    public static TimeSeriesContainer movingAverage(TimeSeriesContainer tsc, MovingAverageMethod method, int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws ComputationException {
        int i;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        if (numberToAverageOver < 2 || numberToAverageOver > tsc.numberValues) {
            throw new ComputationException("Number to average over must be >= 2 and <= " + tsc.numberValues + " for" + tsc.fullName);
        }
        if ((method == MovingAverageMethod.CENTERED || method == MovingAverageMethod.OLYMPIC) && numberToAverageOver % 2 == 0) {
            throw new ComputationException("Number to average over cannot be an even number for " + method.toString());
        }
        int i_first = -1;
        int i_last = -1;
        int j_first = -1;
        int j_last = -1;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        int boundarySize = numberToAverageOver - 1;
        if (method == MovingAverageMethod.CENTERED || method == MovingAverageMethod.OLYMPIC) {
            boundarySize /= 2;
        }
        int null_quality = 0;
        int missing = QualityTx.setMissing_int(null_quality);
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        for (i = 0; i < myTsc.numberValues; ++i) {
            myTsc.values[i] = -3.4028234663852886E38;
        }
        if (tsc.quality != null) {
            for (i = 0; i < myTsc.numberValues; ++i) {
                myTsc.quality[i] = missing;
            }
        }
        if (useReduced) {
            i_first = 0;
            i_last = tsc.numberValues - 1;
        } else {
            i_first = boundarySize;
            i_last = method == MovingAverageMethod.FORWARD ? tsc.numberValues - 1 : tsc.numberValues - boundarySize - 1;
        }
        for (i = i_first; i <= i_last; ++i) {
            if (myTsc.quality != null && QualityTx.isProtected_int(myTsc.quality[i])) continue;
            j_first = Math.max(0, i - boundarySize);
            switch (method) {
                case FORWARD: {
                    j_last = i;
                    break;
                }
                case CENTERED: 
                case OLYMPIC: {
                    j_last = Math.min(myTsc.numberValues - 1, i + boundarySize);
                }
            }
            sum = 0.0;
            int count = 0;
            if (method == MovingAverageMethod.OLYMPIC) {
                min = Double.POSITIVE_INFINITY;
                max = Double.NEGATIVE_INFINITY;
            }
            for (int j = j_first; j <= j_last; ++j) {
                if (TimeSeriesFunctions.isValid(tsc, j)) {
                    ++count;
                    sum += tsc.values[j];
                    if (method != MovingAverageMethod.OLYMPIC) continue;
                    if (tsc.values[j] < min) {
                        min = tsc.values[j];
                    }
                    if (!(tsc.values[j] > max)) continue;
                    max = tsc.values[j];
                    continue;
                }
                if (!onlyValidValues) continue;
                count = 0;
                break;
            }
            if (count <= true) continue;
            if (method == MovingAverageMethod.OLYMPIC) {
                sum = sum - min - max;
                count -= 2;
            }
            if (count <= 0) continue;
            myTsc.values[i] = sum / (double)count;
            if (myTsc.quality == null) continue;
            myTsc.quality[i] = null_quality;
        }
        return myTsc;
    }

    @Scriptable
    public static TimeSeriesContainer centeredMovingAverage(TimeSeriesContainer tsc, int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws ComputationException {
        return TimeSeriesFunctions.movingAverage(tsc, MovingAverageMethod.CENTERED, numberToAverageOver, onlyValidValues, useReduced);
    }

    @Scriptable
    public static TimeSeriesContainer olympicSmoothing(TimeSeriesContainer tsc, int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws ComputationException {
        return TimeSeriesFunctions.movingAverage(tsc, MovingAverageMethod.OLYMPIC, numberToAverageOver, onlyValidValues, useReduced);
    }

    @Scriptable
    public static TimeSeriesContainer forwardMovingAverage(TimeSeriesContainer tsc, int numberToAverageOver, boolean onlyValidValues, boolean useReduced) throws ComputationException {
        return TimeSeriesFunctions.movingAverage(tsc, MovingAverageMethod.FORWARD, numberToAverageOver, onlyValidValues, useReduced);
    }

    @Scriptable
    public static TimeSeriesContainer forwardMovingAverage(TimeSeriesContainer tsc, int numberToAverageOver) throws ComputationException {
        return TimeSeriesFunctions.forwardMovingAverage(tsc, numberToAverageOver, false, false);
    }

    @Scriptable
    public static TimeSeriesContainer screenWithMaxMin(TimeSeriesContainer tsc, double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidValueToSpecified, double invalidValueReplacement, String qualityFlagForInvalidValue) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        boolean qualityCharSpecified = qualityFlagForInvalidValue != null && qualityFlagForInvalidValue.length() > 0;
        int qualityChar = 77;
        if (qualityCharSpecified) {
            qualityChar = qualityFlagForInvalidValue.charAt(0);
            switch (qualityChar) {
                case 77: 
                case 81: 
                case 82: {
                    break;
                }
                default: {
                    throw new ComputationException("If specified, quality flag must be \"M\", \"Q\", or \"R\".");
                }
            }
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        boolean failedAbsMag = false;
        boolean failedROC = false;
        for (int i = 0; i < tsc.numberValues; ++i) {
            failedAbsMag = false;
            failedROC = false;
            if (myTsc.values[i] != -3.4028234663852886E38) {
                failedAbsMag = myTsc.values[i] < minValueLimit || myTsc.values[i] > maxValueLimit;
                boolean bl = failedROC = !failedAbsMag && i > 0 && QualityTx.isOkay_int(myTsc.quality[i - 1]) && Math.abs(myTsc.values[i] - myTsc.values[i - 1]) > changeLimit;
                if (failedAbsMag || failedROC) {
                    if (setInvalidValueToSpecified && !QualityTx.isProtected_int(myTsc.quality[i])) {
                        myTsc.values[i] = invalidValueReplacement;
                        myTsc.quality[i] = QualityTx.setRevisedAutomatically_int(myTsc.quality[i]);
                        if (invalidValueReplacement == -3.4028234663852886E38) {
                            myTsc.quality[i] = QualityTx.setReplaceWithMissing_int(myTsc.quality[i]);
                        }
                    }
                    if (!qualityCharSpecified) continue;
                    switch (qualityChar) {
                        case 77: {
                            if (QualityTx.isProtected_int(myTsc.quality[i])) break;
                            myTsc.quality[i] = QualityTx.setMissing_int(myTsc.quality[i]);
                            break;
                        }
                        case 81: {
                            myTsc.quality[i] = QualityTx.setQuestion_int(myTsc.quality[i]);
                            myTsc.quality[i] = failedAbsMag ? QualityTx.setAbsoluteMagnitude_int(myTsc.quality[i]) : QualityTx.setRateOfChange_int(myTsc.quality[i]);
                            break;
                        }
                        case 82: {
                            myTsc.quality[i] = QualityTx.setReject_int(myTsc.quality[i]);
                            myTsc.quality[i] = failedAbsMag ? QualityTx.setAbsoluteMagnitude_int(myTsc.quality[i]) : QualityTx.setRateOfChange_int(myTsc.quality[i]);
                        }
                    }
                    continue;
                }
                if (QualityTx.isReject_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i])) continue;
                myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
                continue;
            }
            if (tsc.quality != null) continue;
            myTsc.quality[i] = QualityTx.setMissing_int(0);
        }
        return myTsc;
    }

    @Scriptable
    public static TimeSeriesContainer screenWithMaxMin(TimeSeriesContainer tsc, double minValueLimit, double maxValueLimit, double changeLimit, boolean setInvalidValueToUndefined, String qualityFlagForInvalidValue) throws ComputationException {
        return TimeSeriesFunctions.screenWithMaxMin(tsc, minValueLimit, maxValueLimit, changeLimit, setInvalidValueToUndefined, -3.4028234663852886E38, qualityFlagForInvalidValue);
    }

    @Scriptable
    public static TimeSeriesContainer screenWithMaxMin(TimeSeriesContainer tsc, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        for (int i = 0; i < myTsc.numberValues; ++i) {
            if (TimeSeriesFunctions.isValid(tsc, i)) {
                if (myTsc.values[i] < minRejectLimit || myTsc.values[i] > maxRejectLimit) {
                    myTsc.quality[i] = QualityTx.setAbsoluteMagnitude_int(QualityTx.setReject_int(myTsc.quality[i]));
                    continue;
                }
                if (myTsc.values[i] < minQuestionLimit || myTsc.values[i] > maxQuestionLimit) {
                    myTsc.quality[i] = QualityTx.setAbsoluteMagnitude_int(QualityTx.setQuestion_int(myTsc.quality[i]));
                    continue;
                }
                if (QualityTx.isReject_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i])) continue;
                myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
                continue;
            }
            if (tsc.quality != null) continue;
            myTsc.quality[i] = QualityTx.setMissing_int(0);
        }
        return myTsc;
    }

    @Scriptable
    public static TimeSeriesContainer screenWithRateOfChange(TimeSeriesContainer tsc, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws ComputationException {
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
        }
        int lastOkIndex = 0;
        double rate = 0.0;
        for (lastOkIndex = 0; lastOkIndex < myTsc.numberValues && !TimeSeriesFunctions.isValid(myTsc, lastOkIndex); ++lastOkIndex) {
        }
        for (int i = lastOkIndex + 1; i < myTsc.numberValues; ++i) {
            if (TimeSeriesFunctions.isValid(myTsc, i)) {
                rate = (myTsc.values[i] - myTsc.values[lastOkIndex]) / ((double)(myTsc.times[i] - myTsc.times[lastOkIndex]) / 60.0);
                if (rate < minRejectLimit || rate > maxRejectLimit) {
                    myTsc.quality[i] = QualityTx.setRateOfChange_int(QualityTx.setReject_int(myTsc.quality[i]));
                    continue;
                }
                if (rate < minQuestionLimit || rate > maxQuestionLimit) {
                    myTsc.quality[i] = QualityTx.setRateOfChange_int(QualityTx.setQuestion_int(myTsc.quality[i]));
                    continue;
                }
                if (!(QualityTx.isMissing_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i]) || QualityTx.isReject_int(myTsc.quality[i]))) {
                    myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
                    continue;
                }
                if (QualityTx.isReject_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i])) continue;
                myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
                continue;
            }
            if (tsc.quality != null) continue;
            myTsc.quality[i] = QualityTx.setMissing_int(0);
        }
        return myTsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scriptable
    public static TimeSeriesContainer screenWithDurationMagnitude(TimeSeriesContainer tsc, String durationStr, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit) throws ComputationException {
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
        }
        return TimeSeriesFunctions.screenWithDurationMagnitude(tsc, durationStr, minRejectLimit, minQuestionLimit, maxQuestionLimit, maxRejectLimit, allowUnsafe, warnUnsafe);
    }

    public static int durationMinutes(String durationStr) throws ComputationException {
        int i;
        if (durationStr == null) {
            throw new ComputationException("Duration specification must not be null.");
        }
        int multiplier = 0;
        for (i = 0; i < durationStr.length() && Character.isDigit(durationStr.charAt(i)); ++i) {
        }
        if (i == durationStr.length()) {
            throw new ComputationException("Invalid duration specification: " + durationStr);
        }
        String durationUnit = durationStr.substring(i).toUpperCase();
        if (new String("MINUTES").startsWith(durationUnit)) {
            multiplier = 1;
        } else if (new String("HOURS").startsWith(durationUnit)) {
            multiplier = 60;
        } else if (new String("DAYS").startsWith(durationUnit)) {
            multiplier = 1440;
        } else {
            throw new ComputationException("Invalid duration specification: " + durationStr);
        }
        try {
            return Integer.parseInt(durationStr.substring(0, i)) * multiplier;
        }
        catch (NumberFormatException nfe) {
            throw new ComputationException("Invalid duration specification: " + durationStr);
        }
    }

    @Scriptable
    public static TimeSeriesContainer screenWithDurationMagnitude(TimeSeriesContainer tsc, String durationStr, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit, boolean allowUnsafe, boolean warnUnsafe) throws ComputationException {
        return TimeSeriesFunctions.screenWithDurationMagnitude(tsc, durationStr, -3.4028234663852886E38, minRejectLimit, minQuestionLimit, maxQuestionLimit, maxRejectLimit, -3.4028234663852886E38, 75.0, allowUnsafe, warnUnsafe);
    }

    @Scriptable
    public static TimeSeriesContainer screenWithDurationMagnitude(TimeSeriesContainer tsc, String durationStr, double minMissingLimit, double minRejectLimit, double minQuestionLimit, double maxQuestionLimit, double maxRejectLimit, double maxMissingLimit, double percentRequired, boolean allowUnsafe, boolean warnUnsafe) throws ComputationException {
        boolean unsafe;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int duration = TimeSeriesFunctions.durationMinutes(durationStr);
        boolean bl = unsafe = !totalTimeSeriesTypes.contains(tsc.type.toLowerCase());
        if (unsafe) {
            if (!allowUnsafe) {
                throw new ComputationException("Unsafe math operation: cannot accumulate data type " + tsc.type + "on " + tsc.fullName);
            }
            if (warnUnsafe) {
                System.err.println("Unsafe math operation: accumulating data type " + tsc.type + ".\n\t" + tsc.fullName);
            }
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
            for (int i = 0; i < myTsc.numberValues; ++i) {
                myTsc.quality[i] = TimeSeriesFunctions.isValid(tsc, i) ? 0 : QualityTx.setMissing_int(0);
            }
        }
        boolean[] setQuestioned = new boolean[tsc.numberValues];
        boolean[] setRejected = new boolean[tsc.numberValues];
        boolean[] setMissing = new boolean[tsc.numberValues];
        Arrays.fill(setQuestioned, false);
        Arrays.fill(setRejected, false);
        Arrays.fill(setMissing, false);
        double sum = -3.4028234663852886E38;
        double required = percentRequired / 100.0;
        int validCount = Integer.MIN_VALUE;
        int totalCount = Integer.MIN_VALUE;
        int span = 0;
        for (int first = 0; first < tsc.numberValues - 1; ++first) {
            int i;
            int last;
            for (last = first; last < tsc.numberValues && (span = last == tsc.numberValues - 1 ? tsc.times[last] - tsc.times[first] + tsc.times[last] - tsc.times[last - 1] : tsc.times[last + 1] - tsc.times[first]) < duration; ++last) {
            }
            if (span < duration) break;
            validCount = 0;
            totalCount = 0;
            for (i = first; i <= last; ++i) {
                if (TimeSeriesFunctions.isValid(myTsc, i)) {
                    ++validCount;
                }
                ++totalCount;
            }
            if ((double)validCount / (double)totalCount < required) continue;
            sum = 0.0;
            for (i = first + 1; i <= last; ++i) {
                if (!TimeSeriesFunctions.isValid(myTsc, i)) continue;
                sum += myTsc.values[i];
            }
            if (span > duration) {
                int overage = span - duration;
                int increment = tsc.times[first + 1] - tsc.times[first];
                int keep = increment - overage;
                double fraction = (double)keep / (double)increment;
                sum += myTsc.values[first] * fraction;
            } else {
                sum += myTsc.values[first];
            }
            if (sum < minMissingLimit || sum > maxMissingLimit) {
                for (i = first; i <= last; ++i) {
                    setMissing[i] = true;
                }
                continue;
            }
            if (sum < minRejectLimit || sum > maxRejectLimit) {
                for (i = first; i <= last; ++i) {
                    setRejected[i] = true;
                }
                continue;
            }
            if (!(sum < minQuestionLimit) && !(sum > maxQuestionLimit)) continue;
            for (i = first; i <= last; ++i) {
                setQuestioned[i] = true;
            }
        }
        for (int i = 0; i < myTsc.numberValues; ++i) {
            if (QualityTx.isMissing_int(myTsc.quality[i])) continue;
            if (setMissing[i]) {
                myTsc.quality[i] = QualityTx.setMissing_int(QualityTx.setRateOfChange_int(myTsc.quality[i]));
                continue;
            }
            if (setRejected[i]) {
                myTsc.quality[i] = QualityTx.setReject_int(QualityTx.setRateOfChange_int(myTsc.quality[i]));
                continue;
            }
            if (setQuestioned[i] && !QualityTx.isReject_int(myTsc.quality[i])) {
                myTsc.quality[i] = QualityTx.setQuestion_int(QualityTx.setRateOfChange_int(myTsc.quality[i]));
                continue;
            }
            if (QualityTx.isReject_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i])) continue;
            myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
        }
        return myTsc;
    }

    @Scriptable
    public static TimeSeriesContainer screenWithConstantValue(TimeSeriesContainer tsc, String durationStr, double rejectTolerance, double questionTolerance) throws ComputationException {
        return TimeSeriesFunctions.screenWithConstantValue(tsc, durationStr, rejectTolerance, questionTolerance, 0.0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scriptable
    public static TimeSeriesContainer screenWithConstantValue(TimeSeriesContainer tsc, String durationStr, double rejectTolerance, double questionTolerance, double minThreshold, int maxMissing) throws ComputationException {
        boolean warnUnsafe;
        boolean allowUnsafe;
        Object object = allowUnsafeLock;
        synchronized (object) {
            allowUnsafe = AlwaysAllowUnsafe;
            warnUnsafe = AlwaysWarnUnsafe;
        }
        return TimeSeriesFunctions.screenWithConstantValue(tsc, durationStr, rejectTolerance, questionTolerance, minThreshold, maxMissing, allowUnsafe, warnUnsafe);
    }

    @Scriptable
    public static TimeSeriesContainer screenWithConstantValue(TimeSeriesContainer tsc, String durationStr, double rejectTolerance, double questionTolerance, double minThreshold, int maxMissing, boolean allowUnsafe, boolean warnUnsafe) throws ComputationException {
        return TimeSeriesFunctions.screenWithConstantValue(tsc, durationStr, -1.0, rejectTolerance, questionTolerance, minThreshold, maxMissing, allowUnsafe, warnUnsafe);
    }

    @Scriptable
    public static TimeSeriesContainer screenWithConstantValue(TimeSeriesContainer tsc, String durationStr, double missingTolerance, double rejectTolerance, double questionTolerance, double minThreshold, int maxMissing, boolean allowUnsafe, boolean warnUnsafe) throws ComputationException {
        int i;
        boolean unsafe;
        TimeSeriesFunctions.validateTimeSeriesContainer(tsc);
        int duration = TimeSeriesFunctions.durationMinutes(durationStr);
        boolean bl = unsafe = !instTimeSeriesTypes.contains(tsc.type.toLowerCase());
        if (unsafe) {
            if (!allowUnsafe) {
                throw new ComputationException("Unsafe math operation: cannot test for constant value with data type " + tsc.type + "on " + tsc.fullName);
            }
            if (warnUnsafe) {
                System.err.println("Unsafe math operation: testing for constant value with data type " + tsc.type + ".\n\t" + tsc.fullName);
            }
        }
        TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
        if (tsc.quality == null) {
            myTsc.quality = new int[myTsc.numberValues];
            for (int i2 = 0; i2 < myTsc.numberValues; ++i2) {
                myTsc.quality[i2] = TimeSeriesFunctions.isValid(tsc, i2) ? 0 : QualityTx.setMissing_int(0);
            }
        }
        boolean[] setMissing = new boolean[tsc.numberValues];
        boolean[] setRejected = new boolean[tsc.numberValues];
        boolean[] setQuestioned = new boolean[tsc.numberValues];
        Arrays.fill(setMissing, false);
        Arrays.fill(setRejected, false);
        Arrays.fill(setQuestioned, false);
        block1: for (i = 0; i < tsc.numberValues - 1; ++i) {
            if (TimeSeriesFunctions.isMissing(tsc, i)) continue;
            int missingCount = 0;
            for (int j = i + 1; j < tsc.numberValues; ++j) {
                if (TimeSeriesFunctions.isMissing(tsc, j)) {
                    if (++missingCount <= maxMissing) continue;
                    continue block1;
                }
                double diff = Math.abs(tsc.values[j] - tsc.values[i]);
                if (tsc.times[j] - tsc.times[i] >= duration) {
                    int k;
                    if (!(tsc.values[j] > minThreshold)) continue block1;
                    if (missingTolerance > 0.0 && diff <= missingTolerance) {
                        for (k = i; k <= j; ++k) {
                            setMissing[k] = true;
                        }
                        continue block1;
                    }
                    if (rejectTolerance > 0.0 && diff <= rejectTolerance) {
                        for (k = i; k <= j; ++k) {
                            setRejected[k] = true;
                        }
                        continue block1;
                    }
                    if (!(questionTolerance > 0.0) || !(diff <= questionTolerance)) continue block1;
                    for (k = i; k <= j; ++k) {
                        setQuestioned[k] = true;
                    }
                    continue block1;
                }
                if (missingTolerance > diff || rejectTolerance > diff || questionTolerance > diff) continue;
                i = j - 1;
                continue block1;
            }
        }
        for (i = 0; i < myTsc.numberValues; ++i) {
            if (QualityTx.isMissing_int(myTsc.quality[i])) continue;
            if (setMissing[i]) {
                myTsc.quality[i] = QualityTx.setMissing_int(QualityTx.setConstantValue_int(myTsc.quality[i]));
                myTsc.values[i] = -3.4028234663852886E38;
                continue;
            }
            if (setRejected[i]) {
                myTsc.quality[i] = QualityTx.setReject_int(QualityTx.setConstantValue_int(myTsc.quality[i]));
                continue;
            }
            if (setQuestioned[i] && !QualityTx.isReject_int(myTsc.quality[i])) {
                myTsc.quality[i] = QualityTx.setQuestion_int(QualityTx.setConstantValue_int(myTsc.quality[i]));
                continue;
            }
            if (QualityTx.isReject_int(myTsc.quality[i]) || QualityTx.isQuestion_int(myTsc.quality[i])) continue;
            myTsc.quality[i] = QualityTx.setOkay_int(myTsc.quality[i]);
        }
        return myTsc;
    }

    @Scriptable
    public static TimeSeriesContainer screenWithForwardMovingAverage(TimeSeriesContainer tsc, int numberToAverageOver, double changeLimit, boolean setInvalidValueToUndefined, String qualityFlagForInvalidValue) throws ComputationException {
        TimeSeriesContainer tsc1 = new TimeSeriesContainer();
        tsc.clone(tsc1);
        if (tsc1.quality == null) {
            tsc1.quality = new int[tsc.numberValues];
        }
        TimeSeriesContainer avg = TimeSeriesFunctions.forwardMovingAverage(tsc, numberToAverageOver);
        for (int i = 0; i < tsc1.numberValues; ++i) {
            if (TimeSeriesFunctions.isMissing(tsc1, i)) {
                tsc1.quality[i] = QualityTx.setMissing_int(tsc1.quality[i]);
                continue;
            }
            if (TimeSeriesFunctions.isValid(tsc1, i) && Math.abs(tsc1.values[i] - avg.values[i]) <= changeLimit) {
                tsc1.quality[i] = QualityTx.setOkay_int(tsc1.quality[i]);
                continue;
            }
            if (setInvalidValueToUndefined) {
                tsc1.values[i] = -3.4028234663852886E38;
            }
            if (qualityFlagForInvalidValue == null || qualityFlagForInvalidValue.length() <= 0) continue;
            if (qualityFlagForInvalidValue.equalsIgnoreCase("M")) {
                tsc1.quality[i] = QualityTx.setMissing_int(tsc1.quality[i]);
                continue;
            }
            if (qualityFlagForInvalidValue.equalsIgnoreCase("Q")) {
                tsc1.quality[i] = QualityTx.setQuestion_int(tsc1.quality[i]);
                continue;
            }
            if (qualityFlagForInvalidValue.equalsIgnoreCase("R")) {
                tsc1.quality[i] = QualityTx.setReject_int(tsc1.quality[i]);
                continue;
            }
            if (qualityFlagForInvalidValue.equalsIgnoreCase(" ")) continue;
            throw new ComputationException("Illegal quality flag: \"" + qualityFlagForInvalidValue + "\", must be \"M\", \"Q\", or \"R\"");
        }
        return tsc1;
    }

    @Scriptable
    public static TimeSeriesContainer estimateForMissingValues(TimeSeriesContainer tsc, int maxMissingAllowed, boolean accumulation, boolean setQuestioned, boolean estimateRejected, boolean allowUnsafe, boolean warnUnsafe) throws ComputationException {
        try {
            boolean unsafe;
            if (accumulation) {
                unsafe = !tsc.type.equals("INST-CUM") && (!tsc.type.equals("Inst") || !tsc.parameter.startsWith("Precip"));
            } else {
                boolean bl = unsafe = !tsc.type.equals("INST-VAL") && !tsc.type.equals("Inst");
            }
            if (unsafe) {
                String msg = String.format("Unsafe math operation: cannot estimate for missing %svalues with data type %s on %s", accumulation ? "accumulated " : "", tsc.type, tsc.fullName);
                if (!allowUnsafe) {
                    throw new ComputationException(msg);
                }
                if (warnUnsafe) {
                    Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.WARNING, msg);
                }
            }
            TimeSeriesContainer myTsc = (TimeSeriesContainer)tsc.clone();
            int lastGood = Integer.MIN_VALUE;
            int nextGood = Integer.MIN_VALUE;
            for (int i = 0; i < myTsc.numberValues; ++i) {
                boolean good;
                boolean bl = estimateRejected ? TimeSeriesFunctions.isValid(myTsc, i) : (good = !TimeSeriesFunctions.isMissing(myTsc, i));
                if (good) {
                    lastGood = i;
                    continue;
                }
                if (lastGood == Integer.MIN_VALUE) continue;
                for (int j = i + 1; j < myTsc.numberValues; ++j) {
                    boolean bl2 = estimateRejected ? TimeSeriesFunctions.isValid(myTsc, j) : (good = !TimeSeriesFunctions.isMissing(myTsc, j));
                    if (!good) continue;
                    nextGood = j;
                    break;
                }
                if (nextGood <= lastGood) continue;
                int count = nextGood - lastGood;
                if (count <= maxMissingAllowed + 1) {
                    double diff = myTsc.values[nextGood] - myTsc.values[lastGood];
                    if (!accumulation || diff >= 0.0 || -diff < 1.0E-4) {
                        for (int k = lastGood + 1; k < nextGood; ++k) {
                            myTsc.values[k] = myTsc.values[lastGood] + (double)(k - lastGood) / (double)count * diff;
                            if (myTsc.quality == null) continue;
                            myTsc.quality[k] = setQuestioned ? QualityTx.setQuestion_int(QualityTx.setReplaceLinearInterpolation_int(QualityTx.setRevisedAutomatically_int(myTsc.quality[k]))) : QualityTx.setOkay_int(QualityTx.setReplaceLinearInterpolation_int(QualityTx.setRevisedAutomatically_int(myTsc.quality[k])));
                        }
                    }
                }
                i = lastGood = nextGood;
            }
            return myTsc;
        }
        catch (Throwable t) {
            if (t instanceof ComputationException) {
                throw (ComputationException)t;
            }
            throw new ComputationException(t);
        }
    }

    public static TimeSeriesContainer snapToRegularInterval(TimeSeriesContainer tsc, String timeIntervalStr, String timeOffsetStr, String timeBackwardStr, String timeForwardStr) throws ComputationException {
        return TimeSeriesFunctions.snapToRegularInterval(tsc, TimeSeriesFunctions.parseTimeIntervalString(timeIntervalStr), timeOffsetStr == null ? 0 : TimeSeriesFunctions.parseTimeIntervalString(timeOffsetStr), timeBackwardStr == null ? 0 : TimeSeriesFunctions.parseTimeIntervalString(timeBackwardStr), timeForwardStr == null ? 0 : TimeSeriesFunctions.parseTimeIntervalString(timeForwardStr));
    }

    public static TimeSeriesContainer snapToRegularInterval(TimeSeriesContainer tsc, int timeIntervalMinutes, int timeOffsetMinutes, int timeBackwardMinutes, int timeForwardMinutes) throws ComputationException {
        try {
            int max_time;
            class TimeVal {
                public int top = Integer.MIN_VALUE;
                public int offset;
                public double value;
                public int quality;

                public TimeVal() {
                }

                public TimeVal(int top, int offset, TimeSeriesContainer tsc, int index) {
                    this.set(top, offset, tsc, index);
                }

                public TimeVal(int top, int offset, double value, int quality) {
                    this.set(top, offset, value, quality);
                }

                public void set(int top, int offset, TimeSeriesContainer tsc, int index) {
                    this.top = top;
                    this.offset = offset;
                    this.value = tsc.values[index];
                    this.quality = tsc.quality == null ? 0 : tsc.quality[index];
                }

                public void set(int top, int offset, double value, int quality) {
                    this.top = top;
                    this.offset = offset;
                    this.value = value;
                    this.quality = quality;
                }

                public boolean isEmpty() {
                    return this.top == Integer.MIN_VALUE;
                }

                public TimeVal copy() {
                    return new TimeVal(this.top, this.offset, this.value, this.quality);
                }
            }
            HashMap<Integer, TimeVal> values = new HashMap<Integer, TimeVal>();
            hec.data.Interval interval = null;
            IntervalOffset intervalOffset = null;
            TimeZone tz = null;
            try {
                String intervalName = new hec.data.Interval(timeIntervalMinutes).getInterval();
                interval = new hec.data.Interval(intervalName);
                intervalOffset = new IntervalOffset(timeOffsetMinutes * 60, interval.getSeconds());
                tz = tsc.timeZoneID != null && tsc.timeZoneID.length() > 0 ? TimeZone.getTimeZone(tsc.timeZoneID) : TimeZone.getTimeZone(TimeZone.getAvailableIDs(tsc.timeZoneRawOffset)[0]);
                int[] allowableOffset = new int[]{timeBackwardMinutes, timeForwardMinutes};
                for (int i = 0; i < tsc.times.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int offset;
                        int top;
                        if (j == 0) {
                            top = Conversion.toMinutes(hec.data.Interval.getTimeOnNextInterval(Conversion.toMillis(tsc.times[i]), interval, intervalOffset, tz));
                            offset = top - tsc.times[i];
                        } else {
                            top = Conversion.toMinutes(hec.data.Interval.getTimeOnPreviousInterval(Conversion.toMillis(tsc.times[i]), interval, intervalOffset, tz));
                            offset = tsc.times[i] - top;
                        }
                        if (offset > allowableOffset[j] || values.containsKey(top) && offset >= ((TimeVal)values.get((Object)Integer.valueOf((int)top))).offset) continue;
                        values.put(top, new TimeVal(top, offset, tsc.values[i], tsc.quality == null ? Integer.MIN_VALUE : tsc.quality[i]));
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof ComputationException) {
                    throw (ComputationException)t;
                }
                throw new ComputationException(t);
            }
            int min_time = Conversion.toMinutes(hec.data.Interval.getTimeOnPreviousInterval(Conversion.toMillis(tsc.times[0]), interval, intervalOffset, tz));
            if (tsc.times[0] - min_time > timeForwardMinutes) {
                min_time += timeIntervalMinutes;
            }
            if ((max_time = Conversion.toMinutes(hec.data.Interval.getTimeOnNextInterval(Conversion.toMillis(tsc.times[tsc.times.length - 1]), interval, intervalOffset, tz))) - tsc.times[tsc.times.length - 1] > timeBackwardMinutes) {
                max_time -= timeIntervalMinutes;
            }
            int numberValues = (max_time - min_time) / timeIntervalMinutes + 1;
            TimeSeriesContainer regularTsc = new TimeSeriesContainer();
            tsc.clone(regularTsc);
            regularTsc.interval = timeIntervalMinutes;
            regularTsc.setStartTime(new HecTime(min_time, 11));
            regularTsc.setEndTime(new HecTime(max_time, 11));
            regularTsc.numberValues = numberValues;
            regularTsc.times = new int[numberValues];
            regularTsc.values = new double[numberValues];
            regularTsc.quality = tsc.quality == null ? null : new int[numberValues];
            int missing = QualityTx.setMissing_int(0);
            for (int i = 0; i < numberValues; ++i) {
                regularTsc.times[i] = i == 0 ? min_time : regularTsc.times[i - 1] + timeIntervalMinutes;
                TimeVal tv = (TimeVal)values.get(regularTsc.times[i]);
                if (tv == null) {
                    regularTsc.values[i] = -3.4028234663852886E38;
                    if (regularTsc.quality == null) continue;
                    regularTsc.quality[i] = missing;
                    continue;
                }
                regularTsc.values[i] = tv.value;
                if (regularTsc.quality == null) continue;
                regularTsc.quality[i] = tv.quality;
            }
            if (TextUtil.split(regularTsc.fullName, "/").length == 8) {
                DSSPathname path = new DSSPathname(regularTsc.fullName);
                String ePart = HecTimeSeriesBase.getEPartFromInterval(regularTsc.interval);
                if (ePart == null || ePart.length() == 0) {
                    throw new HecMathException("Invalid interval");
                }
                path.setEPart(ePart);
                regularTsc.fullName = path.toString();
            } else if (TextUtil.split(regularTsc.fullName, ".").length == 6) {
                String[] parts = TextUtil.split(regularTsc.fullName, ".");
                parts[3] = new hec.data.Interval(regularTsc.interval).getInterval();
                regularTsc.fullName = TextUtil.join(".", parts);
            }
            return regularTsc;
        }
        catch (Throwable t) {
            if (t instanceof ComputationException) {
                throw (ComputationException)t;
            }
            throw new ComputationException(t);
        }
    }

    public static double interpolate(TimeSeriesContainer tsc, int time, String dataType, intContainer lastIndex) {
        int t0;
        HecTime t = new HecTime();
        t.set(time);
        if (time == tsc.times[tsc.times.length - 1]) {
            return tsc.values[tsc.times.length - 1];
        }
        int idx = Integer.MIN_VALUE;
        if (instTimeSeriesTypes.contains(dataType.toLowerCase()) || tsc.interval <= 0) {
            idx = TimeSeriesFunctions.findInterval(tsc.times, time, lastIndex.value);
        } else if (time >= tsc.times[0]) {
            idx = TimeSeriesFunctions.findInterval(tsc.times, time, lastIndex.value);
        } else {
            HecTime hTime = new HecTime();
            hTime.set(tsc.times[0]);
            hTime.increment(-1, tsc.interval);
            if (time >= hTime.value()) {
                idx = -1;
            }
        }
        if (idx == Integer.MIN_VALUE) {
            return -3.4028234663852886E38;
        }
        lastIndex.value = idx;
        if (idx >= 0 && time == tsc.times[idx]) {
            return tsc.values[idx];
        }
        int idxNext = idx + 1;
        if (instTimeSeriesTypes.contains(dataType.toLowerCase())) {
            if (!TimeSeriesFunctions.isValid(tsc, idx)) {
                int nidx = TimeSeriesFunctions.findValidValue(tsc, idx, false);
                if (nidx == Integer.MIN_VALUE) {
                    if (idx != -1) {
                        return -3.4028234663852886E38;
                    }
                } else {
                    idx = nidx;
                }
            }
            if (!TimeSeriesFunctions.isValid(tsc, idxNext) && (idxNext = TimeSeriesFunctions.findValidValue(tsc, idxNext, true)) == Integer.MIN_VALUE) {
                return -3.4028234663852886E38;
            }
        } else if (idxNext == Integer.MIN_VALUE || !TimeSeriesFunctions.isValid(tsc, idxNext)) {
            return -3.4028234663852886E38;
        }
        if (idx == -1) {
            HecTime hTime = new HecTime();
            hTime.set(tsc.times[0]);
            hTime.increment(-1, tsc.interval);
            t0 = hTime.value();
        } else {
            t0 = tsc.times[idx];
        }
        if ((double)(tsc.times[idxNext] - t0) == 0.0) {
            return -3.4028234663852886E38;
        }
        double fact = (double)(time - t0) / (double)(tsc.times[idxNext] - t0);
        double val1 = tsc.values[idxNext];
        double val0 = 0.0;
        if (instTimeSeriesTypes.contains(dataType.toLowerCase())) {
            val0 = tsc.values[idx];
        } else if (averageTimeSeriesTypes.contains(dataType.toLowerCase())) {
            val0 = tsc.values[idxNext];
        } else if (totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
            val0 = 0.0;
        }
        if (val0 == -3.4028234663852886E38) {
            return -3.4028234663852886E38;
        }
        double interpVal = val0 + fact * (val1 - val0);
        if ((dataType.equalsIgnoreCase("INST-CUM") || dataType.equalsIgnoreCase("Inst") && tsc.parameter.toLowerCase().indexOf("precip") != -1) && val0 > val1 && fact > 0.0 && fact < 1.0) {
            return -3.4028234663852886E38;
        }
        return interpVal;
    }

    public static void transformTimeSeries(TimeSeriesContainer currentTsc, TimeSeriesContainer newTsc, int functionType, boolean toIrregular, double missingAllowed) throws ComputationException {
        block52: {
            try {
                TimeSeriesContainer currentTscExpanded = currentTsc.expandVerticalDatum();
                TimeSeriesContainer newTscExpanded = newTsc.expandVerticalDatum();
                boolean isDss = dssTimeSeriesTypes.contains(currentTsc.type.toUpperCase());
                if (newTscExpanded instanceof VerticalDatum && !(currentTscExpanded instanceof VerticalDatum)) {
                    throw new ComputationException("Computation.transformTimeSeries: TimeSeriesContainerVerticalDatum cannot be converted to a TimeSeriesContainer");
                }
                if (newTscExpanded instanceof VerticalDatum && currentTscExpanded instanceof VerticalDatum) {
                    if (newTsc instanceof VerticalDatum) {
                        newTsc.supplementalInfo = currentTsc.supplementalInfo;
                        ((TimeSeriesContainerVertDatum)newTsc).setVerticalDatumContainer(((VerticalDatum)currentTscExpanded).getVerticalDatumContainer());
                    } else {
                        newTsc.supplementalInfo = currentTsc.supplementalInfo;
                    }
                } else if (!(newTscExpanded instanceof VerticalDatum) && currentTscExpanded instanceof VerticalDatum) {
                    newTsc.supplementalInfo = currentTsc.supplementalInfo;
                } else if (!(newTscExpanded instanceof VerticalDatum) && !(currentTscExpanded instanceof VerticalDatum)) {
                    newTsc.supplementalInfo = currentTsc.supplementalInfo;
                }
                if (currentTsc.type == null) {
                    throw new ComputationException("Data type is undefined");
                }
                if (!TimeSeriesFunctions.isValidTimeSeriesType(currentTsc.getType())) {
                    throw new ComputationException("Invalid data type: " + currentTsc.type);
                }
                String dataType = currentTsc.type;
                intContainer lastIndex = new intContainer();
                lastIndex.value = -1;
                if (functionType == 11) {
                    for (int i = 0; i < newTsc.times.length; ++i) {
                        newTsc.values[i] = TimeSeriesFunctions.interpolate(currentTsc, newTsc.times[i], dataType, lastIndex);
                    }
                    break block52;
                }
                if (functionType == 15 || functionType == 14 || functionType == 16 || functionType == 17) {
                    doubleContainer sumTime = new doubleContainer();
                    sumTime.value = 0.0;
                    double sumArea = 0.0;
                    for (int i = 0; i < newTsc.times.length; ++i) {
                        int time0;
                        if (i == 0) {
                            if (newTsc.interval <= 1440) {
                                time0 = newTsc.times[0] - newTsc.interval;
                            } else {
                                HecTime newStartTime = new HecTime(newTsc.times[0], 1);
                                newStartTime.increment(-1, newTsc.interval);
                                time0 = newStartTime.value();
                            }
                        } else {
                            time0 = newTsc.times[i - 1];
                        }
                        sumArea = TimeSeriesFunctions.integrate(currentTsc, time0, newTsc.times[i], dataType, functionType, missingAllowed, lastIndex, sumTime);
                        if (functionType == 14) {
                            if (sumArea == -3.4028234663852886E38 || !(sumTime.value > 0.0)) continue;
                            newTsc.values[i] = sumArea / sumTime.value;
                            continue;
                        }
                        if (functionType == 16) {
                            if (sumArea == -3.4028234663852886E38 || !(sumTime.value > 0.0)) continue;
                            if (totalTimeSeriesTypes.contains(dataType.toLowerCase())) {
                                newTsc.values[i] = sumArea;
                                continue;
                            }
                            newTsc.values[i] = sumArea / sumTime.value;
                            continue;
                        }
                        newTsc.values[i] = sumArea;
                    }
                    if (functionType == 14) {
                        newTsc.type = isDss ? "PER-AVER" : "Ave";
                    } else if (functionType == 15 || functionType == 16) {
                        newTsc.type = isDss ? "PER-CUM" : "Total";
                    } else if (functionType == 17) {
                        String parameter;
                        newTsc.type = isDss ? "PER-CUM" : "Total";
                        double multiplier = -3.4028234663852886E38;
                        String units = newTsc.units;
                        if (Units.isUnitsInAlias(units, "cfs")) {
                            multiplier = 0.0013774104683195593;
                            String string = newTsc.units = isDss ? "AC-FT" : "ac-ft";
                            if (newTsc.parameter.toUpperCase().indexOf("FLOW") >= 0) {
                                newTsc.parameter = newTsc.parameter.replaceAll("FLOW", "STOR").replaceAll("Flow", "Stor").replaceAll("flow", "stor");
                            }
                        } else if (Units.isUnitsInAlias(units, "cms")) {
                            multiplier = 60.0;
                            String string = newTsc.units = isDss ? "M3" : "m3";
                            if (newTsc.parameter.toUpperCase().indexOf("FLOW") >= 0) {
                                newTsc.parameter = newTsc.parameter.replaceAll("FLOW", "STOR").replaceAll("Flow", "Stor").replaceAll("flow", "stor");
                            }
                        }
                        if (multiplier != -3.4028234663852886E38) {
                            int i = 1;
                            while (i < newTsc.values.length) {
                                int n = i++;
                                newTsc.values[n] = newTsc.values[n] * multiplier;
                            }
                            newTsc.values[0] = newTsc.values[0] * multiplier;
                        }
                        String string = parameter = newTsc.parameter + newTsc.subParameter == null ? "" : "-" + newTsc.subParameter;
                        if (isDss) {
                            String[] parts = TextUtil.split(newTsc.fullName, "/");
                            parts[3] = parameter;
                            newTsc.fullName = TextUtil.join("/", parts);
                        } else {
                            String[] parts = TextUtil.split(newTsc.fullName, ".");
                            parts[1] = parameter;
                            newTsc.fullName = TextUtil.join(".", parts);
                        }
                    }
                    break block52;
                }
                if (functionType != 13 && functionType != 12 && functionType != 18) break block52;
                intContainer timeOfOccurrence = new intContainer();
                int[] irrTimes = new int[newTsc.times.length];
                int count = 0;
                for (int i = 0; i < newTsc.times.length; ++i) {
                    int time0;
                    if (i == 0) {
                        if (newTsc.interval <= 1440) {
                            time0 = newTsc.times[0] - newTsc.interval;
                        } else {
                            HecTime newStartTime = new HecTime(newTsc.times[0], 1);
                            newStartTime.increment(-1, newTsc.interval);
                            time0 = newStartTime.value();
                        }
                    } else {
                        time0 = newTsc.times[i - 1];
                    }
                    int intl = newTsc.interval;
                    if (intl > 1440) {
                        if (i > 0) {
                            intl = newTsc.times[i] - newTsc.times[i - 1];
                        } else if (newTsc.times.length > 1) {
                            intl = newTsc.times[1] - newTsc.times[0];
                        }
                    }
                    double val = TimeSeriesFunctions.intervalStats(functionType, currentTsc, time0, newTsc.times[i], intl, dataType, missingAllowed, lastIndex, timeOfOccurrence);
                    if (toIrregular) {
                        if (val == -3.4028234663852886E38) continue;
                        irrTimes[count] = timeOfOccurrence.value;
                        newTsc.values[count] = val;
                        ++count;
                        continue;
                    }
                    newTsc.values[i] = val;
                }
                if (toIrregular) {
                    if (count == irrTimes.length) {
                        newTsc.times = irrTimes;
                    } else {
                        newTsc.times = Arrays.copyOf(irrTimes, count);
                        newTsc.values = Arrays.copyOf(newTsc.values, count);
                        newTsc.numberValues = count;
                    }
                }
                if (functionType == 13 || functionType == 12 || functionType == 18) {
                    if (averageTimeSeriesTypes.contains(newTsc.type.toLowerCase())) {
                        newTsc.type = isDss ? "INST-VAL" : "Inst";
                    }
                    break block52;
                }
                throw new ComputationException("TimeSeriesFunctions.transformTimeSeries: Undefined Function type\nFunction Type = " + functionType);
            }
            catch (RuntimeException | VerticalDatumException e) {
                Logger.getLogger(TimeSeriesFunctions.class.getName()).log(Level.FINE, "Computation.transformTimeSeries", e);
                throw new ComputationException("Computation.transformTimeSeries", e);
            }
        }
    }

    private static boolean isValidTimeSeriesType(String timeSeriesType) {
        for (String validTimeSeriesType : validTimeSeriesTypes) {
            if (!validTimeSeriesType.equalsIgnoreCase(timeSeriesType)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        TimeSeriesContainer tsc1 = new TimeSeriesContainer();
        tsc1.fullName = "/a1/b1/c1/d1/e1/f1/";
        tsc1.numberValues = 5;
        tsc1.times = new int[]{1, 3, 5, 7, 9};
        tsc1.values = new double[]{1.0, 10.0, -3.4, 12.5, 7.0};
        tsc1.quality = new int[]{0, 0, 0, 0, 0};
        TimeSeriesContainer tsc2 = new TimeSeriesContainer();
        tsc2.fullName = "/a2/b2/c2/d2/e2/f2/";
        tsc2.numberValues = 5;
        tsc2.times = new int[]{1, 3, 5, 8, 9};
        tsc2.values = new double[]{2.0, 20.0, -3.4, 22.5, 7.0};
        tsc2.quality = new int[]{0, 0, 0, 0, 0};
        Vector<ValueContainer> vcl = new Vector<ValueContainer>();
        vcl.add(new ValueContainer(tsc1));
        vcl.add(new ValueContainer(tsc2));
        String conditionStr = "$0 > 10 || $1 < 20";
        Condition condition = new Condition(conditionStr);
        System.out.println("Condition = " + conditionStr);
        System.out.println("Condition = " + condition.toString());
        TimeSeriesContainer tsc3 = TimeSeriesFunctions.add(vcl, condition);
        for (int i = 0; i < 5; ++i) {
            System.out.println(tsc1.values[i] + "\t" + tsc1.quality[i] + "\t" + tsc2.values[i] + "\t" + tsc2.quality[i] + "\t" + tsc3.values[i] + "\t" + tsc3.quality[i]);
        }
    }

    public static TimeSeriesContainer transformWithFunction(TimeSeriesContainer baseTsc, ScalarOperable transformer) {
        TimeSeriesContainer result = new TimeSeriesContainer();
        baseTsc.clone(result);
        for (int i = 0; i < result.values.length; ++i) {
            result.values[i] = transformer.evaluate(result.values[i]);
        }
        return result;
    }

    public static TimeSeriesContainer resample(TimeSeriesContainer tsc, Interval interval) throws HecMathException {
        HecTime start = tsc.getStartTime();
        int offset = start.getIntervalOffset(tsc.getTimeInterval());
        TimeSeriesContainer out = ((TimeSeriesMath)TimeSeriesMath.generateRegularIntervalTimeSeries(tsc.getStartTime().toString(), tsc.getEndTime().toString(), interval.getMinutes(), offset, -3.4028234663852886E38)).getContainer();
        block0: for (int j = 0; j < tsc.times.length; ++j) {
            for (int i = 0; i < out.times.length; ++i) {
                if (out.times[i] != tsc.times[j]) continue;
                out.values[i] = tsc.values[j];
                continue block0;
            }
        }
        out.setFullName(tsc.getFullName());
        out.setType(tsc.getType());
        return out;
    }

    static {
        dssTimeSeriesTypes = new HashSet<String>();
        for (String type : DssDataType.getTimeSeriesTypes()) {
            dssTimeSeriesTypes.add(type);
        }
        cwmsTimeSeriesTypes = new HashSet<String>();
        cwmsTimeSeriesTypes.add("Inst");
        cwmsTimeSeriesTypes.add("Total");
        cwmsTimeSeriesTypes.add("Ave");
        validTimeSeriesTypes = new HashSet<String>();
        validTimeSeriesTypes.addAll(dssTimeSeriesTypes);
        validTimeSeriesTypes.addAll(cwmsTimeSeriesTypes);
        instTimeSeriesTypes = new HashSet<String>();
        periodTimeSeriesTypes = new HashSet<String>();
        totalTimeSeriesTypes = new HashSet<String>();
        averageTimeSeriesTypes = new HashSet<String>();
        Iterator<String> it = validTimeSeriesTypes.iterator();
        while (it.hasNext()) {
            String type = it.next().toLowerCase();
            if (type.startsWith("inst")) {
                instTimeSeriesTypes.add(type);
                continue;
            }
            if (!type.startsWith("per") && !type.startsWith("total") && !type.startsWith("ave")) continue;
            periodTimeSeriesTypes.add(type);
            if (type.indexOf("ave") != -1) {
                averageTimeSeriesTypes.add(type);
                continue;
            }
            totalTimeSeriesTypes.add(type);
        }
    }

    public static enum MovingAverageMethod {
        FORWARD,
        CENTERED,
        OLYMPIC;

    }
}

