/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.DataStorage;
import hec.model.DataObject;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractDataStorage
implements DataStorage {
    Method[] _nativeMethods;
    Hashtable _objectToNativeMethod = new Hashtable();
    Class _myClass = this.getClass();

    @Override
    public int getObjectCount() {
        throw new RuntimeException("Method not yet implemented");
    }

    @Override
    public String getFilename() {
        throw new RuntimeException("Method not yet implemented");
    }

    @Override
    public Object callNativeMethod(Object obj) {
        Class<?> cls = obj.getClass();
        if (cls.equals(Object.class)) {
            return null;
        }
        Method m = null;
        if (this._nativeMethods == null) {
            this._nativeMethods = this.getMethodsByName("callNativeMethod");
        } else {
            m = (Method)this._objectToNativeMethod.get(cls);
        }
        if (m != null) {
            try {
                Object retObj = m.invoke((Object)this, obj);
                return retObj;
            }
            catch (Exception te) {
                System.out.println("FdaDataStorage: ERROR failed to call " + m.getName() + " with args " + cls.getName() + " error " + te);
                return null;
            }
        }
        while (cls != null) {
            for (int i = 0; i < this._nativeMethods.length; ++i) {
                m = this._nativeMethods[i];
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].equals(cls)) continue;
                try {
                    if (cls.equals(obj.getClass())) {
                        this._objectToNativeMethod.put(cls, m);
                    }
                    Object retObj = m.invoke((Object)this, obj);
                    return retObj;
                }
                catch (Exception te) {
                    System.out.println("FdaDataStorage: ERROR failed to call " + m.getName() + " with args " + cls.getName() + " error " + te);
                    return null;
                }
            }
            cls = cls.getSuperclass();
        }
        System.out.println("FdaDataStorage:ERROR Failed to find callNativeMethod(" + obj.getClass() + ")");
        return null;
    }

    protected Method[] getMethodsByName(String methodName) {
        Method[] methods = this._myClass.getDeclaredMethods();
        Vector<Method> v = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName)) continue;
            v.addElement(m);
        }
        Object[] nativeMethods = new Method[v.size()];
        v.copyInto(nativeMethods);
        return nativeMethods;
    }

    @Override
    public DataObject addNewObject2(Object obj) {
        if (!(obj instanceof DataObject)) {
            return null;
        }
        DataObject dataObj = (DataObject)obj;
        long id = this.addNewObject(dataObj);
        if (id > -1L) {
            dataObj.setId(id);
            return dataObj;
        }
        return null;
    }

    @Override
    public long addNewObject(Object obj) {
        System.out.println(this.getClass().getName() + ".addNewObject: WARNING method no implemented");
        return -1L;
    }

    @Override
    public boolean save() {
        System.out.println(this.getClass().getName() + ".save: WARNING method no implemented");
        return true;
    }

    @Override
    public boolean removeObject(long objId, String objClass) {
        System.out.println(this.getClass().getName() + ".removeObject: WARNING method no implemented");
        return false;
    }

    @Override
    public boolean removeObject(long[] objId, String objClass) {
        System.out.println(this.getClass().getName() + ".removeObject: WARNING method no implemented");
        return false;
    }

    @Override
    public void workspaceClosing() {
    }

    @Override
    public Object loadObject(String name, String objClass) {
        System.out.println(this.getClass().getName() + ".loadObject: WARNING method no implemented");
        return null;
    }

    @Override
    public boolean backupData(String backupDir, DataObject obj) {
        System.out.println(this.getClass().getName() + ".backupData: WARNING method no implemented");
        return false;
    }

    @Override
    public boolean reload() {
        return true;
    }

    @Override
    public long getLastModifiedTime() {
        return Long.MIN_VALUE;
    }

    @Override
    public void compress() {
    }
}

