/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import rma.util.RMAFilenameFilter;

public class AppLockFile {
    private FileLock _lock;
    private FileChannel _lockChannel;

    public void createLockFile(String clsName) {
        File lockFile;
        String name = clsName;
        int idx = clsName.lastIndexOf(46);
        if (idx > -1) {
            name = clsName.substring(idx + 1);
        }
        try {
            lockFile = File.createTempFile(name, ".lck");
        }
        catch (IOException e) {
            System.out.println("createLockFile:failed to create lock file " + e);
            return;
        }
        lockFile.deleteOnExit();
        if (AppLockFile.checkForPreviousApps(name, lockFile)) {
            System.exit(0);
        }
        try {
            this._lockChannel = new RandomAccessFile(lockFile, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            System.out.println("createLockFile:failed to get File Channel for lock file " + e);
            return;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread("Unlock File Hook"){

            @Override
            public void run() {
                if (AppLockFile.this._lock != null) {
                    try {
                        AppLockFile.this._lock.release();
                        AppLockFile.this._lock = null;
                    }
                    catch (IOException e) {
                        System.out.println("createLockFile:failed to release application file lock " + e);
                    }
                }
                if (AppLockFile.this._lockChannel != null) {
                    try {
                        AppLockFile.this._lockChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                lockFile.delete();
            }
        });
    }

    private static boolean checkForPreviousApps(String name, File lockFile) {
        File[] files;
        RMAFilenameFilter filter = new RMAFilenameFilter("lck", "lock files");
        filter.setAcceptDirectories(false);
        File dir = lockFile;
        if (!lockFile.isDirectory()) {
            dir = lockFile.getParentFile();
        }
        if ((files = dir.listFiles(filter)) != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean b;
                if (!files[i].getName().startsWith(name) || (b = AppLockFile.canLockFile(files[i]))) continue;
                JFrame frame = new JFrame();
                frame.setAlwaysOnTop(true);
                String msg = "<html>At least one other instance of " + name + " is currently running.<br>Use the TaskList included with the " + name + " installation to view or end any instances that should not be running.<br><br>Are you sure you want to open another copy of " + name + "?</html>";
                String title = "Multiple Instances of " + name + " Detected";
                int opt = JOptionPane.showConfirmDialog(frame, msg, title, 0);
                return opt == 1;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canLockFile(File file) {
        FileChannel channel;
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            System.out.println("canLockFile:failed to get File Channel for lock file " + e);
            return false;
        }
        try {
            boolean locked;
            FileLock lock = channel.tryLock();
            boolean bl = locked = lock != null;
            if (lock != null) {
                lock.release();
            }
            boolean bl2 = locked;
            return bl2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

