/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.appInterface.AppDaddy;
import hec.heclib.util.HecTime;
import hec.io.AsciiDeserializerV1;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializableConstants;
import hec.io.TextFileReference;
import hec.lang.DeserializeObjectException;
import hec.model.PairedValues;
import hec.model.SeasonalRecord;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.AsciiDeserializerLoggingMarker;

public class AsciiDeserializer
implements AsciiSerializableConstants {
    private static final MarkingClassLogger ASCII_DESERIALIZER_LOGGER = MarkingClassLogger.forMarkingClass(AsciiDeserializerLoggingMarker.class);
    protected static final Float FLOAT_NAN = Float.valueOf(Float.NaN);
    protected static final Float FLOAT_POSITIVE_INFINITY = Float.valueOf(Float.POSITIVE_INFINITY);
    protected static final Float FLOAT_NEGATIVE_INFINITY = Float.valueOf(Float.NEGATIVE_INFINITY);
    protected static final Double DOUBLE_NAN = Double.NaN;
    protected static final Double DOUBLE_POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    protected static final Double DOUBLE_NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    protected BufferedReader _in = null;
    private static final Class[] NULL_CLASS_ARGS = new Class[0];
    private static final Object[] NULL_METHOD_ARGS = new Object[0];
    protected Map<Object, Object> _objectTable = new HashMap<Object, Object>();
    Stack _objectStack = new Stack();
    Object _currentObject = null;
    protected String _curLine;
    protected String _curType;
    protected String _curParam;
    protected int _version = 1;
    protected static boolean _showTiming = false;
    private Map<String, String> _clsMappings = new HashMap<String, String>();
    private Map<Class, Map<String, WeakReference<Field>>> _accessibleFields = new WeakHashMap<Class, Map<String, WeakReference<Field>>>();

    public AsciiDeserializer(BufferedReader in) {
        this._in = in;
        if (this._in == null) {
            return;
        }
        this.getVersion();
    }

    protected void putObjectInTable(Object id, Object obj) {
        this._objectTable.put(id, obj);
    }

    public void reset(BufferedReader in) {
        this._in = in;
        this.clear();
        if (this._in == null) {
            return;
        }
        this.getVersion();
    }

    public void clear() {
        this._objectTable.clear();
        this._objectStack.clear();
        this._currentObject = null;
        this._version = 1;
        this._curLine = null;
        this._curType = null;
        this._curParam = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeObject(Object obj) {
        if (this._in == null) {
            return false;
        }
        if (this._version == 1) {
            AsciiDeserializerV1 v1deserializer = new AsciiDeserializerV1(this._in);
            boolean bl = v1deserializer.deserializeObject(obj);
            return bl;
        }
        if (this._version >= 2) {
            boolean results;
            boolean bl = results = this.deserializeObjectV2(obj);
            return bl;
        }
        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("deserializeObject: unknown version " + this._version);
        if (AppDaddy.getApp() != null) {
            AppDaddy.getApp().postError("Load Error unknown AsciiSerialized File version" + this._version, "Load Error");
        }
        boolean bl = false;
        return bl;
        finally {
            try {
                Class<?> c2 = obj.getClass();
                Method cleanupMethod = c2.getDeclaredMethod("cleanupFromDeSerialization", NULL_CLASS_ARGS);
                cleanupMethod.invoke(obj, NULL_METHOD_ARGS);
            }
            catch (Exception c2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deserializeObjectV2(Object obj) {
        long t2;
        long t1;
        block23: {
            if (obj == null) {
                return false;
            }
            t1 = System.currentTimeMillis();
            try {
                this._curLine = this._in.readLine();
                while (this._curLine != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType(this._curLine, "=");
                    if (this._curType.equals("{")) {
                        this._curParam = RMAIO.getParam(this._curLine, "=");
                        this._curParam = this.getNewClassMapping(this._curParam);
                        if (obj.getClass().getName().equals(this._curParam)) {
                            try {
                                if (_showTiming) {
                                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("readObject:");
                                }
                                if (this.readOBJECT(obj) == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            catch (DeserializeObjectException e) {
                                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("DeserializeObject error " + e);
                                if (AppDaddy.getApp() != null) {
                                    AppDaddy.getApp().postError("Load Error " + e, "Error");
                                }
                                boolean bl = false;
                                return bl;
                            }
                            finally {
                                if (_showTiming) {
                                    System.out.println("\n");
                                }
                            }
                            t2 = System.currentTimeMillis();
                            if (!_showTiming) return true;
                            break block23;
                        }
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log(" ERROR expected a " + obj.getClass().getName() + " but found a " + this._curParam);
                    }
                    this._curLine = this._in.readLine();
                }
                return false;
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer." + e);
                boolean bl = false;
                return bl;
            }
        }
        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("deserializeObjectV2 " + obj.getClass() + " took " + (t2 - t1) + " ms.");
        return true;
        finally {
            this.clear();
            this._in = null;
        }
    }

    private Object readNextObject() throws DeserializeObjectException {
        Object obj = null;
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, "=");
                if (this._curType.equals("I")) {
                    return this.readInteger();
                }
                if (this._curType.equals("B")) {
                    return this.readByte();
                }
                if (this._curType.equals("F")) {
                    return this.readFloat();
                }
                if (this._curType.equals("D")) {
                    return this.readDouble();
                }
                if (this._curType.equals("J")) {
                    return this.readLong();
                }
                if (this._curType.equals("S")) {
                    return this.readShort();
                }
                if (this._curType.equals("C")) {
                    return this.readCharacter();
                }
                if (this._curType.equals("Z")) {
                    return this.readBoolean();
                }
                if (this._curType.equals("L")) {
                    return this.readClass();
                }
                if (this._curType.equals("STR")) {
                    return this.readString();
                }
                if (this._curType.equals("java.awt.Shape")) {
                    return this.readShape(RMAIO.getParam(this._curLine, "="));
                }
                if (this._curType.equals("{ENUM")) {
                    return this.readEnumType();
                }
                if (this._curType.equals("hec.heclib.util.HecTime")) {
                    return this.readHecTime();
                }
                if (this._curType.equals("java.awt.Color")) {
                    return this.readColor();
                }
                if (this._curType.equals("java.awt.Insets")) {
                    return this.readInsets();
                }
                if (this._curType.equals("java.time.Duration")) {
                    return this.readJavaDuration();
                }
                if (this._curType.equals("java.awt.Font")) {
                    return this.readFont();
                }
                if (this._curType.equals("REF")) {
                    return this.readREFERENCE();
                }
                if (this._curType.equals("{")) {
                    return this.readOBJECT(null);
                }
                if (this._curType.indexOf("{") == 0) {
                    this.skipToNextEnd();
                } else {
                    if (this._curType.equals("ID")) {
                        return null;
                    }
                    if (this._curType.equals("FLD")) {
                        return null;
                    }
                    if (this._curType.indexOf("}") == 0) {
                        return null;
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer." + e);
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer." + e);
        }
        return obj;
    }

    protected Integer readInteger() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Integer.parseInt(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Byte readByte() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Byte.parseByte(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Float readFloat() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Float.valueOf(this._curParam);
        }
        catch (NumberFormatException e) {
            if (this._curParam.equals("-Infinity")) {
                return FLOAT_NEGATIVE_INFINITY;
            }
            if (this._curParam.equals("Infinity")) {
                return FLOAT_POSITIVE_INFINITY;
            }
            return null;
        }
    }

    private Long readLong() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Long.parseLong(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Double readDouble() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Double.valueOf(this._curParam);
        }
        catch (NumberFormatException e) {
            if (this._curParam.equals("-Infinity")) {
                return DOUBLE_NEGATIVE_INFINITY;
            }
            if (this._curParam.equals("Infinity")) {
                return DOUBLE_POSITIVE_INFINITY;
            }
            return null;
        }
    }

    private Short readShort() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Short.parseShort(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Character readCharacter() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Character.valueOf(this._curParam.charAt(0));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean readBoolean() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Boolean.valueOf(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String readString() {
        return RMAIO.getParam(this._curLine, "=").replace('\u0001', '\n');
    }

    private Class readClass() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        this._curParam = this.getNewClassMapping(this._curParam);
        Class<?> cls = null;
        try {
            cls = Class.forName(this._curParam);
        }
        catch (ClassNotFoundException ce) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Class not found " + this._curParam + " Error " + ce);
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ce.toString());
        }
        catch (NoClassDefFoundError ne) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Class not found " + this._curParam + " Error " + ne);
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ne.toString());
        }
        return cls;
    }

    private Color readColor() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        int rgb = Integer.parseInt(this._curParam.trim());
        return new Color(rgb);
    }

    private Font readFont() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        StringTokenizer strTok = new StringTokenizer(this._curParam, ",", false);
        String fontName = strTok.nextToken();
        int fontSize = Integer.parseInt(strTok.nextToken());
        int fontStyle = Integer.parseInt(strTok.nextToken());
        return new Font(fontName, fontStyle, fontSize);
    }

    private Duration readJavaDuration() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            return Duration.parse(this._curParam);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    private Insets readInsets() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        StringTokenizer strTok = new StringTokenizer(this._curParam, ",", false);
        int top = Integer.parseInt(strTok.nextToken());
        int left = Integer.parseInt(strTok.nextToken());
        int bot = Integer.parseInt(strTok.nextToken());
        int rt = Integer.parseInt(strTok.nextToken());
        return new Insets(top, left, bot, rt);
    }

    private Object readShape(String className) {
        try {
            this._curLine = this._in.readLine();
            this._curType = RMAIO.getType(this._curLine, "=");
            this._curParam = RMAIO.getParam(this._curLine, "=");
            List shapeList = (List)this.readOBJECT(new ArrayList());
            if (shapeList == null || shapeList.size() == 0) {
                return null;
            }
            GeneralPath path = new GeneralPath();
            Line2D.Double lineSeg = new Line2D.Double();
            for (int j = 0; j < shapeList.size(); ++j) {
                List ptList = (List)shapeList.get(j);
                double[] pt0 = (double[])ptList.get(0);
                for (int i = 1; i < ptList.size(); ++i) {
                    double[] pt1 = (double[])ptList.get(i);
                    lineSeg.setLine(pt0[0], pt0[1], pt1[0], pt1[1]);
                    path.append(lineSeg, true);
                    pt0 = pt1;
                }
            }
            return new Area(path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private HecTime readHecTime() {
        this._curParam = RMAIO.getParam(this._curLine, "=");
        int idx = this._curParam.indexOf(44);
        int val = Integer.parseInt(this._curParam.substring(0, idx));
        int incr = Integer.parseInt(this._curParam.substring(idx + 1));
        return new HecTime(val, incr);
    }

    protected Object readREFERENCE() {
        Integer id;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        try {
            id = Integer.parseInt(this._curParam);
        }
        catch (NumberFormatException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("NumberFormatException parsing [" + this._curParam + "]");
            id = null;
        }
        if (id == null) {
            return null;
        }
        Object obj = this._objectTable.get(id);
        if (obj == null) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("ref " + id + " is null");
        }
        return obj;
    }

    protected Object readOBJECT(Object oldobj) {
        Object obj;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        if (this._curParam.equals("null")) {
            obj = null;
        } else {
            Class<?> c2;
            this._curParam = this.getNewClassMapping(this._curParam);
            if (this._curParam.equals("hec.model.PairedValues") && this._version >= 3) {
                return this.readPairedValues();
            }
            if (this._curParam.equals("hec.model.PairedValuesExt")) {
                return null;
            }
            if (this._curParam.equals("hec.model.SeasonalRecord") && this._version >= 4) {
                return this.readSeasonalRecord();
            }
            if (this._curParam.equals("hec.io.TextFileReference") && this._version >= 5) {
                return this.readTextFileReference();
            }
            try {
                c2 = Class.forName(this._curParam);
            }
            catch (ClassNotFoundException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            catch (NoClassDefFoundError ne) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + ne.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ne.toString());
            }
            catch (UnsatisfiedLinkError e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            if (c2.isArray()) {
                return this.readArrayOBJECT(oldobj);
            }
            if (oldobj != null && oldobj.getClass() == c2) {
                obj = oldobj;
            } else {
                int idx = this._curParam.indexOf(36);
                if (idx > 0) {
                    try {
                        Class<?> oc = Class.forName(this._curParam.substring(0, idx));
                    }
                    catch (ClassNotFoundException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding outer class for object " + this._curParam.substring(0, idx) + " Error " + e.toString());
                        System.out.println("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
                    }
                    catch (NoClassDefFoundError ce) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding outer class for object " + this._curParam + " Error " + ce.toString());
                        System.out.println("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ce.toString());
                    }
                    Object[] params = new Object[]{oldobj};
                    try {
                        obj = c2.getDeclaredConstructors()[0].newInstance(params);
                    }
                    catch (UnsatisfiedLinkError e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c2.getName() + " Error " + e);
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e);
                    }
                    catch (NoSuchMethodError e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object. (probably no default constructor) " + c2.getName() + " Error " + e);
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object. (probably no default constructor) " + c2.getName() + " Error " + e);
                    }
                    catch (InstantiationException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c2.getName() + " Error " + e.toString());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c2.getName() + " Error " + e.toString());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                    }
                    catch (InvocationTargetException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c2.getName() + " Error " + e.toString() + " " + e.getMessage());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString() + " " + e.getMessage());
                    }
                }
                try {
                    obj = c2.newInstance();
                }
                catch (UnsatisfiedLinkError e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object " + c2.getName() + " Error " + e);
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e);
                }
                catch (NoSuchMethodError e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object. (probably no default constructor) " + c2.getName() + " Error " + e);
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object. (probably no default constructor) " + c2.getName() + " Error " + e);
                }
                catch (InstantiationException e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object " + c2.getName() + " Error " + e.toString());
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                }
                catch (IllegalAccessException e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object " + c2.getName() + " Error " + e.toString());
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                }
            }
        }
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, "=");
                if (_showTiming) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log(".");
                }
                if (this._curType.equals("ID")) {
                    Integer id = this.readInteger();
                    if (id != null) {
                        this._objectTable.put(id, obj);
                    }
                } else if (this._curType.equals("FLD")) {
                    this.readObjectField(obj);
                } else if (this._curType.equals("{COLLECT")) {
                    if (obj instanceof Collection) {
                        this.readObjectCollection((Collection)obj);
                    } else {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("incorrect Collection data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else if (this._curType.equals("{MAP")) {
                    if (obj instanceof Map) {
                        this.readObjectMap((Map)obj);
                    } else {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("incorrect Map data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else {
                    if (this._curType.indexOf("}") == 0) {
                        return obj;
                    }
                    if (this._curType.indexOf("{") == 0) {
                        this.skipToNextEnd();
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return obj;
    }

    protected Object readArrayOBJECT(Object oldobj) {
        Class<?> c2;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        this._curParam = this.getNewClassMapping(this._curParam);
        try {
            c2 = Class.forName(this._curParam);
        }
        catch (ClassNotFoundException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Failed to find Array Class " + this._curParam);
            return null;
        }
        Object obj = null;
        Integer id = null;
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, "=");
                if (this._curType.equals("ID")) {
                    id = this.readInteger();
                } else if (this._curType.equals("{[")) {
                    this._curParam = RMAIO.getParam(this._curLine, "=");
                    int len = RMAIO.parseInt(this._curParam);
                    if (len == Integer.MIN_VALUE) {
                        return null;
                    }
                    int[] dim = new int[]{len};
                    if (oldobj != null && oldobj.getClass() == c2) {
                        obj = oldobj;
                    } else {
                        try {
                            obj = Array.newInstance(c2.getComponentType(), dim);
                        }
                        catch (NegativeArraySizeException e) {
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("negative array error for " + c2.getName() + " error " + e.toString());
                            return null;
                        }
                        catch (IllegalArgumentException e) {
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("IllegalArgumentException error for " + c2.getName() + " error " + e.toString());
                            return null;
                        }
                    }
                    if (id != null) {
                        this._objectTable.put(id, obj);
                    }
                    if (c2.getComponentType().isPrimitive()) {
                        this.readArrayElements(obj);
                    } else {
                        this.readObjectArrayElements(obj, len);
                    }
                } else {
                    if (this._curType.indexOf("}") == 0) {
                        return obj;
                    }
                    if (this._curType.indexOf("{") == 0) {
                        this.skipToNextEnd();
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return obj;
    }

    protected void readObjectField(Object obj) throws IOException {
        String fname = this._curParam = RMAIO.getParam(this._curLine, "=");
        Field fld = this.getAccessibleField(obj.getClass(), fname);
        if (fld == null) {
            if (_showTiming) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding Field " + fname + " in Class " + obj.getClass().getName());
            }
            return;
        }
        Object fobj = this.readNextObject();
        if (fobj != null) {
            this.setFieldValue(obj, fld, fobj);
        }
    }

    public Field getField(Class fclass, String fname) {
        Field fld = null;
        while (fclass != null) {
            try {
                fld = fclass.getDeclaredField(fname);
                break;
            }
            catch (NoSuchFieldException e) {
                fclass = fclass.getSuperclass();
            }
            catch (SecurityException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log(e.toString());
                return null;
            }
        }
        return fld;
    }

    private Field getAccessibleField(Class fclass, String fname) {
        WeakReference<Field> weakRef;
        Field retval = null;
        Field field = null;
        Map<String, WeakReference<Field>> mapForClass = this._accessibleFields.get(fclass);
        if (mapForClass != null && (weakRef = mapForClass.get(fname)) != null) {
            retval = (Field)weakRef.get();
        }
        if (retval == null && (field = this.getField(fclass, fname)) != null) {
            try {
                field.setAccessible(true);
                retval = field;
                this.addAccessibleField(fclass, fname, retval);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (retval == null) {
            retval = field;
        }
        return retval;
    }

    private void addAccessibleField(Class fclass, String fname, Field retval) {
        Map<String, WeakReference<Field>> mapForClass = this._accessibleFields.get(fclass);
        if (mapForClass == null) {
            mapForClass = new HashMap<String, WeakReference<Field>>();
            this._accessibleFields.put(fclass, mapForClass);
        }
        mapForClass.put(fname, new WeakReference<Field>(retval));
    }

    public void setFieldValue(Object obj, Field fld, Object fobj) {
        if (fobj != null) {
            block8: {
                if (!fld.isAccessible()) {
                    try {
                        fld.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        if (Modifier.isPublic(fld.getModifiers()) || !(obj instanceof AsciiSerializable)) break block8;
                        ((AsciiSerializable)obj).setFieldObject(fld, fobj);
                        return;
                    }
                }
            }
            try {
                fld.set(obj, fobj);
            }
            catch (IllegalAccessException e) {
                System.out.println("Field " + fld.getName() + " " + e.toString());
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                if (obj instanceof AsciiSerializable) {
                    ((AsciiSerializable)obj).setFieldObject(fld, fobj);
                }
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause(e)).log("field %s", fld.getName());
            }
        }
    }

    protected void readArrayElements(Object obj) throws IOException {
        int icnt = 0;
        int startIdx = 0;
        int endIdx = 0;
        while ((this._curLine = this._in.readLine()) != null) {
            String token;
            endIdx = 0;
            startIdx = 0;
            this._curType = RMAIO.getType(this._curLine, "=");
            if (this._curType.indexOf("}") == 0) {
                return;
            }
            this._curParam = RMAIO.getParam(this._curLine, "=");
            while ((endIdx = this._curParam.indexOf(44, startIdx)) > -1 && (token = this._curParam.substring(startIdx, endIdx)) != null) {
                Object elem = this.getArrayElement(this._curType, token);
                if (obj != null) {
                    try {
                        Array.set(obj, icnt, elem);
                    }
                    catch (Exception e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log(" error " + e.toString());
                    }
                }
                ++icnt;
                startIdx = endIdx + 1;
            }
        }
    }

    private Object getArrayElement(String primType, String value) {
        try {
            switch (primType.charAt(0)) {
                case 'B': {
                    return Byte.parseByte(value);
                }
                case 'C': {
                    return Character.valueOf(value.charAt(0));
                }
                case 'D': {
                    return Double.valueOf(value);
                }
                case 'F': {
                    return Float.valueOf(value);
                }
                case 'I': {
                    return Integer.parseInt(value);
                }
                case 'J': {
                    return Long.parseLong(value);
                }
                case 'S': {
                    return Short.parseShort(value);
                }
                case 'Z': {
                    return Boolean.valueOf(value);
                }
            }
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("unknown type " + primType + " value " + value);
            return null;
        }
        catch (NumberFormatException e) {
            switch (primType.charAt(0)) {
                case 'D': {
                    if (value.equals("-Infinity")) {
                        return DOUBLE_NEGATIVE_INFINITY;
                    }
                    if (value.equals("Infinity")) {
                        return DOUBLE_POSITIVE_INFINITY;
                    }
                    if (value.equals("NaN")) {
                        return DOUBLE_NAN;
                    }
                    return null;
                }
                case 'F': {
                    if (value.equals("-Infinity")) {
                        return FLOAT_NEGATIVE_INFINITY;
                    }
                    if (value.equals("Infinity")) {
                        return FLOAT_POSITIVE_INFINITY;
                    }
                    if (value.equals("NaN")) {
                        return FLOAT_NAN;
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            System.out.println("error creating object for type " + primType + " value " + value);
            System.out.println("\terror " + e);
        }
        return null;
    }

    private void readObjectArrayElements(Object obj, int len) throws IOException {
        for (int icnt = 0; icnt < len; ++icnt) {
            Object vobj = this.readNextObject();
            try {
                Array.set(obj, icnt, vobj);
                continue;
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log(" error " + e.toString());
            }
        }
        this.readNextObject();
    }

    protected void readObjectCollection(Collection obj) throws IOException {
        Object vobj = this.readNextObject();
        while (vobj != null) {
            obj.add(vobj);
            vobj = this.readNextObject();
        }
    }

    protected Object readEnumType() {
        try {
            Object enumClassObj = this.readNextObject();
            Object enumNameObj = this.readNextObject();
            Class enumClass = (Class)enumClassObj;
            T[] enumConstants = enumClass.getEnumConstants();
            if (enumConstants == null) {
                return null;
            }
            for (Object enumObj : enumConstants) {
                if (!enumObj.toString().equalsIgnoreCase(enumNameObj.toString())) continue;
                this.skipToNextEnd();
                return enumObj;
            }
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    protected void readObjectMap(Map obj) throws IOException {
        Object tobj;
        Object kobj = this.readNextObject();
        while (kobj != null && (tobj = this.readNextObject()) != null) {
            obj.put(kobj, tobj);
            kobj = this.readNextObject();
        }
    }

    protected void skipToNextEnd() throws IOException {
        this._curLine = this._in.readLine();
        while (this._curLine != null) {
            if (this._curLine.length() == 0) {
                this._curLine = this._in.readLine();
                continue;
            }
            this._curType = RMAIO.getType(this._curLine, "=");
            if (this._curType.indexOf("}") == 0) {
                return;
            }
            if (this._curType.indexOf("{") == 0) {
                this.skipToNextEnd();
            }
            this._curLine = this._in.readLine();
        }
    }

    protected void getVersion() {
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() > 0) {
                    this._curType = RMAIO.getType(this._curLine, "=");
                    if (this._curType.equals("AsciiSerializer")) {
                        this._curParam = RMAIO.getParam(this._curLine, "=");
                        this._version = RMAIO.parseInt(this._curParam, 1);
                        return;
                    }
                    if (this._curType.indexOf("{") == 0) {
                        return;
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException ioe) {
            return;
        }
    }

    public void setCurParam(String curParam) {
        this._curParam = curParam;
    }

    public String getCurParam() {
        return this._curParam;
    }

    public String getCurLine() {
        return this._curLine;
    }

    public void addClassMapping(String oldClass, String newClass) {
        this._clsMappings.put(oldClass, newClass);
    }

    protected String getNewClassMapping(String curClass) {
        if (curClass == null) {
            return curClass;
        }
        if (curClass.startsWith("[L") && curClass.endsWith(";")) {
            String tempClass = curClass.substring(2, curClass.length() - 1);
            Object newClass = this._clsMappings.get(tempClass);
            if (newClass != null) {
                newClass = "[L" + (String)newClass + ";";
                return newClass;
            }
        } else {
            String newClass = this._clsMappings.get(curClass);
            if (newClass != null) {
                return newClass;
            }
        }
        return curClass;
    }

    protected SeasonalRecord readSeasonalRecord() {
        SeasonalRecord sr;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        if (this._curParam.equals("null")) {
            sr = null;
        } else {
            sr = new SeasonalRecord();
            try {
                while ((this._curLine = this._in.readLine()) != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType(this._curLine, "=");
                    if (this._curType.equals("DSSPATH")) continue;
                    if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id == null) continue;
                        this._objectTable.put(id, sr);
                        continue;
                    }
                    if (this._curType.equals("REF")) {
                        return (SeasonalRecord)this.readREFERENCE();
                    }
                    if (this._curType.equals("FLD")) {
                        this.readObjectField(sr);
                        continue;
                    }
                    if (this._curType.indexOf("}") == 0) {
                        return sr;
                    }
                    if (this._curType.indexOf("{") != 0) continue;
                    this.skipToNextEnd();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return sr;
    }

    protected PairedValues readPairedValues() {
        PairedValues pv;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        double[] xValues = null;
        double[] yValues = null;
        boolean firstArray = true;
        if (this._curParam.equals("null")) {
            pv = null;
        } else {
            pv = new PairedValues();
            try {
                this._curLine = this._in.readLine();
                while (this._curLine != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType(this._curLine, "=");
                    if (this._curType.equals("DSSPATH")) continue;
                    if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id != null) {
                            this._objectTable.put(id, pv);
                        }
                    } else if (this._curType.equals("{[")) {
                        this._curParam = RMAIO.getParam(this._curLine, "=");
                        int len = RMAIO.parseInt(this._curParam);
                        if (len == Integer.MIN_VALUE) continue;
                        if (firstArray) {
                            xValues = new double[len];
                            this.readArrayElements(xValues);
                            firstArray = false;
                        } else {
                            yValues = new double[len];
                            this.readArrayElements(yValues);
                            for (int i = 0; i < len; ++i) {
                                pv.addPair(xValues[i], yValues[i]);
                            }
                        }
                    } else if (this._curType.equals("FLD")) {
                        this.readObjectField(pv);
                    } else {
                        if (this._curType.indexOf("}") == 0) {
                            return pv;
                        }
                        if (this._curType.indexOf("{") == 0) {
                            this.skipToNextEnd();
                        }
                    }
                    this._curLine = this._in.readLine();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return pv;
    }

    protected TextFileReference readTextFileReference() {
        TextFileReference retval;
        this._curParam = RMAIO.getParam(this._curLine, "=");
        if (this._curParam.equals("null")) {
            retval = null;
        } else {
            retval = new TextFileReference();
            try {
                this._curLine = this._in.readLine();
                while (this._curLine != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType(this._curLine, "=");
                    if (this._curType.equals("FILEPATH")) continue;
                    if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id != null) {
                            this._objectTable.put(id, retval);
                        }
                    } else if (this._curType.equals("FLD")) {
                        this.readObjectField(retval);
                    } else {
                        if (this._curType.indexOf("}") == 0) {
                            return retval;
                        }
                        if (this._curType.indexOf("{") == 0) {
                            this.skipToNextEnd();
                        }
                    }
                    this._curLine = this._in.readLine();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return retval;
    }

    static {
        _showTiming = Boolean.getBoolean("AsciiSerializer.showTiming");
    }
}

