/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.appInterface.AppDaddy;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.lang.DeserializeObjectException;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import rma.util.RMAHashkey;
import rma.util.RMAIO;

public class AsciiDeserializerV1 {
    BufferedReader _in = null;
    Hashtable _objectTable = new Hashtable();
    Stack _objectStack = new Stack();
    Object _currentObject = null;
    String _curLine;
    String _curType;
    String _curParam;
    String _delim = "=";
    RMAHashkey _refId = new RMAHashkey();

    public AsciiDeserializerV1(BufferedReader in) {
        this._in = in;
    }

    public boolean deserializeObject(Object obj) {
        if (obj == null) {
            return false;
        }
        long t1 = System.currentTimeMillis();
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, this._delim);
                if (this._curType.equals("BEGIN OBJECT")) {
                    this._curParam = RMAIO.getParam(this._curLine, this._delim);
                    if (obj.getClass().getName().equals(this._curParam)) {
                        try {
                            if (this.readOBJECT(obj) == null) {
                                return false;
                            }
                        }
                        catch (DeserializeObjectException e) {
                            System.out.println("DeserializeObject error " + e);
                            if (AppDaddy.getApp() != null) {
                                AppDaddy.getApp().postError("Load Error " + e, "Error");
                            }
                            return false;
                        }
                        long t2 = System.currentTimeMillis();
                        System.out.println("DeserializeObject " + obj.getClass() + " took " + (t2 - t1) + " ms");
                        return true;
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file in AsciiDeserializer.");
            return false;
        }
        return false;
    }

    private Object readNextObject() throws DeserializeObjectException {
        Object obj = null;
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, this._delim);
                if (this._curType.equals("Integer")) {
                    return this.readInteger();
                }
                if (this._curType.equals("Byte")) {
                    return this.readByte();
                }
                if (this._curType.equals("Float")) {
                    return this.readFloat();
                }
                if (this._curType.equals("Double")) {
                    return this.readDouble();
                }
                if (this._curType.equals("Long")) {
                    return this.readLong();
                }
                if (this._curType.equals("Short")) {
                    return this.readShort();
                }
                if (this._curType.equals("Character")) {
                    return this.readCharacter();
                }
                if (this._curType.equals("Boolean")) {
                    return this.readBoolean();
                }
                if (this._curType.equals("Class")) {
                    return this.readClass();
                }
                if (this._curType.equals("String")) {
                    return this.readString();
                }
                if (this._curType.equals("hec.heclib.util.HecTime")) {
                    return this.readHecTime();
                }
                if (this._curType.equals("REFERENCE")) {
                    return this.readREFERENCE();
                }
                if (this._curType.equals("BEGIN OBJECT")) {
                    return this.readOBJECT(null);
                }
                if (this._curType.indexOf("BEGIN") == 0) {
                    this.skipToNextEnd();
                } else {
                    if (this._curType.equals("ID")) {
                        return null;
                    }
                    if (this._curType.equals("FIELD")) {
                        return null;
                    }
                    if (this._curType.indexOf("END") == 0) {
                        return null;
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file in AsciiDeserializer." + e);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer." + e);
        }
        return obj;
    }

    private Integer readInteger() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Integer(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Byte readByte() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Byte(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Float readFloat() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Float(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Long readLong() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Long(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Double readDouble() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Double(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Short readShort() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Short(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Character readCharacter() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return new Character(this._curParam.charAt(0));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean readBoolean() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            return Boolean.valueOf(this._curParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String readString() {
        return RMAIO.getParam(this._curLine, this._delim).replace('\u0001', '\n');
    }

    private Class readClass() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        Class<?> cls = null;
        try {
            cls = Class.forName(this._curParam);
        }
        catch (ClassNotFoundException ce) {
            System.out.println("Class not found " + this._curParam);
            throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ce.toString());
        }
        return cls;
    }

    private HecTime readHecTime() {
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        int idx = this._curParam.indexOf(",");
        int val = Integer.parseInt(this._curParam.substring(0, idx));
        int incr = Integer.parseInt(this._curParam.substring(idx + 1));
        return new HecTime(val, incr);
    }

    private Object readREFERENCE() {
        Integer id;
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            id = new Integer(this._curParam);
        }
        catch (NumberFormatException e) {
            id = null;
        }
        if (id == null) {
            return null;
        }
        Object obj = this._objectTable.get(id);
        if (obj == null) {
            System.out.println("WARNING:readREFERENCE: ref " + id + " is null");
        }
        return obj;
    }

    private Object readOBJECT(Object oldobj) {
        Object obj;
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        if (this._curParam.equals("null")) {
            obj = null;
        } else {
            Class<?> c2;
            try {
                c2 = Class.forName(this._curParam);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Error finding class for object " + this._curParam + " Error " + e.toString());
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("Error finding class for object " + this._curParam + " Error " + e.toString());
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            if (c2.isArray()) {
                return this.readArrayOBJECT(oldobj);
            }
            if (oldobj != null && oldobj.getClass() == c2) {
                obj = oldobj;
            } else {
                try {
                    obj = c2.newInstance();
                }
                catch (UnsatisfiedLinkError e) {
                    System.out.println("Error creating object " + c2.getName() + " Error " + e.toString());
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                }
                catch (NoSuchMethodError e) {
                    System.out.println("Error creating object. (probably no default constructor) " + c2.getName() + " Error " + e.toString());
                    throw new DeserializeObjectException("Error creating object. (probably no default constructor) " + c2.getName() + " Error " + e.toString());
                }
                catch (InstantiationException e) {
                    System.out.println("Error creating object " + c2.getName() + " Error " + e.toString());
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                }
                catch (IllegalAccessException e) {
                    System.out.println("Error creating object " + c2.getName() + " Error " + e.toString());
                    throw new DeserializeObjectException("Error creating object " + c2.getName() + " Error " + e.toString());
                }
            }
        }
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, this._delim);
                if (this._curType.equals("ID")) {
                    Integer id = this.readInteger();
                    if (id != null) {
                        this._objectTable.put(id, obj);
                    }
                } else if (this._curType.equals("FIELD")) {
                    this.readObjectField(obj);
                } else if (this._curType.equals("BEGIN VECTOR")) {
                    if (obj instanceof Vector) {
                        this.readObjectVector((Vector)obj);
                    } else {
                        System.out.println("incorrect vector data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else if (this._curType.equals("BEGIN HASH")) {
                    if (obj instanceof Hashtable) {
                        this.readObjectHash((Hashtable)obj);
                    } else {
                        System.out.println("incorrect vector data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else {
                    if (this._curType.equals("END OBJECT")) {
                        return obj;
                    }
                    if (this._curType.indexOf("BEGIN") == 0) {
                        this.skipToNextEnd();
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("readObject():Error reading file in AsciiDeserializer. " + e.toString());
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return obj;
    }

    private Object readArrayOBJECT(Object oldobj) {
        Class<?> c2;
        this._curParam = RMAIO.getParam(this._curLine, this._delim);
        try {
            c2 = Class.forName(this._curParam);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Object obj = null;
        Integer id = null;
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType(this._curLine, this._delim);
                if (this._curType.equals("ID")) {
                    id = this.readInteger();
                } else if (this._curType.equals("BEGIN ARRAY")) {
                    this._curParam = RMAIO.getParam(this._curLine, this._delim);
                    int len = RMAIO.parseInt(this._curParam);
                    if (len == Integer.MIN_VALUE) {
                        return null;
                    }
                    int[] dim = new int[]{len};
                    if (oldobj != null && oldobj.getClass() == c2) {
                        obj = oldobj;
                    } else {
                        try {
                            obj = Array.newInstance(c2.getComponentType(), dim);
                        }
                        catch (NegativeArraySizeException e) {
                            System.out.println("readArrayOBJECT() negative array error for " + c2.getName() + " error " + e.toString());
                            return null;
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println("readArrayOBJECT() IllegalArgumentException error for " + c2.getName() + " error " + e.toString());
                            return null;
                        }
                    }
                    if (id != null) {
                        this._objectTable.put(id, obj);
                    }
                    this.readArrayElements(obj);
                } else {
                    if (this._curType.equals("END OBJECT")) {
                        return obj;
                    }
                    if (this._curType.indexOf("BEGIN") == 0) {
                        this.skipToNextEnd();
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file in AsciiDeserializer. " + e.toString());
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return obj;
    }

    private void readObjectField(Object obj) throws IOException {
        String fname = this._curParam = RMAIO.getParam(this._curLine, this._delim);
        Field fld = null;
        for (Class<?> fclass = obj.getClass(); fclass != null; fclass = fclass.getSuperclass()) {
            try {
                fld = fclass.getDeclaredField(fname);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (SecurityException e) {
                System.out.println(e.toString());
                return;
            }
        }
        if (fld == null) {
            System.out.println("Error finding Field " + fname);
            return;
        }
        Object fobj = this.readNextObject();
        if (fobj != null) {
            try {
                if (Modifier.isPublic(fld.getModifiers())) {
                    fld.set(obj, fobj);
                } else if (obj instanceof AsciiSerializable) {
                    ((AsciiSerializable)obj).setFieldObject(fld, fobj);
                }
            }
            catch (IllegalAccessException e) {
                System.out.println(e.toString());
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.toString());
            }
        }
    }

    private void readArrayElements(Object obj) throws IOException {
        int icnt = 0;
        Object vobj = this.readNextObject();
        while (vobj != null) {
            try {
                Array.set(obj, icnt, vobj);
            }
            catch (Exception e) {
                System.out.println("readArrayElements() error " + e.toString());
            }
            ++icnt;
            vobj = this.readNextObject();
        }
    }

    private void readObjectVector(Vector obj) throws IOException {
        Object vobj = this.readNextObject();
        while (vobj != null) {
            obj.addElement(vobj);
            vobj = this.readNextObject();
        }
    }

    private void readObjectHash(Hashtable obj) throws IOException {
        Object tobj;
        Object kobj = this.readNextObject();
        while (kobj != null && (tobj = this.readNextObject()) != null) {
            obj.put(kobj, tobj);
            kobj = this.readNextObject();
        }
    }

    private void skipToNextEnd() throws IOException {
        this._curLine = this._in.readLine();
        while (this._curLine != null) {
            if (this._curLine.length() == 0) {
                this._curLine = this._in.readLine();
                continue;
            }
            this._curType = RMAIO.getType(this._curLine, this._delim);
            if (this._curType.indexOf("END") == 0) {
                return;
            }
            if (this._curType.indexOf("BEGIN") == 0) {
                this.skipToNextEnd();
            }
            this._curLine = this._in.readLine();
        }
    }
}

