/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializableConstants;
import hec.io.TextFileReference;
import hec.model.PairedValues;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import rma.util.DoubleVector;
import rma.util.IntVector;
import rma.util.LongVector;
import rma.util.RMAHashtable;
import rma.util.RMAIO;

public class AsciiSerializer
implements AsciiSerializableConstants {
    private static final int CUR_VERSION = 5;
    protected BufferedWriter _out = null;
    int _recursionLevel = 0;
    protected String _strIndent = "";
    int _tabcount = 2;
    int _nextHashIndex = 0;
    RMAHashtable _objectTable = new RMAHashtable();
    protected StringBuffer _outLine = new StringBuffer();
    protected static int _maxArraySize = 10;
    protected static boolean _formatFile = false;
    protected static boolean _showTiming = false;
    static final Class[] NULL_CLASS_ARGS = new Class[0];
    static final Object[] NULL_METHOD_ARGS = new Object[0];

    public AsciiSerializer(BufferedWriter out) {
        this._out = out;
        if (this._out == null) {
            return;
        }
        this.writeHeader();
    }

    public void reset(BufferedWriter out) {
        this._out = out;
        this._objectTable.clear();
        this._strIndent = "";
        this._recursionLevel = 0;
        this._nextHashIndex = 0;
        this._outLine.setLength(0);
        if (this._out == null) {
            return;
        }
        this.writeHeader();
    }

    public boolean serializeObject(Object obj) {
        if (obj == null || this._out == null) {
            return false;
        }
        try {
            long t1 = System.currentTimeMillis();
            Class<?> c2 = obj.getClass();
            try {
                Method setupMethod = c2.getDeclaredMethod("setupForSerialization", NULL_CLASS_ARGS);
                setupMethod.invoke(obj, NULL_METHOD_ARGS);
            }
            catch (NoSuchMethodException setupMethod) {
            }
            catch (InvocationTargetException ite) {
                System.out.println("serializeObject: Exception on setupForSerialization" + ite.getTargetException());
                ite.getTargetException().printStackTrace(System.out);
            }
            catch (IllegalAccessException iae) {
                System.out.println("serializeObject: Exception on setupForSerialization" + iae);
                iae.printStackTrace(System.out);
            }
            this.writeObject(obj);
            try {
                Method cleanupMethod = c2.getDeclaredMethod("cleanupFromSerialization", NULL_CLASS_ARGS);
                cleanupMethod.invoke(obj, NULL_METHOD_ARGS);
            }
            catch (Exception cleanupMethod) {
                // empty catch block
            }
            long t2 = System.currentTimeMillis();
            if (_showTiming) {
                System.out.println("serialized Object took " + (t2 - t1) + " ms.");
            }
        }
        catch (IOException e) {
            System.out.println("failed to write object");
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    protected void writeHeader() {
        try {
            this._out.write("AsciiSerializer=5");
            this._out.newLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean writeObjectFields(Object obj) throws IOException {
        Class<?> supclass;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Serializable)) {
            return true;
        }
        boolean isAsciiSerializable = obj instanceof AsciiSerializable;
        Class objclass = obj.getClass();
        Stack classStack = new Stack();
        Class c2 = objclass;
        classStack.push(c2);
        while ((supclass = c2.getSuperclass()) != null) {
            classStack.push(supclass);
            c2 = supclass;
        }
        while (!classStack.empty()) {
            c2 = (Class)classStack.pop();
            Field[] fieldArray = c2.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                int mods = fieldArray[i].getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                Object fldObj = null;
                if (Modifier.isPublic(mods)) {
                    try {
                        fldObj = fieldArray[i].get(obj);
                    }
                    catch (IllegalAccessException e) {
                        fldObj = null;
                    }
                } else if (isAsciiSerializable) {
                    fldObj = ((AsciiSerializable)obj).getFieldObject(fieldArray[i]);
                }
                if (fldObj == null || this.writeField(fieldArray[i], fldObj)) continue;
                return false;
            }
        }
        if (obj instanceof Collection) {
            this.writeCollectionData((Collection)obj);
        } else if (obj instanceof Map) {
            this.writeMapData((Map)obj);
        }
        return true;
    }

    protected boolean writeField(Field fld, Object obj) throws IOException {
        Class<?> c2 = fld.getType();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("FLD");
        this._outLine.append("=");
        this._outLine.append(fld.getName());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this.writeObject(obj);
        return true;
    }

    protected Integer getTableObjectIndex(Object obj) {
        Integer id = null;
        if (this._objectTable.containsKey(obj)) {
            id = (Integer)this._objectTable.get(obj);
        }
        return id;
    }

    protected Integer addTableObject(Object obj) {
        Integer id;
        if (this._objectTable.containsKey(obj)) {
            id = (Integer)this._objectTable.get(obj);
        } else {
            id = new Integer(this._nextHashIndex);
            this._objectTable.put(obj, id);
            ++this._nextHashIndex;
        }
        return id;
    }

    protected void incrementRecursion() {
        ++this._recursionLevel;
        if (_formatFile) {
            for (int i = 0; i < this._tabcount; ++i) {
                this._strIndent = this._strIndent + " ";
            }
        }
    }

    protected void decrementRecursion() {
        --this._recursionLevel;
        if (_formatFile) {
            this._strIndent = this._strIndent.substring(0, this._recursionLevel * this._tabcount);
        }
    }

    protected void writeObject(Object obj) throws IOException {
        Class<?> c2 = null;
        if (obj != null) {
            c2 = obj.getClass();
        }
        String type = null;
        String val = null;
        if (c2 != null && c2.isPrimitive()) {
            type = "VAL";
            val = obj.toString();
        } else if (c2 != null && c2.isEnum()) {
            this.writeEnumData(obj);
        } else if (obj instanceof Class) {
            type = "L";
            val = ((Class)obj).getName();
        } else if (obj instanceof String) {
            type = "STR";
            val = ((String)obj).replace('\n', '\u0001');
        } else if (obj instanceof Integer) {
            type = "I";
            val = obj.toString();
        } else if (obj instanceof Byte) {
            type = "B";
            val = obj.toString();
        } else if (obj instanceof Float) {
            type = "F";
            val = obj.toString();
        } else if (obj instanceof Double) {
            type = "D";
            val = obj.toString();
        } else if (obj instanceof Long) {
            type = "J";
            val = obj.toString();
        } else if (obj instanceof Short) {
            type = "S";
            val = obj.toString();
        } else if (obj instanceof Character) {
            type = "C";
            val = obj.toString();
        } else if (obj instanceof Boolean) {
            type = "Z";
            val = obj.toString();
        } else if (obj instanceof Area) {
            Shape shape = (Shape)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Shape=" + shape.getClass().getName());
            this._out.write(this._outLine.toString());
            this._out.newLine();
            PathIterator path = shape.getPathIterator(null);
            double[] p = new double[6];
            ArrayList polygonList = new ArrayList();
            ArrayList<double[]> pointList = null;
            while (!path.isDone()) {
                int style = path.currentSegment(p);
                switch (style) {
                    case 0: {
                        if (pointList != null) {
                            polygonList.add(pointList);
                        }
                        pointList = new ArrayList<double[]>();
                        pointList.add(new double[]{p[0], p[1]});
                        break;
                    }
                    case 3: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[2], p[3]});
                        break;
                    }
                    case 2: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[4], p[5]});
                        break;
                    }
                    case 1: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[0], p[1]});
                        break;
                    }
                    case 4: {
                        if (pointList == null) break;
                        polygonList.add(pointList);
                        pointList = null;
                    }
                }
                path.next();
            }
            this.writeObject(polygonList);
        } else if (obj instanceof HecTime) {
            HecTime ht = (HecTime)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("hec.heclib.util.HecTime");
            this._outLine.append("=");
            this._outLine.append(ht.value());
            this._outLine.append(",");
            this._outLine.append(ht.timeIncrement());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Color) {
            Color color = (Color)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Color");
            this._outLine.append("=");
            this._outLine.append(color.getRGB());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Insets) {
            Insets insets = (Insets)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Insets");
            this._outLine.append("=");
            this._outLine.append(insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right);
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Duration) {
            Duration duration = (Duration)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.time.Duration");
            this._outLine.append("=");
            this._outLine.append(duration.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Font) {
            Font font = (Font)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Font");
            this._outLine.append("=");
            this._outLine.append(font.getFontName() + "," + font.getSize() + "," + font.getStyle());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof PairedValues) {
            this.writePairedValues((PairedValues)obj);
        } else {
            if (obj instanceof LongVector) {
                LongVector lc = (LongVector)obj;
                lc.trimToSize();
            } else if (obj instanceof IntVector) {
                IntVector iv = (IntVector)obj;
                iv.trimToSize();
            } else if (obj instanceof DoubleVector) {
                DoubleVector dv = (DoubleVector)obj;
                dv.trimToSize();
            }
            if (obj == null) {
                this._out.write(this._strIndent + "{=null");
                this._out.newLine();
                this._out.write(this._strIndent + "}");
                this._out.newLine();
                return;
            }
            Integer id = this.getTableObjectIndex(obj);
            if (id != null) {
                type = "REF";
                val = id.toString();
            } else {
                id = this.addTableObject(obj);
                this._outLine.setLength(0);
                this._outLine.append(this._strIndent);
                this._outLine.append("{");
                this._outLine.append("=");
                this._outLine.append(obj.getClass().getName());
                this._out.write(this._outLine.toString());
                this._out.newLine();
                this.incrementRecursion();
                this._outLine.setLength(0);
                this._outLine.append(this._strIndent);
                this._outLine.append("ID");
                this._outLine.append("=");
                this._outLine.append(id.toString());
                this._out.write(this._outLine.toString());
                this._out.newLine();
                if (c2.isArray()) {
                    this.writeArray(obj);
                } else {
                    this.writeObjectFields(obj);
                }
                this.decrementRecursion();
                this._out.write(this._strIndent + "}");
                this._out.newLine();
            }
        }
        if (type != null && val != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append(type);
            this._outLine.append("=");
            this._outLine.append(val);
            this._out.write(this._outLine.toString());
            this._out.newLine();
        }
    }

    protected void writePairedValues(PairedValues pv) throws IOException {
        Integer id = this.getTableObjectIndex(pv);
        if (id != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("REF");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else {
            Object fldObj;
            int mods;
            if (pv.size() > 0 && pv.getDssIdentifer() != null) {
                return;
            }
            id = this.addTableObject(pv);
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("{");
            this._outLine.append("=");
            this._outLine.append("hec.model.PairedValues");
            this._out.write(this._outLine.toString());
            this._out.newLine();
            this.incrementRecursion();
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("ID");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
            double[] xarray = pv.getXArray();
            this.writeArray(xarray);
            double[] yarray = pv.getYArray();
            this.writeArray(yarray);
            Class<PairedValues> c2 = PairedValues.class;
            Field[] fieldArray = c2.getDeclaredFields();
            for (int i = 0; i < fieldArray.length && (fieldArray[i].getName().equals("_dataVector") || Modifier.isTransient(mods = fieldArray[i].getModifiers()) || Modifier.isStatic(mods) || (fldObj = this.getFieldObject(pv, fieldArray[i], mods)) == null || this.writeField(fieldArray[i], fldObj)); ++i) {
            }
            this.decrementRecursion();
            this._out.write(this._strIndent + "}");
            this._out.newLine();
        }
    }

    protected Object getFieldObject(AsciiSerializable obj, Field field, int mods) {
        Object fldObj = null;
        if (Modifier.isPublic(mods)) {
            try {
                fldObj = field.get(obj);
            }
            catch (IllegalAccessException e) {
                fldObj = null;
            }
        } else {
            fldObj = obj.getFieldObject(field);
        }
        return fldObj;
    }

    protected void writeTypeParamLine(String type, String param) throws IOException {
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append(type);
        this._outLine.append("=");
        this._outLine.append(param);
        this._out.write(this._outLine.toString());
        this._out.newLine();
    }

    protected void writeTextFileReference(TextFileReference tfr) throws IOException {
        Integer id = this.getTableObjectIndex(tfr);
        if (id != null) {
            this.writeTypeParamLine("REF", id.toString());
        } else {
            Integer objId = this.addTableObject(tfr);
            this.writeTypeParamLine("{", "hec.io.TextFileReference");
            this.incrementRecursion();
            this.writeTypeParamLine("ID", objId.toString());
            this.writeFields(tfr, TextFileReference.class.getDeclaredFields());
            this.decrementRecursion();
            this._out.write(this._strIndent + "}");
            this._out.newLine();
        }
    }

    protected void writeFields(AsciiSerializable obj, Field[] declaredFields) throws IOException {
        boolean worked = true;
        for (Field field : declaredFields) {
            if (!worked) continue;
            worked = this.writeField(obj, field);
        }
    }

    protected boolean writeField(AsciiSerializable obj, Field field) throws IOException {
        Object fldObj;
        boolean worked = true;
        int mods = field.getModifiers();
        if (!Modifier.isTransient(mods) && !Modifier.isStatic(mods) && (fldObj = this.getFieldObject(obj, field, mods)) != null) {
            worked = this.writeField(field, fldObj);
        }
        return worked;
    }

    protected void writeArray(Object obj) throws IOException {
        Class<?> c2 = obj.getClass();
        if (!c2.isArray()) {
            System.out.println("WARNING: Multi-dimensional arrays not yet supported by AsciiSerializer.");
            return;
        }
        Class<?> type = c2.getComponentType();
        this._outLine.setLength(0);
        Object cType = this._strIndent;
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("{[");
        this._outLine.append("=");
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                int[] array = (int[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "I=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Byte.TYPE) {
                byte[] array = (byte[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "B=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Float.TYPE) {
                float[] array = (float[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "F=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Double.TYPE) {
                double[] array = (double[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "D=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Long.TYPE) {
                long[] array = (long[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "J=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Short.TYPE) {
                short[] array = (short[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = (String)cType + "S=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Character.TYPE) {
                char[] array = (char[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = "C=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            } else if (type == Boolean.TYPE) {
                boolean[] array = (boolean[])obj;
                int length = array.length;
                this._outLine.append(length);
                this._out.write(this._outLine.toString());
                this._out.newLine();
                cType = "Z=";
                this._out.write((String)cType);
                for (int i = 0; i < length; ++i) {
                    if (i > 0 && i % _maxArraySize == 0) {
                        this._out.newLine();
                        this._out.write((String)cType);
                    }
                    this._out.write(array[i] + ",");
                }
            }
        } else {
            Object[] array = (Object[])obj;
            int length = array.length;
            this._outLine.append(length);
            this._out.write(this._outLine.toString());
            this._out.newLine();
            for (int i = 0; i < length; ++i) {
                this.writeObject(array[i]);
            }
        }
        this._out.newLine();
        this._out.write(this._strIndent + "}]");
        this._out.newLine();
    }

    private void writeCollectionData(Collection col) throws IOException {
        if (col.size() == 0) {
            return;
        }
        Class<?> colClass = col.getClass();
        this._out.write(this._strIndent + "{COLLECT");
        this._out.newLine();
        this.incrementRecursion();
        Iterator iter = col.iterator();
        Class<?> cobjClass = null;
        try {
            cobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        while (iter.hasNext()) {
            Object cobj = iter.next();
            this.writeObject(cobj);
        }
        this.decrementRecursion();
        this._out.write(this._strIndent + "}COLLECT");
        this._out.newLine();
    }

    private void writeVectorData(Vector vec) throws IOException {
        if (vec.size() == 0) {
            return;
        }
        Class<?> vecClass = vec.getClass();
        this._out.write(this._strIndent + "{VECTOR");
        this._out.newLine();
        this.incrementRecursion();
        Enumeration enumeration = vec.elements();
        Class<?> vobjClass = null;
        try {
            vobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        while (enumeration.hasMoreElements()) {
            Object vobj = enumeration.nextElement();
            this.writeObject(vobj);
        }
        this.decrementRecursion();
        this._out.write(this._strIndent + "}VECTOR");
        this._out.newLine();
    }

    protected void writeEnumData(Object enumObject) throws IOException {
        Class<?> mapClass = enumObject.getClass();
        this._out.write(this._strIndent + "{ENUM");
        this._out.newLine();
        this.incrementRecursion();
        this.writeObject(mapClass);
        this.writeObject(enumObject.toString());
        this.decrementRecursion();
        this._out.write(this._strIndent + "}ENUM");
        this._out.newLine();
    }

    private void writeMapData(Map map) throws IOException {
        if (map.size() == 0) {
            return;
        }
        Class<?> mapClass = map.getClass();
        this._out.write(this._strIndent + "{MAP");
        this._out.newLine();
        this.incrementRecursion();
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        Class<?> kobjClass = null;
        Class<?> tobjClass = null;
        try {
            kobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            tobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        while (iter.hasNext()) {
            Object kobj = iter.next();
            Object tobj = map.get(kobj);
            this.writeObject(kobj);
            this.writeObject(tobj);
        }
        this.decrementRecursion();
        this._out.write(this._strIndent + "}MAP");
        this._out.newLine();
    }

    private void writeHashtableData(Hashtable tab) throws IOException {
        if (tab.size() == 0) {
            return;
        }
        Class<?> tabClass = tab.getClass();
        this._out.write(this._strIndent + "{HASH");
        this._out.newLine();
        this.incrementRecursion();
        Enumeration enumeration = tab.keys();
        Class<?> kobjClass = null;
        Class<?> tobjClass = null;
        try {
            kobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            tobjClass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        while (enumeration.hasMoreElements()) {
            Object kobj = enumeration.nextElement();
            Object tobj = tab.get(kobj);
            this.writeObject(kobj);
            this.writeObject(tobj);
        }
        this.decrementRecursion();
        this._out.write(this._strIndent + "}HASH");
        this._out.newLine();
    }

    static {
        _maxArraySize = RMAIO.parseInt(System.getProperty("AsciiSerializer.arraySize"), 10);
        _formatFile = Boolean.getBoolean("AsciiSerializer.formatFile");
        _showTiming = Boolean.getBoolean("AsciiSerializer.showTiming");
    }
}

