/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;

public class AsciiSerializerFormatter {
    private String[] _fileNames;
    private boolean _replaceFiles = false;
    private int _recursionLevel = 0;
    private String _strIndent = "";
    int _tabcount = 2;

    public AsciiSerializerFormatter(String[] fileNames, boolean replaceFiles) {
        this._fileNames = fileNames;
        this._replaceFiles = replaceFiles;
    }

    public AsciiSerializerFormatter() {
    }

    public void format() {
        PrintStream out = null;
        if (this._fileNames == null || this._fileNames.length == 0) {
            System.err.println("No files to format");
            return;
        }
        if (!this._replaceFiles) {
            out = System.out;
        }
        File file = null;
        File file2 = null;
        File parentDir = null;
        for (int i = 0; i < this._fileNames.length; ++i) {
            block11: {
                String fileName = this._fileNames[i];
                if (fileName == null) continue;
                file = new File(fileName);
                System.err.println("Processing file " + fileName);
                if (!file.exists()) {
                    System.err.println("format: file " + fileName + " does not exist");
                    continue;
                }
                if (this._replaceFiles) {
                    file2 = new File(fileName + ".orig");
                    parentDir = file2.getParentFile();
                    if (!parentDir.canWrite()) {
                        System.err.println("format: can't write to file " + parentDir.getPath());
                        continue;
                    }
                    if (!file.renameTo(file2)) {
                        System.err.println("format: failed to rename " + file + " to " + file2);
                        continue;
                    }
                    try {
                        out = new PrintStream(new FileOutputStream(file));
                        break block11;
                    }
                    catch (FileNotFoundException nfe) {
                        System.err.println("format: file not found " + file);
                        continue;
                    }
                }
                file2 = file;
            }
            try {
                BufferedReader in = new BufferedReader(new FileReader(file2));
                this.format(in, out);
                in.close();
                if (out == System.out) continue;
                out.close();
                out = null;
                continue;
            }
            catch (IOException ioe) {
                System.out.println("format: IOException formatting file " + file + " error " + ioe);
                if (!this._replaceFiles) continue;
                file2.renameTo(file);
            }
        }
    }

    private void format(BufferedReader in, PrintStream out) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.indexOf(125) == 0) {
                this.decrementRecursion();
            }
            out.println(this._strIndent + line);
            if (line.indexOf(123) != 0) continue;
            this.incrementRecursion();
        }
    }

    public String format(String asciiText) {
        BufferedReader reader = new BufferedReader(new StringReader(asciiText));
        StringBuffer output = new StringBuffer(asciiText.length());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(125) == 0) {
                    this.decrementRecursion();
                }
                output.append(this._strIndent);
                output.append(line);
                output.append("\n");
                if (line.indexOf(123) != 0) continue;
                this.incrementRecursion();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toString();
    }

    private void incrementRecursion() {
        ++this._recursionLevel;
        for (int i = 0; i < this._tabcount; ++i) {
            this._strIndent = this._strIndent + " ";
        }
    }

    private void decrementRecursion() {
        --this._recursionLevel;
        this._strIndent = this._strIndent.substring(0, this._recursionLevel * this._tabcount);
    }

    public static void printUsage() {
        System.err.println("usage: hec.io.AsciiSerializerFormatter [-R] file [file] [...]");
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            AsciiSerializerFormatter.printUsage();
            System.exit(1);
        }
        String[] fileNames = new String[args.length];
        boolean replaceFiles = false;
        int idx = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-R")) {
                replaceFiles = true;
                continue;
            }
            fileNames[idx++] = args[i];
            System.err.println("Added file " + args[i]);
        }
        new AsciiSerializerFormatter(fileNames, replaceFiles).format();
        System.exit(0);
    }
}

