/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.gui.AbstractFileChooserField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class BasicRmiFileChooserFieldUI
extends BasicTextFieldUI {
    JButton _ellipsesButton;
    AbstractFileChooserField _fileChooserField;
    MouseAdapter _mouseListener;
    ActionListener _actionListener;
    MouseMotionAdapter _mouseMotionListener;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c2) {
        return new BasicRmiFileChooserFieldUI();
    }

    public BasicRmiFileChooserFieldUI() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!BasicRmiFileChooserFieldUI.this._fileChooserField.isEnabled()) {
                    return;
                }
                Point p = e.getPoint();
                if (p.x > BasicRmiFileChooserFieldUI.this._fileChooserField.getWidth() - BasicRmiFileChooserFieldUI.this._ellipsesButton.getWidth()) {
                    BasicRmiFileChooserFieldUI.this._ellipsesButton.doClick();
                }
            }
        };
        this._mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getPoint().x;
                if (x > BasicRmiFileChooserFieldUI.this._fileChooserField.getWidth() - BasicRmiFileChooserFieldUI.this._ellipsesButton.getWidth()) {
                    BasicRmiFileChooserFieldUI.this._fileChooserField.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    BasicRmiFileChooserFieldUI.this._fileChooserField.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        };
        this._actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicRmiFileChooserFieldUI.this._fileChooserField.displayFileChooserDialog();
            }
        };
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public void installUI(JComponent c2) {
        if (!(c2 instanceof AbstractFileChooserField)) {
            String classname = "null";
            if (null != c2) {
                classname = c2.getClass().getName();
            }
            throw new Error("FileChooserUI needs hec.gui.AbstractFileChooserField was:" + c2 + " class:" + classname);
        }
        this._fileChooserField = (AbstractFileChooserField)c2;
        super.installUI(c2);
        if (this._ellipsesButton != null) {
            this.configureEllipsesButton();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this._ellipsesButton = this.createEllipsesButton();
        this._fileChooserField.add(this._ellipsesButton);
        this._fileChooserField.setLayout(this.createLayoutManager());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = new Rectangle(this._fileChooserField.getSize());
        Insets insets = this._fileChooserField.getInsets();
        alloc.x += insets.left;
        alloc.y += insets.top;
        alloc.width -= insets.left + insets.right;
        alloc.width -= this._ellipsesButton.getBounds().width;
        alloc.height -= insets.top + insets.bottom;
        return alloc;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        if (this._ellipsesButton != null) {
            Rectangle r = this._ellipsesButton.getBounds();
            Rectangle a = this.getVisibleEditorRect();
            g.translate(r.x, r.y);
            this._ellipsesButton.paint(g);
        }
    }

    protected JButton createEllipsesButton() {
        return new JButton("...");
    }

    public void configureEllipsesButton() {
        if (this._ellipsesButton != null) {
            this._ellipsesButton.setEnabled(this._fileChooserField.isEnabled());
            this._ellipsesButton.setRequestFocusEnabled(false);
            this._ellipsesButton.setCursor(Cursor.getPredefinedCursor(0));
            if (this._mouseListener != null) {
                this._ellipsesButton.addActionListener(this._actionListener);
                this._fileChooserField.addMouseListener(this._mouseListener);
                this._fileChooserField.addMouseMotionListener(this._mouseMotionListener);
            }
        }
    }

    protected LayoutManager createLayoutManager() {
        return new FileChooserFieldLayoutManager();
    }

    protected Insets getInsets() {
        return this._fileChooserField.getInsets();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = this.getMinimumSize(c2);
        size.width += 4;
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        Insets insets = this.getInsets();
        FontMetrics fm = this._fileChooserField.getFontMetrics(this._fileChooserField.getFont());
        Dimension size = new Dimension(100, fm.getHeight());
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        Dimension size = this.getPreferredSize(c2);
        size.width = Short.MAX_VALUE;
        return size;
    }

    public class FileChooserFieldLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            AbstractFileChooserField cb = (AbstractFileChooserField)parent;
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            AbstractFileChooserField cb = (AbstractFileChooserField)parent;
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            AbstractFileChooserField df = (AbstractFileChooserField)parent;
            int width = df.getWidth();
            int height = df.getHeight();
            Insets insets = BasicRmiFileChooserFieldUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicRmiFileChooserFieldUI.this._ellipsesButton != null) {
                BasicRmiFileChooserFieldUI.this._ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
            }
        }
    }
}

