/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.text.MessageFormat;

public class CodebaseErrorTable {
    private static MessageFormat m_textFormat = new MessageFormat("({0}) {1}");

    public static String getErrorCodeString(int errorCode) {
        switch (errorCode) {
            case -10: {
                return "Closing File Error, An error occurred while attempting to close a file";
            }
            case -20: {
                return "Creating File Error, This error could be caused by specifying an illegal file name, attempting to create a file that is open, having a full directory, or by having a disk problem. This error also results when the operating system doesn't have enough file handles.";
            }
            case -30: {
                return "Determinig File Length, Ac error occurred while attempting to determine the length of a file.  This error occurs\nwhen CodeBase runs out of valid file handles.";
            }
            case -40: {
                return "Setting File Length, An error occurred while setting the length of a file. This error occurs when an aplication\ndoes not have write access to the file or is out of disk space.";
            }
            case -50: {
                return "Locking File, An error occurred while trying to lock a file.  Generally this error occurs when the Code4::lockEnforce\nvariable is set to true and an attempt is made to modify an unlocked record.   This error can occur when File4::lock is called\nmore than once for the same set of bytes without calling File4::unlock between the calls to File4::lock.";
            }
            case -60: {
                return "Open File Error, A general file failure occurred opening a file. This error may also include of the -6x errors of the selected compiler or OS does not allow for distinguishing between various file errors.";
            }
            case -61: {
                return "Permission Error Opening File. Permission to open the file as specified was denied.\nFor example, another user may have the file opened exclusively.";
            }
            case -62: {
                return "Access Error Opening File. Invalid open mode was specified.  This would usually occur\nif there was a discrepancy between CodeBase and the implementation on a compiler or operating system.";
            }
            case -63: {
                return "File Handle Count Overflow. The maximum file handle count was exceeded.";
            }
            case -64: {
                return "File Find Error. File was not found as specified";
            }
            case -69: {
                return "Duplicate Instance. An attempt to open a duplicate instance of a file has been denied. The Code4::singleOpen setting influences how duplicate accessing of a file from within the same executable is performed.\nIndicates one of two possibilities\n\n1. An open request has occurred but an active data handle in the same executable is inhibiting the open\n2. In a client-server configuration, a different client application has explicitly requested and has been granted\nexclusive client-access to the specified file.";
            }
            case -70: {
                return "Reading File Error:  An error occurred while reading a file.  This could be caused by calling Data4:go with a \nnonexistent record number.";
            }
            case -200: {
                return "File is not a Data File: Attempting to opena file as a .DBF data file when the file is not actually a true data file.  If the file\n is a data file, this error indicates that the file header and possibly the data are corrupt.";
            }
            case -210: {
                return "Unrecognized Field Name: A function, such as Data4::Field, was called with a field name not present in the data file";
            }
            case -220: {
                return "Unrecognized Field Type: A data field had an unrecognized field type.  The field type of each field is specified in the data file header";
            }
            case -230: {
                return "Record Length too Large: The total record length is too large.  The maximum is USHRT_MAX-1, which is 65534 for most compilers";
            }
            case -240: {
                return "Record Append Attempt Past End of File";
            }
            case -250: {
                return "Seeking: This error can occur if int Data4::Seek(double) tries to do a seek on a non-numeric tag.";
            }
            case -300: {
                return "Tag Entry Missing: A tag entry was not located. This error occurs when a key, corresponding to a data file record,\nshould be in a tag but is not.";
            }
            case -310: {
                return "Not a Correct Index File: This error indicates that a file specified as an indes file is note a true index file. \nSome internal index file inconsistency was detected.";
            }
            case -330: {
                return "Tag Name not Found: The Tag name specified is not an actual tag name.  Make sure the name is correct and that the\ncorresponding index file is open.";
            }
            case -340: {
                return "Unique Key Error: An attempt was made to add a record or create an index file that would have resulted in a duplicate\nkey for a unique key tag.  In addition, Tag4::unique returned e4unique, or when creating an index file,\nthe member TAG4INFO.unique specified e4unique";
            }
            case -350: {
                return "Tag Information is Invalid: Usually occurs when calling Data4::create or Index4::create with invalid information in the input TAG4INFO structure";
            }
            case -490: {
                return "Unrecognized Value - A character sequence was not recongnized as a dBase constant, field name, or function.";
            }
        }
        return "Can't find Error Code in Codebase Information manual";
    }

    public static void printErrorString(int errorCode) {
        System.out.println(m_textFormat.format(new Object[]{Integer.toString(errorCode), CodebaseErrorTable.getErrorCodeString(errorCode)}));
    }
}

