/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.appInterface.AppDaddy;
import hec.io.ConsoleWindow;
import hec.io.HecOutputStream;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class Console {
    protected ConsoleWindow _console;
    private HecOutputStream _output;

    public boolean hasConsoleWindow() {
        return this._console != null;
    }

    public ConsoleWindow getConsoleWindow() {
        return this._console;
    }

    public void showConsole() {
        if (this._console != null) {
            if (this._console.getState() == 1) {
                this._console.setState(0);
            } else {
                this._console.setVisible(true);
            }
        } else {
            System.out.println("showConsole: no console created");
        }
    }

    public static Console getConsole() {
        String logFile = System.getProperty("LOGFILE");
        if (logFile != null) {
            Console c2 = new Console();
            c2.setLogFile(logFile);
            return c2;
        }
        return null;
    }

    public void setLogFile(String logFileName) {
        File parent;
        String cwms_home;
        if (((String)logFileName).indexOf("CWMS_HOME") > -1 && (cwms_home = System.getProperty("CWMS_HOME", null)) != null) {
            int i = ((String)logFileName).indexOf("CWMS_HOME");
            logFileName = ((String)logFileName).substring(0, i) + cwms_home + ((String)logFileName).substring(i + 9);
        }
        System.out.println("setLogFile: set to " + (String)logFileName);
        File logFile = new File((String)logFileName);
        if (logFile.exists()) {
            File logFileBak = new File((String)logFileName + ".bak");
            if (logFileBak.exists()) {
                logFileBak.delete();
            }
            logFile.renameTo(logFileBak);
        }
        if ((parent = logFile.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
            System.out.println("setLogFile:failed to mkdir " + parent.getAbsolutePath());
        }
        try {
            this._output = new HecOutputStream(logFile);
            this._console = new ConsoleWindow(){

                @Override
                public void setVisible(boolean b) {
                    if (b) {
                        this.readFile();
                        Console.this._output.setUserInterface(Console.this._console);
                    } else {
                        Console.this._output.setUserInterface(null);
                    }
                    super.setVisible(b);
                }
            };
            this._console.setToolTipText("LogFile=" + logFile.getAbsolutePath());
            this._console.setLogFile(logFile);
            PrintStream out = new PrintStream(this._output, true);
            System.setOut(out);
            System.setErr(out);
        }
        catch (Exception e) {
            System.out.println("setLogFile:Error setting output streams " + e);
            e.printStackTrace(System.out);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AppDaddy.getFrame() != null && ((Component)((Object)AppDaddy.getFrame())).isVisible()) {
                        JOptionPane.showMessageDialog(null, "Failed to set output streams " + e);
                    }
                }
            });
        }
    }
}

