/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.gui.AbstractRmiTextFileReaderJDialog;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import hec.model.UserInterface;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import rma.util.RMAIO;

public class ConsoleWindow
extends AbstractRmiTextFileReaderJDialog
implements UserInterface {
    private File _logFile;

    public ConsoleWindow() {
        super((Frame)null, false);
        this.setTitle("Console Output");
        this._readFile = true;
        this.setHTTPText(false);
        this.buildFormatMenu();
        this.setSystemClosable(false);
    }

    @Override
    public void printMessage(final String msg) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                Document doc = this.jTA_text.getDocument();
                int len = doc.getLength();
                doc.insertString(len, msg, null);
            }
            catch (BadLocationException ble) {
                System.out.println(ble);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document doc = ConsoleWindow.this.jTA_text.getDocument();
                        int len = doc.getLength();
                        doc.insertString(len, msg, null);
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble);
                    }
                }
            });
        }
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void computeComplete() {
    }

    @Override
    public void setProgress(int i) {
    }

    @Override
    public void printErrorMessage(String msg) {
        this.printMessage(msg);
    }

    @Override
    public void printWarningMessage(String msg) {
        this.printMessage(msg);
    }

    @Override
    public void printStatus(String status) {
        this.printMessage(status);
    }

    public void setToolTipText(String text) {
        this.jTA_text.setToolTipText(text);
        this.jTxtFileName.setText(RMAIO.getParam(text, "="));
    }

    public void readFile() {
        BufferedReader reader;
        if (this._logFile == null) {
            return;
        }
        int pos = this.jTA_text.getCaretPosition();
        this.jTA_text.setText("");
        try {
            reader = new BufferedReader(new FileReader(this._logFile));
        }
        catch (FileNotFoundException e1) {
            System.out.println("readFile: FileNotFoundException " + e1);
            e1.printStackTrace();
            return;
        }
        try {
            this.jTA_text.read(reader, (Object)this._logFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("readFile: IOException " + e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (pos > 0 && pos < this.jTA_text.getText().length()) {
            try {
                this.jTA_text.setCaretPosition(pos);
            }
            catch (Exception e) {
                System.out.println("readFile:failed to set caret position to " + pos + " Error:" + e);
            }
        }
    }

    public void setLogFile(File logfile) {
        this._logFile = logfile;
    }

    @Override
    protected Identifier getFileIdentifier(Identifier id) {
        Identifier newId = new Identifier(id);
        newId.setFile(new SimpleHecFileImpl(id.getPath()));
        return newId;
    }

    @Override
    protected boolean fileExists(String prevFilePath) {
        return Files.exists(Paths.get(prevFilePath, new String[0]), new LinkOption[0]);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            Document doc = this.jTA_text.getDocument();
            int len = doc.getLength();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleWindow.this.jTA_text.requestFocus();
                    ConsoleWindow.this.jTA_text.setCaretPosition(0);
                }
            });
        } else {
            this.jTA_text.setText("");
        }
    }
}

