/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4relateMatch;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4;
import codebase.Field4boolean;
import codebase.Field4byteArray;
import codebase.Field4date;
import codebase.Field4deleteFlag;
import codebase.Field4double;
import codebase.Field4info;
import codebase.Field4stringBuffer;
import codebase.Relate4jni;
import codebase.Tag4info;
import hec.io.AbstractDataStorage;
import hec.io.AsciiSerializableConstants;
import hec.io.CodebaseErrorTable;
import hec.io.DBFFileNameFactory;
import hec.io.DBFIndexObject;
import hec.io.DBFMapObject;
import hec.io.DBFMappingClass;
import hec.io.DBFSerializable;
import hec.io.EndianInputStream;
import hec.io.Identifier;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBaseIVMemoUpdate;
import hec.io.dbf.annotations.Parameter;
import hec.io.dbf.annotations.Type;
import hec.io.dbf.types.UserType;
import hec.lang.Const;
import hec.lang.DeserializeObjectException;
import hec.model.DataObject;
import hec.model.DataStruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class DBFDataStorage
extends AbstractDataStorage
implements AsciiSerializableConstants {
    protected static MessageFormat _errorCodeFormat = new MessageFormat("({0}) {1}");
    static final Logger LOGGER = Logger.getLogger(DBFDataStorage.class.getName());
    protected boolean _checkForDifferences = true;
    public static boolean DEBUG = false;
    protected Code4jni _database = null;
    protected Data4jni _dbfFile = null;
    protected Map _dbfSubFileTable = null;
    protected Field4info _dbfFields = null;
    protected Tag4info _dbfTags = null;
    protected DBFMappingClass _dbfMap = null;
    protected List _field4List = new ArrayList();
    protected boolean _hasBeenInit = false;
    protected boolean _hasTags = false;
    protected Identifier _id = null;
    protected String _TAGID = "";
    protected String _TAGNAME = "";
    protected Field4deleteFlag _deleteFlag = null;
    protected Map<String, Field> _jName2FieldMap = new HashMap<String, Field>();
    protected long _nextId = 1L;
    protected String _classType = "";
    protected DBFSerializable _serializedObj = null;
    protected int _dbfRefCount = 0;
    protected int _currentRow = 0;
    protected boolean _recordDeleted = false;
    private String _testString = new String();
    private List<DBFIndexObject> mIndexesToAdd = new ArrayList<DBFIndexObject>();
    private Class[] _field4ConstParam = new Class[2];
    private boolean _serializeUpdate = false;
    private static final String NEW_LINE = "\n";
    private static final String TAB_CHAR = "\t";
    public static final Integer DBF_UNDEF_INT = new Integer(-901);
    public static final Long DBF_UNDEF_LONG = new Long(DBF_UNDEF_INT.longValue());
    public static final Double DBF_UNDEF_DOUBLE = new Double(DBF_UNDEF_LONG.doubleValue());
    public static final Float DBF_UNDEF_FLOAT = new Float(DBF_UNDEF_LONG.floatValue());
    public static final Integer DBF_UNDEF_INT2 = new Integer(-922);
    public static final Long DBF_UNDEF_LONG2 = new Long(DBF_UNDEF_INT2.longValue());
    public static final Double DBF_UNDEF_DOUBLE2 = new Double(DBF_UNDEF_INT2.doubleValue());
    public static final Float DBF_UNDEF_FLOAT2 = new Float(DBF_UNDEF_INT2.floatValue());
    Object _idLock = new Object();
    String _fileName;
    static final Object syncObject = "1";
    Double UNDEF_DOUBLE = new Double(-3.4028234663852886E38);
    Double NEG_INFIN_D = new Double(Double.NEGATIVE_INFINITY);
    Double POS_INFIN_D = new Double(Double.POSITIVE_INFINITY);
    Double NAN_D = new Double(Double.NaN);
    Float UNDEF_FLOAT = new Float(-3.4028235E38f);
    Float NEG_INFIN_F = new Float(Float.NEGATIVE_INFINITY);
    Float POS_INFIN_F = new Float(Float.POSITIVE_INFINITY);
    Float NAN_F = new Float(Float.NaN);
    Integer UNDEF_INT = new Integer(Integer.MIN_VALUE);
    Long UNDEF_LONG = new Long(Long.MIN_VALUE);

    public DBFDataStorage(String workspacePath, String clsType) {
        try {
            this.setup(workspacePath, clsType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DBFDataStorage(String filePath, String clsType, String notUsed) {
        this.setup2(filePath, clsType);
    }

    public void setCheckForDifferences(boolean runCheck) {
        this._checkForDifferences = runCheck;
    }

    public int getCurrentRowIndex() {
        return this._currentRow;
    }

    private void setup2(String filePath, String clsType) {
        Class<?> ICls = null;
        Class<?> cls = null;
        this._classType = clsType;
        try {
            ICls = Class.forName("hec.io.DBFSerializable");
            cls = Class.forName(this._classType);
            if (!ICls.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(this._classType + " is not implement hec.io.DBFSerializable");
            }
            this.serializeObject((DBFSerializable)cls.newInstance(), filePath);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.log(Level.SEVERE, cnfe.getMessage(), cnfe);
            throw new DeserializeObjectException("Error finding class for object " + this._classType + " Error " + cnfe.toString());
        }
        catch (InstantiationException ie) {
            LOGGER.log(Level.SEVERE, ie.getMessage(), ie);
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            LOGGER.log(Level.SEVERE, iae.getMessage(), iae);
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + iae.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + e.toString());
        }
    }

    private void setup(String workspacePath, String clsType) {
        Class<?> ICls = null;
        Class<?> cls = null;
        this._classType = clsType;
        try {
            ICls = Class.forName("hec.io.DBFSerializable");
            cls = Class.forName(this._classType);
            if (!ICls.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(this._classType + " is not implement hec.io.DBFSerializable");
            }
            this.serializeObject((DBFSerializable)cls.newInstance(), workspacePath, clsType);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Error finding class for object " + this._classType + " Error " + cnfe.toString());
            throw new DeserializeObjectException("Error finding class for object " + this._classType + " Error " + cnfe.toString());
        }
        catch (InstantiationException ie) {
            System.out.println("Error creating object " + cls.getName() + " Error " + ie.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            System.out.println("Error creating object " + cls.getName() + " Error " + iae.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + iae.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Error4unexpected, Error4relateMatch {
    }

    private void serializeObject(DBFSerializable dbfObj, String workspacePath, String classType) {
        String fileName;
        this._classType = classType;
        this._fileName = DBFFileNameFactory.getFileNameforClass(this._classType);
        if (this._fileName == null) {
            System.out.println("DBFDataStorage.serializeObject: failed to get filename for " + this._classType);
            return;
        }
        try {
            fileName = workspacePath + "/" + this._fileName;
        }
        catch (Exception e) {
            System.out.println("DBFDataStorage.serializeObject:failed to get workspace path " + e);
            return;
        }
        if (this._fileName.indexOf(".dbf") <= 0) {
            fileName = fileName + ".dbf";
        }
        this.serializeObject(dbfObj, fileName);
    }

    public void setInitialized(boolean b) {
        this._hasBeenInit = b;
    }

    public static Tag4info createTagInfo(DBFSerializable dbfObj) throws Error4usage {
        boolean hasTags = false;
        Tag4info dbfTags = new Tag4info();
        DBFMappingClass dbfMap = dbfObj.getMappingInformation();
        for (int i = 0; i < dbfMap.numObjects(); ++i) {
            DBFMapObject mapObj = dbfMap.getMapObject(i);
            if (mapObj.cbTagName == null) continue;
            dbfTags.add(mapObj.cbTagName, mapObj.cbExpression, mapObj.cbFilter, mapObj.cbUnique, mapObj.cbDescending);
            hasTags = true;
        }
        List<DBFIndexObject> indexObjs = dbfMap.getIndex();
        for (int i = 0; i < indexObjs.size(); ++i) {
            DBFIndexObject indx = indexObjs.get(i);
            dbfTags.add(indx.cbTagName, indx.cbExpression, indx.cbFilter, indx.cbUnique, indx.cbDescending);
            hasTags = true;
        }
        return hasTags ? dbfTags : null;
    }

    private void serializeObject(DBFSerializable dbfObj, String filePath) {
        DBFMapObject mapObj;
        int i;
        this._fileName = filePath;
        this._id = new Identifier(this._fileName);
        this._TAGID = dbfObj.getIDTag();
        this._TAGNAME = dbfObj.getNameTag();
        Class<?> cls = dbfObj.getClass();
        try {
            this._dbfFields = new Field4info();
            this._dbfTags = DBFDataStorage.createTagInfo(dbfObj);
            this._hasTags = this._dbfTags != null;
            this._dbfMap = dbfObj.getMappingInformation();
            if (this._dbfMap == null || this._dbfMap.numObjects() == 0) {
                throw new IllegalArgumentException("Cannot CREATE a dbf file " + this._fileName + " without mapping information");
            }
            for (i = 0; i < this._dbfMap.numObjects(); ++i) {
                mapObj = this._dbfMap.getMapObject(i);
                DBFFieldDescriptor fd = mapObj.cbFieldDescriptor;
                this._dbfFields.add(fd.getFieldName(), fd.getFieldType(), fd.getFieldSize(), fd.getNumDecimal(), mapObj.allowNull);
            }
        }
        catch (Error4usage e) {
            System.out.println("Fatal Error creating fields and TAGS for DBF file " + this._fileName + " in DBFDataStorage constructor");
            System.out.println(e.getMessage());
        }
        for (i = 0; i < this._dbfMap.numObjects(); ++i) {
            mapObj = this._dbfMap.getMapObject(i);
            Field jField = DBFMapObject.getJField(cls, mapObj.jFieldName);
            if (jField == null) continue;
            this._jName2FieldMap.put(mapObj.jFieldName, jField);
        }
        this._serializedObj = dbfObj;
    }

    @Override
    public long addNewObject(Object obj) {
        if (obj instanceof DBFSerializable) {
            DBFSerializable dbfObj = (DBFSerializable)obj;
            long id = this.nextId();
            dbfObj.setId(id);
            this.storeObject(obj);
            return id;
        }
        return -1L;
    }

    @Override
    public boolean backupData(String backupDir, DataObject obj) {
        return true;
    }

    @Override
    public Object callNativeMethod(Object obj) {
        return null;
    }

    @Override
    public Object[] getDataObjectIdList(String objClass) {
        try {
            Class<?> cls = Class.forName(objClass);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("AsciiDataStorage.getDataObjectIdList: can't find class " + objClass + " " + cfe);
            return null;
        }
        return this.getObjectList(objClass);
    }

    @Override
    public int getObjectCount() {
        return this.numberRecords();
    }

    @Override
    public Method[] getMethodsByName(String methodName) {
        return null;
    }

    @Override
    public DataStruct[] getObjectList(String objClass) {
        if (!this._hasBeenInit && !this.init()) {
            return new DataStruct[0];
        }
        DataStruct[] objs = new DataStruct[this.numberRecords()];
        int i = 0;
        try {
            this._dbfFile.select(this._TAGID);
        }
        catch (Error4usage ex) {
            LOGGER.log(Level.SEVERE, "Ussage error when loading data for " + objClass, ex);
        }
        catch (Error4unexpected ex) {
            LOGGER.log(Level.SEVERE, "Unexpected error when loading data for " + objClass, ex);
        }
        catch (Error4tagName ex) {
            LOGGER.log(Level.SEVERE, "Bad Tag " + this._TAGID + " used by dataobject " + objClass, ex);
        }
        try {
            int rc = this._dbfFile.top();
            while (rc == 0) {
                try {
                    Object dataObj = this.loadCurrentObject();
                    objs[i] = (DataStruct)dataObj;
                    ++i;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rc = this._dbfFile.skip(1);
            }
            return objs;
        }
        catch (Exception e) {
            System.out.println("ERROR: Trying to load object list");
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void lockAddAll() {
        try {
            this._dbfFile.lockAddAppend();
            this._database.lock();
        }
        catch (Error4locked | Error4unexpected | Error4usage ex) {
            Logger.getLogger(DBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unlock() {
        try {
            this._database.unlock();
        }
        catch (Error4unexpected ex) {
            Logger.getLogger(DBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int numberRecords() {
        try {
            int recCount = 0;
            int rc = this._dbfFile.top();
            while (rc == 0) {
                try {
                    ++recCount;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rc = this._dbfFile.skip(1);
            }
            return recCount;
        }
        catch (Exception e) {
            System.out.println("ERROR: Trying to count records");
            System.out.println(e.getMessage());
            return 0;
        }
    }

    private boolean checkForDbfChanges(File dbFile) {
        Vector attributeList = new Vector();
        Vector<DBFFieldDescriptor> fieldDescriptors = new Vector<DBFFieldDescriptor>();
        if (!dbFile.exists()) {
            System.out.println("File Does Not Exist");
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(dbFile);
            EndianInputStream input = new EndianInputStream(fis);
            byte db3table = input.readByte();
            if (db3table != 139) {
                // empty if block
            }
            byte year = input.readByte();
            byte month = input.readByte();
            byte day = input.readByte();
            int numRecs = input.readInt(200);
            short nbytesH = input.readShort(200);
            short nbytesR = input.readShort(200);
            input.skipBytes(20);
            int fieldLen = nbytesH - 32 - 1;
            byte[] field = new byte[fieldLen];
            int nFieldDescr = fieldLen / 32;
            for (int i = 0; i < nFieldDescr; ++i) {
                int n;
                int nread = input.read(field, 0, 32);
                for (n = 0; n < 10 && field[n] != 0; ++n) {
                }
                DBFFieldDescriptor dbfDc = new DBFFieldDescriptor();
                dbfDc.fieldName = new String(field, 0, n);
                dbfDc.fieldType = (char)field[11];
                dbfDc.fieldSize = field[16] & 0xFF;
                dbfDc.numDecimal = field[17];
                fieldDescriptors.addElement(dbfDc);
            }
            byte ibyte = input.readByte();
            if (ibyte != 13) {
                System.out.println("Error reading " + dbFile.getPath());
                System.out.println("Did not find field descriptor terminator");
                return false;
            }
            input.close();
            boolean[] dbMapAdd = new boolean[this._dbfMap.numObjects()];
            boolean[] fdMapRemove = new boolean[fieldDescriptors.size()];
            boolean[] fdMapResize = new boolean[fieldDescriptors.size()];
            Arrays.fill(dbMapAdd, false);
            Arrays.fill(fdMapRemove, false);
            if (this.matchFieldDescriptors(fieldDescriptors, dbMapAdd, fdMapRemove, fdMapResize)) {
                File oldDbfile = null;
                int index = this._id.getPath().indexOf(".dbf");
                StringBuffer strBuf = new StringBuffer(this._id.getPath());
                int cnt = 1;
                boolean fileExist = true;
                while (fileExist) {
                    strBuf.insert(index, cnt);
                    oldDbfile = new File(strBuf.toString());
                    fileExist = oldDbfile.exists();
                    ++cnt;
                    strBuf.deleteCharAt(index);
                }
                dbFile.renameTo(oldDbfile);
                DBaseIVMemoUpdate dbaseUpdate = new DBaseIVMemoUpdate(dbFile, oldDbfile, fdMapRemove, dbMapAdd, fdMapResize, this._dbfMap.getFieldDescriptorList());
                dbaseUpdate.runUpdate();
                this._serializeUpdate = true;
            }
            Object mdxFilePath = dbFile.getAbsolutePath();
            File mdxFile = new File((String)(mdxFilePath = ((String)mdxFilePath).substring(0, ((String)mdxFilePath).toLowerCase().indexOf(".dbf")) + ".mdx"));
            if (mdxFile.exists()) {
                fis = new FileInputStream((String)mdxFilePath);
                FileChannel channel = fis.getChannel();
                channel.position(28L);
                int numTags = 0;
                ByteBuffer buff = ByteBuffer.allocate(1);
                channel.read(buff);
                buff.rewind();
                numTags = buff.get();
                buff = ByteBuffer.allocate(32);
                channel.position(544L);
                ArrayList<String> existingTags = new ArrayList<String>();
                for (int i = 0; i < numTags; ++i) {
                    int bytesRead = channel.read(buff);
                    buff.rewind();
                    byte[] tagNameBytes = new byte[10];
                    buff.position(4);
                    buff.get(tagNameBytes, 0, tagNameBytes.length);
                    String tagName = new String(tagNameBytes);
                    existingTags.add(tagName.trim());
                    buff.rewind();
                }
                boolean found = false;
                List<DBFIndexObject> dbfMapTags = this._dbfMap.getIndex();
                DBFIndexObject dBFIndexObject = null;
                for (int jj = 0; jj < dbfMapTags.size(); ++jj) {
                    dBFIndexObject = dbfMapTags.get(jj);
                    for (int z = 0; z < existingTags.size(); ++z) {
                        if (!dBFIndexObject.cbTagName.equals(existingTags.get(z))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.mIndexesToAdd.add(dBFIndexObject);
                }
                channel.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading " + dbFile.getPath());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private boolean matchFieldDescriptors(Vector fdVec, boolean[] dbMapAdd, boolean[] fdMapRemove, boolean[] fdMapResize) {
        boolean found;
        int i;
        boolean error = false;
        for (i = 0; i < fdVec.size(); ++i) {
            DBFFieldDescriptor fd = (DBFFieldDescriptor)fdVec.elementAt(i);
            found = false;
            boolean resize = false;
            for (int j = 0; j < this._dbfMap.numObjects(); ++j) {
                DBFMapObject mapObject = this._dbfMap.getMapObject(j);
                DBFFieldDescriptor mapObjFd = mapObject.cbFieldDescriptor;
                if (mapObjFd.fieldName.equals(fd.fieldName) && mapObjFd.fieldType == fd.fieldType && mapObjFd.fieldSize != fd.fieldSize && fd.numDecimal == mapObjFd.numDecimal) {
                    resize = true;
                    break;
                }
                if (!mapObject.cbFieldDescriptor.equals(fd)) continue;
                found = true;
                break;
            }
            if (resize) {
                fdMapResize[i] = true;
            }
            if (found) {
                fdMapRemove[i] = false;
                continue;
            }
            fdMapRemove[i] = true;
            error = true;
            if (!resize) continue;
            fdMapRemove[i] = false;
        }
        for (i = 0; i < this._dbfMap.numObjects(); ++i) {
            DBFMapObject mapObject = this._dbfMap.getMapObject(i);
            found = false;
            for (int j = 0; j < fdVec.size(); ++j) {
                DBFFieldDescriptor fd = (DBFFieldDescriptor)fdVec.elementAt(j);
                DBFFieldDescriptor mapObjFd = mapObject.cbFieldDescriptor;
                boolean resize = false;
                if (mapObjFd.fieldName.equals(fd.fieldName) && mapObjFd.fieldType == fd.fieldType && mapObjFd.fieldSize != fd.fieldSize && fd.numDecimal == mapObjFd.numDecimal) {
                    found = true;
                    break;
                }
                if (!fd.equals(mapObject.cbFieldDescriptor)) continue;
                found = true;
                break;
            }
            if (found) {
                dbMapAdd[i] = false;
                continue;
            }
            dbMapAdd[i] = true;
            error = true;
        }
        return error;
    }

    public boolean isInitialized() {
        return this._hasBeenInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        if (this._hasBeenInit) {
            return this._hasBeenInit;
        }
        Object object = syncObject;
        synchronized (object) {
            if (this._database == null) {
                try {
                    this._database = new Code4jni();
                    this._database.accessMode((byte)0);
                }
                catch (Error4usage error4usage) {
                }
                catch (IOException e) {
                    System.out.println("Critical Error trying to open the database");
                    System.out.println(e.getMessage());
                }
            }
            if (this._database == null) {
                return false;
            }
        }
        try {
            object = this._database;
            synchronized (object) {
                File file;
                if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
                    this._id.setPath(this._id.getPath().replace('/', '\\'));
                }
                if ((file = new File(this._id.getPath())).exists()) {
                    if (this._checkForDifferences) {
                        this.checkForDbfChanges(file);
                    }
                    if (this.mIndexesToAdd.size() > 0) {
                        byte accessmode = this._database.accessMode();
                        this._database.accessMode((byte)1);
                        this._dbfFile = new Data4jni(this._database, this._id.getPath());
                        try {
                            this._dbfFile.pack();
                            this._dbfFile.memoCompress();
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                        Object mdxFilePath = this._id.getPath();
                        mdxFilePath = ((String)mdxFilePath).substring(0, ((String)mdxFilePath).toLowerCase().indexOf(".dbf")) + ".mdx";
                        String mdxFilePathTemp = ((String)mdxFilePath).substring(0, ((String)mdxFilePath).toLowerCase().indexOf(".mdx")) + "temp.mdx";
                        Tag4info createTagInfo = DBFDataStorage.createTagInfo(this._serializedObj);
                        try {
                            boolean done = this._database.safety(false);
                            this._dbfFile.createIndex(mdxFilePathTemp, createTagInfo);
                            this._dbfFile.close();
                            File oldMdxFile = new File((String)mdxFilePath);
                            oldMdxFile.delete();
                            new File(mdxFilePathTemp).renameTo(oldMdxFile);
                            RandomAccessFile randomAccessFile = new RandomAccessFile(oldMdxFile, "rw");
                            FileChannel fc = randomAccessFile.getChannel();
                            ByteBuffer allocate = ByteBuffer.allocate(1);
                            allocate.put((byte)1);
                            allocate.rewind();
                            fc.position(24L).write(allocate);
                            fc.close();
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, null, ex);
                        }
                        this._database.accessMode(accessmode);
                        this._database.safety(true);
                    }
                    this._dbfFile = new Data4jni(this._database, this._id.getPath());
                } else {
                    this._dbfFile = new Data4jni(this._database);
                    File jfile = new File(this._id.getPath());
                    File parent = jfile.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        System.out.println(" <DBFDataStorage.openNewFile> : Cannot create parent directory structure.");
                        return false;
                    }
                    if (this._hasTags) {
                        this._dbfFile.create(this._id.getPath(), this._dbfFields, this._dbfTags);
                    } else {
                        this._dbfFile.create(this._id.getPath(), this._dbfFields);
                    }
                }
                if (this._serializeUpdate) {
                    try {
                        this._dbfFile.pack();
                        this._dbfFile.memoCompress();
                        this._dbfFile.reindex();
                        this._dbfFile.top();
                    }
                    catch (Exception e) {
                        System.out.println("ERROR: trying to reindex after a serialization update");
                        return false;
                    }
                    this._serializeUpdate = false;
                }
                this.mapBaseFields();
                this._dbfFile.bottom();
                if (this._dbfFile.recCount() == 0) {
                    this._nextId = 1L;
                    this._dbfFile.top();
                } else {
                    Object ID_COL = this._field4List.get(0);
                    this._nextId = ID_COL instanceof Field4double ? ((Field4double)ID_COL).get().longValue() + 1L : (long)this._dbfFile.recCount();
                }
                this._currentRow = this._dbfFile.recNo();
                int ID_COL = this._dbfFile.recCount();
            }
        }
        catch (Error4file e4f) {
            short error = this._database.getLastError();
            String msg = "Error trying to create DBF file in DBFDataStorage.init()-> " + this._id.getPath() + ".\n Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error);
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, msg, e4f);
            System.out.println(e4f.getMessage());
            return false;
        }
        catch (Error4usage e4u) {
            short error = this._database.getLastError();
            System.out.println("Incorrect Codebase Method called in DBFDataStorage.init(). Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error));
            System.out.println(e4u.getMessage());
            return false;
        }
        catch (RemoteException re) {
            System.out.println("Remote Excetion in DBFDataStorage.init()");
            System.out.println(re.getMessage());
            return false;
        }
        catch (Error4unexpected e4ue) {
            short error = this._database.getLastError();
            String msg = "Unexpected Error in DBFDataStorage.init() - " + this._id.getPath() + ".\nError Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error);
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, msg, e4ue);
            return false;
        }
        catch (Error4message e4m) {
            short error = this._database.getLastError();
            System.out.println("Misunderstood or incorrect Message passed in DBFDataStorage.init(). Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error));
            System.out.println(e4m.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.out.println("IO Excetion in DBFDataStorage.init()");
            System.out.println(ioe.getMessage());
            return false;
        }
        catch (Error4locked e4lock) {
            short error = this._database.getLastError();
            System.out.println("Error 4 Lock occurred in DBFDataStorage.init(). Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error));
            System.out.println(e4lock.getMessage());
            return false;
        }
        this._hasBeenInit = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapBaseFields() {
        this._field4List.clear();
        if (this._dbfMap == null || this._dbfMap.numObjects() == 0) {
            return;
        }
        try {
            Code4jni code4jni = this._database;
            synchronized (code4jni) {
                Class<?> recordClass = Class.forName(this._classType);
                for (int i = 0; i < this._dbfMap.numObjects(); ++i) {
                    Object fieldPointer;
                    block10: {
                        DBFMapObject dbfMapObj = this._dbfMap.getMapObject(i);
                        this._field4ConstParam[0] = Class.forName("codebase.Data4");
                        this._field4ConstParam[1] = Class.forName("java.lang.String");
                        Class<?> field4Class = this.getDeclaredFieldClass(dbfMapObj.cbFieldDescriptor.getFieldType());
                        Field f = DBFMapObject.getJField(recordClass, dbfMapObj.jFieldName);
                        if (f != null && f.getAnnotation(Type.class) != null) {
                            field4Class = Class.forName("codebase.Field4byteArray");
                        }
                        Constructor field4Constructor = field4Class.getDeclaredConstructor(this._field4ConstParam);
                        fieldPointer = null;
                        try {
                            fieldPointer = field4Constructor.newInstance(this._dbfFile, dbfMapObj.cbFieldDescriptor.getFieldName());
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block10;
                            System.out.println("Warning: mapping DBF Column - " + this._dbfFile + " -> " + dbfMapObj.cbFieldDescriptor.getFieldName());
                        }
                    }
                    this._field4List.add(fieldPointer);
                }
                this._deleteFlag = new Field4deleteFlag((Data4)this._dbfFile);
            }
        }
        catch (Exception e) {
            System.out.println("Error Mapping ID field in DBFDataStorage");
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
        }
    }

    private Class getDeclaredFieldClass(char ft) {
        try {
            switch (ft) {
                case 'B': {
                    return Class.forName("codebase.Field4byteArray");
                }
                case 'C': {
                    return Class.forName("codebase.Field4stringBuffer");
                }
                case 'D': {
                    return Class.forName("codebase.Field4date");
                }
                case 'F': {
                    return Class.forName("codebase.Field4double");
                }
                case 'G': {
                    return Class.forName("codebase.Field4stringBuffer");
                }
                case 'L': {
                    return Class.forName("codebase.Field4boolean");
                }
                case 'M': {
                    return Class.forName("codebase.Field4stringBuffer");
                }
                case 'N': {
                    return Class.forName("codebase.Field4double");
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: getting declared field 4 class");
            System.out.println(e.getMessage());
        }
        return null;
    }

    @Override
    public Object loadObject(long id, String objClass) {
        if (objClass == null) {
            return null;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        Class<?> ICls = null;
        Class<?> cls = null;
        try {
            ICls = Class.forName("hec.io.DBFSerializable");
            cls = Class.forName(objClass);
            if (!ICls.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(objClass + " is not instance of hec.io.DBFSerializable");
            }
            DBFSerializable dbfObj = (DBFSerializable)cls.newInstance();
            return this.loadObject(id, dbfObj);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Error finding class for object " + objClass + " Error " + cnfe.toString());
            throw new DeserializeObjectException("Error finding class for object " + objClass + " Error " + cnfe.toString());
        }
        catch (InstantiationException ie) {
            System.out.println("Error creating object " + cls.getName() + " Error " + ie.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            System.out.println("Error creating object " + cls.getName() + " Error " + iae.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + iae.toString());
        }
    }

    public Object loadObject(long id, DBFSerializable dbfObj) {
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        if (Const.isUndefined(id)) {
            return null;
        }
        this._TAGID = dbfObj.getIDTag();
        if (this.findObject(this._TAGID, Long.toString(id))) {
            this.assignObjectValues(dbfObj);
            return dbfObj;
        }
        return null;
    }

    public <T> DBFIterator<T> loadObjects(String expression, Class<T> clazz) {
        try {
            IteratorImpl<T> iteratorImpl = new IteratorImpl<T>(this._dbfFile, expression, clazz);
            return iteratorImpl;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
            return new DBFIterator(){

                @Override
                public int getRecordCount() {
                    return 0;
                }

                @Override
                public void close() {
                }

                @Override
                public boolean isClosed() {
                    return true;
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    protected void assignObjectValues(DBFSerializable dbfObj) {
        if (dbfObj == null) {
            return;
        }
        Field4 fld4 = null;
        for (int i = 0; i < this._dbfMap.numObjects(); ++i) {
            Object data;
            DBFMapObject mapObject = this._dbfMap.getMapObject(i);
            String jFldName = mapObject.jFieldName;
            Field jfld = this._jName2FieldMap.get(jFldName);
            if (jfld == null || (fld4 = (Field4)this._field4List.get(i)) == null || (data = this.instantiateDataObject(fld4, jfld)) == null) continue;
            DBFMapObject.setFieldObject(dbfObj, jFldName, jfld, data);
        }
    }

    private boolean isUndefined(Double d) {
        return DBF_UNDEF_DOUBLE.equals(d) || DBF_UNDEF_DOUBLE2.equals(d);
    }

    private boolean isUndefined(Float d) {
        return DBF_UNDEF_FLOAT.equals(d) || DBF_UNDEF_FLOAT2.equals(d);
    }

    private boolean isUndefined(Integer d) {
        return DBF_UNDEF_INT.equals(d) || DBF_UNDEF_INT2.equals(d);
    }

    private boolean isUndefined(Long d) {
        return DBF_UNDEF_LONG.equals(d) || DBF_UNDEF_LONG2.equals(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateDataObject(Field4 data, Field fieldObj) {
        Class<?> classTypeObj = fieldObj.getType();
        data.getClass();
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                Type customType = fieldObj.getAnnotation(Type.class);
                if (customType != null) {
                    String customTypeStr = customType.type();
                    Parameter[] parameters = customType.parameters();
                    Properties properties = new Properties();
                    for (int pIter = 0; pIter < parameters.length; ++pIter) {
                        Parameter p = parameters[pIter];
                        properties.put(p.name(), p.value());
                    }
                    UserType type = (UserType)Class.forName(customTypeStr).newInstance();
                    type.setParameterValues(properties);
                    return type.nullSafeGet(new ByteArrayInputStream(((Field4byteArray)data).get()));
                }
                if (classTypeObj.isPrimitive()) {
                    if (classTypeObj == Long.TYPE) {
                        try {
                            Double dbl = ((Field4double)data).get();
                            if (this.isUndefined(dbl)) {
                                return this.UNDEF_LONG;
                            }
                            return dbl.longValue();
                        }
                        catch (NumberFormatException e) {
                            return this.UNDEF_LONG;
                        }
                    }
                    if (classTypeObj == Integer.TYPE) {
                        try {
                            Double dbl = ((Field4double)data).get();
                            if (this.isUndefined(dbl)) {
                                return this.UNDEF_INT;
                            }
                            return dbl.intValue();
                        }
                        catch (NumberFormatException e) {
                            return this.UNDEF_INT;
                        }
                    }
                    if (classTypeObj == Double.TYPE) {
                        try {
                            Double dbl = ((Field4double)data).get();
                            if (this.isUndefined(dbl)) {
                                return this.UNDEF_DOUBLE;
                            }
                            return dbl;
                        }
                        catch (NumberFormatException e) {
                            return this.UNDEF_DOUBLE;
                        }
                    }
                    if (classTypeObj == Float.TYPE) {
                        try {
                            Double dbl = ((Field4double)data).get();
                            if (this.isUndefined(dbl)) {
                                return this.UNDEF_FLOAT;
                            }
                            return Float.valueOf(dbl.floatValue());
                        }
                        catch (NumberFormatException e) {
                            return this.UNDEF_FLOAT;
                        }
                    }
                    if (classTypeObj == Boolean.TYPE) {
                        return new Boolean(((Field4boolean)data).get());
                    }
                    if (classTypeObj != Byte.TYPE && classTypeObj != Short.TYPE && classTypeObj == Character.TYPE) {
                        StringBuffer st = ((Field4stringBuffer)data).get();
                        Character c2 = st.length() == 0 ? new Character('z') : new Character(st.charAt(0));
                        return c2;
                    }
                } else {
                    if (classTypeObj == String.class) {
                        String retval = ((Field4stringBuffer)data).get().toString().trim();
                        if (0 == retval.length()) {
                            retval = "";
                        }
                        return retval;
                    }
                    if (classTypeObj == Date.class) {
                        return new Date(((Field4date)data).get().getTime());
                    }
                    if (classTypeObj.isArray()) {
                        return this.readArray(classTypeObj, data);
                    }
                    if (!Class.forName("java.util.Collection").isAssignableFrom(classTypeObj) && classTypeObj.isEnum()) {
                        ?[] enumConstants = classTypeObj.getEnumConstants();
                        String enumNameObj = ((Field4stringBuffer)data).get().toString().trim();
                        for (Object enumObj : enumConstants) {
                            if (!enumObj.toString().equalsIgnoreCase(enumNameObj.toString())) continue;
                            return enumObj;
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: An error occurred instantiating a data object from the database for Object - " + this._serializedObj.getClass().getName());
                System.err.println(e.getMessage());
                return null;
            }
        }
        System.err.println("WARNING: Data Object " + classTypeObj.getName() + " not recognized in instantiateDataObject()");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readArray(Class classObj, Field4 fld4) {
        if (!(fld4 instanceof Field4stringBuffer)) {
            throw new IllegalArgumentException("ERROR: Cannont read Array from a non Field4stringBuffer");
        }
        StringBuffer strBuf = null;
        try {
            Code4jni code4jni = this._database;
            synchronized (code4jni) {
                strBuf = ((Field4stringBuffer)fld4).get();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: Error getting array from data storage. Returning NULL");
            System.err.println(e.getMessage());
            return null;
        }
        if (strBuf.length() == 0) {
            return Array.newInstance(classObj.getComponentType(), 0);
        }
        strBuf.setLength(strBuf.length() - 1);
        StringTokenizer strTok = new StringTokenizer(strBuf.toString(), System.getProperty("line.separator"), false);
        int length = strTok.countTokens();
        Object arrayObj = null;
        try {
            arrayObj = Array.newInstance(classObj.getComponentType(), length);
        }
        catch (NegativeArraySizeException e) {
            System.out.println("readArrayOBJECT() negative array error for " + classObj.getName() + " error " + e.toString());
            return null;
        }
        catch (IllegalArgumentException e) {
            System.out.println("readArrayOBJECT() IllegalArgumentException error for " + classObj.getName() + " error " + e.toString());
            return null;
        }
        if (classObj.getComponentType().isPrimitive()) {
            this.readArrayElements(strTok, arrayObj, classObj.getComponentType().getName());
        } else if (classObj.getComponentType().isArray()) {
            this.readMultiDimensionalArray(strTok, arrayObj);
        } else {
            System.out.println("ERROR: DBFStorage Does not Support Reading Object Arrays");
        }
        return arrayObj;
    }

    private void readMultiDimensionalArray(StringTokenizer strTok, Object arrayObj) {
        Class<?> arrayClass = arrayObj.getClass();
        Class<?> type = arrayClass.getComponentType().getComponentType();
        int pos = 0;
        Object arrayObj2 = null;
        while (strTok.hasMoreElements()) {
            if (type.isArray()) continue;
            StringTokenizer strTok2 = new StringTokenizer(strTok.nextToken(), TAB_CHAR);
            arrayObj2 = Array.newInstance(type, strTok2.countTokens());
            this.readArrayElements(strTok2, arrayObj2, type.getName());
            Array.set(arrayObj, pos, arrayObj2);
            ++pos;
        }
    }

    private void readArrayElements(StringTokenizer strTok, Object arrayObj, String type) {
        int pos = 0;
        while (strTok.hasMoreElements()) {
            Object elem = this.getArrayElement(type, strTok.nextToken());
            Array.set(arrayObj, pos, elem);
            ++pos;
        }
    }

    private Object getArrayElement(String primType, String value) {
        try {
            if (primType.equals("byte")) {
                return Byte.valueOf(value.trim());
            }
            if (primType.equals("char")) {
                return Character.valueOf(value.charAt(0));
            }
            if (primType.equals("double")) {
                Double d = Double.valueOf(value.trim());
                if (this.isUndefined(d)) {
                    d = this.UNDEF_DOUBLE;
                }
                return d;
            }
            if (primType.equals("float")) {
                Float f = new Float(value.trim());
                if (this.isUndefined(f)) {
                    f = this.UNDEF_FLOAT;
                }
                return f;
            }
            if (primType.equals("int")) {
                Integer i = new Integer(value.trim());
                if (this.isUndefined(i)) {
                    i = this.UNDEF_INT;
                }
                return i;
            }
            if (primType.equals("long")) {
                Long l = Long.valueOf(value.trim());
                if (this.isUndefined(l)) {
                    l = this.UNDEF_LONG;
                }
                return l;
            }
            if (primType.equals("short")) {
                return Short.valueOf(value.trim());
            }
            if (primType.equals("boolean")) {
                return Boolean.valueOf(value.trim());
            }
            System.out.println("ERROR: Undefined primitve type in getArrayElement() " + primType);
        }
        catch (NumberFormatException e) {
            if (primType.equals("double")) {
                if (value.equals("-Infinity")) {
                    return this.NEG_INFIN_D;
                }
                if (value.equals("Infinity")) {
                    return this.POS_INFIN_D;
                }
                if (value.equals("NaN")) {
                    return this.NAN_D;
                }
                return null;
            }
            if (primType.equals("float")) {
                if (value.equals("-Infinity")) {
                    return this.NEG_INFIN_F;
                }
                if (value.equals("Infinity")) {
                    return this.POS_INFIN_F;
                }
                if (value.equals("NaN")) {
                    return this.NAN_F;
                }
                return null;
            }
        }
        catch (Exception e) {
            System.out.println("getArrayElement: error creating object for type " + primType + " value " + value);
            System.out.println("\terror " + e);
        }
        return null;
    }

    @Override
    public Object loadObject(String name, String objClass) {
        if (objClass == null || name == null) {
            return null;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        DBFSerializable dbfObj = null;
        Class<?> ICls = null;
        Class<?> cls = null;
        try {
            ICls = Class.forName("hec.io.DBFSerializable");
            cls = Class.forName(objClass);
            if (!ICls.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(objClass + " is not instance of hec.io.DBFSerializable");
            }
            dbfObj = (DBFSerializable)cls.newInstance();
            this._TAGNAME = dbfObj.getNameTag();
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Error finding class for object " + objClass + " Error " + cnfe.toString());
            throw new DeserializeObjectException("Error finding class for object " + objClass + " Error " + cnfe.toString());
        }
        catch (InstantiationException ie) {
            System.out.println("Error creating object " + cls.getName() + " Error " + ie.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            System.out.println("Error creating object " + cls.getName() + " Error " + iae.toString());
            throw new DeserializeObjectException("Error creating object " + cls.getName() + " Error " + iae.toString());
        }
        if (this.findObject(this._TAGNAME, name.toUpperCase())) {
            this.assignObjectValues(dbfObj);
            return dbfObj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findObject(String tag, String key) {
        if (this._dbfFile == null) {
            return false;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        try {
            Code4jni code4jni = this._database;
            synchronized (code4jni) {
                if (this._hasTags) {
                    if (this._dbfFile == null) {
                        return false;
                    }
                    this._dbfFile.select(tag);
                }
                if (this._dbfFile.seek(key) != 0) {
                    return false;
                }
                this._currentRow = this._dbfFile.recNo();
            }
        }
        catch (Error4 e) {
            short error = this._database.getLastError();
            System.out.println("Exception when seeking for record in FindObject(tag,key). Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error));
            System.out.println("Filename - " + this._id.getPath());
            System.out.println("Tag Name - " + tag + " Key - " + key);
            System.out.println(e.getMessage());
            return false;
        }
        catch (Exception e) {
            System.out.println("Non-Codebase Exception in FindObject(tag,key)");
            System.out.println("Filename - " + this._id.getPath());
            System.out.println("Tag Name - " + tag + " Key - " + key);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeObject(long[] objIds, String objClass) {
        if (objIds == null) {
            return false;
        }
        boolean success = true;
        for (int i = 0; i < objIds.length; ++i) {
            success &= this.removeObject(objIds[i], objClass);
        }
        try {
            Code4jni i = this._database;
            synchronized (i) {
                this._dbfFile.pack();
                this._dbfFile.memoCompress();
            }
        }
        catch (Exception e) {
            System.out.println("There was an error trying to compress the database");
            System.out.println(e.getMessage());
        }
        return success;
    }

    public void pack() {
        if (!this._hasBeenInit && !this.init()) {
            return;
        }
        try {
            this._dbfFile.pack();
        }
        catch (Error4usage ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4unexpected ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4locked ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4unique ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void memoCompress() {
        if (!this._hasBeenInit && !this.init()) {
            return;
        }
        try {
            this._dbfFile.memoCompress();
        }
        catch (Error4usage ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4locked ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4unexpected ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeObject(long objId, String objClass) {
        if (Const.isUndefined(objId)) {
            return false;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        if (!this.findObject(this._TAGID, Long.toString(objId))) {
            return false;
        }
        try {
            Code4jni code4jni = this._database;
            synchronized (code4jni) {
                this._deleteFlag.set(true);
                this._dbfFile.update();
            }
        }
        catch (Exception e) {
            System.out.println("There was an error trying to Delete record ID=" + objId);
            System.out.println(e.getMessage());
            return false;
        }
        this._recordDeleted = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save() {
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        try {
            Code4jni code4jni = this._database;
            synchronized (code4jni) {
                this._dbfFile.update();
            }
        }
        catch (Exception e) {
            short error = this._database.getLastError();
            System.out.println("There was an error trying to Update the current record in " + this._id.getPath() + ". Error Code (" + error + ") " + CodebaseErrorTable.getErrorCodeString(error));
            return false;
        }
        return true;
    }

    public boolean doesExist(DBFSerializable dbfObj) {
        String ID_TAG = dbfObj.getIDTag();
        long id = dbfObj.getId();
        boolean objExist = false;
        objExist = this.findObject(ID_TAG, Long.toString(id));
        return objExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(Object obj) {
        if (!(obj instanceof DBFSerializable)) {
            return false;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        DBFSerializable dbfObj = (DBFSerializable)obj;
        boolean objExist = this.doesExist(dbfObj);
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                this.serializeData(dbfObj);
                Code4jni code4jni2 = this._database;
                synchronized (code4jni2) {
                    if (objExist) {
                        this._dbfFile.update();
                    } else {
                        this._dbfFile.append();
                    }
                }
            }
            catch (Error4unique e4unique) {
                System.err.println("Unique key constraint is violated in DBFDataStorage.storeObject()");
                System.err.println(e4unique.getMessage());
                System.err.println(obj);
                System.err.println(((DBFSerializable)obj).getId());
                e4unique.printStackTrace();
                return false;
            }
            catch (Exception e) {
                System.err.println("Fatal Error Saving Data");
                System.err.println(obj);
                System.err.println(e.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendData(Object obj) {
        if (!(obj instanceof DBFSerializable)) {
            return false;
        }
        if (!this._hasBeenInit && !this.init()) {
            return false;
        }
        DBFSerializable dbfObj = (DBFSerializable)obj;
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                this.serializeData(dbfObj);
                Code4jni code4jni2 = this._database;
                synchronized (code4jni2) {
                    this._dbfFile.append();
                }
            }
            catch (Error4unique e4unique) {
                System.err.println("Unique key constraint is violated in DBFDataStorage.storeObject()");
                System.err.println(e4unique.getMessage());
                System.err.println(obj);
                System.err.println(((DBFSerializable)obj).getId());
                e4unique.printStackTrace();
                return false;
            }
            catch (Exception e) {
                System.err.println("Fatal Error Saving Data");
                System.err.println(obj);
                System.err.println(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void serializeData(DBFSerializable dbfObj) {
        Class<?> cls = dbfObj.getClass();
        Object jFldObj = null;
        Field4 fld4 = null;
        for (int i = 0; i < this._dbfMap.numObjects(); ++i) {
            if (this._dbfMap.getMapObject((int)i).readOnly) continue;
            String jFldName = this._dbfMap.getMapObject((int)i).jFieldName;
            Field jfld = DBFMapObject.getJField(cls, jFldName);
            if (jfld == null) {
                if (!DEBUG) continue;
                System.out.println("Possible error, field " + jFldName + " does not have a corresponding field in " + dbfObj.toString());
                continue;
            }
            jFldObj = jFldName.indexOf(46) == -1 ? dbfObj.getFieldObject(jfld) : DBFMapObject.getFieldObject(dbfObj, jFldName, jfld);
            if (jFldObj == null) continue;
            Type customType = jfld.getAnnotation(Type.class);
            Class<?> c2 = null;
            try {
                c2 = jFldObj.getClass();
                fld4 = (Field4)this._field4List.get(i);
                if (fld4 == null) continue;
                if (customType != null) {
                    String customTypeStr = customType.type();
                    Parameter[] parameters = customType.parameters();
                    Properties properties = new Properties();
                    for (int pIter = 0; pIter < parameters.length; ++pIter) {
                        Parameter p = parameters[pIter];
                        properties.put(p.name(), p.value());
                    }
                    UserType type = (UserType)Class.forName(customTypeStr).newInstance();
                    type.setParameterValues(properties);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    type.nullSafeSet(stream, jFldObj);
                    ((Field4byteArray)fld4).set(stream.toByteArray());
                    continue;
                }
                if (c2.isArray()) {
                    StringBuffer temp = this.writeArray(jFldObj, NEW_LINE);
                    ((Field4stringBuffer)fld4).set(temp);
                    continue;
                }
                if (Class.forName("java.util.Collection").isAssignableFrom(c2)) {
                    this.writeCollection((Collection)jFldObj);
                    continue;
                }
                if (fld4 instanceof Field4stringBuffer) {
                    ((Field4stringBuffer)fld4).set(new StringBuffer(jFldObj.toString()));
                    continue;
                }
                if (fld4 instanceof Field4double) {
                    Double dbl = null;
                    try {
                        dbl = jFldObj instanceof Long && Const.isUndefined((Long)jFldObj) ? new Double(DBF_UNDEF_LONG.doubleValue()) : (jFldObj instanceof Integer && Const.isUndefined((Integer)jFldObj) ? new Double(DBF_UNDEF_INT.doubleValue()) : (jFldObj instanceof Float && Const.isUndefined(((Float)jFldObj).floatValue()) ? new Double(DBF_UNDEF_FLOAT.doubleValue()) : (jFldObj instanceof Double && (Const.isUndefined((Double)jFldObj) || RMAConst.isUndefinedValue((Double)jFldObj)) ? DBF_UNDEF_DOUBLE : (jFldObj instanceof Number ? new Double(((Number)jFldObj).doubleValue()) : new Double(jFldObj.toString())))));
                        ((Field4double)fld4).set(dbl);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (fld4 instanceof Field4boolean) {
                    Boolean bool = null;
                    bool = jFldObj instanceof Boolean ? (Boolean)jFldObj : Boolean.valueOf(jFldObj.toString());
                    ((Field4boolean)fld4).set(bool);
                    continue;
                }
                if (!(fld4 instanceof Field4date)) continue;
                Date date = null;
                date = jFldObj instanceof Date ? (Date)jFldObj : new Date(jFldObj.toString());
                ((Field4date)fld4).set(date);
                continue;
            }
            catch (Exception e) {
                if (fld4 != null) {
                    System.err.println("ERROR: Error Setting the Database Field: " + c2.getName() + " in field " + fld4.name());
                    e.printStackTrace();
                } else {
                    System.err.println("ERROR: Error Setting the Database Field: " + c2.getName() + " field is null.");
                }
                System.err.println(e.getMessage());
            }
        }
    }

    public void writeCollection(Collection c2) {
    }

    private StringBuffer writeMultiDemsionalArray(Object jFldObj) {
        if (jFldObj == null) {
            System.err.println("ERROR: writeMultiDemsionalArray called with NULL data - " + jFldObj.toString());
            System.err.println("ERROR: This data is will not be saved");
            return null;
        }
        Class<?> objClass = jFldObj.getClass();
        if (!objClass.isArray()) {
            System.err.println("ERROR: writeMultiDemsionalArray called with non Array - " + jFldObj.toString());
            System.err.println("ERROR: This data is will not be saved");
            return null;
        }
        Object[] array = (Object[])jFldObj;
        Class<?> type = objClass.getComponentType();
        if (type == null || !type.isArray()) {
            System.err.println("ERROR: writeMultiDemsionalArray called with non MultiDemnsional Array - " + jFldObj.toString());
            System.err.println("ERROR: This data is will not be saved");
            return null;
        }
        StringBuffer data = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            StringBuffer temp;
            if (array[i] == null || (temp = this.writeArray(array[i], TAB_CHAR)) == null) continue;
            data.append(temp);
        }
        return data;
    }

    private StringBuffer writeArray(Object jFldObj, String delim) {
        Class<?> objClass = jFldObj.getClass();
        if (!objClass.isArray()) {
            System.err.println("ERROR: writeArray called with non Array - " + jFldObj.toString());
            System.err.println("ERROR: This data is will not be saved");
            return null;
        }
        StringBuffer outline = new StringBuffer();
        outline.setLength(0);
        Class<?> c2 = jFldObj.getClass();
        Class<?> type = c2.getComponentType();
        int i = 0;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                for (int d : (int[])jFldObj) {
                    if (Const.isUndefined(d)) {
                        d = DBF_UNDEF_DOUBLE.intValue();
                    }
                    outline.append(d + delim);
                }
            } else if (type == Byte.TYPE) {
                byte[] array = (byte[])jFldObj;
                int length = array.length;
                for (i = 0; i < length; ++i) {
                    outline.append(array[i] + delim);
                }
            } else if (type == Float.TYPE) {
                for (float f : (float[])jFldObj) {
                    if (Const.isUndefined(f)) {
                        f = DBF_UNDEF_DOUBLE.floatValue();
                    }
                    outline.append(f + delim);
                }
            } else if (type == Double.TYPE) {
                for (double d : (double[])jFldObj) {
                    if (Const.isUndefined(d)) {
                        d = DBF_UNDEF_DOUBLE;
                    }
                    outline.append(d + delim);
                }
            } else if (type == Long.TYPE) {
                for (long l : (long[])jFldObj) {
                    if (Const.isUndefined(l)) {
                        l = DBF_UNDEF_DOUBLE.longValue();
                    }
                    outline.append(l + delim);
                }
            } else if (type == Short.TYPE) {
                short[] array = (short[])jFldObj;
                int length = array.length;
                for (i = 0; i < length; ++i) {
                    outline.append(array[i] + delim);
                }
            } else if (type == Character.TYPE) {
                char[] array = (char[])jFldObj;
                int length = array.length;
                for (i = 0; i < length; ++i) {
                    outline.append(array[i] + delim);
                }
            } else if (type == Boolean.TYPE) {
                boolean[] array = (boolean[])jFldObj;
                int length = array.length;
                for (i = 0; i < length; ++i) {
                    outline.append(array[i] + delim);
                }
            }
            if (outline.length() != 0) {
                outline.setLength(outline.length() - 1);
            }
        } else {
            if (type.isArray()) {
                return this.writeMultiDemsionalArray(jFldObj);
            }
            System.err.println("WARNING: Object Arrays not supported");
            return null;
        }
        outline.append(NEW_LINE);
        return outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workspaceClosing() {
        if (this._database == null) {
            return;
        }
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            if (this._dbfFile == null) {
                return;
            }
            try {
                if (this._recordDeleted) {
                    System.out.println((String)("PACKING AND CLOSING DBF FILE" + this._id != null ? " - " + this._id.getPath() : ""));
                    this._dbfFile.pack();
                    this._dbfFile.memoCompress();
                    this._recordDeleted = false;
                } else {
                    System.out.println((String)("CLOSING DBF FILE" + this._id != null ? " - " + this._id.getPath() : ""));
                }
                try {
                    this._dbfFile.close();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                this._dbfFile = null;
                this._hasBeenInit = false;
            }
            catch (Error4unexpected e4unex) {
                System.err.println("Unexcpected Error encountered when closing the database:" + e4unex.getMessage());
                String error = _errorCodeFormat.format(new String[]{Short.toString(this._database.getLastError()), CodebaseErrorTable.getErrorCodeString(this._database.getLastError())});
                System.err.println(error);
                System.err.println("DBF File: " + this._id != null ? this._id.getPath() : "DBF FILE UNDEFINED");
                e4unex.printStackTrace(System.err);
            }
            catch (Error4usage e4usage) {
                System.err.println("Usage error occurred when closing the database file:" + e4usage.getMessage());
                String error = _errorCodeFormat.format(new String[]{Short.toString(this._database.getLastError()), CodebaseErrorTable.getErrorCodeString(this._database.getLastError())});
                System.err.println(error);
                System.err.println("DBF File: " + this._id != null ? this._id.getPath() : "DBF FILE UNDEFINED");
                e4usage.printStackTrace(System.err);
            }
            catch (Error4locked e4lock) {
                System.err.println("WARNING: DBF File was locked and could do a pack when workspace closed" + e4lock.getMessage());
                String error = _errorCodeFormat.format(new String[]{Short.toString(this._database.getLastError()), CodebaseErrorTable.getErrorCodeString(this._database.getLastError())});
                System.err.println(error);
                System.err.println("DBF File: " + this._id != null ? this._id.getPath() : "DBF FILE UNDEFINED");
                e4lock.printStackTrace(System.err);
            }
            catch (Error4unique e4unique) {
                System.err.println("ERROR: Unique Error occured when packing the DBF File on workspace close" + e4unique.getMessage());
                String error = _errorCodeFormat.format(new String[]{Short.toString(this._database.getLastError()), CodebaseErrorTable.getErrorCodeString(this._database.getLastError())});
                System.err.println(error);
                System.err.println("DBF File: " + this._id != null ? this._id.getPath() : "DBF FILE UNDEFINED");
                e4unique.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextId() {
        Object object = this._idLock;
        synchronized (object) {
            long currentId = this._nextId++;
            this._idLock.notifyAll();
            return currentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextRecord() {
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                if (this._currentRow + 1 > this._dbfFile.recCount()) {
                    return false;
                }
                this._dbfFile.go(++this._currentRow);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error trying to go to the next row in the database");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previousRecord() {
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                if (this._currentRow - 1 < 1) {
                    return false;
                }
                this._dbfFile.go(--this._currentRow);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error trying to go to the previous row in the database");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadCurrentObject() {
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                if (!this._hasBeenInit && !this.init()) {
                    return false;
                }
                Class<?> cls = this._serializedObj.getClass();
                Object obj = cls.newInstance();
                this.assignObjectValues((DBFSerializable)obj);
                return obj;
            }
            catch (Exception e) {
                System.err.println("ERROR: Error instantiating new Serialized Object to load");
                System.err.println(e.getMessage());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean top() {
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                this._dbfFile.top();
                this._currentRow = this._dbfFile.recNo();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end() {
        Code4jni code4jni = this._database;
        synchronized (code4jni) {
            try {
                this._dbfFile.bottom();
                this._currentRow = this._dbfFile.recNo();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    @Override
    public String getFilename() {
        return this._fileName;
    }

    @Override
    public void compress() {
        try {
            this._dbfFile.pack();
            this._dbfFile.memoCompress();
        }
        catch (Error4usage ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4unexpected ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4locked ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (Error4unique ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void reindex() throws IOException {
        try {
            this._dbfFile.reindex();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new IOException(ex.getLocalizedMessage(), ex);
        }
    }

    private class IteratorImpl<T>
    implements DBFIterator<T> {
        Data4jni mDb = null;
        int mCurrentPos = -1;
        int mCurrentStatus = 0;
        Class mClazz = null;
        Relate4jni mRelate4;
        boolean mIteratorOpen = false;
        int mRecordCount = 0;

        public IteratorImpl(Data4jni db, String expression, Class<T> clazz) throws Error4usage, Error4usage, Error4unexpected, Error4tagName {
            this.mDb = db;
            db.select(null);
            this.mClazz = clazz;
            this.mRelate4 = new Relate4jni(this.mDb);
            if (expression != null && !((String)expression).isEmpty()) {
                expression = "(" + (String)expression + ") .AND. .NOT. DELETED()";
                this.mRelate4.querySet((String)expression);
            }
            this.mIteratorOpen = true;
            try {
                this.mRelate4.top();
                this.mRecordCount = 0;
                short rc = this.mRelate4.top();
                while (rc == 0) {
                    try {
                        ++this.mRecordCount;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rc = this.mRelate4.skip(1);
                }
                this.mRelate4.top();
            }
            catch (Error4relateMatch ex) {
                Logger.getLogger(DBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void close() {
            if (!this.mIteratorOpen) {
                return;
            }
            this.mRelate4.free();
            this.mIteratorOpen = false;
        }

        @Override
        public boolean isClosed() {
            return this.mIteratorOpen;
        }

        @Override
        public int getRecordCount() {
            return this.mRecordCount;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            try {
                if (!this.mIteratorOpen) {
                    return false;
                }
                this.mCurrentStatus = this.mCurrentPos == -1 ? (int)this.mRelate4.top() : (int)this.mRelate4.skip(1);
                this.mCurrentPos = this.mDb.recNo();
            }
            catch (Error4relateMatch ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return false;
            }
            catch (Error4usage ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return false;
            }
            boolean bl = hasNext = this.mCurrentStatus == 0;
            if (!hasNext) {
                // empty if block
            }
            return hasNext;
        }

        public T next() {
            Object t;
            if (this.mCurrentPos == -1) {
                throw new NoSuchElementException();
            }
            try {
                t = this.mClazz.newInstance();
            }
            catch (InstantiationException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IllegalAccessException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return null;
            }
            DBFDataStorage.this.assignObjectValues((DBFSerializable)t);
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface DBFIterator<T>
    extends Iterator {
        public int getRecordCount();

        public void close();

        public boolean isClosed();
    }
}

