/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.FieldAccessor;
import hec.io.dbf.DBFFieldDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class DBFMapObject
implements Serializable {
    public DBFFieldDescriptor cbFieldDescriptor;
    public String cbTagName;
    public boolean cbDescending;
    public byte cbUnique;
    public String cbFilter;
    public String cbExpression;
    public boolean allowNull;
    public boolean readOnly = false;
    public boolean isCompound = false;
    public String jFieldName;
    public String relationalObjClass;
    public Field jField;
    public String jFullFieldName;
    public Constructor constructor;
    public String jclassName;

    public static Field getJField(Class cls, String fieldName) {
        if (cls == null || fieldName == null) {
            return null;
        }
        int idx = fieldName.indexOf(46);
        if (idx != -1) {
            String strContainingField = fieldName.substring(0, idx);
            Field containingField = DBFMapObject.getJField(cls, strContainingField);
            if (containingField == null) {
                return null;
            }
            String strSubField = fieldName.substring(idx + 1);
            Class<?> containingClass = containingField.getType();
            Field subField = DBFMapObject.getJField(containingClass, strSubField);
            return subField;
        }
        try {
            Field f = cls.getDeclaredField(fieldName);
            return f;
        }
        catch (NoSuchFieldException e) {
            return DBFMapObject.getJField(cls.getSuperclass(), fieldName);
        }
    }

    public static Object getFieldObject(FieldAccessor dbfObj, String strFieldName, Field field) {
        if (dbfObj == null || strFieldName == null || field == null) {
            return null;
        }
        int idx = strFieldName.indexOf(46);
        if (idx != -1) {
            String strContainingObject = strFieldName.substring(0, idx);
            Field containingField = DBFMapObject.getJField(dbfObj.getClass(), strContainingObject);
            if (containingField == null) {
                return null;
            }
            Object containingObject = dbfObj.getFieldObject(containingField);
            if (!(containingObject instanceof FieldAccessor)) {
                return null;
            }
            dbfObj = (FieldAccessor)containingObject;
            strFieldName = strFieldName.substring(idx + 1);
            return DBFMapObject.getFieldObject(dbfObj, strFieldName, field);
        }
        return dbfObj.getFieldObject(field);
    }

    public static boolean setFieldObject(FieldAccessor dbfObj, String strFieldName, Field field, Object data) {
        if (dbfObj == null || strFieldName == null || field == null) {
            return false;
        }
        int idx = strFieldName.indexOf(46);
        if (idx != -1) {
            String strContainingObject = strFieldName.substring(0, idx);
            Field containingField = DBFMapObject.getJField(dbfObj.getClass(), strContainingObject);
            if (containingField == null) {
                return false;
            }
            Object containingObject = dbfObj.getFieldObject(containingField);
            if (!(containingObject instanceof FieldAccessor)) {
                return false;
            }
            dbfObj = (FieldAccessor)containingObject;
            strFieldName = strFieldName.substring(idx + 1);
            return DBFMapObject.setFieldObject(dbfObj, strFieldName, field, data);
        }
        return dbfObj.setFieldObject(field, data);
    }
}

