/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.DBFIndexObject;
import hec.io.DBFMapObject;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.annotations.Column;
import hec.io.dbf.annotations.Index;
import hec.io.dbf.annotations.Indexes;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DBFMappingClass
implements Serializable {
    public List<DBFMapObject> _dbfMap = new ArrayList<DBFMapObject>();
    public List<DBFIndexObject> _dbfIndx = new ArrayList<DBFIndexObject>();

    public void add(DBFMappingClass mappClass) {
        this._dbfMap.addAll(mappClass._dbfMap);
        this._dbfIndx.addAll(mappClass._dbfIndx);
    }

    public void addIndex(String tagName, String expression, String filter, byte unique, boolean descending) {
        DBFIndexObject index = new DBFIndexObject();
        index.cbTagName = tagName;
        index.cbDescending = descending;
        index.cbUnique = unique;
        index.cbFilter = filter;
        index.cbExpression = expression;
        this._dbfIndx.add(index);
        for (int i = 0; i < this._dbfMap.size(); ++i) {
            DBFMapObject mo = this._dbfMap.get(i);
            if (unique != 20 || expression.indexOf(mo.cbFieldDescriptor.fieldName) < 0) continue;
            mo.cbFieldDescriptor.indexFld = 1;
        }
    }

    public List<DBFIndexObject> getIndex() {
        return this._dbfIndx;
    }

    public int numObjects() {
        return this._dbfMap.size();
    }

    public DBFMapObject getMapObject(int i) {
        if (i < 0 || i >= this._dbfMap.size()) {
            return null;
        }
        return this._dbfMap.get(i);
    }

    public void addMapObject(DBFMapObject mapObj) {
        this._dbfMap.add(mapObj);
    }

    public void addDbfMap(String fldName, String cbFldName, char type, boolean allowNull) {
        this.addDbfMap(fldName, null, cbFldName, null, type, 1, 0, allowNull, null, null, null, (byte)0, false);
    }

    public void addDbfMap(String fldName, String cbFldName, char type, int fldSize, int numDecimal, boolean allowNull) {
        this.addDbfMap(fldName, null, cbFldName, null, type, fldSize, numDecimal, allowNull, null, null, null, (byte)0, false);
    }

    public void addDbfMap(String fldName, String cbFldName, char type, int fldSize, int numDecimal, boolean allowNull, String tagName, String exp, String filter, byte unique, boolean descending) {
        this.addDbfMap(fldName, null, cbFldName, null, type, fldSize, numDecimal, allowNull, tagName, exp, filter, unique, descending);
    }

    public void addDbfMap(String fldName, String cbFldName, String cbFldDesc, char type, int fldSize, int numDecimal, boolean allowNull, String tagName, String exp, String filter, byte unique, boolean descending) {
        this.addDbfMap(fldName, null, cbFldName, cbFldDesc, type, fldSize, numDecimal, allowNull, tagName, exp, filter, unique, descending);
    }

    public void addDbfMap(String fldName, String cbFldName, String cbFldDesc, char type, int fldSize, int numDecimal, boolean allowNull) {
        this.addDbfMap(fldName, null, cbFldName, cbFldDesc, type, fldSize, numDecimal, allowNull, null, null, null, (byte)0, false);
    }

    public void addDbfMap(String fldName, String relObjClass, String cbFldName, String cbFldDesc, char type, int fldSize, int numDecimal, boolean allowNull) {
        this.addDbfMap(fldName, relObjClass, cbFldName, cbFldDesc, type, fldSize, numDecimal, allowNull, null, null, null, (byte)0, false);
    }

    public void addDbfMap(String fldName, String relationalObjClass, String cbFldName, String cbFldDesc, char type, int fldSize, int numDecimal, boolean allowNull, String tagName, String exp, String filter, byte unique, boolean descending) {
        DBFMapObject mapObject = new DBFMapObject();
        mapObject.jFieldName = fldName.trim();
        mapObject.relationalObjClass = relationalObjClass;
        mapObject.cbFieldDescriptor = new DBFFieldDescriptor(cbFldName.trim(), cbFldDesc, type, fldSize, numDecimal);
        mapObject.allowNull = allowNull;
        mapObject.cbTagName = tagName;
        mapObject.cbExpression = exp;
        mapObject.cbFilter = filter;
        mapObject.cbUnique = unique;
        mapObject.cbDescending = descending;
        if (tagName != null && !tagName.isEmpty() && unique == 20) {
            mapObject.cbFieldDescriptor.indexFld = 1;
        }
        this._dbfMap.add(mapObject);
    }

    public void addComplexDbfMap(String fldName) {
        DBFMapObject mapObject = new DBFMapObject();
        mapObject.jFieldName = fldName;
        mapObject.isCompound = true;
        this._dbfMap.add(mapObject);
    }

    public boolean removeDbfMap(String cbFldName) {
        for (int i = 0; i < this._dbfMap.size(); ++i) {
            DBFMapObject mapObject = this._dbfMap.get(i);
            if (!mapObject.cbFieldDescriptor.getFieldName().equals(cbFldName.toUpperCase())) continue;
            this._dbfMap.remove(mapObject);
            return true;
        }
        return false;
    }

    public DBFFieldDescriptor[] getFieldDescriptorList() {
        DBFFieldDescriptor[] fdList = new DBFFieldDescriptor[this._dbfMap.size()];
        for (int i = 0; i < this._dbfMap.size(); ++i) {
            fdList[i] = this._dbfMap.get((int)i).cbFieldDescriptor;
        }
        return fdList;
    }

    public static DBFMappingClass createMappingClass(Class dbfObject) {
        Class superClass = dbfObject.getSuperclass();
        DBFMappingClass superMappingClass = null;
        if (superClass != null) {
            superMappingClass = DBFMappingClass.createMappingClass(superClass);
        }
        DBFMappingClass mappingClass = new DBFMappingClass();
        if (superMappingClass != null) {
            mappingClass.add(superMappingClass);
        }
        Field[] fields = dbfObject.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Column column = f.getAnnotation(Column.class);
            Index index = f.getAnnotation(Index.class);
            Indexes indexes = f.getAnnotation(Indexes.class);
            if (column != null) {
                mappingClass.addDbfMap(f.getName(), column.name(), column.fieldType(), column.fieldSize(), column.numDecimal(), column.allowNull());
            }
            if (index != null) {
                mappingClass.addIndex(index.name(), index.expression(), index.filter(), index.unique(), index.descending());
            }
            if (indexes == null) continue;
            Index[] indexes1 = indexes.indexes();
            for (int zz = 0; zz < indexes1.length; ++zz) {
                mappingClass.addIndex(indexes1[zz].name(), indexes1[zz].expression(), indexes1[zz].filter(), indexes1[zz].unique(), indexes1[zz].descending());
            }
        }
        return mappingClass;
    }
}

