/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.util.HecTime;
import hec.util.TextUtil;
import java.io.Serializable;

public class DSSIdentifier
implements Serializable {
    protected String _fileName = null;
    protected String _dssPath = null;
    protected String _type = null;
    protected HecTime _startTime = new HecTime();
    protected HecTime _endTime = new HecTime();
    protected String _units;
    protected String _verticalDatumInfo = null;
    protected String _currentVerticalDatum = null;
    protected boolean _readPrevious;
    protected boolean _readSubsequent;
    protected long _updateTime = Long.MIN_VALUE;
    protected String _timeZoneID = null;

    public DSSIdentifier() {
    }

    public DSSIdentifier(String fname) {
        this._fileName = fname;
    }

    public DSSIdentifier(String fname, String path) {
        this._fileName = fname;
        this._dssPath = path;
    }

    public DSSIdentifier(DSSIdentifier dssId) {
        if (dssId != null) {
            this._fileName = dssId.getFileName();
            this._dssPath = dssId.getDSSPath();
            if (dssId.getStartTime() != null) {
                this._startTime = new HecTime(dssId.getStartTime());
            }
            if (dssId.getEndTime() != null) {
                this._endTime = new HecTime(dssId.getEndTime());
            }
            this._units = dssId.getUnits();
            this._verticalDatumInfo = dssId.getVerticalDatumInfo();
        }
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setReadPrevious(boolean bool) {
        this._readPrevious = bool;
    }

    public void setReadSubsequent(boolean bool) {
        this._readSubsequent = bool;
    }

    public boolean getReadPrevious() {
        return this._readPrevious;
    }

    public boolean getReadSubsequent() {
        return this._readSubsequent;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setDSSPath(String dssPath) {
        this._dssPath = dssPath;
    }

    public String getDSSPath() {
        return this._dssPath;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    public String getUnits() {
        return this._units;
    }

    public void setTimeZoneID(String timeZoneID) {
        this._timeZoneID = timeZoneID;
    }

    public String getTimeZoneID() {
        return this._timeZoneID;
    }

    public String getVerticalDatumInfo() {
        return this._verticalDatumInfo;
    }

    public String getCurrentVerticalDatum() {
        return this._currentVerticalDatum;
    }

    public void setVerticalDatumInfo(String verticalDatumInfo) {
        this._verticalDatumInfo = verticalDatumInfo;
    }

    public void setCurrentVerticalDatum(String currentVerticalDatum) {
        this._currentVerticalDatum = currentVerticalDatum;
    }

    public void setTimeWindow(String timeWindow) {
        HecTime.getTimeWindow(timeWindow, this._startTime, this._endTime);
    }

    public String getTimeWindow() {
        if (this._startTime == null || this._endTime == null) {
            return "";
        }
        if (this._startTime.isDefined() && this._endTime.isDefined()) {
            String timeWindow = this._startTime.toString(4) + "; " + this._endTime.toString(4);
            return timeWindow;
        }
        return "";
    }

    public void setTimeWindow(HecTime start, HecTime end) {
        this._startTime = start;
        this._endTime = end;
    }

    public void setStartTime(HecTime time) {
        this._startTime = time;
    }

    public HecTime getStartTime() {
        return this._startTime;
    }

    public void setEndTime(HecTime time) {
        this._endTime = time;
    }

    public HecTime getEndTime() {
        return this._endTime;
    }

    public String toString() {
        return this._fileName + ":" + this._dssPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DSSIdentifier) {
            return this.equals((DSSIdentifier)obj);
        }
        return false;
    }

    public boolean equals(DSSIdentifier dssId) {
        return dssId != null && TextUtil.equals(this._fileName, dssId._fileName) && TextUtil.equals(this._dssPath, dssId._dssPath);
    }

    public long getUpdateTime() {
        return this._updateTime;
    }

    public void setUpdateTime(long time) {
        this._updateTime = time;
    }
}

