/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup _group;
    private final AtomicInteger _threadNumber = new AtomicInteger(1);
    private final String _namePrefix;

    public DaemonThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        this._group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this._namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this._group, r, this._namePrefix + this._threadNumber.getAndIncrement(), 0L);
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

