/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.util.doubleContainer;
import hec.util.TextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class DataContainer
implements Cloneable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(DataContainer.class.getName());
    private static final long serialVersionUID = 1353050029414367368L;
    public static final String VERTICAL_DATUM_INFO_KEY = "verticalDatumInfo";
    public static final String VERTICAL_DATUM_INFO_HEADER = "verticalDatumInfo:";
    public static final String CURRENT_VERTICAL_DATUM_KEY = "verticalDatum";
    public static final String CURRENT_VERTICAL_DATUM_HEADER = "verticalDatum:";
    public String fullName = "";
    public String watershed = "";
    public String location = "";
    public String version = "";
    public String subVersion = "";
    public String fileName = "";
    public boolean storedAsdoubles = true;
    public int dataType = 0;
    public long lastWriteTimeMillis = 0L;
    public long fileLastWriteTimeMillis = 0L;
    public double xOrdinate;
    public double yOrdinate;
    public double zOrdinate;
    public int coordinateSystem;
    public int coordinateID;
    public int horizontalUnits;
    public int horizontalDatum;
    public int verticalUnits;
    public int verticalDatum;
    public String locationTimezone = "";
    public String supplementalInfo = null;
    public Object otherInfo = null;
    public boolean modified;

    public void setName(String datasetName) {
        this.fullName = datasetName;
    }

    public String getName() {
        return this.fullName;
    }

    public void setFullName(String datasetName) {
        this.fullName = datasetName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setStoreAsDoubles(boolean storedAsdoubles) {
        this.storedAsdoubles = storedAsdoubles;
    }

    public boolean getStoreAsDoubles() {
        return this.storedAsdoubles;
    }

    public void clone(DataContainer dc) {
        dc.fullName = this.fullName;
        dc.watershed = this.watershed;
        dc.location = this.location;
        dc.version = this.version;
        dc.subVersion = this.subVersion;
        dc.fileName = this.fileName;
        dc.storedAsdoubles = this.storedAsdoubles;
        dc.dataType = this.dataType;
        dc.xOrdinate = this.xOrdinate;
        dc.yOrdinate = this.yOrdinate;
        dc.zOrdinate = this.zOrdinate;
        dc.coordinateSystem = this.coordinateSystem;
        dc.coordinateID = this.coordinateID;
        dc.horizontalUnits = this.horizontalUnits;
        dc.horizontalDatum = this.horizontalDatum;
        dc.verticalUnits = this.verticalUnits;
        dc.verticalDatum = this.verticalDatum;
        dc.supplementalInfo = this.supplementalInfo;
        dc.otherInfo = this.otherInfo;
        dc.modified = this.modified;
    }

    public String toString() {
        return this.fullName;
    }

    public void setLatLong(double latitude, double longitude) {
        this.yOrdinate = latitude;
        this.xOrdinate = longitude;
        this.coordinateSystem = 1;
        this.coordinateID = 0;
    }

    public boolean getLatLong(doubleContainer latitude, doubleContainer longitude) {
        if (this.coordinateSystem != 1) {
            return false;
        }
        latitude.value = this.yOrdinate;
        longitude.value = this.xOrdinate;
        return true;
    }

    public void setHorizontalDatum(String datum) {
        this.horizontalDatum = "NAD83".equalsIgnoreCase(datum) ? 1 : ("NAD27".equalsIgnoreCase(datum) ? 2 : ("WAS84".equalsIgnoreCase(datum) ? 3 : ("WAS72".equalsIgnoreCase(datum) ? 4 : (datum != null ? 5 : 0))));
    }

    public String getHorizontalDatum() {
        if (this.horizontalDatum == 1) {
            return "NAD83";
        }
        if (this.horizontalDatum == 2) {
            return "NAD27";
        }
        if (this.horizontalDatum == 3) {
            return "WAS84";
        }
        if (this.horizontalDatum == 4) {
            return "WAS72";
        }
        if (this.horizontalDatum == 5) {
            return "Local (other)";
        }
        return "Not Set";
    }

    public void setVerticalDatum(VERTICAL_DATUM datum) {
        switch (datum) {
            case UNSET: {
                this.verticalDatum = 0;
                break;
            }
            case NAVD88: {
                this.verticalDatum = 1;
                break;
            }
            case NGVD29: {
                this.verticalDatum = 2;
                break;
            }
            case LOCAL: {
                this.verticalDatum = 3;
                break;
            }
            default: {
                this.verticalDatum = -1;
            }
        }
    }

    public void setVerticalDatum(String datum) {
        switch (datum.toUpperCase()) {
            case "UNSET": {
                this.verticalDatum = 0;
                break;
            }
            case "NAVD88": {
                this.verticalDatum = 1;
                break;
            }
            case "NGVD29": {
                this.verticalDatum = 2;
                break;
            }
            case "LOCAL": {
                this.verticalDatum = 3;
                break;
            }
            default: {
                this.verticalDatum = -1;
            }
        }
    }

    public String getVerticalDatum() {
        String datum = "UNKNOWN";
        switch (this.verticalDatum) {
            case 0: {
                datum = "Not set";
                break;
            }
            case 1: {
                datum = "NAVD88";
                break;
            }
            case 2: {
                datum = "NGVD29";
                break;
            }
            case 3: {
                datum = "LOCAL";
            }
        }
        return datum;
    }

    public void setVerticalUnits(VERTICAL_UNITS units) {
        switch (units) {
            case UNSET: {
                this.verticalUnits = 0;
                break;
            }
            case FEET: {
                this.verticalUnits = 1;
                break;
            }
            case METERS: {
                this.verticalUnits = 2;
                break;
            }
            default: {
                this.verticalUnits = -1;
            }
        }
    }

    public void setVerticalUnits(String units) {
        switch (units.toUpperCase()) {
            case "UNSET": {
                this.verticalUnits = 0;
                break;
            }
            case "FEET": {
                this.verticalUnits = 1;
                break;
            }
            case "METERS": {
                this.verticalUnits = 2;
                break;
            }
            default: {
                this.verticalUnits = -1;
            }
        }
    }

    public String getVerticalUnits() {
        String units = "Unexpected";
        switch (this.verticalUnits) {
            case 0: {
                units = "Not set";
                break;
            }
            case 1: {
                units = "ft";
                break;
            }
            case 2: {
                units = "m";
            }
        }
        return units;
    }

    public HashMap<String, String> getSupplementalInfo() {
        HashMap<String, String> si = new HashMap<String, String>();
        if (this.supplementalInfo != null) {
            StringTokenizer tok = new StringTokenizer(this.supplementalInfo, ";");
            while (tok.hasMoreTokens()) {
                String item = tok.nextToken();
                String[] parts = TextUtil.split(item, ":");
                if (parts.length != 2) continue;
                for (int i = 0; i < 2; ++i) {
                    int len = parts[i].length();
                    while (parts[i].charAt(len - 1) == ' ') {
                        --len;
                    }
                    if (len >= parts[i].length()) continue;
                    parts[i] = parts[i].substring(0, len);
                }
                si.put(parts[0], parts[1]);
            }
        }
        return si;
    }

    public void setSupplementalInfo(HashMap<String, String> si) {
        StringBuilder sb = new StringBuilder();
        for (String key : si.keySet()) {
            sb.append(key).append(":").append(si.get(key)).append(";");
        }
        this.supplementalInfo = sb.toString();
    }

    public VerticalDatumContainer extractVerticalDatum() throws VerticalDatumException, IOException {
        VerticalDatumContainer vdc = null;
        HashMap<String, String> si = this.getSupplementalInfo();
        if (si.containsKey(VERTICAL_DATUM_INFO_KEY)) {
            String verticalDatumInfo = si.get(VERTICAL_DATUM_INFO_KEY);
            if (verticalDatumInfo != null) {
                try {
                    vdc = new VerticalDatumContainer(TextUtil.uncompress(verticalDatumInfo, "base64"));
                }
                catch (Exception e) {
                    throw new VerticalDatumException((Throwable)e);
                }
            }
            si.remove(VERTICAL_DATUM_INFO_KEY);
        }
        if (si.containsKey(CURRENT_VERTICAL_DATUM_KEY)) {
            String currentVerticalDatum = si.get(CURRENT_VERTICAL_DATUM_KEY);
            if (currentVerticalDatum.equals("UNKNOWN")) {
                LOGGER.warning("The Vertical Datum is '" + currentVerticalDatum + "' Vertical Datum conversion will be skipped");
            } else if (vdc != null) {
                vdc.toVerticalDatum(currentVerticalDatum);
            }
            si.remove(CURRENT_VERTICAL_DATUM_KEY);
        }
        return vdc;
    }

    public void insertVerticalDatum(VerticalDatumContainer vdc) throws IOException, VerticalDatumException {
        HashMap<String, String> si = this.getSupplementalInfo();
        if (vdc == null) {
            si.remove(VERTICAL_DATUM_INFO_KEY);
            si.remove(CURRENT_VERTICAL_DATUM_KEY);
        } else {
            String verticalDatumInfo = vdc.toString();
            String currentVerticalDatum = vdc.getCurrentVerticalDatum();
            si.put(VERTICAL_DATUM_INFO_KEY, TextUtil.compress(verticalDatumInfo, "base64"));
            si.put(CURRENT_VERTICAL_DATUM_KEY, currentVerticalDatum);
        }
        this.setSupplementalInfo(si);
    }

    public static enum VERTICAL_DATUM {
        UNSET,
        NAVD88,
        NGVD29,
        LOCAL;

    }

    public static enum VERTICAL_UNITS {
        UNSET,
        METERS,
        FEET;

    }
}

