/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.LogTimeIntervals;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import rma.util.TimeInterval;

public class DatedFileNamer
implements LogTimeIntervals {
    TimeInterval _timeInterval = null;
    long _nextTimeForNewFile = 0L;
    boolean _localTime = true;
    String _directory = null;
    String _baseFilename = null;
    String _ext = null;
    static final String MINUTE_TIME_INTERVAL_MASK = "yyyy.MM.dd.HH.mm";
    static final String HOUR_TIME_INTERVAL_MASK = "yyyy.MM.dd.HH";
    static final String DAY_TIME_INTERVAL_MASK = "yyyy.MM.dd";
    static final String WEEK_TIME_INTERVAL_MASK = "yyyy.MM.dd";
    static final String MONTH_TIME_INTERVAL_MASK = "yyyy.MM";
    static final String YEAR_TIME_INTERVAL_MASK = "yyyy";
    static final String UTC = "utc";
    static final String DOT = ".";

    public DatedFileNamer(String directory, String baseFileName, TimeInterval timeInterval, boolean localTime) {
        this._directory = directory;
        this._baseFilename = baseFileName;
        this._timeInterval = timeInterval;
        this._localTime = localTime;
        if (!this.isValidTimeInterval()) {
            throw new IllegalArgumentException("Invalid timeInterval " + this._timeInterval.getIntervalType());
        }
    }

    public void setExtension(String str) {
        this._ext = str;
    }

    public boolean isValidTimeInterval() {
        for (int i = 0; i < TIME_INTERVALS.length; ++i) {
            if (!this._timeInterval.getIntervalType().equalsIgnoreCase(TIME_INTERVALS[i])) continue;
            return true;
        }
        System.out.println("DatedFileNamer: invalid time interval " + this._timeInterval);
        return false;
    }

    public String getNewFilename(long currentTime) throws IOException {
        SimpleDateFormat simpleDateFormat = null;
        String theDateMask = null;
        StringBuffer filename = new StringBuffer();
        Date startDate = null;
        if (this._timeInterval.getIntervalType().equalsIgnoreCase("mi")) {
            theDateMask = MINUTE_TIME_INTERVAL_MASK;
            startDate = new Date();
        } else if (this._timeInterval.getIntervalType().equalsIgnoreCase("hr")) {
            theDateMask = HOUR_TIME_INTERVAL_MASK;
            startDate = new Date();
        } else {
            GregorianCalendar gc = null;
            gc = this._localTime ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone(UTC));
            int day = 0;
            int month = 0;
            int year = 0;
            int dayOfWeek = -1;
            if (this._timeInterval.getIntervalType().equalsIgnoreCase("dy")) {
                theDateMask = "yyyy.MM.dd";
                day = gc.get(5);
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, day);
                startDate = gc.getTime();
                gc.roll(5, true);
            } else if (this._timeInterval.getIntervalType().equalsIgnoreCase("wk")) {
                theDateMask = "yyyy.MM.dd";
                day = gc.get(5);
                month = gc.get(2);
                year = gc.get(1);
                dayOfWeek = gc.get(7);
                gc.clear();
                gc.set(year, month, day);
                gc.add(5, -(dayOfWeek - 1));
                startDate = gc.getTime();
                gc.add(5, 7);
            } else if (this._timeInterval.getIntervalType().equalsIgnoreCase("mo")) {
                theDateMask = MONTH_TIME_INTERVAL_MASK;
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, 1);
                startDate = gc.getTime();
                gc.roll(2, true);
            } else if (this._timeInterval.getIntervalType().equalsIgnoreCase("yr")) {
                theDateMask = YEAR_TIME_INTERVAL_MASK;
                year = gc.get(1);
                gc.clear();
                gc.set(year, 0, 1);
                startDate = gc.getTime();
                gc.roll(1, true);
            }
        }
        if (this._localTime) {
            simpleDateFormat = new SimpleDateFormat(theDateMask);
        } else {
            TimeZone tzLocal = TimeZone.getDefault();
            TimeZone.setDefault(TimeZone.getTimeZone(UTC));
            simpleDateFormat = new SimpleDateFormat(theDateMask);
            TimeZone.setDefault(tzLocal);
        }
        filename.append(this._directory);
        filename.append("/");
        filename.append(this._baseFilename);
        filename.append(DOT);
        filename.append(this._timeInterval.getLength());
        filename.append(this._timeInterval.getIntervalType());
        filename.append(DOT);
        filename.append(simpleDateFormat.format(startDate));
        if (!this._localTime) {
            filename.append(DOT);
            filename.append(UTC);
        }
        if (this._ext != null) {
            filename.append(this._ext);
        }
        return filename.toString();
    }
}

