/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.EndianTypes;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class EndianInputStream
extends DataInputStream
implements EndianTypes {
    private int _type = 200;
    private byte[] w = new byte[8];

    public EndianInputStream(InputStream is) {
        super(is);
    }

    public void setEndianType(int type) {
        this._type = type;
    }

    public final short readShort(int type) throws IOException {
        if (type == 200) {
            if (super.read(this.w, 0, 2) != 2) {
                throw new EOFException();
            }
            return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
        }
        return super.readShort();
    }

    public final int readUnsignedShort(int type) throws IOException {
        if (type == 200) {
            if (super.read(this.w, 0, 2) != 2) {
                throw new EOFException();
            }
            return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
        }
        return super.readUnsignedShort();
    }

    public final char readChar(int type) throws IOException {
        if (type == 200) {
            if (super.read(this.w, 0, 2) != 2) {
                throw new EOFException();
            }
            return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
        }
        return super.readChar();
    }

    public final int readInt(int type) throws IOException {
        if (type == 200) {
            if (super.read(this.w, 0, 4) != 4) {
                throw new EOFException();
            }
            return (this.w[3] & 0xFF) << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
        }
        return super.readInt();
    }

    public final long readLong(int type) throws IOException {
        if (type == 200) {
            if (super.read(this.w, 0, 8) != 8) {
                throw new EOFException();
            }
            return (long)(this.w[7] & 0xFF) << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
        }
        return super.readLong();
    }

    public final float readFloat(int type) throws IOException {
        return Float.intBitsToFloat(this.readInt(type));
    }

    public final double readDouble(int type) throws IOException {
        return Double.longBitsToDouble(this.readLong(type));
    }
}

