/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.EndianTypes;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianOutputStream
extends DataOutputStream
implements EndianTypes {
    private byte[] w = new byte[8];

    public EndianOutputStream(OutputStream is) {
        super(is);
    }

    public final void writeShort(int type, short s) throws IOException {
        if (type == 200) {
            this.w[1] = (byte)((s & 0xFF00) >> 8);
            this.w[0] = (byte)(s & 0xFF);
            super.write(this.w, 0, 2);
        } else {
            super.writeShort(s);
        }
    }

    public final void writeUnsignedShort(int type, short us) throws IOException {
        if (type == 200) {
            this.w[1] = (byte)((us & 0xFF00) >> 8);
            this.w[0] = (byte)(us & 0xFF);
            super.write(this.w, 0, 2);
        } else {
            super.writeShort(us);
        }
    }

    public final void writeChar(int type, char c2) throws IOException {
        if (type == 200) {
            this.w[1] = (byte)((c2 & 0xFF00) >> 8);
            this.w[0] = (byte)(c2 & 0xFF);
            super.write(this.w, 0, 2);
        } else {
            super.writeChar(c2);
        }
    }

    public final void writeInt(int type, int i) throws IOException {
        if (type == 200) {
            this.w[3] = (byte)((i & 0xFF000000) >> 24);
            this.w[2] = (byte)((i & 0xFF0000) >> 16);
            this.w[1] = (byte)((i & 0xFF00) >> 8);
            this.w[0] = (byte)(i & 0xFF);
            super.write(this.w, 0, 4);
        } else {
            super.writeInt(i);
        }
    }

    public final void writeLong(int type, long l) throws IOException {
        if (type == 200) {
            int lo = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            int hi = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.writeInt(200, lo);
            this.writeInt(200, hi);
        } else {
            super.writeLong(l);
        }
    }

    public final void writeFloat(int type, float f) throws IOException {
        if (type == 200) {
            this.writeInt(200, Float.floatToIntBits(f));
        } else {
            super.writeFloat(f);
        }
    }

    public final void writeDouble(int type, double d) throws IOException {
        if (type == 200) {
            this.writeLong(200, Double.doubleToLongBits(d));
        } else {
            super.writeDouble(d);
        }
    }
}

