/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.Serializable;

public class FileLock
implements Serializable {
    static final long serialVersionUID = -7460773342039308594L;
    public static final int NO_LOCK = 0;
    public static final int UNLOCK = 1;
    public static final int UNLOCK_ALL = 2;
    public static final int READ_LOCK = 3;
    public static final int WRITE_LOCK = 4;
    public static final int WRITE_UNLOCK = 5;
    public static final int EDIT_LOCK = 6;
    public static final int EDIT_UNLOCK = 7;
    public static final String NO_LOCK_STRING = "No Lock";
    public static final String UNLOCK_STRING = "Unlock";
    public static final String UNLOCK_ALL_STRING = "Unlock All";
    public static final String READ_LOCK_STRING = "Read Lock";
    public static final String WRITE_LOCK_STRING = "Write Lock";
    public static final String WRITE_UNLOCK_STRING = "Write Unlock";
    public static final String EDIT_LOCK_STRING = "Edit Lock";
    public static final String EDIT_UNLOCK_STRING = "Edit Unlock";
    private static final int FIRST_LOCK_TYPE = 0;
    private static final int LAST_LOCK_TYPE = 7;
    private String _userId;
    private int _lockType;
    private long _lockedTime = -1L;
    private int _refCnt = 0;

    public FileLock(String userId, int lockType) {
        if (lockType < 0 || lockType > 7) {
            throw new IllegalArgumentException("Invalid lock type " + lockType);
        }
        if (userId == null || userId.length() < 1) {
            throw new IllegalArgumentException("Invalid user id [" + userId + "]");
        }
        this._lockType = lockType;
        this._userId = userId;
    }

    public int getLockType() {
        return this._lockType;
    }

    public String getUserId() {
        return this._userId;
    }

    public long getLockedTime() {
        return this._lockedTime;
    }

    public void setLockedTime(long lockedTime) {
        this._lockedTime = lockedTime;
    }

    public String toString() {
        return "FileLock(" + this._userId + " " + this.getLockTypeString() + " refCnt=" + this._refCnt + ")";
    }

    public int hashCode() {
        return this._userId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileLock) {
            return this.equals((FileLock)obj);
        }
        return false;
    }

    public boolean equals(FileLock fl) {
        if (fl == null) {
            return false;
        }
        if (fl == this) {
            return true;
        }
        return this._userId.equals(fl._userId);
    }

    public int getRefCount() {
        return this._refCnt;
    }

    public int incrementRefCount() {
        ++this._refCnt;
        this._lockedTime = System.currentTimeMillis();
        return this._refCnt;
    }

    public int decrementRefCount() {
        if (this._refCnt > 0) {
            --this._refCnt;
        }
        return this._refCnt;
    }

    public String getLockTypeString() {
        switch (this._lockType) {
            case 0: {
                return NO_LOCK_STRING;
            }
            case 1: {
                return UNLOCK_STRING;
            }
            case 2: {
                return UNLOCK_ALL_STRING;
            }
            case 3: {
                return READ_LOCK_STRING;
            }
            case 4: {
                return WRITE_LOCK_STRING;
            }
            case 5: {
                return WRITE_UNLOCK_STRING;
            }
            case 6: {
                return EDIT_LOCK_STRING;
            }
            case 7: {
                return EDIT_UNLOCK_STRING;
            }
        }
        return "";
    }

    public static String getLockTypeString(int lockType) {
        switch (lockType) {
            case 0: {
                return NO_LOCK_STRING;
            }
            case 1: {
                return UNLOCK_STRING;
            }
            case 2: {
                return UNLOCK_ALL_STRING;
            }
            case 3: {
                return READ_LOCK_STRING;
            }
            case 4: {
                return WRITE_LOCK_STRING;
            }
            case 5: {
                return WRITE_UNLOCK_STRING;
            }
            case 6: {
                return EDIT_LOCK_STRING;
            }
            case 7: {
                return EDIT_UNLOCK_STRING;
            }
        }
        return "Unknown lockType " + lockType;
    }

    public static FileLock getUnlockForLock(FileLock fLock) {
        if (fLock == null) {
            return null;
        }
        switch (fLock.getLockType()) {
            case 3: {
                return new FileLock(fLock.getUserId(), 1);
            }
            case 4: {
                return new FileLock(fLock.getUserId(), 5);
            }
            case 6: {
                return new FileLock(fLock.getUserId(), 7);
            }
        }
        return fLock;
    }

    public static boolean isUnlockType(int lockType) {
        switch (lockType) {
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }
}

