/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.FileListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    private Timer _timer;
    private Map _listeners = new HashMap();

    public FileMonitor(long pollingInterval) {
        this._timer = new Timer(true);
        this._timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, pollingInterval);
    }

    public void stop() {
        this._timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, FileListener listener) {
        FileListenerInfo fli = (FileListenerInfo)this._listeners.get(file);
        if (fli == null) {
            long modifiedTime = file.exists() ? file.lastModified() : -1L;
            fli = new FileListenerInfo(listener, modifiedTime);
            Map map = this._listeners;
            synchronized (map) {
                this._listeners.put(file, fli);
            }
        } else {
            fli.listeners.add(new WeakReference<FileListener>(listener));
        }
    }

    public void updateLastModified(File file, long time) {
        FileListenerInfo info = (FileListenerInfo)this._listeners.get(file);
        if (info != null) {
            info.setModTime(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(File file) {
        Map map = this._listeners;
        synchronized (map) {
            this._listeners.remove(file);
        }
    }

    public boolean contains(File file) {
        return this._listeners.containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(File file, FileListener fileListener) {
        FileListenerInfo fli = (FileListenerInfo)this._listeners.get(file);
        if (fli == null) {
            return;
        }
        Iterator i = fli.listeners.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            FileListener listener = (FileListener)reference.get();
            if (listener != fileListener) continue;
            i.remove();
            break;
        }
        if (fli.listeners.size() == 0) {
            Map map = this._listeners;
            synchronized (map) {
                this._listeners.remove(file);
            }
        }
    }

    public static void main(String[] args) {
        FileMonitor monitor = new FileMonitor(1000L);
        monitor.addFile(new File("/dev/apps/bob"), new TestListener());
        monitor.addFile(new File("/dev/apps/foo"), new TestListener());
        monitor.addFile(new File("/dev/apps/"), new TestListener());
        while (true) {
            // Infinite loop
        }
    }

    private class FileMonitorNotifier
    extends TimerTask {
        private FileMonitorNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap files;
            Object object = FileMonitor.this._listeners;
            synchronized (object) {
                files = new HashMap(FileMonitor.this._listeners);
            }
            object = FileMonitor.this._timer;
            synchronized (object) {
                Set keyset = files.keySet();
                Iterator i = keyset.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    FileListenerInfo fli = (FileListenerInfo)FileMonitor.this._listeners.get(file);
                    if (fli == null) {
                        i.remove();
                        continue;
                    }
                    long lastModifiedTime = fli.getModTime();
                    long newModifiedTime = file.exists() ? file.lastModified() : -1L;
                    if (newModifiedTime <= lastModifiedTime) continue;
                    fli.setModTime(newModifiedTime);
                    this.notifyListeners(fli, file);
                }
            }
        }

        private void notifyListeners(FileListenerInfo fli, File file) {
            for (int j = fli.listeners.size() - 1; j >= 0; --j) {
                WeakReference reference = (WeakReference)fli.listeners.get(j);
                FileListener listener = (FileListener)reference.get();
                if (listener == null) {
                    fli.listeners.remove(j);
                    continue;
                }
                listener.fileChanged(file);
            }
        }
    }

    private static class FileListenerInfo {
        List listeners = new ArrayList();
        private long modTime;

        public FileListenerInfo(FileListener listener, long modifiedTime) {
            this.modTime = modifiedTime;
            this.listeners.add(new WeakReference<FileListener>(listener));
        }

        public void setModTime(long mTime) {
            this.modTime = mTime;
        }

        public long getModTime() {
            return this.modTime;
        }
    }

    private static class TestListener
    implements FileListener {
        private TestListener() {
        }

        @Override
        public void fileChanged(File file) {
            System.out.println("File changed: " + file);
        }
    }
}

